# AAPT2 On-Disk Formats
- AAPT2 Container Format (extension `.apc`)
- AAPT2 Static Library Format (extension `.sapk`)

## AAPT2 Container Format (extension `.apc`)
The APC format (AAPT2 Container Format) is generated by AAPT2 during the compile phase and
consumed by the AAPT2 link phase. It is a simple container format for storing compiled PNGs,
binary and protobuf XML, and intermediate protobuf resource tables. It also stores all associated
meta-data from the compile phase.

### Format
The file starts with a simple header. All multi-byte fields are little-endian.

| Size (in bytes) | Field         | Description                                          |
|:----------------|:--------------|:-----------------------------------------------------|
| `4`             | `magic`       | The magic bytes must equal `'AAPT'` or `0x54504141`. |
| `4`             | `version`     | The version of the container format.                 |
| `4`             | `entry_count` | The number of entries in this container.             |

This is followed by `entry_count` of the following data structure. It must be aligned on a 32-bit
boundary, so if a previous entry ends unaligned, padding must be inserted.

| Size (in bytes) | Field          | Description                                                                                               |
|:----------------|:---------------|:----------------------------------------------------------------------------------------------------------|
| `4`             | `entry_type`   | The type of the entry. This can be one of two types: `RES_TABLE (0x00000000)` or `RES_FILE (0x00000001)`. |
| `8`             | `entry_length` | The length of the data that follows.                                                                      |
| `entry_length`  | `data`         | The payload. The contents of this varies based on the `entry_type`.                                       |

If the `entry_type` is equal to `RES_TABLE (0x00000000)`, the `data` field contains a serialized
[aapt.pb.ResourceTable](Resources.proto).

If the `entry_type` is equal to `RES_FILE (0x00000001)`, the `data` field contains the following:


| Size (in bytes) | Field          | Description                                                                                               |
|:----------------|:---------------|:----------------------------------------------------------------------------------------------------------|
| `4`             | `header_size`  | The size of the `header` field.                                                                 |
| `8`             | `data_size`    | The size of the `data` field.                                                                   |
| `header_size`   | `header`       | The serialized Protobuf message [aapt.pb.internal.CompiledFile](ResourcesInternal.proto).       |
| `x`             | `padding`      | Up to 4 bytes of zeros, if padding is necessary to align the `data` field on a 32-bit boundary. |
| `data_size`     | `data`         | The payload, which is determined by the `type` field in the `aapt.pb.internal.CompiledFile`. This can be a PNG file, binary XML, or [aapt.pb.XmlNode](Resources.proto). |

## AAPT2 Static Library Format (extension `.sapk`)

