/*=========================================================================
 *
 *  Copyright UMC Utrecht and contributors
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/
#ifndef __elxMovingSmoothingPyramid_h
#define __elxMovingSmoothingPyramid_h

#include "elxIncludes.h" // include first to avoid MSVS warning
#include "itkMultiResolutionGaussianSmoothingPyramidImageFilter.h"

namespace elastix
{

/**
 * \class MovingSmoothingPyramid
 * \brief A pyramid based on the itkMultiResolutionGaussianSmoothingPyramidImageFilter.
 *
 * The parameters used in this class are:
 * \parameter MovingImagePyramid: Select this pyramid as follows:\n
 *    <tt>(MovingImagePyramid "MovingSmoothingImagePyramid")</tt>
 *
 * \ingroup ImagePyramids
 */

template< class TElastix >
class MovingSmoothingPyramid :
  public
  itk::MultiResolutionGaussianSmoothingPyramidImageFilter<
  typename MovingImagePyramidBase< TElastix >::InputImageType,
  typename MovingImagePyramidBase< TElastix >::OutputImageType >,
  public
  MovingImagePyramidBase< TElastix >
{
public:

  /** Standard ITK. */
  typedef MovingSmoothingPyramid Self;
  typedef itk::MultiResolutionGaussianSmoothingPyramidImageFilter<
    typename MovingImagePyramidBase< TElastix >::InputImageType,
    typename MovingImagePyramidBase< TElastix >::OutputImageType >  Superclass1;
  typedef MovingImagePyramidBase< TElastix > Superclass2;
  typedef itk::SmartPointer< Self >          Pointer;
  typedef itk::SmartPointer< const Self >    ConstPointer;

  /** Method for creation through the object factory. */
  itkNewMacro( Self );

  /** Run-time type information (and related methods). */
  itkTypeMacro( MovingSmoothingPyramid, MultiResolutionGaussianSmoothingPyramidImageFilter );

  /** Name of this class.
   * Use this name in the parameter file to select this specific pyramid. \n
   * example: <tt>(MovingImagePyramid "MovingSmoothingImagePyramid")</tt>\n
   */
  elxClassNameMacro( "MovingSmoothingImagePyramid" );

  /** Get the ImageDimension. */
  itkStaticConstMacro( ImageDimension, unsigned int, Superclass1::ImageDimension );

  /** Typedefs inherited from Superclass1. */
  typedef typename Superclass1::InputImageType         InputImageType;
  typedef typename Superclass1::OutputImageType        OutputImageType;
  typedef typename Superclass1::InputImagePointer      InputImagePointer;
  typedef typename Superclass1::OutputImagePointer     OutputImagePointer;
  typedef typename Superclass1::InputImageConstPointer InputImageConstPointer;

  /** Typedefs inherited from Elastix. */
  typedef typename Superclass2::ElastixType          ElastixType;
  typedef typename Superclass2::ElastixPointer       ElastixPointer;
  typedef typename Superclass2::ConfigurationType    ConfigurationType;
  typedef typename Superclass2::ConfigurationPointer ConfigurationPointer;
  typedef typename Superclass2::RegistrationType     RegistrationType;
  typedef typename Superclass2::RegistrationPointer  RegistrationPointer;
  typedef typename Superclass2::ITKBaseType          ITKBaseType;

protected:

  /** The constructor. */
  MovingSmoothingPyramid() {}
  /** The destructor. */
  virtual ~MovingSmoothingPyramid() {}

private:

  /** The private constructor. */
  MovingSmoothingPyramid( const Self & );   // purposely not implemented
  /** The private copy constructor. */
  void operator=( const Self & );           // purposely not implemented

};

} // end namespace elastix

#ifndef ITK_MANUAL_INSTANTIATION
#include "elxMovingSmoothingPyramid.hxx"
#endif

#endif // end #ifndef __elxMovingSmoothingPyramid_h
