<!-- FreeIPA documentation master file, created by
sphinx-quickstart on Wed Mar 18 08:53:57 2020.
You can adapt this file completely to your liking, but it should at least
contain the root `toctree` directive. -->
# Welcome to FreeIPA’s documentation!

## What is FreeIPA?

FreeIPA is an integrated security information management solution combining
Linux (Fedora), 389 Directory Server, MIT Kerberos, DNS, Dogtag
(Certificate System). It consists of a web interface and command-line
administration tools.

FreeIPA is an integrated Identity and Authentication solution for
Linux/UNIX networked environments. A FreeIPA server provides centralized
authentication, authorization and account information by storing data about
user, groups, hosts and other objects necessary to manage the security
aspects of a network of computers.

FreeIPA is built on top of well known Open Source components and standard
protocols with a very strong focus on ease of management and automation of
installation and configuration tasks.

## Contents:


* [FreeIPA design documentation](designs/index.md)


    * [One-way trust with shared secret](designs/adtrust/oneway-trust-with-shared-secret.md)


    * [Support domain controller for Samba file server as domain member on IPA client](designs/adtrust/samba-domain-controller.md)


    * [Support Samba file server as a domain member on IPA client](designs/adtrust/samba-domain-member.md)


    * [Manage FreeIPA as a user from a trusted Active Directory domain](designs/adtrust/admin-ipa-as-trusted-user.md)


    * [Include users and groups from a trusted Active Directory domain into SUDO rules](designs/adtrust/sudorules-with-ad-objects.md)


    * [ID Range: new option for private groups](designs/adtrust/auto-private-groups.md)


    * [Integrate SID configuration into base IPA installers](designs/adtrust/sidconfig.md)


    * [Policies by authentication indicators](designs/krb-ticket-policy.md)


    * [Extdom plugin protocol](designs/extdom-plugin-protocol.md)


    * [Expiring Password Notifications](designs/expiring-password-notification.md)


    * [LDAP Grace Period](designs/ldap_grace_period.md)


    * [PasswordExpired control](designs/ldap_grace_period.md#passwordexpired-control)


    * [LDAP PAM Passthrough support](designs/ldap_pam_passthrough.md)


    * [Password quality using libpwquality](designs/libpwquality.md)


    * [Member Manager for group membership](designs/membermanager.md)


    * [IPA Migration](designs/ipa_to_ipa_migration.md)


    * [Hidden replicas](designs/hidden-replicas.md)


    * [Disable Stale Users](designs/disable-stale-users.md)


    * [LDAPI autobind authentication for services](designs/ldapi-autobind-services.md)


    * [Central management of subordinate user and group ids](designs/subordinate-ids.md)


    * [FreeIPA and an external identity provider integration](designs/external-idp/external-idp.md)


    * [IPA and an external identity provider integration - idp objects](designs/external-idp/idp-api.md)


    * [Random Serial Numbers v3 (RSNv3)](designs/random-serial-numbers.md)


* [IPA API](api.md)


    * [ipaserver.plugins](api/ipaserver.plugins.md)


* [FreeIPA workshop](workshop.md)


    * [Introduction](workshop/workshop.md)


    * [Preparation](workshop/workshop.md#preparation)


    * [Unit 1: Installing the FreeIPA server](workshop/1-server-install.md)


    * [Unit 2: Enrolling client machines](workshop/2-client-install.md)


    * [Unit 3: User management and Kerberos authentication](workshop/3-user-management.md)


    * [Unit 4: Host-based access control (HBAC)](workshop/4-hbac.md)


    * [Unit 5: Web application authentication and authorisation](workshop/5-web-app-authnz.md)


    * [Unit 6: Service certificates](workshop/6-cert-management.md)


    * [Unit 7: Replica installation](workshop/7-replica-install.md)


    * [Unit 8: Sudo rule management](workshop/8-sudorule.md)


    * [Unit 9: SELinux User Maps](workshop/9-selinux-user-map.md)


    * [Unit 10: SSH user and host key management](workshop/10-ssh-key-management.md)


    * [Unit 11: Kerberos ticket policy](workshop/11-kerberos-ticket-policy.md)


    * [Unit 12: Authentication against external Identity Providers](workshop/12-external-idp-support.md)


    * [Troubleshooting](workshop/troubleshooting.md)


    * [Building Vagrant box images](workshop/building.md)


    * [Notes for workshop facilitators](workshop/facilitators.md)


# Indices and tables


* [Index](genindex.md)


* [Module Index](py-modindex.md)


* [Search Page](search.md)
