#!/usr/bin/env python

"""
A Web interface to a user's calendar.

Copyright (C) 2014, 2015 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

# Edit this path to refer to the location of the imiptools libraries, if
# necessary.

LIBRARY_PATH = "/var/lib/imip-agent"

import sys
sys.path.append(LIBRARY_PATH)

from imipweb.calendar import CalendarPage
from imipweb.event import EventPage
from imipweb.profile import ProfilePage
from imipweb.resource import ResourceClient

class Manager(ResourceClient):

    "A simple manager application."

    def select_action(self):

        "Select the desired action and show the result."

        path_info = self.env.get_path_info().strip("/")

        if not path_info:
            CalendarPage(self).show()
        elif path_info == "profile":
            ProfilePage(self).show()
        elif EventPage(self).show(path_info):
            pass
        else:
            self.no_page()

    def __call__(self):

        "Interpret a request and show an appropriate response."

        if not self.user:
            self.no_user()
        else:
            self.select_action()

        # Write the headers and actual content.

        print >>self.out, "Content-Type: text/html; charset=%s" % self.encoding
        print >>self.out
        self.out.write(unicode(self.page).encode(self.encoding))

if __name__ == "__main__":
    Manager()()

# vim: tabstop=4 expandtab shiftwidth=4
