#!/usr/bin/env python

"""
Show the contents of a table.

Copyright (C) 2016 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from imiptools.data import Object
from imiptools.stores import get_store, get_journal
import sys

def show_list(data):
    if data:
        for row in data:
            print row or ""

def show_object(data):
    if data:
        print Object(data).to_string(line_length=1000)

def show_periods(data):
    if data:
        for row in data:
            print "\t".join(row.as_tuple(strings_only=True))

def show_tuples(data):
    if data:
        for row in data:
            print "\t".join([(column or "") for column in row])

if __name__ == "__main__":
    try:
        store_type, store_dir, journal_dir, user, table = sys.argv[1:6]
        args = sys.argv[6:]
    except ValueError:
        print >>sys.stderr, """\
Need a store type, a store directory, a journal directory, a user URI, and a
table to show. Other arguments may be needed for certain tables.
"""
        sys.exit(1)

    store = get_store(store_type, store_dir)
    journal = get_journal(store_type, journal_dir)

    # Periods.

    if table == "entries":
        group = args[0]
        data = journal.get_entries(user, group)
        show_periods(data)

    elif table == "freebusy":
        data = store.get_freebusy(user)
        show_periods(data)

    elif table == "freebusy_offers":
        data = store.get_freebusy_offers(user)
        show_periods(data)

    elif table == "freebusy_other":
        other = args[0]
        data = store.get_freebusy_for_other(user, other)
        show_periods(data)

    # Tuples.

    elif table == "requests":
        data = store.get_requests(user)
        show_tuples(data)

    elif table == "freebusy_providers":
        data = store.get_freebusy_providers(user)
        show_tuples(data)

    elif table == "journal_freebusy_providers":
        data = journal.get_freebusy_providers(user)
        show_tuples(data)

    # Objects.

    elif table == "countered_object":
        uid = args[0]
        other = args[1]
        data = store.get_counter(user, other, uid)
        show_object(data)

    elif table == "object":
        uid = args[0]
        data = store.get_event(user, uid)
        show_object(data)

    elif table == "journal_object":
        uid = args[0]
        data = journal.get_event(user, uid)
        show_object(data)

    elif table == "recurrence":
        uid = args[0]
        recurrenceid = args[1]
        data = store.get_event(user, uid, recurrenceid)
        show_object(data)

    elif table == "cancelled_recurrences":
        uid = args[0]
        data = store.get_cancelled_recurrences(user, uid)
        show_list(data)

# vim: tabstop=4 expandtab shiftwidth=4
