#!/usr/bin/env python

"""
Set quota limits for a collection of user groups.

Copyright (C) 2016, 2017 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from codecs import getreader
from os.path import abspath, split
import sys

# Find the modules.

try:
    import imiptools
except ImportError:
    parent = abspath(split(split(__file__)[0])[0])
    if split(parent)[1] == "imip-agent":
        sys.path.append(parent)

from imiptools.config import settings
from imiptools.stores import get_journal
from imiptools.text import get_table_from_stream

# Main program.

if __name__ == "__main__":

    # Interpret the command line arguments.

    args = []
    store_type = []
    journal_dir = []

    # Collect quota details first, switching to other arguments when encountering
    # switches.

    l = args

    for arg in sys.argv[1:]:
        if arg == "-T":
            l = store_type
        elif arg == "-j":
            l = journal_dir
        else:
            l.append(arg)

    try:
        quota, = args
    except ValueError:
        print >>sys.stderr, """\
Usage: %s <quota> [ <options> ]

Read from standard input a list of group-to-limit mappings of the following
form:

<user or group> <limit>

For example:

* PT1H

The values may be separated using any whitespace characters.

General options:

-j  Indicates the journal directory location
-T  Indicates the store type (the configured value if omitted)
""" % split(sys.argv[0])[1]
        sys.exit(1)

    # Override defaults if indicated.

    getvalue = lambda value, default=None: value and value[0] or default

    store_type = getvalue(store_type, settings["STORE_TYPE"])
    journal_dir = getvalue(journal_dir)

    # Obtain store-related objects.

    journal = get_journal(store_type, journal_dir)
    f = getreader("utf-8")(sys.stdin)
    limits = dict(get_table_from_stream(f, tab_separated=False))
    journal.set_limits(quota, limits)

# vim: tabstop=4 expandtab shiftwidth=4
