/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jmeter.monitor.parser;

/**
 * Constants for the custom DocumentHandler.
 *
 * @version $Revision: 674365 $
 */
public class Constants {
    public static final String STATUS = "status";

    public static final String JVM = "jvm";

    public static final String CONNECTOR = "connector";

    public static final String MEMORY = "memory";

    public static final String THREADINFO = "threadInfo";

    public static final String REQUESTINFO = "requestInfo";

    public static final String WORKER = "worker";

    public static final String WORKERS = "workers";

    public static final String MEMORY_FREE = "free";

    public static final String MEMORY_TOTAL = "total";

    public static final String MEMORY_MAX = "max";

    public static final String ATTRIBUTE_NAME = "name";

    public static final String MAXTHREADS = "maxThreads";

    public static final String MINSPARETHREADS = "minSpareThreads";

    public static final String MAXSPARETHREADS = "maxSpareThreads";

    public static final String CURRENTTHREADCOUNT = "currentThreadCount";

    public static final String CURRENTBUSYTHREADS = "currentThreadsBusy";

    public static final String MAXTIME = "maxTime=";

    public static final String PROCESSINGTIME = "processingTime=";

    public static final String REQUESTCOUNT = "requestCount";

    public static final String ERRORCOUNT = "errorCount=";

    public static final String BYTESRECEIVED = "bytesReceived";

    public static final String BYTESSENT = "bytesSent";

    public static final String STAGE = "stage";

    public static final String REQUESTPROCESSINGTIME = "requestProcessingTime=";

    public static final String REQUESTBYTESSENT = "requestBytesSent";

    public static final String REQUESTBYTESRECEIVED = "requestBytesReceived";

    public static final String REMOTEADDR = "remoteAddr";

    public static final String VIRTUALHOST = "virtualHost";

    public static final String METHOD = "method";

    public static final String CURRENTURI = "currentUri";

    public static final String CURRENTQUERYSTRING = "currentQueryString";

    public static final String PROTOCOL = "protocol";
}
