/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// CpuTopology struct for CpuTopology
type CpuTopology struct {
	ThreadsPerCore *int32 `json:"threads_per_core,omitempty"`
	CoresPerDie    *int32 `json:"cores_per_die,omitempty"`
	DiesPerPackage *int32 `json:"dies_per_package,omitempty"`
	Packages       *int32 `json:"packages,omitempty"`
}

// NewCpuTopology instantiates a new CpuTopology object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCpuTopology() *CpuTopology {
	this := CpuTopology{}
	return &this
}

// NewCpuTopologyWithDefaults instantiates a new CpuTopology object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCpuTopologyWithDefaults() *CpuTopology {
	this := CpuTopology{}
	return &this
}

// GetThreadsPerCore returns the ThreadsPerCore field value if set, zero value otherwise.
func (o *CpuTopology) GetThreadsPerCore() int32 {
	if o == nil || o.ThreadsPerCore == nil {
		var ret int32
		return ret
	}
	return *o.ThreadsPerCore
}

// GetThreadsPerCoreOk returns a tuple with the ThreadsPerCore field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CpuTopology) GetThreadsPerCoreOk() (*int32, bool) {
	if o == nil || o.ThreadsPerCore == nil {
		return nil, false
	}
	return o.ThreadsPerCore, true
}

// HasThreadsPerCore returns a boolean if a field has been set.
func (o *CpuTopology) HasThreadsPerCore() bool {
	if o != nil && o.ThreadsPerCore != nil {
		return true
	}

	return false
}

// SetThreadsPerCore gets a reference to the given int32 and assigns it to the ThreadsPerCore field.
func (o *CpuTopology) SetThreadsPerCore(v int32) {
	o.ThreadsPerCore = &v
}

// GetCoresPerDie returns the CoresPerDie field value if set, zero value otherwise.
func (o *CpuTopology) GetCoresPerDie() int32 {
	if o == nil || o.CoresPerDie == nil {
		var ret int32
		return ret
	}
	return *o.CoresPerDie
}

// GetCoresPerDieOk returns a tuple with the CoresPerDie field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CpuTopology) GetCoresPerDieOk() (*int32, bool) {
	if o == nil || o.CoresPerDie == nil {
		return nil, false
	}
	return o.CoresPerDie, true
}

// HasCoresPerDie returns a boolean if a field has been set.
func (o *CpuTopology) HasCoresPerDie() bool {
	if o != nil && o.CoresPerDie != nil {
		return true
	}

	return false
}

// SetCoresPerDie gets a reference to the given int32 and assigns it to the CoresPerDie field.
func (o *CpuTopology) SetCoresPerDie(v int32) {
	o.CoresPerDie = &v
}

// GetDiesPerPackage returns the DiesPerPackage field value if set, zero value otherwise.
func (o *CpuTopology) GetDiesPerPackage() int32 {
	if o == nil || o.DiesPerPackage == nil {
		var ret int32
		return ret
	}
	return *o.DiesPerPackage
}

// GetDiesPerPackageOk returns a tuple with the DiesPerPackage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CpuTopology) GetDiesPerPackageOk() (*int32, bool) {
	if o == nil || o.DiesPerPackage == nil {
		return nil, false
	}
	return o.DiesPerPackage, true
}

// HasDiesPerPackage returns a boolean if a field has been set.
func (o *CpuTopology) HasDiesPerPackage() bool {
	if o != nil && o.DiesPerPackage != nil {
		return true
	}

	return false
}

// SetDiesPerPackage gets a reference to the given int32 and assigns it to the DiesPerPackage field.
func (o *CpuTopology) SetDiesPerPackage(v int32) {
	o.DiesPerPackage = &v
}

// GetPackages returns the Packages field value if set, zero value otherwise.
func (o *CpuTopology) GetPackages() int32 {
	if o == nil || o.Packages == nil {
		var ret int32
		return ret
	}
	return *o.Packages
}

// GetPackagesOk returns a tuple with the Packages field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CpuTopology) GetPackagesOk() (*int32, bool) {
	if o == nil || o.Packages == nil {
		return nil, false
	}
	return o.Packages, true
}

// HasPackages returns a boolean if a field has been set.
func (o *CpuTopology) HasPackages() bool {
	if o != nil && o.Packages != nil {
		return true
	}

	return false
}

// SetPackages gets a reference to the given int32 and assigns it to the Packages field.
func (o *CpuTopology) SetPackages(v int32) {
	o.Packages = &v
}

func (o CpuTopology) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ThreadsPerCore != nil {
		toSerialize["threads_per_core"] = o.ThreadsPerCore
	}
	if o.CoresPerDie != nil {
		toSerialize["cores_per_die"] = o.CoresPerDie
	}
	if o.DiesPerPackage != nil {
		toSerialize["dies_per_package"] = o.DiesPerPackage
	}
	if o.Packages != nil {
		toSerialize["packages"] = o.Packages
	}
	return json.Marshal(toSerialize)
}

type NullableCpuTopology struct {
	value *CpuTopology
	isSet bool
}

func (v NullableCpuTopology) Get() *CpuTopology {
	return v.value
}

func (v *NullableCpuTopology) Set(val *CpuTopology) {
	v.value = val
	v.isSet = true
}

func (v NullableCpuTopology) IsSet() bool {
	return v.isSet
}

func (v *NullableCpuTopology) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCpuTopology(val *CpuTopology) *NullableCpuTopology {
	return &NullableCpuTopology{value: val, isSet: true}
}

func (v NullableCpuTopology) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCpuTopology) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
