
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFileDialog.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QFileDialog>
#include <QAbstractFileIconProvider>
#include <QAbstractItemDelegate>
#include <QAbstractProxyModel>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDir>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFileDialog

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFileDialog::staticMetaObject);
}


// QFileDialog::AcceptMode QFileDialog::acceptMode()


static void _init_f_acceptMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDialog::AcceptMode>::target_type > ();
}

static void _call_f_acceptMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFileDialog::AcceptMode>::target_type > ((qt_gsi::Converter<QFileDialog::AcceptMode>::target_type)qt_gsi::CppToQtAdaptor<QFileDialog::AcceptMode>(((QFileDialog *)cls)->acceptMode ()));
}


// QString QFileDialog::defaultSuffix()


static void _init_f_defaultSuffix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_defaultSuffix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFileDialog *)cls)->defaultSuffix ());
}


// QDir QFileDialog::directory()


static void _init_f_directory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_directory_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDir > ((QDir)((QFileDialog *)cls)->directory ());
}


// QUrl QFileDialog::directoryUrl()


static void _init_f_directoryUrl_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_directoryUrl_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QFileDialog *)cls)->directoryUrl ());
}


// QFileDialog::FileMode QFileDialog::fileMode()


static void _init_f_fileMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDialog::FileMode>::target_type > ();
}

static void _call_f_fileMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFileDialog::FileMode>::target_type > ((qt_gsi::Converter<QFileDialog::FileMode>::target_type)qt_gsi::CppToQtAdaptor<QFileDialog::FileMode>(((QFileDialog *)cls)->fileMode ()));
}


// QFlags<QDir::Filter> QFileDialog::filter()


static void _init_f_filter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QDir::Filter> > ();
}

static void _call_f_filter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QDir::Filter> > ((QFlags<QDir::Filter>)((QFileDialog *)cls)->filter ());
}


// QStringList QFileDialog::history()


static void _init_f_history_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_history_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QFileDialog *)cls)->history ());
}


// QAbstractFileIconProvider *QFileDialog::iconProvider()


static void _init_f_iconProvider_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractFileIconProvider * > ();
}

static void _call_f_iconProvider_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractFileIconProvider * > ((QAbstractFileIconProvider *)((QFileDialog *)cls)->iconProvider ());
}


// QAbstractItemDelegate *QFileDialog::itemDelegate()


static void _init_f_itemDelegate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_f_itemDelegate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QFileDialog *)cls)->itemDelegate ());
}


// QString QFileDialog::labelText(QFileDialog::DialogLabel label)


static void _init_f_labelText_c2681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_labelText_c2681 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & >() (args, heap);
  ret.write<QString > ((QString)((QFileDialog *)cls)->labelText (qt_gsi::QtToCppAdaptor<QFileDialog::DialogLabel>(arg1).cref()));
}


// QStringList QFileDialog::mimeTypeFilters()


static void _init_f_mimeTypeFilters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_mimeTypeFilters_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QFileDialog *)cls)->mimeTypeFilters ());
}


// QStringList QFileDialog::nameFilters()


static void _init_f_nameFilters_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_nameFilters_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QFileDialog *)cls)->nameFilters ());
}


// void QFileDialog::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->open ();
}


// void QFileDialog::open(QObject *receiver, const char *member)


static void _init_f_open_2925 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_open_2925 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->open (arg1, arg2);
}


// QFlags<QFileDialog::Option> QFileDialog::options()


static void _init_f_options_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QFileDialog::Option> > ();
}

static void _call_f_options_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QFileDialog::Option> > ((QFlags<QFileDialog::Option>)((QFileDialog *)cls)->options ());
}


// QAbstractProxyModel *QFileDialog::proxyModel()


static void _init_f_proxyModel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractProxyModel * > ();
}

static void _call_f_proxyModel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractProxyModel * > ((QAbstractProxyModel *)((QFileDialog *)cls)->proxyModel ());
}


// bool QFileDialog::restoreState(const QByteArray &state)


static void _init_f_restoreState_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_restoreState_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<bool > ((bool)((QFileDialog *)cls)->restoreState (arg1));
}


// QByteArray QFileDialog::saveState()


static void _init_f_saveState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_saveState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QFileDialog *)cls)->saveState ());
}


// void QFileDialog::selectFile(const QString &filename)


static void _init_f_selectFile_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectFile_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->selectFile (arg1);
}


// void QFileDialog::selectMimeTypeFilter(const QString &filter)


static void _init_f_selectMimeTypeFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectMimeTypeFilter_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->selectMimeTypeFilter (arg1);
}


// void QFileDialog::selectNameFilter(const QString &filter)


static void _init_f_selectNameFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectNameFilter_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->selectNameFilter (arg1);
}


// void QFileDialog::selectUrl(const QUrl &url)


static void _init_f_selectUrl_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_selectUrl_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->selectUrl (arg1);
}


// QStringList QFileDialog::selectedFiles()


static void _init_f_selectedFiles_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_selectedFiles_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QFileDialog *)cls)->selectedFiles ());
}


// QString QFileDialog::selectedMimeTypeFilter()


static void _init_f_selectedMimeTypeFilter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_selectedMimeTypeFilter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFileDialog *)cls)->selectedMimeTypeFilter ());
}


// QString QFileDialog::selectedNameFilter()


static void _init_f_selectedNameFilter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_selectedNameFilter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFileDialog *)cls)->selectedNameFilter ());
}


// QList<QUrl> QFileDialog::selectedUrls()


static void _init_f_selectedUrls_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QUrl> > ();
}

static void _call_f_selectedUrls_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QUrl> > ((QList<QUrl>)((QFileDialog *)cls)->selectedUrls ());
}


// void QFileDialog::setAcceptMode(QFileDialog::AcceptMode mode)


static void _init_f_setAcceptMode_2590 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::AcceptMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptMode_2590 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::AcceptMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::AcceptMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setAcceptMode (qt_gsi::QtToCppAdaptor<QFileDialog::AcceptMode>(arg1).cref());
}


// void QFileDialog::setDefaultSuffix(const QString &suffix)


static void _init_f_setDefaultSuffix_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("suffix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultSuffix_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setDefaultSuffix (arg1);
}


// void QFileDialog::setDirectory(const QString &directory)


static void _init_f_setDirectory_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirectory_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setDirectory (arg1);
}


// void QFileDialog::setDirectory(const QDir &directory)


static void _init_f_setDirectory_1681 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QDir & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirectory_1681 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDir &arg1 = gsi::arg_reader<const QDir & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setDirectory (arg1);
}


// void QFileDialog::setDirectoryUrl(const QUrl &directory)


static void _init_f_setDirectoryUrl_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirectoryUrl_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setDirectoryUrl (arg1);
}


// void QFileDialog::setFileMode(QFileDialog::FileMode mode)


static void _init_f_setFileMode_2382 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::FileMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileMode_2382 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::FileMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::FileMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setFileMode (qt_gsi::QtToCppAdaptor<QFileDialog::FileMode>(arg1).cref());
}


// void QFileDialog::setFilter(QFlags<QDir::Filter> filters)


static void _init_f_setFilter_2230 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<QFlags<QDir::Filter> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilter_2230 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QDir::Filter> arg1 = gsi::arg_reader<QFlags<QDir::Filter> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setFilter (arg1);
}


// void QFileDialog::setHistory(const QStringList &paths)


static void _init_f_setHistory_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paths");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHistory_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setHistory (arg1);
}


// void QFileDialog::setIconProvider(QAbstractFileIconProvider *provider)


static void _init_f_setIconProvider_3143 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("provider");
  decl->add_arg<QAbstractFileIconProvider * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconProvider_3143 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractFileIconProvider *arg1 = gsi::arg_reader<QAbstractFileIconProvider * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setIconProvider (arg1);
}


// void QFileDialog::setItemDelegate(QAbstractItemDelegate *delegate)


static void _init_f_setItemDelegate_2717 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delegate");
  decl->add_arg<QAbstractItemDelegate * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemDelegate_2717 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemDelegate *arg1 = gsi::arg_reader<QAbstractItemDelegate * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setItemDelegate (arg1);
}


// void QFileDialog::setLabelText(QFileDialog::DialogLabel label, const QString &text)


static void _init_f_setLabelText_4598 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setLabelText_4598 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::DialogLabel>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setLabelText (qt_gsi::QtToCppAdaptor<QFileDialog::DialogLabel>(arg1).cref(), arg2);
}


// void QFileDialog::setMimeTypeFilters(const QStringList &filters)


static void _init_f_setMimeTypeFilters_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMimeTypeFilters_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setMimeTypeFilters (arg1);
}


// void QFileDialog::setNameFilter(const QString &filter)


static void _init_f_setNameFilter_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilter_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setNameFilter (arg1);
}


// void QFileDialog::setNameFilters(const QStringList &filters)


static void _init_f_setNameFilters_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filters");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameFilters_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setNameFilters (arg1);
}


// void QFileDialog::setOption(QFileDialog::Option option, bool on)


static void _init_f_setOption_2998 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::Option>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_2998 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::Option>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::Option>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setOption (qt_gsi::QtToCppAdaptor<QFileDialog::Option>(arg1).cref(), arg2);
}


// void QFileDialog::setOptions(QFlags<QFileDialog::Option> options)


static void _init_f_setOptions_2938 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptions_2938 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QFileDialog::Option> arg1 = gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setOptions (arg1);
}


// void QFileDialog::setProxyModel(QAbstractProxyModel *model)


static void _init_f_setProxyModel_2566 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractProxyModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxyModel_2566 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractProxyModel *arg1 = gsi::arg_reader<QAbstractProxyModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setProxyModel (arg1);
}


// void QFileDialog::setSidebarUrls(const QList<QUrl> &urls)


static void _init_f_setSidebarUrls_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("urls");
  decl->add_arg<const QList<QUrl> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSidebarUrls_2316 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QUrl> &arg1 = gsi::arg_reader<const QList<QUrl> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setSidebarUrls (arg1);
}


// void QFileDialog::setSupportedSchemes(const QStringList &schemes)


static void _init_f_setSupportedSchemes_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("schemes");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSupportedSchemes_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setSupportedSchemes (arg1);
}


// void QFileDialog::setViewMode(QFileDialog::ViewMode mode)


static void _init_f_setViewMode_2409 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::ViewMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewMode_2409 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::ViewMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::ViewMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setViewMode (qt_gsi::QtToCppAdaptor<QFileDialog::ViewMode>(arg1).cref());
}


// void QFileDialog::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog *)cls)->setVisible (arg1);
}


// QList<QUrl> QFileDialog::sidebarUrls()


static void _init_f_sidebarUrls_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QUrl> > ();
}

static void _call_f_sidebarUrls_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QUrl> > ((QList<QUrl>)((QFileDialog *)cls)->sidebarUrls ());
}


// QStringList QFileDialog::supportedSchemes()


static void _init_f_supportedSchemes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_supportedSchemes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QFileDialog *)cls)->supportedSchemes ());
}


// bool QFileDialog::testOption(QFileDialog::Option option)


static void _init_f_testOption_c2242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QFileDialog::Option>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c2242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFileDialog::Option>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFileDialog::Option>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QFileDialog *)cls)->testOption (qt_gsi::QtToCppAdaptor<QFileDialog::Option>(arg1).cref()));
}


// QFileDialog::ViewMode QFileDialog::viewMode()


static void _init_f_viewMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFileDialog::ViewMode>::target_type > ();
}

static void _call_f_viewMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFileDialog::ViewMode>::target_type > ((qt_gsi::Converter<QFileDialog::ViewMode>::target_type)qt_gsi::CppToQtAdaptor<QFileDialog::ViewMode>(((QFileDialog *)cls)->viewMode ()));
}


// static QString QFileDialog::getExistingDirectory(QWidget *parent, const QString &caption, const QString &dir, QFlags<QFileDialog::Option> options)


static void _init_f_getExistingDirectory_7979 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("options", true, "QFileDialog::ShowDirsOnly");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_getExistingDirectory_7979 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QFlags<QFileDialog::Option> arg4 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (QFileDialog::ShowDirsOnly, heap);
  ret.write<QString > ((QString)QFileDialog::getExistingDirectory (arg1, arg2, arg3, arg4));
}


// static QUrl QFileDialog::getExistingDirectoryUrl(QWidget *parent, const QString &caption, const QUrl &dir, QFlags<QFileDialog::Option> options, const QStringList &supportedSchemes)


static void _init_f_getExistingDirectoryUrl_9984 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QUrl()");
  decl->add_arg<const QUrl & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("options", true, "QFileDialog::ShowDirsOnly");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("supportedSchemes", true, "QStringList()");
  decl->add_arg<const QStringList & > (argspec_4);
  decl->set_return<QUrl > ();
}

static void _call_f_getExistingDirectoryUrl_9984 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QUrl &arg3 = args ? gsi::arg_reader<const QUrl & >() (args, heap) : gsi::arg_maker<const QUrl & >() (QUrl(), heap);
  QFlags<QFileDialog::Option> arg4 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (QFileDialog::ShowDirsOnly, heap);
  const QStringList &arg5 = args ? gsi::arg_reader<const QStringList & >() (args, heap) : gsi::arg_maker<const QStringList & >() (QStringList(), heap);
  ret.write<QUrl > ((QUrl)QFileDialog::getExistingDirectoryUrl (arg1, arg2, arg3, arg4, arg5));
}


// static QString QFileDialog::getOpenFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)


static void _init_f_getOpenFileName_11122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "nullptr");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "QFileDialog::Options()");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_5);
  decl->set_return<QString > ();
}

static void _call_f_getOpenFileName_11122 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QString *arg5 = args ? gsi::arg_reader<QString * >() (args, heap) : gsi::arg_maker<QString * >() (nullptr, heap);
  QFlags<QFileDialog::Option> arg6 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (QFileDialog::Options(), heap);
  ret.write<QString > ((QString)QFileDialog::getOpenFileName (arg1, arg2, arg3, arg4, arg5, arg6));
}


// static QStringList QFileDialog::getOpenFileNames(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)


static void _init_f_getOpenFileNames_11122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "nullptr");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "QFileDialog::Options()");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_5);
  decl->set_return<QStringList > ();
}

static void _call_f_getOpenFileNames_11122 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QString *arg5 = args ? gsi::arg_reader<QString * >() (args, heap) : gsi::arg_maker<QString * >() (nullptr, heap);
  QFlags<QFileDialog::Option> arg6 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (QFileDialog::Options(), heap);
  ret.write<QStringList > ((QStringList)QFileDialog::getOpenFileNames (arg1, arg2, arg3, arg4, arg5, arg6));
}


// static QUrl QFileDialog::getOpenFileUrl(QWidget *parent, const QString &caption, const QUrl &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options, const QStringList &supportedSchemes)


static void _init_f_getOpenFileUrl_13127 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QUrl()");
  decl->add_arg<const QUrl & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "nullptr");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "QFileDialog::Options()");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("supportedSchemes", true, "QStringList()");
  decl->add_arg<const QStringList & > (argspec_6);
  decl->set_return<QUrl > ();
}

static void _call_f_getOpenFileUrl_13127 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QUrl &arg3 = args ? gsi::arg_reader<const QUrl & >() (args, heap) : gsi::arg_maker<const QUrl & >() (QUrl(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QString *arg5 = args ? gsi::arg_reader<QString * >() (args, heap) : gsi::arg_maker<QString * >() (nullptr, heap);
  QFlags<QFileDialog::Option> arg6 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (QFileDialog::Options(), heap);
  const QStringList &arg7 = args ? gsi::arg_reader<const QStringList & >() (args, heap) : gsi::arg_maker<const QStringList & >() (QStringList(), heap);
  ret.write<QUrl > ((QUrl)QFileDialog::getOpenFileUrl (arg1, arg2, arg3, arg4, arg5, arg6, arg7));
}


// static QList<QUrl> QFileDialog::getOpenFileUrls(QWidget *parent, const QString &caption, const QUrl &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options, const QStringList &supportedSchemes)


static void _init_f_getOpenFileUrls_13127 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QUrl()");
  decl->add_arg<const QUrl & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "nullptr");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "QFileDialog::Options()");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("supportedSchemes", true, "QStringList()");
  decl->add_arg<const QStringList & > (argspec_6);
  decl->set_return<QList<QUrl> > ();
}

static void _call_f_getOpenFileUrls_13127 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QUrl &arg3 = args ? gsi::arg_reader<const QUrl & >() (args, heap) : gsi::arg_maker<const QUrl & >() (QUrl(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QString *arg5 = args ? gsi::arg_reader<QString * >() (args, heap) : gsi::arg_maker<QString * >() (nullptr, heap);
  QFlags<QFileDialog::Option> arg6 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (QFileDialog::Options(), heap);
  const QStringList &arg7 = args ? gsi::arg_reader<const QStringList & >() (args, heap) : gsi::arg_maker<const QStringList & >() (QStringList(), heap);
  ret.write<QList<QUrl> > ((QList<QUrl>)QFileDialog::getOpenFileUrls (arg1, arg2, arg3, arg4, arg5, arg6, arg7));
}


// static QString QFileDialog::getSaveFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)


static void _init_f_getSaveFileName_11122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "nullptr");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "QFileDialog::Options()");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_5);
  decl->set_return<QString > ();
}

static void _call_f_getSaveFileName_11122 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QString *arg5 = args ? gsi::arg_reader<QString * >() (args, heap) : gsi::arg_maker<QString * >() (nullptr, heap);
  QFlags<QFileDialog::Option> arg6 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (QFileDialog::Options(), heap);
  ret.write<QString > ((QString)QFileDialog::getSaveFileName (arg1, arg2, arg3, arg4, arg5, arg6));
}


// static QUrl QFileDialog::getSaveFileUrl(QWidget *parent, const QString &caption, const QUrl &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options, const QStringList &supportedSchemes)


static void _init_f_getSaveFileUrl_13127 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dir", true, "QUrl()");
  decl->add_arg<const QUrl & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("selectedFilter", true, "nullptr");
  decl->add_arg<QString * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("options", true, "QFileDialog::Options()");
  decl->add_arg<QFlags<QFileDialog::Option> > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("supportedSchemes", true, "QStringList()");
  decl->add_arg<const QStringList & > (argspec_6);
  decl->set_return<QUrl > ();
}

static void _call_f_getSaveFileUrl_13127 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QUrl &arg3 = args ? gsi::arg_reader<const QUrl & >() (args, heap) : gsi::arg_maker<const QUrl & >() (QUrl(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QString *arg5 = args ? gsi::arg_reader<QString * >() (args, heap) : gsi::arg_maker<QString * >() (nullptr, heap);
  QFlags<QFileDialog::Option> arg6 = args ? gsi::arg_reader<QFlags<QFileDialog::Option> >() (args, heap) : gsi::arg_maker<QFlags<QFileDialog::Option> >() (QFileDialog::Options(), heap);
  const QStringList &arg7 = args ? gsi::arg_reader<const QStringList & >() (args, heap) : gsi::arg_maker<const QStringList & >() (QStringList(), heap);
  ret.write<QUrl > ((QUrl)QFileDialog::getSaveFileUrl (arg1, arg2, arg3, arg4, arg5, arg6, arg7));
}


// static void QFileDialog::saveFileContent(const QByteArray &fileContent, const QString &fileNameHint)


static void _init_f_saveFileContent_4226 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileContent");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fileNameHint", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_saveFileContent_4226 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QFileDialog::saveFileContent (arg1, arg2);
}


// static QString QFileDialog::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QFileDialog::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QFileDialog () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":acceptMode", "@brief Method QFileDialog::AcceptMode QFileDialog::acceptMode()\n", true, &_init_f_acceptMode_c0, &_call_f_acceptMode_c0);
  methods += new qt_gsi::GenericMethod (":defaultSuffix", "@brief Method QString QFileDialog::defaultSuffix()\n", true, &_init_f_defaultSuffix_c0, &_call_f_defaultSuffix_c0);
  methods += new qt_gsi::GenericMethod ("directory", "@brief Method QDir QFileDialog::directory()\n", true, &_init_f_directory_c0, &_call_f_directory_c0);
  methods += new qt_gsi::GenericMethod (":directoryUrl", "@brief Method QUrl QFileDialog::directoryUrl()\n", true, &_init_f_directoryUrl_c0, &_call_f_directoryUrl_c0);
  methods += new qt_gsi::GenericMethod (":fileMode", "@brief Method QFileDialog::FileMode QFileDialog::fileMode()\n", true, &_init_f_fileMode_c0, &_call_f_fileMode_c0);
  methods += new qt_gsi::GenericMethod (":filter", "@brief Method QFlags<QDir::Filter> QFileDialog::filter()\n", true, &_init_f_filter_c0, &_call_f_filter_c0);
  methods += new qt_gsi::GenericMethod (":history", "@brief Method QStringList QFileDialog::history()\n", true, &_init_f_history_c0, &_call_f_history_c0);
  methods += new qt_gsi::GenericMethod (":iconProvider", "@brief Method QAbstractFileIconProvider *QFileDialog::iconProvider()\n", true, &_init_f_iconProvider_c0, &_call_f_iconProvider_c0);
  methods += new qt_gsi::GenericMethod (":itemDelegate", "@brief Method QAbstractItemDelegate *QFileDialog::itemDelegate()\n", true, &_init_f_itemDelegate_c0, &_call_f_itemDelegate_c0);
  methods += new qt_gsi::GenericMethod ("labelText", "@brief Method QString QFileDialog::labelText(QFileDialog::DialogLabel label)\n", true, &_init_f_labelText_c2681, &_call_f_labelText_c2681);
  methods += new qt_gsi::GenericMethod (":mimeTypeFilters", "@brief Method QStringList QFileDialog::mimeTypeFilters()\n", true, &_init_f_mimeTypeFilters_c0, &_call_f_mimeTypeFilters_c0);
  methods += new qt_gsi::GenericMethod (":nameFilters", "@brief Method QStringList QFileDialog::nameFilters()\n", true, &_init_f_nameFilters_c0, &_call_f_nameFilters_c0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QFileDialog::open()\nThis is a reimplementation of QDialog::open", false, &_init_f_open_0, &_call_f_open_0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method void QFileDialog::open(QObject *receiver, const char *member)\n", false, &_init_f_open_2925, &_call_f_open_2925);
  methods += new qt_gsi::GenericMethod (":options", "@brief Method QFlags<QFileDialog::Option> QFileDialog::options()\n", true, &_init_f_options_c0, &_call_f_options_c0);
  methods += new qt_gsi::GenericMethod (":proxyModel", "@brief Method QAbstractProxyModel *QFileDialog::proxyModel()\n", true, &_init_f_proxyModel_c0, &_call_f_proxyModel_c0);
  methods += new qt_gsi::GenericMethod ("restoreState", "@brief Method bool QFileDialog::restoreState(const QByteArray &state)\n", false, &_init_f_restoreState_2309, &_call_f_restoreState_2309);
  methods += new qt_gsi::GenericMethod ("saveState", "@brief Method QByteArray QFileDialog::saveState()\n", true, &_init_f_saveState_c0, &_call_f_saveState_c0);
  methods += new qt_gsi::GenericMethod ("selectFile", "@brief Method void QFileDialog::selectFile(const QString &filename)\n", false, &_init_f_selectFile_2025, &_call_f_selectFile_2025);
  methods += new qt_gsi::GenericMethod ("selectMimeTypeFilter", "@brief Method void QFileDialog::selectMimeTypeFilter(const QString &filter)\n", false, &_init_f_selectMimeTypeFilter_2025, &_call_f_selectMimeTypeFilter_2025);
  methods += new qt_gsi::GenericMethod ("selectNameFilter", "@brief Method void QFileDialog::selectNameFilter(const QString &filter)\n", false, &_init_f_selectNameFilter_2025, &_call_f_selectNameFilter_2025);
  methods += new qt_gsi::GenericMethod ("selectUrl", "@brief Method void QFileDialog::selectUrl(const QUrl &url)\n", false, &_init_f_selectUrl_1701, &_call_f_selectUrl_1701);
  methods += new qt_gsi::GenericMethod ("selectedFiles", "@brief Method QStringList QFileDialog::selectedFiles()\n", true, &_init_f_selectedFiles_c0, &_call_f_selectedFiles_c0);
  methods += new qt_gsi::GenericMethod ("selectedMimeTypeFilter", "@brief Method QString QFileDialog::selectedMimeTypeFilter()\n", true, &_init_f_selectedMimeTypeFilter_c0, &_call_f_selectedMimeTypeFilter_c0);
  methods += new qt_gsi::GenericMethod ("selectedNameFilter", "@brief Method QString QFileDialog::selectedNameFilter()\n", true, &_init_f_selectedNameFilter_c0, &_call_f_selectedNameFilter_c0);
  methods += new qt_gsi::GenericMethod ("selectedUrls", "@brief Method QList<QUrl> QFileDialog::selectedUrls()\n", true, &_init_f_selectedUrls_c0, &_call_f_selectedUrls_c0);
  methods += new qt_gsi::GenericMethod ("setAcceptMode|acceptMode=", "@brief Method void QFileDialog::setAcceptMode(QFileDialog::AcceptMode mode)\n", false, &_init_f_setAcceptMode_2590, &_call_f_setAcceptMode_2590);
  methods += new qt_gsi::GenericMethod ("setDefaultSuffix|defaultSuffix=", "@brief Method void QFileDialog::setDefaultSuffix(const QString &suffix)\n", false, &_init_f_setDefaultSuffix_2025, &_call_f_setDefaultSuffix_2025);
  methods += new qt_gsi::GenericMethod ("setDirectory", "@brief Method void QFileDialog::setDirectory(const QString &directory)\n", false, &_init_f_setDirectory_2025, &_call_f_setDirectory_2025);
  methods += new qt_gsi::GenericMethod ("setDirectory", "@brief Method void QFileDialog::setDirectory(const QDir &directory)\n", false, &_init_f_setDirectory_1681, &_call_f_setDirectory_1681);
  methods += new qt_gsi::GenericMethod ("setDirectoryUrl|directoryUrl=", "@brief Method void QFileDialog::setDirectoryUrl(const QUrl &directory)\n", false, &_init_f_setDirectoryUrl_1701, &_call_f_setDirectoryUrl_1701);
  methods += new qt_gsi::GenericMethod ("setFileMode|fileMode=", "@brief Method void QFileDialog::setFileMode(QFileDialog::FileMode mode)\n", false, &_init_f_setFileMode_2382, &_call_f_setFileMode_2382);
  methods += new qt_gsi::GenericMethod ("setFilter|filter=", "@brief Method void QFileDialog::setFilter(QFlags<QDir::Filter> filters)\n", false, &_init_f_setFilter_2230, &_call_f_setFilter_2230);
  methods += new qt_gsi::GenericMethod ("setHistory|history=", "@brief Method void QFileDialog::setHistory(const QStringList &paths)\n", false, &_init_f_setHistory_2437, &_call_f_setHistory_2437);
  methods += new qt_gsi::GenericMethod ("setIconProvider|iconProvider=", "@brief Method void QFileDialog::setIconProvider(QAbstractFileIconProvider *provider)\n", false, &_init_f_setIconProvider_3143, &_call_f_setIconProvider_3143);
  methods += new qt_gsi::GenericMethod ("setItemDelegate|itemDelegate=", "@brief Method void QFileDialog::setItemDelegate(QAbstractItemDelegate *delegate)\n", false, &_init_f_setItemDelegate_2717, &_call_f_setItemDelegate_2717);
  methods += new qt_gsi::GenericMethod ("setLabelText", "@brief Method void QFileDialog::setLabelText(QFileDialog::DialogLabel label, const QString &text)\n", false, &_init_f_setLabelText_4598, &_call_f_setLabelText_4598);
  methods += new qt_gsi::GenericMethod ("setMimeTypeFilters|mimeTypeFilters=", "@brief Method void QFileDialog::setMimeTypeFilters(const QStringList &filters)\n", false, &_init_f_setMimeTypeFilters_2437, &_call_f_setMimeTypeFilters_2437);
  methods += new qt_gsi::GenericMethod ("setNameFilter", "@brief Method void QFileDialog::setNameFilter(const QString &filter)\n", false, &_init_f_setNameFilter_2025, &_call_f_setNameFilter_2025);
  methods += new qt_gsi::GenericMethod ("setNameFilters|nameFilters=", "@brief Method void QFileDialog::setNameFilters(const QStringList &filters)\n", false, &_init_f_setNameFilters_2437, &_call_f_setNameFilters_2437);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Method void QFileDialog::setOption(QFileDialog::Option option, bool on)\n", false, &_init_f_setOption_2998, &_call_f_setOption_2998);
  methods += new qt_gsi::GenericMethod ("setOptions|options=", "@brief Method void QFileDialog::setOptions(QFlags<QFileDialog::Option> options)\n", false, &_init_f_setOptions_2938, &_call_f_setOptions_2938);
  methods += new qt_gsi::GenericMethod ("setProxyModel|proxyModel=", "@brief Method void QFileDialog::setProxyModel(QAbstractProxyModel *model)\n", false, &_init_f_setProxyModel_2566, &_call_f_setProxyModel_2566);
  methods += new qt_gsi::GenericMethod ("setSidebarUrls|sidebarUrls=", "@brief Method void QFileDialog::setSidebarUrls(const QList<QUrl> &urls)\n", false, &_init_f_setSidebarUrls_2316, &_call_f_setSidebarUrls_2316);
  methods += new qt_gsi::GenericMethod ("setSupportedSchemes", "@brief Method void QFileDialog::setSupportedSchemes(const QStringList &schemes)\n", false, &_init_f_setSupportedSchemes_2437, &_call_f_setSupportedSchemes_2437);
  methods += new qt_gsi::GenericMethod ("setViewMode|viewMode=", "@brief Method void QFileDialog::setViewMode(QFileDialog::ViewMode mode)\n", false, &_init_f_setViewMode_2409, &_call_f_setViewMode_2409);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QFileDialog::setVisible(bool visible)\nThis is a reimplementation of QDialog::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += new qt_gsi::GenericMethod (":sidebarUrls", "@brief Method QList<QUrl> QFileDialog::sidebarUrls()\n", true, &_init_f_sidebarUrls_c0, &_call_f_sidebarUrls_c0);
  methods += new qt_gsi::GenericMethod ("supportedSchemes", "@brief Method QStringList QFileDialog::supportedSchemes()\n", true, &_init_f_supportedSchemes_c0, &_call_f_supportedSchemes_c0);
  methods += new qt_gsi::GenericMethod ("testOption", "@brief Method bool QFileDialog::testOption(QFileDialog::Option option)\n", true, &_init_f_testOption_c2242, &_call_f_testOption_c2242);
  methods += new qt_gsi::GenericMethod (":viewMode", "@brief Method QFileDialog::ViewMode QFileDialog::viewMode()\n", true, &_init_f_viewMode_c0, &_call_f_viewMode_c0);
  methods += gsi::qt_signal ("accepted()", "accepted", "@brief Signal declaration for QFileDialog::accepted()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("currentChanged(const QString &)", "currentChanged", gsi::arg("path"), "@brief Signal declaration for QFileDialog::currentChanged(const QString &path)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QUrl & > ("currentUrlChanged(const QUrl &)", "currentUrlChanged", gsi::arg("url"), "@brief Signal declaration for QFileDialog::currentUrlChanged(const QUrl &url)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QFileDialog::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QFileDialog::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("directoryEntered(const QString &)", "directoryEntered", gsi::arg("directory"), "@brief Signal declaration for QFileDialog::directoryEntered(const QString &directory)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QUrl & > ("directoryUrlEntered(const QUrl &)", "directoryUrlEntered", gsi::arg("directory"), "@brief Signal declaration for QFileDialog::directoryUrlEntered(const QUrl &directory)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("fileSelected(const QString &)", "fileSelected", gsi::arg("file"), "@brief Signal declaration for QFileDialog::fileSelected(const QString &file)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QStringList & > ("filesSelected(const QStringList &)", "filesSelected", gsi::arg("files"), "@brief Signal declaration for QFileDialog::filesSelected(const QStringList &files)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("filterSelected(const QString &)", "filterSelected", gsi::arg("filter"), "@brief Signal declaration for QFileDialog::filterSelected(const QString &filter)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("finished(int)", "finished", gsi::arg("result"), "@brief Signal declaration for QFileDialog::finished(int result)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QFileDialog::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rejected()", "rejected", "@brief Signal declaration for QFileDialog::rejected()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QUrl & > ("urlSelected(const QUrl &)", "urlSelected", gsi::arg("url"), "@brief Signal declaration for QFileDialog::urlSelected(const QUrl &url)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QList<QUrl> & > ("urlsSelected(const QList<QUrl> &)", "urlsSelected", gsi::arg("urls"), "@brief Signal declaration for QFileDialog::urlsSelected(const QList<QUrl> &urls)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QFileDialog::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QFileDialog::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QFileDialog::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("getExistingDirectory", "@brief Static method QString QFileDialog::getExistingDirectory(QWidget *parent, const QString &caption, const QString &dir, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getExistingDirectory_7979, &_call_f_getExistingDirectory_7979);
  methods += new qt_gsi::GenericStaticMethod ("getExistingDirectoryUrl", "@brief Static method QUrl QFileDialog::getExistingDirectoryUrl(QWidget *parent, const QString &caption, const QUrl &dir, QFlags<QFileDialog::Option> options, const QStringList &supportedSchemes)\nThis method is static and can be called without an instance.", &_init_f_getExistingDirectoryUrl_9984, &_call_f_getExistingDirectoryUrl_9984);
  methods += new qt_gsi::GenericStaticMethod ("getOpenFileName", "@brief Static method QString QFileDialog::getOpenFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getOpenFileName_11122, &_call_f_getOpenFileName_11122);
  methods += new qt_gsi::GenericStaticMethod ("getOpenFileNames", "@brief Static method QStringList QFileDialog::getOpenFileNames(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getOpenFileNames_11122, &_call_f_getOpenFileNames_11122);
  methods += new qt_gsi::GenericStaticMethod ("getOpenFileUrl", "@brief Static method QUrl QFileDialog::getOpenFileUrl(QWidget *parent, const QString &caption, const QUrl &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options, const QStringList &supportedSchemes)\nThis method is static and can be called without an instance.", &_init_f_getOpenFileUrl_13127, &_call_f_getOpenFileUrl_13127);
  methods += new qt_gsi::GenericStaticMethod ("getOpenFileUrls", "@brief Static method QList<QUrl> QFileDialog::getOpenFileUrls(QWidget *parent, const QString &caption, const QUrl &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options, const QStringList &supportedSchemes)\nThis method is static and can be called without an instance.", &_init_f_getOpenFileUrls_13127, &_call_f_getOpenFileUrls_13127);
  methods += new qt_gsi::GenericStaticMethod ("getSaveFileName", "@brief Static method QString QFileDialog::getSaveFileName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options)\nThis method is static and can be called without an instance.", &_init_f_getSaveFileName_11122, &_call_f_getSaveFileName_11122);
  methods += new qt_gsi::GenericStaticMethod ("getSaveFileUrl", "@brief Static method QUrl QFileDialog::getSaveFileUrl(QWidget *parent, const QString &caption, const QUrl &dir, const QString &filter, QString *selectedFilter, QFlags<QFileDialog::Option> options, const QStringList &supportedSchemes)\nThis method is static and can be called without an instance.", &_init_f_getSaveFileUrl_13127, &_call_f_getSaveFileUrl_13127);
  methods += new qt_gsi::GenericStaticMethod ("saveFileContent", "@brief Static method void QFileDialog::saveFileContent(const QByteArray &fileContent, const QString &fileNameHint)\nThis method is static and can be called without an instance.", &_init_f_saveFileContent_4226, &_call_f_saveFileContent_4226);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFileDialog::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QDialog> &qtdecl_QDialog ();

qt_gsi::QtNativeClass<QFileDialog> decl_QFileDialog (qtdecl_QDialog (), "QtWidgets", "QFileDialog_Native",
  methods_QFileDialog (),
  "@hide\n@alias QFileDialog");

GSI_QTWIDGETS_PUBLIC gsi::Class<QFileDialog> &qtdecl_QFileDialog () { return decl_QFileDialog; }

}


class QFileDialog_Adaptor : public QFileDialog, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFileDialog_Adaptor();

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, QFlags<Qt::WindowType> f)
  QFileDialog_Adaptor(QWidget *parent, QFlags<Qt::WindowType> f) : QFileDialog(parent, f)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor() : QFileDialog()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent) : QFileDialog(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent, const QString &caption) : QFileDialog(parent, caption)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent, const QString &caption, const QString &directory) : QFileDialog(parent, caption, directory)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)
  QFileDialog_Adaptor(QWidget *parent, const QString &caption, const QString &directory, const QString &filter) : QFileDialog(parent, caption, directory, filter)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QFileDialog::adjustPosition(QWidget *)
  void fp_QFileDialog_adjustPosition_1315 (QWidget *arg1) {
    QFileDialog::adjustPosition(arg1);
  }

  //  [expose] void QFileDialog::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QFileDialog_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QFileDialog::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QFileDialog::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QFileDialog_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QFileDialog::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QFileDialog::focusNextChild()
  bool fp_QFileDialog_focusNextChild_0 () {
    return QFileDialog::focusNextChild();
  }

  //  [expose] bool QFileDialog::focusPreviousChild()
  bool fp_QFileDialog_focusPreviousChild_0 () {
    return QFileDialog::focusPreviousChild();
  }

  //  [expose] bool QFileDialog::isSignalConnected(const QMetaMethod &signal)
  bool fp_QFileDialog_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QFileDialog::isSignalConnected(signal);
  }

  //  [expose] int QFileDialog::receivers(const char *signal)
  int fp_QFileDialog_receivers_c1731 (const char *signal) const {
    return QFileDialog::receivers(signal);
  }

  //  [expose] QObject *QFileDialog::sender()
  QObject * fp_QFileDialog_sender_c0 () const {
    return QFileDialog::sender();
  }

  //  [expose] int QFileDialog::senderSignalIndex()
  int fp_QFileDialog_senderSignalIndex_c0 () const {
    return QFileDialog::senderSignalIndex();
  }

  //  [expose] void QFileDialog::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QFileDialog_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QFileDialog::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [emitter impl] void QFileDialog::accepted()
  void emitter_QFileDialog_accepted_0()
  {
    emit QFileDialog::accepted();
  }

  //  [emitter impl] void QFileDialog::currentChanged(const QString &path)
  void emitter_QFileDialog_currentChanged_2025(const QString &path)
  {
    emit QFileDialog::currentChanged(path);
  }

  //  [emitter impl] void QFileDialog::currentUrlChanged(const QUrl &url)
  void emitter_QFileDialog_currentUrlChanged_1701(const QUrl &url)
  {
    emit QFileDialog::currentUrlChanged(url);
  }

  //  [emitter impl] void QFileDialog::customContextMenuRequested(const QPoint &pos)
  void emitter_QFileDialog_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QFileDialog::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QFileDialog::destroyed(QObject *)
  void emitter_QFileDialog_destroyed_1302(QObject *arg1)
  {
    emit QFileDialog::destroyed(arg1);
  }

  //  [emitter impl] void QFileDialog::directoryEntered(const QString &directory)
  void emitter_QFileDialog_directoryEntered_2025(const QString &directory)
  {
    emit QFileDialog::directoryEntered(directory);
  }

  //  [emitter impl] void QFileDialog::directoryUrlEntered(const QUrl &directory)
  void emitter_QFileDialog_directoryUrlEntered_1701(const QUrl &directory)
  {
    emit QFileDialog::directoryUrlEntered(directory);
  }

  //  [adaptor impl] int QFileDialog::exec()
  int cbs_exec_0_0()
  {
    return QFileDialog::exec();
  }

  virtual int exec()
  {
    if (cb_exec_0_0.can_issue()) {
      return cb_exec_0_0.issue<QFileDialog_Adaptor, int>(&QFileDialog_Adaptor::cbs_exec_0_0);
    } else {
      return QFileDialog::exec();
    }
  }

  //  [emitter impl] void QFileDialog::fileSelected(const QString &file)
  void emitter_QFileDialog_fileSelected_2025(const QString &file)
  {
    emit QFileDialog::fileSelected(file);
  }

  //  [emitter impl] void QFileDialog::filesSelected(const QStringList &files)
  void emitter_QFileDialog_filesSelected_2437(const QStringList &files)
  {
    emit QFileDialog::filesSelected(files);
  }

  //  [emitter impl] void QFileDialog::filterSelected(const QString &filter)
  void emitter_QFileDialog_filterSelected_2025(const QString &filter)
  {
    emit QFileDialog::filterSelected(filter);
  }

  //  [emitter impl] void QFileDialog::finished(int result)
  void emitter_QFileDialog_finished_767(int result)
  {
    emit QFileDialog::finished(result);
  }

  //  [adaptor impl] bool QFileDialog::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QFileDialog::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QFileDialog_Adaptor, bool>(&QFileDialog_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QFileDialog::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QFileDialog::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QFileDialog::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QFileDialog_Adaptor, int, int>(&QFileDialog_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QFileDialog::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QFileDialog::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QFileDialog::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QFileDialog_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QFileDialog_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QFileDialog::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QFileDialog::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QFileDialog::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QFileDialog_Adaptor, QSize>(&QFileDialog_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QFileDialog::minimumSizeHint();
    }
  }

  //  [emitter impl] void QFileDialog::objectNameChanged(const QString &objectName)
  void emitter_QFileDialog_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QFileDialog::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QFileDialog::open()
  void cbs_open_0_0()
  {
    QFileDialog::open();
  }

  virtual void open()
  {
    if (cb_open_0_0.can_issue()) {
      cb_open_0_0.issue<QFileDialog_Adaptor>(&QFileDialog_Adaptor::cbs_open_0_0);
    } else {
      QFileDialog::open();
    }
  }

  //  [adaptor impl] QPaintEngine *QFileDialog::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QFileDialog::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QFileDialog_Adaptor, QPaintEngine *>(&QFileDialog_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QFileDialog::paintEngine();
    }
  }

  //  [adaptor impl] void QFileDialog::reject()
  void cbs_reject_0_0()
  {
    QFileDialog::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QFileDialog_Adaptor>(&QFileDialog_Adaptor::cbs_reject_0_0);
    } else {
      QFileDialog::reject();
    }
  }

  //  [emitter impl] void QFileDialog::rejected()
  void emitter_QFileDialog_rejected_0()
  {
    emit QFileDialog::rejected();
  }

  //  [adaptor impl] void QFileDialog::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QFileDialog::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QFileDialog_Adaptor, bool>(&QFileDialog_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QFileDialog::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QFileDialog::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QFileDialog::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QFileDialog_Adaptor, QSize>(&QFileDialog_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QFileDialog::sizeHint();
    }
  }

  //  [emitter impl] void QFileDialog::urlSelected(const QUrl &url)
  void emitter_QFileDialog_urlSelected_1701(const QUrl &url)
  {
    emit QFileDialog::urlSelected(url);
  }

  //  [emitter impl] void QFileDialog::urlsSelected(const QList<QUrl> &urls)
  void emitter_QFileDialog_urlsSelected_2316(const QList<QUrl> &urls)
  {
    emit QFileDialog::urlsSelected(urls);
  }

  //  [emitter impl] void QFileDialog::windowIconChanged(const QIcon &icon)
  void emitter_QFileDialog_windowIconChanged_1787(const QIcon &icon)
  {
    emit QFileDialog::windowIconChanged(icon);
  }

  //  [emitter impl] void QFileDialog::windowIconTextChanged(const QString &iconText)
  void emitter_QFileDialog_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QFileDialog::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QFileDialog::windowTitleChanged(const QString &title)
  void emitter_QFileDialog_windowTitleChanged_2025(const QString &title)
  {
    emit QFileDialog::windowTitleChanged(title);
  }

  //  [adaptor impl] void QFileDialog::accept()
  void cbs_accept_0_0()
  {
    QFileDialog::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QFileDialog_Adaptor>(&QFileDialog_Adaptor::cbs_accept_0_0);
    } else {
      QFileDialog::accept();
    }
  }

  //  [adaptor impl] void QFileDialog::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QFileDialog::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QFileDialog_Adaptor, QActionEvent *>(&QFileDialog_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QFileDialog::actionEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QFileDialog::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QFileDialog::changeEvent(e);
    }
  }

  //  [adaptor impl] void QFileDialog::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QFileDialog::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QFileDialog_Adaptor, QChildEvent *>(&QFileDialog_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QFileDialog::childEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QFileDialog::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QFileDialog_Adaptor, QCloseEvent *>(&QFileDialog_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QFileDialog::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QFileDialog::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QFileDialog_Adaptor, QContextMenuEvent *>(&QFileDialog_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QFileDialog::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QFileDialog::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QFileDialog::customEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QFileDialog::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QFileDialog_Adaptor, const QMetaMethod &>(&QFileDialog_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QFileDialog::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QFileDialog::done(int result)
  void cbs_done_767_0(int result)
  {
    QFileDialog::done(result);
  }

  virtual void done(int result)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QFileDialog_Adaptor, int>(&QFileDialog_Adaptor::cbs_done_767_0, result);
    } else {
      QFileDialog::done(result);
    }
  }

  //  [adaptor impl] void QFileDialog::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QFileDialog::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QFileDialog_Adaptor, QDragEnterEvent *>(&QFileDialog_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QFileDialog::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QFileDialog::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QFileDialog_Adaptor, QDragLeaveEvent *>(&QFileDialog_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QFileDialog::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QFileDialog::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QFileDialog_Adaptor, QDragMoveEvent *>(&QFileDialog_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QFileDialog::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QFileDialog::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QFileDialog_Adaptor, QDropEvent *>(&QFileDialog_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QFileDialog::dropEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QFileDialog::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QFileDialog_Adaptor, QEnterEvent *>(&QFileDialog_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QFileDialog::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QFileDialog::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QFileDialog::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QFileDialog_Adaptor, bool, QEvent *>(&QFileDialog_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QFileDialog::event(_event);
    }
  }

  //  [adaptor impl] bool QFileDialog::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QFileDialog::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QFileDialog_Adaptor, bool, QObject *, QEvent *>(&QFileDialog_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QFileDialog::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QFileDialog::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QFileDialog::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QFileDialog_Adaptor, QFocusEvent *>(&QFileDialog_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QFileDialog::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QFileDialog::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QFileDialog::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QFileDialog_Adaptor, bool, bool>(&QFileDialog_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QFileDialog::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QFileDialog::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QFileDialog::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QFileDialog_Adaptor, QFocusEvent *>(&QFileDialog_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QFileDialog::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QFileDialog::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QFileDialog_Adaptor, QHideEvent *>(&QFileDialog_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QFileDialog::hideEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QFileDialog::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QFileDialog_Adaptor, QPainter *>(&QFileDialog_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QFileDialog::initPainter(painter);
    }
  }

  //  [adaptor impl] void QFileDialog::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QFileDialog::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QFileDialog_Adaptor, QInputMethodEvent *>(&QFileDialog_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QFileDialog::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QFileDialog::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QFileDialog_Adaptor, QKeyEvent *>(&QFileDialog_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QFileDialog::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QFileDialog::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QFileDialog_Adaptor, QKeyEvent *>(&QFileDialog_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QFileDialog::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QFileDialog::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QFileDialog_Adaptor, QEvent *>(&QFileDialog_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QFileDialog::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QFileDialog::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QFileDialog::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QFileDialog_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QFileDialog_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QFileDialog::metric(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QFileDialog::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QFileDialog::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QFileDialog::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QFileDialog::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QFileDialog::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QFileDialog::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QFileDialog::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QFileDialog_Adaptor, QMouseEvent *>(&QFileDialog_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QFileDialog::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QFileDialog::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QFileDialog_Adaptor, QMoveEvent *>(&QFileDialog_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QFileDialog::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QFileDialog::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QFileDialog::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QFileDialog_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QFileDialog_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QFileDialog::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QFileDialog::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QFileDialog::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QFileDialog_Adaptor, QPaintEvent *>(&QFileDialog_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QFileDialog::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QFileDialog::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QFileDialog::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QFileDialog_Adaptor, QPaintDevice *, QPoint *>(&QFileDialog_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QFileDialog::redirected(offset);
    }
  }

  //  [adaptor impl] void QFileDialog::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QFileDialog::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QFileDialog_Adaptor, QResizeEvent *>(&QFileDialog_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QFileDialog::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] QPainter *QFileDialog::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QFileDialog::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QFileDialog_Adaptor, QPainter *>(&QFileDialog_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QFileDialog::sharedPainter();
    }
  }

  //  [adaptor impl] void QFileDialog::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QFileDialog::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QFileDialog_Adaptor, QShowEvent *>(&QFileDialog_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QFileDialog::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QFileDialog::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QFileDialog::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QFileDialog_Adaptor, QTabletEvent *>(&QFileDialog_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QFileDialog::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QFileDialog::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QFileDialog_Adaptor, QTimerEvent *>(&QFileDialog_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QFileDialog::timerEvent(event);
    }
  }

  //  [adaptor impl] void QFileDialog::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QFileDialog::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QFileDialog_Adaptor, QWheelEvent *>(&QFileDialog_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QFileDialog::wheelEvent(event);
    }
  }

  gsi::Callback cb_exec_0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_open_0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QFileDialog_Adaptor::~QFileDialog_Adaptor() { }

//  Constructor QFileDialog::QFileDialog(QWidget *parent, QFlags<Qt::WindowType> f) (adaptor class)

static void _init_ctor_QFileDialog_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QFileDialog_Adaptor> ();
}

static void _call_ctor_QFileDialog_Adaptor_3702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QFlags<Qt::WindowType> arg2 = gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap);
  ret.write<QFileDialog_Adaptor *> (new QFileDialog_Adaptor (arg1, arg2));
}


//  Constructor QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter) (adaptor class)

static void _init_ctor_QFileDialog_Adaptor_7066 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("caption", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("directory", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("filter", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return_new<QFileDialog_Adaptor> ();
}

static void _call_ctor_QFileDialog_Adaptor_7066 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg4 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<QFileDialog_Adaptor *> (new QFileDialog_Adaptor (arg1, arg2, arg3, arg4));
}


// void QFileDialog::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_accept_0_0 = cb;
}


// emitter void QFileDialog::accepted()

static void _init_emitter_accepted_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_accepted_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_accepted_0 ();
}


// void QFileDialog::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// exposed void QFileDialog::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_adjustPosition_1315 (arg1);
}


// void QFileDialog::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QFileDialog::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QFileDialog::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QFileDialog::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QFileDialog::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_create_2208 (arg1, arg2, arg3);
}


// emitter void QFileDialog::currentChanged(const QString &path)

static void _init_emitter_currentChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_currentChanged_2025 (arg1);
}


// emitter void QFileDialog::currentUrlChanged(const QUrl &url)

static void _init_emitter_currentUrlChanged_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentUrlChanged_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_currentUrlChanged_1701 (arg1);
}


// emitter void QFileDialog::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_customContextMenuRequested_1916 (arg1);
}


// void QFileDialog::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QFileDialog::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_destroy_1620 (arg1, arg2);
}


// emitter void QFileDialog::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_destroyed_1302 (arg1);
}


// emitter void QFileDialog::directoryEntered(const QString &directory)

static void _init_emitter_directoryEntered_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_directoryEntered_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_directoryEntered_2025 (arg1);
}


// emitter void QFileDialog::directoryUrlEntered(const QUrl &directory)

static void _init_emitter_directoryUrlEntered_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("directory");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_directoryUrlEntered_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_directoryUrlEntered_1701 (arg1);
}


// void QFileDialog::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QFileDialog::done(int result)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_done_767_0 = cb;
}


// void QFileDialog::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QFileDialog::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QFileDialog::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QFileDialog::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QFileDialog::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QFileDialog::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QFileDialog::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// int QFileDialog::exec()

static void _init_cbs_exec_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_exec_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->cbs_exec_0_0 ());
}

static void _set_callback_cbs_exec_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_exec_0_0 = cb;
}


// emitter void QFileDialog::fileSelected(const QString &file)

static void _init_emitter_fileSelected_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_fileSelected_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_fileSelected_2025 (arg1);
}


// emitter void QFileDialog::filesSelected(const QStringList &files)

static void _init_emitter_filesSelected_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("files");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_filesSelected_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_filesSelected_2437 (arg1);
}


// emitter void QFileDialog::filterSelected(const QString &filter)

static void _init_emitter_filterSelected_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filter");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_filterSelected_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_filterSelected_2025 (arg1);
}


// emitter void QFileDialog::finished(int result)

static void _init_emitter_finished_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_finished_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_finished_767 (arg1);
}


// void QFileDialog::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QFileDialog::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_focusNextChild_0 ());
}


// bool QFileDialog::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QFileDialog::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QFileDialog::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_focusPreviousChild_0 ());
}


// bool QFileDialog::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QFileDialog::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QFileDialog::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QFileDialog::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QFileDialog::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QFileDialog::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QFileDialog_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QFileDialog::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_isSignalConnected_c2394 (arg1));
}


// void QFileDialog::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QFileDialog::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QFileDialog::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QFileDialog::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QFileDialog::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QFileDialog_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QFileDialog::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QFileDialog::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QFileDialog::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QFileDialog::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QFileDialog::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QFileDialog::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QFileDialog_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QFileDialog::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_objectNameChanged_4567 (arg1);
}


// void QFileDialog::open()

static void _init_cbs_open_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_open_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_open_0_0 ();
}

static void _set_callback_cbs_open_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_open_0_0 = cb;
}


// QPaintEngine *QFileDialog::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QFileDialog_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QFileDialog::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QFileDialog::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_receivers_c1731 (arg1));
}


// QPaintDevice *QFileDialog::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QFileDialog_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QFileDialog::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_reject_0_0 = cb;
}


// emitter void QFileDialog::rejected()

static void _init_emitter_rejected_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rejected_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_rejected_0 ();
}


// void QFileDialog::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QFileDialog::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_sender_c0 ());
}


// exposed int QFileDialog::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFileDialog_Adaptor *)cls)->fp_QFileDialog_senderSignalIndex_c0 ());
}


// void QFileDialog::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QFileDialog::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QFileDialog_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QFileDialog::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QFileDialog::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QFileDialog_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QFileDialog::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QFileDialog::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QFileDialog::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->fp_QFileDialog_updateMicroFocus_2420 (arg1);
}


// emitter void QFileDialog::urlSelected(const QUrl &url)

static void _init_emitter_urlSelected_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_urlSelected_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_urlSelected_1701 (arg1);
}


// emitter void QFileDialog::urlsSelected(const QList<QUrl> &urls)

static void _init_emitter_urlsSelected_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("urls");
  decl->add_arg<const QList<QUrl> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_urlsSelected_2316 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QUrl> &arg1 = gsi::arg_reader<const QList<QUrl> & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_urlsSelected_2316 (arg1);
}


// void QFileDialog::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFileDialog_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QFileDialog_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QFileDialog::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_windowIconChanged_1787 (arg1);
}


// emitter void QFileDialog::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_windowIconTextChanged_2025 (arg1);
}


// emitter void QFileDialog::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFileDialog_Adaptor *)cls)->emitter_QFileDialog_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QFileDialog> &qtdecl_QFileDialog ();

static gsi::Methods methods_QFileDialog_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileDialog::QFileDialog(QWidget *parent, QFlags<Qt::WindowType> f)\nThis method creates an object of class QFileDialog.", &_init_ctor_QFileDialog_Adaptor_3702, &_call_ctor_QFileDialog_Adaptor_3702);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileDialog::QFileDialog(QWidget *parent, const QString &caption, const QString &directory, const QString &filter)\nThis method creates an object of class QFileDialog.", &_init_ctor_QFileDialog_Adaptor_7066, &_call_ctor_QFileDialog_Adaptor_7066);
  methods += new qt_gsi::GenericMethod ("*accept", "@brief Virtual method void QFileDialog::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("*accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
  methods += new qt_gsi::GenericMethod ("emit_accepted", "@brief Emitter for signal void QFileDialog::accepted()\nCall this method to emit this signal.", false, &_init_emitter_accepted_0, &_call_emitter_accepted_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QFileDialog::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*adjustPosition", "@brief Method void QFileDialog::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QFileDialog::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QFileDialog::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QFileDialog::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QFileDialog::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QFileDialog::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_currentChanged", "@brief Emitter for signal void QFileDialog::currentChanged(const QString &path)\nCall this method to emit this signal.", false, &_init_emitter_currentChanged_2025, &_call_emitter_currentChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_currentUrlChanged", "@brief Emitter for signal void QFileDialog::currentUrlChanged(const QUrl &url)\nCall this method to emit this signal.", false, &_init_emitter_currentUrlChanged_1701, &_call_emitter_currentUrlChanged_1701);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QFileDialog::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QFileDialog::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QFileDialog::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QFileDialog::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("emit_directoryEntered", "@brief Emitter for signal void QFileDialog::directoryEntered(const QString &directory)\nCall this method to emit this signal.", false, &_init_emitter_directoryEntered_2025, &_call_emitter_directoryEntered_2025);
  methods += new qt_gsi::GenericMethod ("emit_directoryUrlEntered", "@brief Emitter for signal void QFileDialog::directoryUrlEntered(const QUrl &directory)\nCall this method to emit this signal.", false, &_init_emitter_directoryUrlEntered_1701, &_call_emitter_directoryUrlEntered_1701);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QFileDialog::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*done", "@brief Virtual method void QFileDialog::done(int result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("*done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QFileDialog::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QFileDialog::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QFileDialog::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QFileDialog::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QFileDialog::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QFileDialog::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QFileDialog::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("exec", "@brief Virtual method int QFileDialog::exec()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_exec_0_0, &_call_cbs_exec_0_0);
  methods += new qt_gsi::GenericMethod ("exec", "@hide", false, &_init_cbs_exec_0_0, &_call_cbs_exec_0_0, &_set_callback_cbs_exec_0_0);
  methods += new qt_gsi::GenericMethod ("emit_fileSelected", "@brief Emitter for signal void QFileDialog::fileSelected(const QString &file)\nCall this method to emit this signal.", false, &_init_emitter_fileSelected_2025, &_call_emitter_fileSelected_2025);
  methods += new qt_gsi::GenericMethod ("emit_filesSelected", "@brief Emitter for signal void QFileDialog::filesSelected(const QStringList &files)\nCall this method to emit this signal.", false, &_init_emitter_filesSelected_2437, &_call_emitter_filesSelected_2437);
  methods += new qt_gsi::GenericMethod ("emit_filterSelected", "@brief Emitter for signal void QFileDialog::filterSelected(const QString &filter)\nCall this method to emit this signal.", false, &_init_emitter_filterSelected_2025, &_call_emitter_filterSelected_2025);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QFileDialog::finished(int result)\nCall this method to emit this signal.", false, &_init_emitter_finished_767, &_call_emitter_finished_767);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QFileDialog::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QFileDialog::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QFileDialog::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QFileDialog::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QFileDialog::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QFileDialog::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QFileDialog::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QFileDialog::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QFileDialog::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QFileDialog::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QFileDialog::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QFileDialog::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QFileDialog::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QFileDialog::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QFileDialog::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QFileDialog::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QFileDialog::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QFileDialog::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QFileDialog::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QFileDialog::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QFileDialog::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QFileDialog::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QFileDialog::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QFileDialog::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("open", "@brief Virtual method void QFileDialog::open()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_open_0_0, &_call_cbs_open_0_0);
  methods += new qt_gsi::GenericMethod ("open", "@hide", false, &_init_cbs_open_0_0, &_call_cbs_open_0_0, &_set_callback_cbs_open_0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QFileDialog::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QFileDialog::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QFileDialog::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QFileDialog::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QFileDialog::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
  methods += new qt_gsi::GenericMethod ("emit_rejected", "@brief Emitter for signal void QFileDialog::rejected()\nCall this method to emit this signal.", false, &_init_emitter_rejected_0, &_call_emitter_rejected_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QFileDialog::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QFileDialog::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QFileDialog::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QFileDialog::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QFileDialog::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QFileDialog::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QFileDialog::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QFileDialog::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QFileDialog::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QFileDialog::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("emit_urlSelected", "@brief Emitter for signal void QFileDialog::urlSelected(const QUrl &url)\nCall this method to emit this signal.", false, &_init_emitter_urlSelected_1701, &_call_emitter_urlSelected_1701);
  methods += new qt_gsi::GenericMethod ("emit_urlsSelected", "@brief Emitter for signal void QFileDialog::urlsSelected(const QList<QUrl> &urls)\nCall this method to emit this signal.", false, &_init_emitter_urlsSelected_2316, &_call_emitter_urlsSelected_2316);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QFileDialog::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QFileDialog::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QFileDialog::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QFileDialog::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QFileDialog_Adaptor> decl_QFileDialog_Adaptor (qtdecl_QFileDialog (), "QtWidgets", "QFileDialog",
  methods_QFileDialog_Adaptor (),
  "@qt\n@brief Binding of QFileDialog");

}


//  Implementation of the enum wrapper class for QFileDialog::AcceptMode
namespace qt_gsi
{

static gsi::Enum<QFileDialog::AcceptMode> decl_QFileDialog_AcceptMode_Enum ("QtWidgets", "QFileDialog_AcceptMode",
    gsi::enum_const ("AcceptOpen", QFileDialog::AcceptOpen, "@brief Enum constant QFileDialog::AcceptOpen") +
    gsi::enum_const ("AcceptSave", QFileDialog::AcceptSave, "@brief Enum constant QFileDialog::AcceptSave"),
  "@qt\n@brief This class represents the QFileDialog::AcceptMode enum");

static gsi::QFlagsClass<QFileDialog::AcceptMode > decl_QFileDialog_AcceptMode_Enums ("QtWidgets", "QFileDialog_QFlags_AcceptMode",
  "@qt\n@brief This class represents the QFlags<QFileDialog::AcceptMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_AcceptMode_Enum_in_parent (decl_QFileDialog_AcceptMode_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_AcceptMode_Enum_as_child (decl_QFileDialog_AcceptMode_Enum, "AcceptMode");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_AcceptMode_Enums_as_child (decl_QFileDialog_AcceptMode_Enums, "QFlags_AcceptMode");

}


//  Implementation of the enum wrapper class for QFileDialog::DialogLabel
namespace qt_gsi
{

static gsi::Enum<QFileDialog::DialogLabel> decl_QFileDialog_DialogLabel_Enum ("QtWidgets", "QFileDialog_DialogLabel",
    gsi::enum_const ("LookIn", QFileDialog::LookIn, "@brief Enum constant QFileDialog::LookIn") +
    gsi::enum_const ("FileName", QFileDialog::FileName, "@brief Enum constant QFileDialog::FileName") +
    gsi::enum_const ("FileType", QFileDialog::FileType, "@brief Enum constant QFileDialog::FileType") +
    gsi::enum_const ("Accept", QFileDialog::Accept, "@brief Enum constant QFileDialog::Accept") +
    gsi::enum_const ("Reject", QFileDialog::Reject, "@brief Enum constant QFileDialog::Reject"),
  "@qt\n@brief This class represents the QFileDialog::DialogLabel enum");

static gsi::QFlagsClass<QFileDialog::DialogLabel > decl_QFileDialog_DialogLabel_Enums ("QtWidgets", "QFileDialog_QFlags_DialogLabel",
  "@qt\n@brief This class represents the QFlags<QFileDialog::DialogLabel> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_DialogLabel_Enum_in_parent (decl_QFileDialog_DialogLabel_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_DialogLabel_Enum_as_child (decl_QFileDialog_DialogLabel_Enum, "DialogLabel");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_DialogLabel_Enums_as_child (decl_QFileDialog_DialogLabel_Enums, "QFlags_DialogLabel");

}


//  Implementation of the enum wrapper class for QFileDialog::FileMode
namespace qt_gsi
{

static gsi::Enum<QFileDialog::FileMode> decl_QFileDialog_FileMode_Enum ("QtWidgets", "QFileDialog_FileMode",
    gsi::enum_const ("AnyFile", QFileDialog::AnyFile, "@brief Enum constant QFileDialog::AnyFile") +
    gsi::enum_const ("ExistingFile", QFileDialog::ExistingFile, "@brief Enum constant QFileDialog::ExistingFile") +
    gsi::enum_const ("Directory", QFileDialog::Directory, "@brief Enum constant QFileDialog::Directory") +
    gsi::enum_const ("ExistingFiles", QFileDialog::ExistingFiles, "@brief Enum constant QFileDialog::ExistingFiles"),
  "@qt\n@brief This class represents the QFileDialog::FileMode enum");

static gsi::QFlagsClass<QFileDialog::FileMode > decl_QFileDialog_FileMode_Enums ("QtWidgets", "QFileDialog_QFlags_FileMode",
  "@qt\n@brief This class represents the QFlags<QFileDialog::FileMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_FileMode_Enum_in_parent (decl_QFileDialog_FileMode_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_FileMode_Enum_as_child (decl_QFileDialog_FileMode_Enum, "FileMode");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_FileMode_Enums_as_child (decl_QFileDialog_FileMode_Enums, "QFlags_FileMode");

}


//  Implementation of the enum wrapper class for QFileDialog::Option
namespace qt_gsi
{

static gsi::Enum<QFileDialog::Option> decl_QFileDialog_Option_Enum ("QtWidgets", "QFileDialog_Option",
    gsi::enum_const ("ShowDirsOnly", QFileDialog::ShowDirsOnly, "@brief Enum constant QFileDialog::ShowDirsOnly") +
    gsi::enum_const ("DontResolveSymlinks", QFileDialog::DontResolveSymlinks, "@brief Enum constant QFileDialog::DontResolveSymlinks") +
    gsi::enum_const ("DontConfirmOverwrite", QFileDialog::DontConfirmOverwrite, "@brief Enum constant QFileDialog::DontConfirmOverwrite") +
    gsi::enum_const ("DontUseNativeDialog", QFileDialog::DontUseNativeDialog, "@brief Enum constant QFileDialog::DontUseNativeDialog") +
    gsi::enum_const ("ReadOnly", QFileDialog::ReadOnly, "@brief Enum constant QFileDialog::ReadOnly") +
    gsi::enum_const ("HideNameFilterDetails", QFileDialog::HideNameFilterDetails, "@brief Enum constant QFileDialog::HideNameFilterDetails") +
    gsi::enum_const ("DontUseCustomDirectoryIcons", QFileDialog::DontUseCustomDirectoryIcons, "@brief Enum constant QFileDialog::DontUseCustomDirectoryIcons"),
  "@qt\n@brief This class represents the QFileDialog::Option enum");

static gsi::QFlagsClass<QFileDialog::Option > decl_QFileDialog_Option_Enums ("QtWidgets", "QFileDialog_QFlags_Option",
  "@qt\n@brief This class represents the QFlags<QFileDialog::Option> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_Option_Enum_in_parent (decl_QFileDialog_Option_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_Option_Enum_as_child (decl_QFileDialog_Option_Enum, "Option");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_Option_Enums_as_child (decl_QFileDialog_Option_Enums, "QFlags_Option");

}


//  Implementation of the enum wrapper class for QFileDialog::ViewMode
namespace qt_gsi
{

static gsi::Enum<QFileDialog::ViewMode> decl_QFileDialog_ViewMode_Enum ("QtWidgets", "QFileDialog_ViewMode",
    gsi::enum_const ("Detail", QFileDialog::Detail, "@brief Enum constant QFileDialog::Detail") +
    gsi::enum_const ("List", QFileDialog::List, "@brief Enum constant QFileDialog::List"),
  "@qt\n@brief This class represents the QFileDialog::ViewMode enum");

static gsi::QFlagsClass<QFileDialog::ViewMode > decl_QFileDialog_ViewMode_Enums ("QtWidgets", "QFileDialog_QFlags_ViewMode",
  "@qt\n@brief This class represents the QFlags<QFileDialog::ViewMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFileDialog> inject_QFileDialog_ViewMode_Enum_in_parent (decl_QFileDialog_ViewMode_Enum.defs ());
static gsi::ClassExt<QFileDialog> decl_QFileDialog_ViewMode_Enum_as_child (decl_QFileDialog_ViewMode_Enum, "ViewMode");
static gsi::ClassExt<QFileDialog> decl_QFileDialog_ViewMode_Enums_as_child (decl_QFileDialog_ViewMode_Enums, "QFlags_ViewMode");

}

