/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef CONTRALBAR_H
#define CONTRALBAR_H

#include <QWidget>
#include "core/mpvtypes.h"

class QSlider;
class QListWidget;
class FilletWidget;
class PreviewWidget;
class QPropertyAnimation;

namespace Ui {
class ContralBar;
}

class ContralBar : public QWidget
{
    Q_OBJECT

public:
    explicit ContralBar(QWidget *parent = nullptr);
    ~ContralBar();

    void setDuration(int duration);
    void setCurrentTime(int currentTime);
    void setPreviewSize(QSize size);
    void setMiniMode(bool b){m_isMiniMode = b;}
    void setHide();
    void setShow();

    void setBlackTheme();
    void setLightTheme();

public slots:
    void clearMark();
    void addMark(int mark_pos, QString desc);
    void insertMark(int mark_pos, QString desc);      // 正在播放时插入书签
    void deleteMark(int mark_pos);

private:
    Ui::ContralBar *ui;
    QString m_theme;
    double m_duration,
           m_currentTime;
    int64_t m_lastPreviewShowTime;
    int m_seekTime;
    int m_volume;
    int m_videoId;
    double m_speed;
    bool m_isVideo,
         m_isMute,
         m_isChangeTime,
         m_isFullScreen,
         m_isMouseEnter,
         m_isMiniMode,
         m_isSeeking,
         m_canChangeDuration;
    Mpv::PlayState m_state;

    QTimer *m_seekTimer;
    QTimer *m_timerVolumeWidgetHide;
    QTimer *m_timerSpeedWidgetHide;
    QTimer *m_timerToolWidgetHide;

    QSlider *m_volumeSlider;
    FilletWidget *m_volumeWidget;

    QListWidget *m_speedList;
    FilletWidget *m_speedWidget;

    QListWidget *m_toolList;
    FilletWidget *m_toolWidget;

    PreviewWidget *m_previewWidget;

    QPropertyAnimation *m_showAnm;
    QPropertyAnimation *m_hideAnm;

    QMap<int, QString> m_markMap;

    void initGlobalSig();
    void initStyle();
    void initConnect();
    void initAnimation();
    void initSpeedList();
    void initToolList();
    void updateIcon();

signals:
    void sigFullScreen(bool);
    void sigCanHide(bool);

protected:
    bool eventFilter(QObject *target, QEvent *event);
    void moveEvent(QMoveEvent *event);
    void enterEvent(QEvent *event);
    void leaveEvent(QEvent *event);
    void showEvent(QShowEvent *event);

private slots:
    void on_btn_play_pause_clicked();
    void slotFullScreen();
    void slotMute();
    void slotShowPreview(int time);
    void slotPlayStateChange(Mpv::PlayState state);
};

#endif // CONTRALBAR_H
