/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef DBUSADAPTER_H
#define DBUSADAPTER_H

#include <QObject>
#include "core/mpvtypes.h"

class DbusAdapter : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.mpris.MediaPlayer2.Player")
public:
    explicit DbusAdapter(QObject *parent = nullptr);

public slots:
    // mpris 使用
    void Stop() const;
    void Next() const;
    // 这个改个名字，不能用 PlayPause，不然会和线控冲突
    void KvPlayPause() const;

    void Previous() const;
    void AddFile(QString file) const;
    void VolumeUp() const;
    void VolumeDown() const;
    void FullScreen() const;
    void LoopMode() const;
    void Exit() const;

    int PlayState();
    QString CurrentFile();

private:
    Mpv::PlayState m_playState;
    QString m_currentFile;

signals:

};

#endif // DBUSADAPTER_H
