#include "include/support.h"
#include "include/command.h"
#include "include/message.h"
#include "include/environment.h"

class LWCommandAnd: public LWCommand {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	
	g_return_val_if_fail (argc == 2, NULL);
	
	gint r = args[0]->toInt() && args[1]->toInt();
	
	return new LWValue(LWEnvironment::getPixmapSet()->getPixmap(r == 1 ? "true" : "false"));
}

const gchar *getName ()
{
	return "and";
}	

gchar *getHint ()
{
	return _("And");
}

guint getPriority ()
{
	return 5;
}

LWLink getLinkType ()
{
	return LW_LINK_LEFT;
}

gboolean hasReturn()
{
	return TRUE;
}

void checkArgument (guint n, LWValue *value)
{
	(void) n;
	
	if (FALSE == value->isVariable() && FALSE == value->checkRange())
			throw new LWMessage (LW_ERROR_NumberOutOfRange);
}

void checkArgc (guint n)
{
	if (n != 2) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}	

};

LWSymbol *new_LWCommandAnd()
{
	return new LWCommandAnd();
}
