#!/bin/sh

srcdir="$1"
builddir="$2"


# --------------------------------------------------------------------------
#
# code
#

rm -Rf aqbanking6 2>/dev/null

# The prefix to the source code (=srcdir)
sprefix=`( cd ${srcdir} ; pwd )`

# The prefix to the build directory (=builddir)
bprefix=`pwd`


# --------------------------------------------------------------------------
#
# functions
#

symlinkFolder () {
  local dfiles
  local src
  local dst
  
  src="$1"
  dst="$2"

  dfiles=`( cd "${sprefix}/${src}" && ls 2>/dev/null )`
  for f in $dfiles; do
    if test -d "${src}/${f}"; then
      case "$f" in
        . | .. | CVS | .* | bin | tools)
          ;;
        *)
          symlinkFolder "${src}/${f}" "${dst}"
          ;;
      esac
    else
      case "${f}" in
        *_p.h | *_l.h | *.ui.h | version.h | system.h)
          ;;
        *.ui)
          AQ_HEADER_FILES="${AQ_HEADER_FILES} ${dst}/${f}.h"
          ln -s "${bprefix}/${src}/${f}.h" "${dst}/${f}.h"
          ;;
#        version.h.in)
#          AQ_HEADER_FILES="${AQ_HEADER_FILES} ${dst}/version.h"
#          ln -s "${bprefix}/${src}/version.h" "${dst}/version.h"
#          ;;
#        system.h.in)
#          AQ_HEADER_FILES="${AQ_HEADER_FILES} ${dst}/system.h"
#          ln -s "${bprefix}/${src}/system.h" "${dst}/system.h"
#          ;;
        *.h)
          AQ_HEADER_FILES="${AQ_HEADER_FILES} ${dst}/${f}"
          ln -s "${sprefix}/${src}/${f}" "${dst}/${f}"
          ;;
        *.hpp)
          AQ_HEADER_FILES="${AQ_HEADER_FILES} ${dst}/${f}"
          ln -s "${sprefix}/${src}/${f}" "${dst}/${f}"
          ;;
      esac
    fi
    
  done
  
}



## symlink all headers from src/lib/aqbanking
#AQ_HEADER_FILES="${sprefix}/version.h ${sprefix}/system.h"
#mkdir -p aqbanking6/aqbanking
#symlinkFolder "src/libs/aqbanking" "aqbanking6/aqbanking"
#ln -s "${bprefix}/version.h" aqbanking6/aqbanking/version.h
#ln -s "${bprefix}/system.h" aqbanking6/aqbanking/system.h
#ln -s "${bprefix}/src/libs/aqbanking/backendsupport/ab_jobqueue.h" aqbanking6/aqbanking
#ln -s "${bprefix}/src/libs/aqbanking/backendsupport/ab_accountqueue.h" aqbanking6/aqbanking
#ln -s "${bprefix}/src/libs/aqbanking/backendsupport/ab_userqueue.h" aqbanking6/aqbanking
#ln -s "${bprefix}/src/libs/aqbanking/backendsupport/ab_queue.h" aqbanking6/aqbanking
#ln -s "${bprefix}/src/libs/aqbanking/backendsupport/siotlsext.h" aqbanking6/aqbanking
#
## symlink all headers from src/lib/aqbankingpp
#mkdir -p aqbanking6/aqbankingpp
#symlinkFolder "src/libs/aqbankingpp" "aqbanking6/aqbankingpp"

# symlink all headers from src/libs/plugins/backends/
#dirlist='aqfints aqhbci aqofxconnect aqnone aqpaypal aqebics'  # list might be empty
dirlist='aqebics aqofxconnect aqpaypal'
for backend in ${dirlist} ; do
  mkdir -p aqbanking6/${backend}
  if [ -d "src/libs/plugins/backends/${backend}" ] ; then
    symlinkFolder "src/libs/plugins/backends/${backend}" "aqbanking6/${backend}"
    # symlink all subfolders
    for f in src/libs/plugins/backends/${backend}/*; do
      if [ -d "src/libs/plugins/backends/${backend}/$f" ] ; then
        case $f in
          .libs | .deps)
            ;;
          *)
            symlinkFolder "src/libs/plugins/backends/${backend}/$f" "aqbanking6/${backend}"
            ;;
        esac
      fi
    done
  fi
  
done

if [ -d aqbanking6/aqofxconnect ] ; then
  ln -s "${bprefix}/src/libs/plugins/backends/aqofxconnect/libofxhome/oh_institute_data.h" aqbanking6/aqofxconnect
  ln -s "${bprefix}/src/libs/plugins/backends/aqofxconnect/libofxhome/oh_institute_spec.h" aqbanking6/aqofxconnect
fi


rm -f sl-headers 2>/dev/null
for i in ${AQ_HEADER_FILES}; do
  echo "$i" >>sl-headers
done


