/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.ReflectionUtils;
import impl.org.controlsfx.skin.GridRow;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.control.skin.VirtualFlow;
import org.controlsfx.control.GridView;

public class GridViewSkin<T>
extends VirtualContainerBase<GridView<T>, GridRow<T>> {
    private VirtualFlow<GridRow<T>> flow;
    private final ListChangeListener<T> gridViewItemsListener = change -> {
        this.updateItemCount();
        ((GridView)this.getSkinnable()).requestLayout();
    };
    private final WeakListChangeListener<T> weakGridViewItemsListener = new WeakListChangeListener(this.gridViewItemsListener);

    public GridViewSkin(GridView<T> control) {
        super(control);
        this.flow = ReflectionUtils.getVirtualFlow(this);
        this.updateGridViewItems();
        this.flow.setId("virtual-flow");
        this.flow.setPannable(false);
        this.flow.setVertical(true);
        this.flow.setFocusTraversable(((GridView)this.getSkinnable()).isFocusTraversable());
        this.flow.setCellFactory(param -> this.createCell());
        this.getChildren().add(this.flow);
        this.updateItemCount();
        this.registerChangeListener((ObservableValue)control.itemsProperty(), e -> this.updateGridViewItems());
        this.registerChangeListener((ObservableValue)control.cellFactoryProperty(), e -> ReflectionUtils.recreateCells(this.flow));
        this.registerChangeListener((ObservableValue)control.parentProperty(), e -> {
            if (((GridView)this.getSkinnable()).getParent() != null && ((GridView)this.getSkinnable()).isVisible()) {
                ((GridView)this.getSkinnable()).requestLayout();
            }
        });
        this.registerChangeListener((ObservableValue)control.cellHeightProperty(), e -> ReflectionUtils.recreateCells(this.flow));
        this.registerChangeListener((ObservableValue)control.cellWidthProperty(), e -> {
            this.updateItemCount();
            ReflectionUtils.recreateCells(this.flow);
        });
        this.registerChangeListener((ObservableValue)control.horizontalCellSpacingProperty(), e -> {
            this.updateItemCount();
            ReflectionUtils.recreateCells(this.flow);
        });
        this.registerChangeListener((ObservableValue)control.verticalCellSpacingProperty(), e -> ReflectionUtils.recreateCells(this.flow));
        this.registerChangeListener((ObservableValue)control.widthProperty(), e -> this.updateItemCount());
        this.registerChangeListener((ObservableValue)control.heightProperty(), e -> this.updateItemCount());
    }

    public void updateGridViewItems() {
        if (((GridView)this.getSkinnable()).getItems() != null) {
            ((GridView)this.getSkinnable()).getItems().removeListener(this.weakGridViewItemsListener);
        }
        if (((GridView)this.getSkinnable()).getItems() != null) {
            ((GridView)this.getSkinnable()).getItems().addListener(this.weakGridViewItemsListener);
        }
        this.updateItemCount();
        ReflectionUtils.recreateCells(this.flow);
        ((GridView)this.getSkinnable()).requestLayout();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double x1 = ((GridView)this.getSkinnable()).getInsets().getLeft();
        double y1 = ((GridView)this.getSkinnable()).getInsets().getTop();
        double w1 = ((GridView)this.getSkinnable()).getWidth() - (((GridView)this.getSkinnable()).getInsets().getLeft() + ((GridView)this.getSkinnable()).getInsets().getRight());
        double h1 = ((GridView)this.getSkinnable()).getHeight() - (((GridView)this.getSkinnable()).getInsets().getTop() + ((GridView)this.getSkinnable()).getInsets().getBottom());
        this.flow.resizeRelocate(x1, y1, w1, h1);
    }

    public int getItemCount() {
        ObservableList items = ((GridView)this.getSkinnable()).getItems();
        return items == null ? 0 : (int)Math.ceil((double)items.size() / (double)this.computeMaxCellsInRow());
    }

    protected void updateItemCount() {
        if (this.flow == null) {
            return;
        }
        int oldCount = this.flow.getCellCount();
        int newCount = this.getItemCount();
        if (newCount != oldCount) {
            this.flow.setCellCount(newCount);
            ReflectionUtils.rebuildCells(this.flow);
        } else {
            ReflectionUtils.reconfigureCells(this.flow);
        }
        this.updateRows(newCount);
        ((GridView)this.getSkinnable()).requestLayout();
    }

    public int computeMaxCellsInRow() {
        return Math.max((int)Math.floor(this.computeRowWidth() / this.computeCellWidth()), 1);
    }

    protected double computeRowWidth() {
        return ((GridView)this.getSkinnable()).getWidth() - 18.0;
    }

    protected double computeCellWidth() {
        return ((GridView)this.getSkinnable()).cellWidthProperty().doubleValue() + ((GridView)this.getSkinnable()).horizontalCellSpacingProperty().doubleValue() * 2.0;
    }

    protected void updateRows(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            GridRow row = (GridRow)this.flow.getVisibleCell(i);
            if (row == null) continue;
            row.updateIndex(i);
        }
    }

    protected double computeMinHeight(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 0.0;
    }

    private GridRow<T> createCell() {
        GridRow row = new GridRow();
        row.updateGridView((GridView)this.getSkinnable());
        return row;
    }
}

