/* ----- decode/1277x3, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1277x3_checksums[] = {
  "cd7ac8c305a343e1ae8e70c486d539bae09546ea02182801780b53de3618c53f",
  "dfba5b6a88e496f1d34cb5f11e59ddb2c26255c22edb9c4a9246d96bb5b687c8",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1277x3_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1277x3_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1277x3_ITEMBYTES

static void *storage_decode_1277x3_x;
static unsigned char *test_decode_1277x3_x;
static void *storage_decode_1277x3_s;
static unsigned char *test_decode_1277x3_s;
static void *storage_decode_1277x3_x2;
static unsigned char *test_decode_1277x3_x2;
static void *storage_decode_1277x3_s2;
static unsigned char *test_decode_1277x3_s2;

#define precomputed_decode_1277x3_NUM 4

static const unsigned char precomputed_decode_1277x3_x[precomputed_decode_1277x3_NUM][crypto_decode_ITEMS] = {
  {2,0,2,0,2,2,2,2,-1,0,-1,-1,2,2,1,1,0,2,0,2,0,-1,1,1,1,0,0,-1,2,1,2,1,2,1,1,-1,-1,2,0,-1,-1,0,2,0,1,0,2,0,-1,2,0,-1,1,-1,0,2,0,1,2,1,1,0,2,1,2,-1,2,-1,0,2,0,0,0,2,0,1,2,1,2,1,2,0,1,1,0,2,1,2,-1,0,0,0,1,0,0,-1,0,0,0,-1,2,0,0,1,1,-1,-1,2,1,2,2,-1,0,2,2,-1,1,2,0,-1,0,-1,1,0,-1,-1,2,-1,0,2,2,-1,2,0,-1,-1,0,-1,2,0,1,2,0,2,-1,-1,1,-1,1,-1,2,2,-1,1,2,2,-1,1,2,2,2,2,2,1,1,0,0,1,0,0,1,-1,2,0,-1,1,2,-1,1,2,1,0,1,0,2,1,0,2,2,1,-1,1,0,-1,-1,2,1,-1,1,0,2,-1,2,0,0,-1,2,1,1,-1,1,1,1,-1,0,0,0,-1,0,1,-1,1,0,2,1,2,-1,-1,1,-1,-1,1,2,-1,0,0,2,1,2,-1,2,0,-1,2,2,2,0,0,2,0,0,-1,0,1,0,-1,1,0,1,0,-1,2,1,-1,1,2,0,2,-1,0,2,0,1,-1,-1,1,-1,-1,-1,-1,2,0,-1,-1,1,1,0,2,0,0,1,-1,0,0,2,1,-1,1,0,2,2,1,0,-1,2,-1,-1,-1,-1,-1,2,-1,1,1,0,2,0,1,0,1,-1,2,2,-1,-1,2,1,2,1,0,0,1,2,2,0,1,-1,2,1,0,-1,2,0,2,2,0,-1,-1,0,2,-1,1,-1,0,0,1,1,2,2,-1,1,0,1,2,-1,1,0,0,-1,-1,0,2,0,-1,-1,-1,0,1,0,0,-1,1,2,1,-1,1,0,1,1,1,1,0,2,0,1,2,-1,2,2,2,2,1,2,2,0,1,1,2,2,0,0,0,0,0,1,0,-1,1,2,2,-1,0,-1,-1,0,-1,0,1,1,1,1,1,2,0,1,0,1,2,-1,1,2,0,-1,-1,1,2,-1,-1,0,2,2,-1,-1,-1,-1,2,2,1,0,-1,-1,1,0,2,1,1,0,1,1,2,1,1,1,2,1,2,2,0,-1,-1,2,1,0,-1,2,2,-1,-1,1,2,1,-1,1,1,0,-1,1,1,0,0,0,0,0,1,1,-1,1,2,1,-1,0,1,-1,0,1,-1,-1,2,0,-1,2,1,1,2,0,0,0,1,-1,-1,2,0,-1,-1,0,1,1,2,1,0,0,1,-1,1,-1,0,-1,2,-1,0,0,2,1,2,0,2,1,1,2,0,0,1,1,-1,-1,-1,2,0,-1,2,0,1,0,0,2,-1,-1,2,1,0,1,-1,1,2,1,0,0,2,2,1,-1,-1,0,1,-1,0,0,2,2,0,-1,2,0,-1,2,1,0,2,0,1,2,-1,2,-1,0,-1,1,2,1,2,2,1,2,-1,-1,0,-1,-1,2,2,1,1,-1,1,1,-1,1,2,-1,2,1,0,-1,1,2,1,1,-1,2,-1,1,0,1,2,1,-1,0,1,2,2,1,-1,0,0,1,2,0,0,0,-1,-1,-1,1,1,-1,2,2,1,1,1,0,-1,-1,0,1,0,2,2,0,-1,2,-1,0,0,2,1,0,0,0,0,1,2,2,1,0,2,1,1,1,2,1,0,2,0,2,0,2,1,1,2,0,-1,-1,1,1,-1,1,1,0,-1,-1,0,2,-1,2,1,1,2,1,0,-1,2,1,2,2,0,2,1,2,2,1,2,2,2,2,2,0,-1,1,2,2,2,2,0,2,2,0,0,1,0,-1,0,-1,2,0,-1,-1,1,0,1,1,-1,1,2,0,1,-1,2,2,1,2,2,2,0,1,0,1,0,1,1,2,1,0,0,0,0,-1,-1,2,1,-1,-1,0,0,0,0,0,2,-1,2,2,-1,0,2,-1,2,2,2,0,-1,0,1,-1,-1,2,0,1,0,2,0,2,1,2,-1,-1,0,-1,0,2,1,-1,0,0,1,1,1,2,2,-1,-1,1,1,2,2,2,0,0,0,2,1,-1,0,1,1,2,0,1,0,-1,2,0,2,2,0,0,2,1,1,1,1,-1,-1,1,0,-1,1,1,1,0,1,0,0,0,1,0,-1,-1,0,-1,-1,2,-1,-1,0,0,2,1,2,0,2,2,1,1,1,0,1,2,-1,0,2,1,1,1,0,-1,2,-1,-1,2,2,0,-1,2,-1,0,1,0,0,-1,-1,0,-1,0,0,0,1,-1,2,-1,-1,-1,0,1,-1,-1,0,0,0,-1,0,-1,1,0,0,1,2,2,-1,1,-1,-1,-1,2,-1,-1,0,0,0,-1,-1,0,-1,1,0,0,-1,-1,1,-1,2,-1,1,0,1,-1,0,1,1,2,0,-1,2,1,0,2,-1,2,2,-1,1,1,2,2,0,-1,1,-1,-1,1,2,2,0,-1,2,0,-1,2,1,2,0,-1,1,0,0,2,-1,-1,2,2,1,1,-1,-1,1,-1,0,1,2,-1,-1,1,2,2,0,0,1,2,2,-1,1,2,-1,1,2,1,-1,-1,0,0,-1,-1,-1,-1,2,2,2,1,2,2,0,1,1,2,1,2,1,1,-1,0,0,1,-1,2,1,-1,2,0,-1,0,-1,0,2,1,1,-1,1,-1,0,2,2,-1,0,2,2,1,-1,1,-1,-1,2,-1,-1,2,0,0,0,2,1,0,1,0,0,2,-1,-1,-1,1,0,1,1,0,1,1,-1,1,2,0,2,-1,-1,2,1,2,1,1,1,-1,2,-1,2,2,-1,0,-1,2,1,-1,1,0,2,2,2,0,0,-1,0,1,-1,0,2,1,2,0,-1,2,0,-1,-1,1,2,0,2,2,2,0,-1,1,-1,2,1,0,-1,2,2,2,-1,1,2,1,0,2,1,1,-1,-1,2,2,1,0,2,1,-1,1,2,0,1,0,1,2,1,2,1,1,-1,0,-1,-1,2,-1,2,2,1,-1,0,1,0,1,-1,2,1,-1,0,1,0,1,0,-1,1,-1,1,1,0,2,2,2,0,-1},
  {2,-1,1,-1,-1,0,0,2,2,0,0,2,-1,0,-1,2,1,1,0,0,2,1,1,1,-1,0,-1,0,0,-1,0,-1,0,2,-1,0,1,2,-1,1,1,-1,-1,1,-1,2,2,2,2,0,2,1,2,-1,1,-1,-1,-1,2,1,-1,0,2,1,1,0,-1,0,0,1,1,-1,1,1,1,2,1,1,-1,0,1,2,1,1,-1,-1,-1,-1,-1,-1,1,1,1,0,1,-1,1,1,0,0,1,0,1,1,0,2,-1,0,1,1,0,2,0,-1,-1,1,-1,2,-1,1,-1,0,0,-1,0,0,1,0,2,1,0,0,1,-1,1,0,2,2,0,0,1,2,0,2,2,1,2,0,2,0,0,-1,0,-1,0,-1,-1,2,1,1,-1,0,1,1,-1,0,-1,-1,-1,1,1,2,-1,0,2,2,1,1,0,2,0,0,2,1,1,1,2,1,2,-1,1,1,2,-1,1,1,0,1,-1,-1,1,-1,0,0,1,2,2,-1,1,1,-1,0,0,0,0,-1,1,2,-1,2,2,2,-1,0,1,0,-1,2,1,0,-1,-1,0,-1,0,-1,0,0,2,0,-1,-1,1,0,-1,2,2,2,0,2,1,-1,-1,1,1,-1,0,2,1,2,2,0,2,1,0,2,0,2,0,0,-1,1,2,2,-1,2,0,1,1,1,2,0,1,-1,2,0,1,1,1,2,-1,0,-1,1,-1,0,1,-1,-1,2,2,1,2,1,-1,0,2,1,-1,2,1,2,2,2,1,0,2,-1,0,1,2,-1,0,-1,0,0,2,0,0,-1,2,2,-1,1,2,-1,1,2,1,2,0,-1,1,-1,1,1,1,-1,0,0,0,-1,1,2,0,0,-1,0,2,1,2,2,1,0,2,0,-1,1,-1,1,2,-1,-1,0,0,-1,-1,0,2,-1,0,1,0,0,0,2,0,0,2,0,1,1,2,1,0,2,0,1,0,-1,1,1,1,1,1,0,1,2,0,1,2,2,1,1,2,2,-1,-1,0,0,0,-1,0,1,0,0,2,2,1,2,0,1,1,2,2,1,1,-1,-1,2,0,-1,2,-1,2,0,2,1,-1,2,2,-1,0,2,1,1,0,2,2,-1,1,0,2,-1,1,0,-1,0,2,-1,2,1,-1,1,-1,2,2,1,0,-1,2,-1,0,2,0,0,0,1,0,2,2,0,0,1,-1,0,2,1,-1,-1,2,2,1,0,0,1,2,1,-1,-1,0,-1,2,2,-1,-1,0,0,0,-1,1,2,2,1,0,0,-1,2,1,1,2,1,-1,1,2,0,0,0,-1,1,-1,-1,1,1,0,-1,1,2,1,-1,-1,-1,2,0,0,0,0,2,-1,1,-1,0,1,1,1,1,-1,2,-1,1,2,1,2,-1,0,-1,0,-1,1,0,2,-1,1,-1,2,1,-1,2,-1,1,-1,2,2,0,1,-1,1,1,2,2,2,-1,2,1,0,1,0,1,0,1,2,1,0,-1,-1,0,2,2,0,1,2,0,2,1,2,0,1,-1,0,-1,-1,-1,-1,0,1,0,-1,0,1,-1,1,0,1,0,-1,-1,-1,0,2,1,0,0,2,1,0,2,0,0,1,-1,-1,0,-1,2,2,2,-1,0,-1,0,1,-1,2,1,2,-1,1,1,0,2,0,0,-1,2,0,2,-1,0,-1,2,0,2,1,0,1,1,2,0,2,-1,0,2,0,2,-1,2,2,2,2,0,1,2,0,1,0,-1,1,-1,0,1,2,2,2,-1,2,0,1,0,2,0,2,-1,1,-1,-1,1,2,-1,1,0,1,-1,-1,1,1,1,2,1,0,2,2,0,0,-1,2,1,1,0,-1,1,-1,1,2,0,0,-1,1,-1,0,1,1,2,1,-1,1,0,-1,0,-1,0,2,0,2,1,1,1,2,0,1,0,1,1,-1,-1,-1,1,2,2,1,1,-1,-1,0,-1,2,0,-1,0,1,2,-1,2,2,0,2,0,2,0,0,1,0,0,-1,-1,1,0,0,2,-1,-1,1,0,1,1,2,-1,1,1,0,-1,0,-1,0,1,2,-1,-1,1,0,-1,2,-1,2,-1,2,1,2,0,-1,-1,0,0,0,-1,1,-1,0,-1,2,-1,1,-1,-1,1,-1,1,-1,2,-1,1,-1,1,2,0,0,0,1,1,-1,2,2,2,2,-1,1,0,1,1,0,-1,0,1,-1,0,-1,0,2,2,2,1,2,1,1,0,0,0,0,1,-1,0,1,1,-1,2,2,-1,0,-1,0,1,1,2,1,0,1,2,0,1,0,0,1,0,0,2,1,2,0,0,0,-1,1,2,2,1,1,1,-1,0,0,2,1,1,-1,1,2,-1,2,2,1,2,0,2,2,1,1,1,0,-1,-1,0,1,0,1,1,-1,1,2,0,-1,1,2,0,2,2,2,1,1,0,0,1,2,-1,-1,0,1,0,-1,2,0,0,-1,-1,1,1,2,0,2,2,0,-1,0,0,1,1,1,-1,2,-1,-1,-1,2,-1,2,1,1,0,0,2,0,2,2,0,-1,1,1,2,2,0,0,2,2,2,0,1,2,2,-1,-1,1,0,2,-1,0,1,-1,0,2,0,2,2,-1,1,1,1,-1,2,2,1,1,2,1,2,1,0,1,1,1,1,0,2,2,-1,1,0,2,0,-1,0,1,2,0,-1,-1,0,1,1,2,2,0,2,2,2,1,-1,1,0,-1,2,2,-1,2,1,1,-1,1,2,-1,1,-1,1,2,-1,0,1,-1,2,1,1,2,1,-1,-1,2,0,1,2,-1,2,0,-1,2,0,-1,-1,2,-1,-1,1,0,0,-1,-1,2,2,2,1,0,2,-1,2,2,1,2,-1,2,1,2,2,2,1,0,-1,-1,0,1,2,0,2,2,-1,1,2,2,-1,1,0,0,0,1,0,2,1,1,2,1,-1,0,2,1,-1,2,-1,2,1,-1,-1,-1,0,0,2,-1,2,0,1,-1,1,-1,-1,0,1,-1,0,1,1,2,0,1,2,-1,1,-1,-1,2,0,1,0,1,0,-1,0,2,2,1,1,0,1,0,1,-1,-1,2,2,-1,-1,2,1,0,-1,1,2,-1,1,1,0,2,2,0},
  {0,2,-1,1,0,0,1,2,2,-1,1,-1,0,2,2,-1,0,1,2,-1,1,0,2,0,1,2,-1,0,1,2,1,1,2,0,1,2,1,0,2,2,0,1,1,-1,2,0,2,2,1,0,2,1,-1,-1,-1,0,2,-1,-1,0,0,2,-1,0,-1,-1,2,-1,0,2,2,2,2,0,1,0,0,1,2,-1,0,-1,1,1,0,1,2,2,0,0,-1,2,0,-1,2,1,-1,2,2,-1,0,-1,1,1,-1,1,2,0,0,1,0,0,2,0,1,0,0,-1,1,1,1,2,0,-1,-1,1,-1,1,-1,2,1,-1,2,-1,2,0,1,2,0,-1,0,0,-1,-1,0,-1,1,0,0,-1,-1,0,1,-1,0,1,-1,1,2,2,2,1,-1,0,0,-1,1,0,-1,2,1,0,2,-1,2,2,2,0,2,1,1,1,1,0,2,2,0,-1,1,2,0,1,2,1,0,0,2,0,0,1,0,1,1,1,-1,-1,0,0,1,2,1,2,0,2,2,2,2,-1,-1,-1,0,1,-1,0,-1,-1,0,-1,-1,1,0,-1,0,0,-1,0,1,0,1,-1,1,2,2,2,0,0,1,2,-1,-1,2,-1,2,2,-1,2,1,-1,-1,1,-1,2,0,-1,1,2,2,2,-1,1,1,-1,2,1,1,2,0,-1,1,-1,2,0,2,0,1,-1,0,2,1,-1,0,1,0,-1,2,2,2,0,-1,-1,1,0,1,-1,2,0,1,-1,1,0,0,2,2,1,-1,0,2,0,1,-1,-1,2,2,0,-1,2,-1,1,1,0,1,2,2,-1,0,1,0,1,1,-1,2,1,-1,0,-1,1,2,2,0,-1,0,1,0,2,1,0,0,-1,1,2,1,1,2,2,2,0,0,1,-1,1,-1,2,1,0,-1,-1,-1,2,-1,2,2,-1,0,1,1,2,0,-1,1,2,0,2,-1,0,2,1,1,-1,-1,0,0,-1,1,1,1,0,0,0,-1,2,2,0,2,2,1,-1,2,1,-1,-1,1,0,2,2,-1,1,1,2,-1,2,1,0,2,2,2,2,1,1,-1,0,-1,1,1,-1,1,-1,2,0,2,0,1,-1,1,0,2,1,2,2,0,0,0,2,0,0,1,2,-1,1,-1,0,0,0,1,0,-1,2,0,1,2,-1,1,0,1,1,-1,-1,-1,-1,-1,0,2,2,2,-1,-1,1,2,2,2,1,2,1,0,2,2,-1,2,-1,1,2,2,0,1,1,1,-1,-1,0,1,1,2,1,-1,0,1,-1,2,1,-1,0,1,1,0,1,0,-1,2,1,-1,2,0,-1,0,-1,-1,1,2,-1,-1,1,-1,2,-1,1,0,-1,2,1,2,2,2,0,-1,2,-1,0,-1,2,0,1,-1,1,-1,0,0,2,-1,1,1,1,1,2,2,0,-1,2,1,2,-1,1,2,-1,-1,0,-1,-1,-1,0,0,2,-1,2,1,1,0,1,1,-1,1,-1,-1,2,0,1,2,2,0,1,1,0,1,0,-1,1,1,-1,-1,2,-1,1,0,2,0,-1,1,0,-1,2,1,0,0,-1,1,1,1,2,0,0,1,0,0,0,2,1,1,-1,1,2,-1,2,1,2,-1,1,1,0,0,2,0,0,1,0,0,0,0,1,-1,-1,2,2,0,-1,-1,0,2,2,1,2,0,0,2,-1,1,-1,1,1,2,1,-1,-1,-1,2,0,0,2,0,0,1,0,0,0,-1,0,1,-1,2,0,0,-1,2,1,1,-1,2,1,-1,2,2,-1,1,1,0,-1,-1,1,-1,-1,-1,2,0,-1,2,1,1,-1,1,2,-1,-1,2,-1,1,2,1,2,-1,-1,0,2,0,-1,1,0,2,-1,1,0,-1,1,0,-1,0,-1,0,2,0,0,0,0,1,1,2,0,-1,0,1,0,-1,2,2,2,2,2,0,1,2,2,0,1,2,2,0,1,0,1,-1,-1,-1,0,2,0,0,0,1,-1,1,0,0,0,-1,-1,0,-1,0,1,2,0,1,-1,0,1,1,1,0,-1,-1,1,-1,2,0,2,-1,-1,2,0,-1,0,0,-1,1,0,0,2,0,-1,0,2,1,2,1,2,2,-1,-1,0,0,0,-1,-1,-1,-1,1,0,0,2,1,0,0,-1,-1,2,2,-1,0,2,0,1,-1,1,0,2,0,0,1,-1,0,1,2,1,2,2,0,1,2,-1,-1,2,-1,0,2,1,1,0,1,-1,0,2,-1,1,1,-1,1,0,2,2,2,2,0,0,-1,1,1,-1,0,2,-1,2,2,-1,1,0,1,-1,0,2,1,0,-1,-1,2,-1,0,0,0,-1,1,1,-1,1,0,-1,0,1,2,2,0,-1,2,-1,1,1,1,0,1,1,0,1,0,-1,2,2,1,0,1,0,2,1,0,-1,1,2,-1,2,0,2,1,-1,2,-1,0,1,0,1,0,1,-1,0,0,0,1,2,1,-1,0,-1,1,1,-1,-1,-1,0,2,0,2,2,-1,1,2,2,1,1,-1,0,0,-1,0,2,1,2,-1,2,1,0,1,1,-1,2,1,-1,0,2,0,2,0,2,-1,2,1,0,2,1,0,0,1,0,0,0,1,2,2,-1,2,2,2,0,-1,2,-1,-1,-1,-1,0,0,2,-1,0,-1,1,-1,2,1,-1,0,1,1,-1,2,-1,1,1,0,2,1,0,-1,1,1,1,0,-1,0,2,1,0,2,0,1,1,-1,2,-1,1,2,0,1,1,0,1,0,0,-1,0,-1,0,2,1,-1,-1,1,2,-1,2,-1,1,2,1,2,2,-1,1,0,2,-1,0,1,2,0,-1,-1,0,0,2,2,2,2,-1,-1,-1,0,0,-1,-1,2,0,0,1,2,1,1,1,0,2,2,-1,1,0,1,1,-1,1,0,0,0,1,0,0,2,1,-1,0,2,1,0,1,1,-1,0,0,0,-1,2,1,1,2,2,1,-1,1,1,2,0,-1,2,1,1,-1,2,0,-1,-1,-1,0,2,-1,1,0,1,2,2,1,-1,-1,0,1,0,1,2,-1,2,1,1,2,2,1,-1,1,0,1,2,1,1,0,0,0,1,-1,1,0,1,-1,0,-1,-1,2,1,0,0},
  {-1,0,0,0,0,-1,-1,0,0,2,0,-1,2,-1,2,-1,0,0,2,0,2,-1,-1,-1,-1,-1,1,2,1,0,2,2,2,-1,0,1,2,1,1,1,1,1,2,-1,2,2,-1,2,2,1,2,1,2,0,0,1,2,0,-1,0,2,2,1,0,2,0,-1,1,1,-1,0,0,-1,2,-1,1,1,1,-1,2,2,1,2,2,1,-1,2,-1,2,2,0,-1,-1,1,-1,1,1,-1,2,0,1,-1,1,0,2,2,0,1,-1,2,2,-1,-1,-1,-1,1,-1,1,1,-1,1,2,-1,2,0,-1,0,0,1,0,-1,-1,-1,-1,1,0,-1,0,2,1,0,1,0,1,2,0,1,0,2,0,-1,0,0,1,-1,-1,1,-1,1,0,0,2,2,2,1,1,1,2,2,2,1,0,0,-1,2,1,1,1,0,-1,-1,2,2,2,0,0,0,0,0,-1,0,1,0,1,-1,0,-1,2,1,0,-1,0,0,1,-1,-1,0,-1,0,2,1,1,-1,2,1,-1,1,-1,1,-1,0,-1,2,1,1,0,0,1,-1,0,-1,1,0,0,1,2,-1,2,1,1,0,-1,1,0,1,2,1,1,-1,2,2,0,-1,1,2,0,-1,2,2,1,-1,0,0,0,1,1,-1,-1,2,0,0,-1,0,2,-1,-1,0,2,-1,2,1,1,0,2,0,-1,1,-1,0,-1,0,2,2,2,1,0,-1,-1,-1,2,-1,-1,2,2,0,2,-1,2,2,1,-1,0,0,1,-1,0,2,1,2,-1,0,2,2,1,2,0,0,1,1,0,1,-1,1,0,0,0,-1,1,2,1,2,2,1,-1,2,0,1,0,-1,-1,-1,-1,-1,2,0,1,-1,-1,0,2,-1,0,-1,1,-1,-1,2,-1,1,-1,0,2,0,0,-1,2,-1,0,0,-1,-1,2,1,-1,-1,0,0,2,2,2,0,-1,1,1,0,2,0,0,-1,2,0,0,2,0,1,2,0,0,2,1,2,1,2,0,2,2,0,-1,1,-1,1,2,-1,1,-1,1,2,0,-1,-1,-1,0,1,1,2,1,0,-1,0,0,1,1,2,0,0,0,-1,0,2,0,0,2,1,2,2,2,1,2,2,1,2,2,1,2,0,0,0,-1,-1,2,1,0,2,2,-1,2,-1,0,-1,0,-1,0,2,0,0,0,1,2,2,-1,2,-1,-1,1,2,2,2,1,1,0,-1,1,2,-1,1,1,1,2,2,0,1,0,0,2,-1,0,0,-1,2,2,1,0,0,0,0,2,0,0,1,-1,-1,-1,0,0,0,0,1,2,0,1,1,2,-1,-1,0,1,0,2,1,1,2,-1,2,-1,-1,1,2,-1,2,-1,0,1,1,2,1,2,-1,2,0,2,2,2,0,2,1,-1,0,2,0,-1,-1,-1,0,-1,-1,0,1,2,0,1,-1,1,0,0,-1,2,1,2,-1,0,-1,2,2,-1,1,-1,0,1,-1,2,2,0,2,1,0,2,-1,1,0,1,-1,-1,0,1,-1,-1,-1,-1,1,-1,0,0,-1,1,-1,1,1,2,1,0,2,1,1,-1,0,-1,1,2,0,1,-1,1,2,0,-1,1,0,2,2,0,1,1,2,0,2,1,-1,2,-1,1,-1,1,2,1,2,2,2,-1,1,0,1,1,2,-1,-1,-1,1,-1,0,2,1,2,2,-1,1,-1,0,0,-1,2,0,-1,-1,-1,0,1,1,0,2,1,1,0,1,0,-1,0,2,1,0,-1,1,1,2,-1,0,-1,-1,2,1,-1,2,2,2,0,0,-1,1,1,1,1,1,0,2,2,-1,-1,-1,2,-1,-1,2,0,2,2,-1,-1,1,0,1,0,2,2,2,2,-1,1,1,2,0,2,2,1,1,0,0,2,1,-1,1,0,1,0,2,2,-1,0,0,2,2,0,0,1,-1,1,2,2,2,1,0,0,-1,0,-1,0,2,0,0,-1,0,0,1,-1,0,1,2,1,0,0,1,0,2,2,0,-1,1,-1,-1,1,0,0,1,0,2,2,1,1,0,2,2,1,-1,2,-1,2,2,1,2,0,2,-1,0,0,2,2,2,-1,-1,2,-1,2,-1,-1,1,1,2,0,2,2,1,1,1,-1,-1,0,-1,2,-1,1,2,2,2,0,1,2,2,0,1,-1,1,2,-1,0,-1,-1,1,0,0,2,2,0,2,0,2,1,-1,1,1,2,0,2,1,2,0,0,-1,1,2,0,0,1,2,0,-1,2,0,0,0,0,2,2,1,2,2,0,2,0,2,2,0,2,1,2,2,0,0,-1,2,0,1,2,0,2,0,0,1,-1,0,1,2,1,1,2,2,1,2,-1,2,2,2,2,2,0,-1,1,0,0,-1,1,2,2,2,0,0,-1,1,-1,1,-1,0,1,-1,-1,2,1,1,1,-1,2,1,0,0,1,2,1,2,-1,1,1,0,-1,2,-1,2,-1,0,0,1,1,2,-1,1,2,-1,1,0,0,2,-1,-1,-1,-1,0,2,2,-1,1,0,-1,0,2,0,-1,0,-1,1,2,2,2,0,1,1,0,-1,0,0,2,0,2,-1,2,1,0,-1,1,-1,0,0,2,2,0,2,1,1,-1,1,2,0,-1,-1,-1,-1,2,2,1,2,0,1,1,0,-1,-1,-1,2,-1,0,1,2,1,-1,2,-1,2,-1,1,-1,2,-1,-1,1,0,-1,1,2,-1,2,2,0,1,-1,2,-1,0,-1,2,-1,0,-1,1,2,-1,2,0,0,1,0,2,0,2,0,2,1,0,0,1,1,2,2,1,1,2,-1,0,0,2,1,1,0,-1,0,2,-1,-1,2,2,1,0,2,2,-1,-1,0,-1,2,1,1,1,1,-1,2,-1,0,1,2,-1,2,0,0,0,-1,2,-1,-1,-1,-1,0,1,-1,2,2,2,1,2,1,0,-1,0,2,-1,-1,-1,-1,1,1,0,0,-1,0,0,2,0,-1,2,0,0,2,-1,-1,2,-1,-1,-1,0,0,0,-1,2,-1,1,1,0,1,-1,-1,0,2,2,0,-1,2,-1,2,2,1,2,1,2,-1,0,2,1,1,1,0,1,-1,0,0,1,0,-1,-1,0,1,1,1,-1,1},
} ;

static const unsigned char precomputed_decode_1277x3_s[precomputed_decode_1277x3_NUM][crypto_decode_STRBYTES] = {
  {119,255,4,175,221,161,22,187,43,28,116,118,28,210,185,182,51,93,157,187,167,237,84,22,21,151,194,62,61,30,97,48,61,7,113,222,32,242,248,248,191,150,37,135,227,102,219,139,193,98,115,177,162,82,145,216,14,130,83,59,199,95,23,25,102,44,222,116,130,0,7,218,37,181,216,27,3,48,218,153,60,236,150,159,108,220,7,141,148,62,230,88,208,1,89,184,152,106,231,252,251,233,87,101,248,4,145,170,103,142,7,14,61,192,27,216,154,174,238,7,27,15,46,26,90,149,226,146,36,28,235,149,112,144,110,137,196,212,222,122,41,112,156,53,108,226,214,11,73,125,28,219,57,19,238,59,4,175,40,206,134,43,99,46,249,82,94,1,202,171,65,246,49,181,85,190,173,110,119,235,129,162,65,179,110,236,183,239,255,225,127,95,70,28,152,226,201,251,103,166,91,5,11,85,205,211,252,145,112,118,59,68,75,169,15,250,87,75,122,198,125,173,10,134,154,149,65,48,212,222,171,57,173,198,240,49,89,16,149,12,36,84,132,229,35,48,84,16,22,200,152,164,199,54,143,126,8,126,28,123,88,195,43,72,14,126,249,56,46,20,192,239,167,187,82,178,28,209,138,244,244,34,12,87,155,53,96,154,226,13,187,202,60,177,216,95,36,237,113,224,253,33,27,63,110,43,188,45,158,185,43,193,188,100,178,100,134,104,127,76},
  {35,212,215,196,90,171,68,17,77,142,130,252,183,35,176,180,70,41,234,74,174,0,160,38,90,166,77,218,129,140,20,101,91,98,95,222,123,23,17,172,164,4,232,244,218,181,186,163,163,9,82,62,74,21,206,79,198,6,17,117,96,252,45,40,237,183,221,133,207,169,39,167,78,72,194,187,180,236,111,147,19,117,241,56,238,33,42,21,94,180,111,135,56,20,52,89,93,167,219,25,170,230,249,250,80,145,245,158,190,194,49,183,60,173,61,54,70,179,200,27,211,149,125,73,11,111,185,16,15,21,190,197,186,120,133,160,225,2,87,141,164,202,184,19,97,35,203,200,39,250,179,153,185,65,159,183,39,1,100,36,102,64,91,219,37,196,79,36,59,218,197,77,220,166,55,221,252,231,25,146,63,103,55,130,99,130,186,125,177,134,120,33,233,98,68,183,122,166,128,175,16,71,206,119,151,5,214,96,58,26,145,131,49,179,7,21,18,35,136,140,120,165,252,99,26,73,244,187,86,73,202,19,233,230,89,214,94,225,171,212,138,243,222,171,65,166,120,120,191,150,67,198,5,122,31,165,50,48,107,221,135,126,253,249,96,147,116,143,202,235,110,170,61,118,228,65,250,253,98,60,43,142,56,201,186,112,206,113,48,88,240,219,188,179,191,65,222,227,99,101,235,210,50,11,212,156,8,73,122,142,112,102,244,154,9,15,27,142,246,33},
  {141,229,35,61,57,118,78,174,231,246,41,247,182,64,67,77,48,253,103,57,161,249,197,177,60,161,120,89,103,161,30,136,44,115,30,5,97,65,146,248,75,97,108,243,183,106,31,158,91,151,169,80,238,253,3,73,16,24,69,38,254,229,48,207,130,28,254,40,235,33,119,210,146,241,7,38,39,214,75,39,124,140,230,147,41,75,248,145,109,225,250,151,200,6,204,147,30,222,180,66,161,86,124,47,11,246,232,108,255,74,40,114,39,182,95,93,142,84,198,57,166,0,244,131,191,219,51,126,42,164,75,178,164,25,203,17,56,200,24,251,199,196,137,212,168,126,236,56,4,212,172,41,194,249,105,134,194,216,97,108,161,94,86,43,206,142,214,101,149,240,65,239,53,162,11,92,151,21,201,197,202,242,104,32,112,172,56,140,59,116,216,24,70,116,149,30,25,255,231,231,103,2,93,137,21,68,158,164,6,114,195,81,88,71,187,15,21,128,181,5,79,39,118,73,238,231,48,173,73,163,216,127,161,52,143,73,27,76,133,98,228,199,168,105,198,155,109,56,183,76,102,82,185,132,2,221,227,43,69,59,155,178,116,55,219,150,149,207,31,3,212,132,44,41,163,109,168,209,118,202,120,154,69,180,224,140,251,216,228,65,253,3,5,151,171,61,166,88,89,75,155,82,177,190,232,177,114,64,99,190,144,57,235,139,185,86,98,18,108,101},
  {84,65,29,51,117,3,224,246,147,171,58,207,187,151,71,111,135,82,140,202,251,50,31,136,114,98,159,60,128,40,206,81,6,96,180,153,103,71,9,98,253,234,111,177,26,252,85,145,73,108,148,16,173,44,34,177,150,132,229,172,97,174,124,120,188,84,10,23,13,205,218,33,209,111,192,240,205,75,73,59,189,151,38,86,184,47,103,0,156,208,132,48,210,197,20,44,212,31,218,197,117,94,187,247,33,142,120,64,186,81,122,69,215,254,190,239,21,108,207,68,116,229,51,248,107,56,234,103,77,241,86,93,2,85,158,14,217,58,131,51,233,206,253,45,29,16,228,137,197,78,60,146,124,219,152,144,0,82,136,110,43,225,137,135,125,122,203,136,251,99,58,32,237,35,197,1,105,107,70,27,58,193,242,23,170,246,192,112,15,102,255,232,189,214,98,246,212,151,248,91,68,23,37,185,101,31,130,101,175,189,204,123,83,63,204,160,247,42,196,248,231,39,78,96,125,183,232,237,133,151,199,85,239,119,223,126,113,222,37,185,190,243,127,88,248,23,34,9,171,108,185,163,49,83,58,142,53,64,143,209,17,254,105,212,205,134,212,183,226,1,188,167,1,147,203,140,12,134,243,201,196,132,115,217,221,150,190,78,173,209,240,246,16,171,50,57,87,12,144,252,110,52,128,22,117,92,195,64,197,104,66,31,243,238,180,154,148,65,42,250},
} ;

static void test_decode_1277x3_impl(long long impl)
{
  unsigned char *x = test_decode_1277x3_x;
  unsigned char *s = test_decode_1277x3_s;
  unsigned char *x2 = test_decode_1277x3_x2;
  unsigned char *s2 = test_decode_1277x3_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1277x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1277x3(impl);
    printf("decode_1277x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277x3_implementation(impl),ntruprime_dispatch_decode_1277x3_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1277x3;
    printf("decode_1277x3 selected implementation %s compiler %s\n",ntruprime_decode_1277x3_implementation(),ntruprime_decode_1277x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1277x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1277x3_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1277x3_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1277x3_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1277x3_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1277x3_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1277x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277x3")) return;
  storage_decode_1277x3_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1277x3_x = aligned(storage_decode_1277x3_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1277x3_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1277x3_s = aligned(storage_decode_1277x3_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1277x3_x2 = callocplus(maxalloc);
  test_decode_1277x3_x2 = aligned(storage_decode_1277x3_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1277x3_s2 = callocplus(maxalloc);
  test_decode_1277x3_s2 = aligned(storage_decode_1277x3_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1277x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1277x3();++impl)
      forked(test_decode_1277x3_impl,impl);
    ++test_decode_1277x3_x;
    ++test_decode_1277x3_s;
    ++test_decode_1277x3_x2;
    ++test_decode_1277x3_s2;
  }
  free(storage_decode_1277x3_s2);
  free(storage_decode_1277x3_x2);
  free(storage_decode_1277x3_s);
  free(storage_decode_1277x3_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

