### NAME

sntrup - command-line interface for the libntruprime implementation of the Streamlined NTRU Prime cryptosystem

### SYNOPSIS

Key generation (for, e.g., `sntrup1277`):

    sntrup1277-keypair 5>publickey 9>secretkey

Encapsulation (for, e.g., `sntrup1277`):

    sntrup1277-enc >ciphertext 7>sessionkey 4<publickey

Decapsulation (for, e.g., `sntrup1277`):

    sntrup1277-dec 7>sessionkey <ciphertext 8<secretkey

### DESCRIPTION

libntruprime is an implementation
of the [Streamlined NTRU Prime](https://ntruprime.cr.yp.to) cryptosystem.
The command-line interface for libntruprime
provides the following command-line tools:

    sntrup{653,761,857,953,1013,1277}-keypair
    sntrup{653,761,857,953,1013,1277}-enc
    sntrup{653,761,857,953,1013,1277}-dec

Each tool exits 0 on success, nonzero on failure.

These tools allow libntruprime
to be easily used from shell scripts.
Other languages can also use libntruprime via these tools,
but languages typically have good support for FFI
and can use the C interface directly.

The details below use `sntrup1277` as an example.

### KEY GENERATION

Alice runs the `sntrup1277-keypair` command.
This command randomly generates
Alice's secret key and Alice's corresponding public key.
It writes the public key to file descriptor 5,
and then writes the secret key to file descriptor 9.

### ENCAPSULATION

Bob runs the `sntrup1277-enc` command.
This command
reads Alice's public key from file descriptor 4.
It randomly generates
a ciphertext and the corresponding session key.
It writes the ciphertext to stdout,
and then writes the session key to file descriptor 7.

### DECAPSULATION

Alice runs the `sntrup1277-dec` command.
This command
reads Alice's secret key from file descriptor 8,
and then reads a ciphertext from stdin.
It computes the corresponding session key,
which it writes to file descriptor 7.

### SEE ALSO

**sntrup**(3)
