/* This file can be used to test whether the code handles non-canonical curve
 * points (i.e. points with the 256th bit set) in the same way as the reference
 * implementation. */

#include <stdint.h>
#include <stdio.h>
#include <string.h>

extern void curve25519_donna(unsigned char *output, const unsigned char *a,
                             const unsigned char *b);
int
main()
{
  static const uint8_t point1[32] = {
    0x25,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  };
  static const uint8_t point2[32] = {
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
  };
  static const uint8_t scalar[32] = { 1 };
  uint8_t out1[32], out2[32];

  curve25519_donna(out1, scalar, point1);
  curve25519_donna(out2, scalar, point2);

  if (0 == memcmp(out1, out2, sizeof(out1))) {
    fprintf(stderr, "Top bit not ignored.\n");
    return 1;
  }

  fprintf(stderr, "Top bit correctly ignored.\n");
  return 0;
}
