require 'rails_helper'

# WARNING: If you change tests make sure you uncomment this line
# and start a test backend. Some of the actions
# require real backend answers for projects/packages.
# CONFIG['global_write_through'] = true

RSpec.describe PackageUpdateIfDirtyJob, type: :job, vcr: true do
  include ActiveJob::TestHelper

  describe '#perform' do
    let!(:project) { create(:project, name: 'apache') }
    let!(:package) { create(:package_with_file, name: 'mod_ssl', project: project) }

    subject { PackageUpdateIfDirtyJob.new.perform(package.id) }

    it 'creates a BackendPackge for the Package' do
      expect { subject }.to change { BackendPackage.count }.by(1)
    end
  end
end
