package org.semanticweb.owlapi.api.test.anonymous;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

import org.junit.jupiter.api.Test;
import org.semanticweb.owlapi.api.test.baseclasses.TestBase;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.vocab.OWLFacet;

class IsAnonymousTestCase extends TestBase {

    @Test
    void shouldCheckAnonymous() {
        IRI itest = I.getIRI();
        SWRLClassAtom sc = SWRLClassAtom(A, SWRLIndividualArgument(J));
        SWRLIndividualArgument sind = SWRLIndividualArgument(I);
        SWRLIndividualArgument sind1 = SWRLIndividualArgument(indA);
        SWRLLiteralArgument sl = SWRLLiteralArgument(literal);
        assertFalse(new OWLOntologyID(itest, itest).isAnonymous());
        OWLOntology o = create(itest);
        assertFalse(o.isAnonymous());
        OWLOntology o1 = createAnon();
        assertTrue(o1.isAnonymous());
        // entities
        assertFalse(A.isAnonymous());
        assertFalse(DP.isAnonymous());
        assertFalse(op1.isAnonymous());
        assertFalse(Datatype(itest).isAnonymous());
        assertFalse(I.isAnonymous());
        assertFalse(AnnotationProperty(itest).isAnonymous());
        assertFalse(OWLThing().isAnonymous());
        assertFalse(OWLNothing().isAnonymous());
        // convenience properties
        assertFalse(RDFSLabel().isAnonymous());
        assertFalse(RDFSComment().isAnonymous());
        assertFalse(TopObjectProperty().isAnonymous());
        assertFalse(TopDataProperty().isAnonymous());
        assertFalse(TopDatatype().isAnonymous());
        assertFalse(BottomObjectProperty().isAnonymous());
        assertFalse(BottomDataProperty().isAnonymous());
        assertFalse(RDFSSeeAlso().isAnonymous());
        assertFalse(RDFSIsDefinedBy().isAnonymous());
        assertFalse(VersionInfo().isAnonymous());
        assertFalse(BackwardCompatibleWith().isAnonymous());
        assertFalse(IncompatibleWith().isAnonymous());
        assertFalse(Deprecated().isAnonymous());
        // convenience datatype methods
        assertFalse(RDFPlainLiteral().isAnonymous());
        assertFalse(Integer().isAnonymous());
        assertFalse(Float().isAnonymous());
        assertFalse(Double().isAnonymous());
        assertFalse(Boolean().isAnonymous());
        assertFalse(String().isAnonymous());
        assertTrue(itest.isAnonymous());
        assertTrue(RDFSLabel("label").isAnonymous());
        assertTrue(RDFSComment("comment").isAnonymous());
        assertTrue(SWRLVariable(iri("urn:swrl:", "variable")).isAnonymous());
        assertTrue(SWRLVariable("?variable").isAnonymous());
        assertTrue(SWRLVariable(itest).isAnonymous());
        assertTrue(new OWLOntologyID().isAnonymous());
        assertTrue(AnonymousIndividual().isAnonymous());
        assertTrue(literal.isAnonymous());
        assertTrue(DeprecatedOWLAnnotationAssertion(itest).isAnonymous());
        assertTrue(Annotation(RDFSComment(), literal).isAnonymous());
        assertTrue(sc.isAnonymous());
        assertTrue(Declaration(A).isAnonymous());
        assertTrue(DatatypeDefinition(Integer(), Double()).isAnonymous());
        assertTrue(DataComplementOf(Integer()).isAnonymous());
        assertTrue(DataAllValuesFrom(DP, Integer()).isAnonymous());
        assertTrue(DataSomeValuesFrom(DP, Integer()).isAnonymous());
        assertTrue(DisjointUnion(A, C1, C2).isAnonymous());
        assertTrue(SubPropertyChainOf(l(op1, op2), P).isAnonymous());
        assertTrue(SWRLRule(l(sc), l(sc)).isAnonymous());
        assertTrue(SWRLDataRangeAtom(Integer(), sl).isAnonymous());
        assertTrue(SWRLObjectPropertyAtom(op1, sind, sind1).isAnonymous());
        assertTrue(SWRLDataPropertyAtom(DP, sind, sl).isAnonymous());
        assertTrue(SWRLBuiltInAtom(itest, l(sl)).isAnonymous());
        assertTrue(sind.isAnonymous());
        assertTrue(sl.isAnonymous());
        assertTrue(SWRLSameIndividualAtom(sind1, sind).isAnonymous());
        assertTrue(SWRLDifferentIndividualsAtom(sind1, sind).isAnonymous());
        assertTrue(AnnotationAssertion(RDFSLabel(), itest, literal).isAnonymous());
        assertTrue(ClassAssertion(A, I).isAnonymous());
        assertTrue(DataPropertyAssertion(DP, I, Literal(2D)).isAnonymous());
        assertTrue(NegativeDataPropertyAssertion(DP, I, literal).isAnonymous());
        assertTrue(ObjectPropertyAssertion(op1, I, indA).isAnonymous());
        assertTrue(NegativeObjectPropertyAssertion(op1, I, indA).isAnonymous());
        assertTrue(SameIndividual(I, indA).isAnonymous());
        assertTrue(DifferentIndividuals(I, indA).isAnonymous());
        assertTrue(DataExactCardinality(1, DP, Integer()).isAnonymous());
        assertTrue(DataMaxCardinality(1, DP).isAnonymous());
        assertTrue(DataMinCardinality(1, DP).isAnonymous());
        assertTrue(ObjectExactCardinality(1, op1, OWLThing()).isAnonymous());
        assertTrue(ObjectMinCardinality(1, op1, OWLThing()).isAnonymous());
        assertTrue(ObjectMaxCardinality(1, op1, OWLThing()).isAnonymous());
        assertTrue(DisjointClasses(A, C1).isAnonymous());
        assertTrue(DisjointObjectProperties(op2, op1).isAnonymous());
        assertTrue(DisjointDataProperties(DP, DPP).isAnonymous());
        assertTrue(EquivalentClasses(A, C1).isAnonymous());
        assertTrue(EquivalentObjectProperties(op2, op1).isAnonymous());
        assertTrue(EquivalentDataProperties(DP, DPP).isAnonymous());
        assertTrue(FunctionalObjectProperty(op1).isAnonymous());
        assertTrue(InverseFunctionalObjectProperty(op1).isAnonymous());
        assertTrue(ReflexiveObjectProperty(op1).isAnonymous());
        assertTrue(IrreflexiveObjectProperty(op1).isAnonymous());
        assertTrue(SymmetricObjectProperty(op1).isAnonymous());
        assertTrue(AsymmetricObjectProperty(op1).isAnonymous());
        assertTrue(TransitiveObjectProperty(op1).isAnonymous());
        assertTrue(FunctionalDataProperty(DP).isAnonymous());
        assertTrue(DatatypeRestriction(Integer(), FacetRestriction(OWLFacet.LENGTH, literal))
            .isAnonymous());
        assertTrue(DatatypeMinInclusiveRestriction(2D).isAnonymous());
        assertTrue(DatatypeMaxInclusiveRestriction(3D).isAnonymous());
        assertTrue(DatatypeMinMaxInclusiveRestriction(2D, 3D).isAnonymous());
        assertTrue(FacetRestriction(OWLFacet.LENGTH, LIT_ONE).isAnonymous());
        assertTrue(DatatypeMinExclusiveRestriction(1).isAnonymous());
        assertTrue(DatatypeMaxExclusiveRestriction(1).isAnonymous());
        assertTrue(DatatypeMinMaxExclusiveRestriction(1, 2).isAnonymous());
        assertTrue(ObjectPropertyDomain(op1, A).isAnonymous());
        assertTrue(DataPropertyDomain(DP, A).isAnonymous());
        assertTrue(AnnotationPropertyDomain(RDFSLabel(), itest).isAnonymous());
        assertTrue(ObjectPropertyRange(op1, A).isAnonymous());
        assertTrue(DataPropertyRange(DP, Integer()).isAnonymous());
        assertTrue(AnnotationPropertyRange(RDFSLabel(), itest).isAnonymous());
        assertTrue(DataIntersectionOf(Integer(), Double()).isAnonymous());
        assertTrue(ObjectIntersectionOf(A, C1).isAnonymous());
        assertTrue(DataUnionOf(Integer(), Double()).isAnonymous());
        assertTrue(ObjectUnionOf(A, C1).isAnonymous());
        assertTrue(SubClassOf(A, C1).isAnonymous());
        assertTrue(SubObjectPropertyOf(op2, op1).isAnonymous());
        assertTrue(SubDataPropertyOf(DP, DPP).isAnonymous());
        assertTrue(SubAnnotationPropertyOf(RDFSLabel(), RDFSLabel()).isAnonymous());
        assertTrue(ObjectComplementOf(A).isAnonymous());
        assertTrue(DataOneOf(literal).isAnonymous());
        assertTrue(ObjectOneOf(I).isAnonymous());
        assertTrue(ObjectAllValuesFrom(op1, A).isAnonymous());
        assertTrue(ObjectSomeValuesFrom(op1, A).isAnonymous());
        assertTrue(HasKey(A, DP).isAnonymous());
        assertTrue(InverseObjectProperties(op1, op1).isAnonymous());
        assertTrue(ObjectHasValue(op1, I).isAnonymous());
        assertTrue(DataHasValue(DP, literal).isAnonymous());
        assertTrue(ObjectInverseOf(op1).isAnonymous());
        assertTrue(ObjectHasSelf(op1).isAnonymous());
    }
}
