// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SADDW_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SADDW_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_saddw_2D[] = {
  0x0000000000007e7d, 0x0000000000007f00,
  0x0000000000007f7d, 0x00000000007ffd00,
  0x00000000007ffd7d, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000001,
  0x000000000000007e, 0x0000000000000002,
  0x000000000000007f, 0x0000000000000020,
  0x000000000000009d, 0x000000000000007d,
  0x00000000000000fa, 0x000000000000007e,
  0x00000000000000fb, 0x000000000000007f,
  0x00000000000000fc, 0x0000000000007ffd,
  0x000000000000807a, 0x0000000000007ffe,
  0x000000000000807b, 0x0000000000007fff,
  0x000000000000807c, 0x0000000033333333,
  0x00000000333333b0, 0x0000000055555555,
  0x00000000555555d2, 0x000000007ffffffd,
  0x000000008000007a, 0x000000007ffffffe,
  0x000000008000007b, 0x000000007fffffff,
  0x000000008000007c, 0xffffffff80000000,
  0xffffffff8000007d, 0xffffffff80000001,
  0xffffffff8000007e, 0xffffffffaaaaaaaa,
  0xffffffffaaaaab27, 0xffffffffcccccccc,
  0xffffffffcccccd49, 0xffffffffffff8000,
  0xffffffffffff807d, 0xffffffffffff8001,
  0xffffffffffff807e, 0xffffffffffff8002,
  0xffffffffffff807f, 0xffffffffffff8003,
  0xffffffffffff8080, 0xffffffffffffff80,
  0xfffffffffffffffd, 0xffffffffffffff81,
  0xfffffffffffffffe, 0xffffffffffffff82,
  0xffffffffffffffff, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffffe0,
  0x000000000000005d, 0xfffffffffffffffd,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000021,
  0x0000000000000020, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000033333334,
  0x0000000033333333, 0x0000000055555556,
  0x0000000055555555, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffffaaaaaaab,
  0xffffffffaaaaaaaa, 0xffffffffcccccccd,
  0xffffffffcccccccc, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffffe1,
  0xffffffffffffffe0, 0xfffffffffffffffe,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000022,
  0x0000000000000021, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x0000000033333335,
  0x0000000033333334, 0x0000000055555557,
  0x0000000055555556, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffffaaaaaaac,
  0xffffffffaaaaaaab, 0xffffffffccccccce,
  0xffffffffcccccccd, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffffe2,
  0xffffffffffffffe1, 0xffffffffffffffff,
  0xffffffffffffffff, 0x000000000000003e,
  0x0000000000000000, 0x000000000000003f,
  0x0000000000000001, 0x0000000000000040,
  0x0000000000000002, 0x0000000000000041,
  0x0000000000000003, 0x0000000000000042,
  0x0000000000000004, 0x0000000000000060,
  0x0000000000000022, 0x00000000000000bd,
  0x000000000000007f, 0x00000000000000be,
  0x0000000000000080, 0x00000000000000bf,
  0x0000000000000081, 0x000000000000803d,
  0x0000000000007fff, 0x000000000000803e,
  0x0000000000008000, 0x000000000000803f,
  0x0000000000008001, 0x0000000033333373,
  0x0000000033333335, 0x0000000055555595,
  0x0000000055555557, 0x000000008000003d,
  0x000000007fffffff, 0x000000008000003e,
  0x0000000080000000, 0x000000008000003f,
  0x0000000080000001, 0xffffffff80000040,
  0xffffffff80000002, 0xffffffff80000041,
  0xffffffff80000003, 0xffffffffaaaaaaea,
  0xffffffffaaaaaaac, 0xffffffffcccccd0c,
  0xffffffffccccccce, 0xffffffffffff8040,
  0xffffffffffff8002, 0xffffffffffff8041,
  0xffffffffffff8003, 0xffffffffffff8042,
  0xffffffffffff8004, 0xffffffffffff8043,
  0xffffffffffff8005, 0xffffffffffffffc0,
  0xffffffffffffff82, 0xffffffffffffffc1,
  0xffffffffffffff83, 0xffffffffffffffc2,
  0xffffffffffffff84, 0xffffffffffffffc3,
  0xffffffffffffff85, 0x0000000000000020,
  0xffffffffffffffe2, 0x000000000000003d,
  0x000000000000003d, 0x000000000000007b,
  0x000000000000003e, 0x000000000000007c,
  0x000000000000003f, 0x000000000000007d,
  0x0000000000000040, 0x000000000000007e,
  0x0000000000000041, 0x000000000000007f,
  0x0000000000000042, 0x000000000000009d,
  0x0000000000000060, 0x00000000000000fa,
  0x00000000000000bd, 0x00000000000000fb,
  0x00000000000000be, 0x00000000000000fc,
  0x00000000000000bf, 0x000000000000807a,
  0x000000000000803d, 0x000000000000807b,
  0x000000000000803e, 0x000000000000807c,
  0x000000000000803f, 0x00000000333333b0,
  0x0000000033333373, 0x00000000555555d2,
  0x0000000055555595, 0x000000008000007a,
  0x000000008000003d, 0x000000008000007b,
  0x000000008000003e, 0x000000008000007c,
  0x000000008000003f, 0xffffffff8000007d,
  0xffffffff80000040, 0xffffffff8000007e,
  0xffffffff80000041, 0xffffffffaaaaab27,
  0xffffffffaaaaaaea, 0xffffffffcccccd49,
  0xffffffffcccccd0c, 0xffffffffffff807d,
  0xffffffffffff8040, 0xffffffffffff807e,
  0xffffffffffff8041, 0xffffffffffff807f,
  0xffffffffffff8042, 0xffffffffffff8080,
  0xffffffffffff8043, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffe,
  0xffffffffffffffc1, 0xffffffffffffffff,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffc3, 0x000000000000005d,
  0x0000000000000020, 0x000000000000007a,
  0x000000000000007a, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x000000000000009e,
  0x000000000000009d, 0x00000000000000fb,
  0x00000000000000fa, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x00000000333333b1,
  0x00000000333333b0, 0x00000000555555d3,
  0x00000000555555d2, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffffaaaaab28,
  0xffffffffaaaaab27, 0xffffffffcccccd4a,
  0xffffffffcccccd49, 0xffffffffffff807e,
  0xffffffffffff807d, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000000000005e,
  0x000000000000005d, 0x000000000000007b,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x000000000000009f,
  0x000000000000009e, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x00000000000000fe,
  0x00000000000000fd, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x00000000333333b2,
  0x00000000333333b1, 0x00000000555555d4,
  0x00000000555555d3, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffffaaaaab29,
  0xffffffffaaaaab28, 0xffffffffcccccd4b,
  0xffffffffcccccd4a, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8082,
  0xffffffffffff8081, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x000000000000005f,
  0x000000000000005e, 0x000000000000007c,
  0x000000000000007c, 0x0000000000007ffb,
  0x000000000000007d, 0x0000000000007ffc,
  0x000000000000007e, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000000081, 0x000000000000801d,
  0x000000000000009f, 0x000000000000807a,
  0x00000000000000fc, 0x000000000000807b,
  0x00000000000000fd, 0x000000000000807c,
  0x00000000000000fe, 0x000000000000fffa,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000807e, 0x000000003333b330,
  0x00000000333333b2, 0x000000005555d552,
  0x00000000555555d4, 0x0000000080007ffa,
  0x000000008000007c, 0x0000000080007ffb,
  0x000000008000007d, 0x0000000080007ffc,
  0x000000008000007e, 0xffffffff80007ffd,
  0xffffffff8000007f, 0xffffffff80007ffe,
  0xffffffff80000080, 0xffffffffaaab2aa7,
  0xffffffffaaaaab29, 0xffffffffcccd4cc9,
  0xffffffffcccccd4b, 0xfffffffffffffffd,
  0xffffffffffff807f, 0xfffffffffffffffe,
  0xffffffffffff8080, 0xffffffffffffffff,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffff8082, 0x0000000000007f7d,
  0xffffffffffffffff, 0x0000000000007f7e,
  0x0000000000000000, 0x0000000000007f7f,
  0x0000000000000001, 0x0000000000007f80,
  0x0000000000000002, 0x0000000000007fdd,
  0x000000000000005f, 0x0000000000007ffa,
  0x0000000000007ffa, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x000000000000801e,
  0x000000000000801d, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000fffa, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x000000003333b331,
  0x000000003333b330, 0x000000005555d553,
  0x000000005555d552, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffffaaab2aa8,
  0xffffffffaaab2aa7, 0xffffffffcccd4cca,
  0xffffffffcccd4cc9, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007fde,
  0x0000000000007fdd, 0x0000000000007ffb,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x000000000000801f,
  0x000000000000801e, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x000000000000fffe,
  0x000000000000fffd, 0x000000003333b332,
  0x000000003333b331, 0x000000005555d554,
  0x000000005555d553, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffffaaab2aa9,
  0xffffffffaaab2aa8, 0xffffffffcccd4ccb,
  0xffffffffcccd4cca, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007fdf,
  0x0000000000007fde, 0x0000000000007ffc,
  0x0000000000007ffc, 0x000000007ffffffb,
  0x0000000000007ffd, 0x000000007ffffffc,
  0x0000000000007ffe, 0x000000007ffffffd,
  0x0000000000007fff, 0x000000007ffffffe,
  0x0000000000008000, 0x000000007fffffff,
  0x0000000000008001, 0x000000008000001d,
  0x000000000000801f, 0x000000008000007a,
  0x000000000000807c, 0x000000008000007b,
  0x000000000000807d, 0x000000008000007c,
  0x000000000000807e, 0x0000000080007ffa,
  0x000000000000fffc, 0x0000000080007ffb,
  0x000000000000fffd, 0x0000000080007ffc,
  0x000000000000fffe, 0x00000000b3333330,
  0x000000003333b332, 0x00000000d5555552,
  0x000000005555d554, 0x00000000fffffffa,
  0x0000000080007ffc, 0x00000000fffffffb,
  0x0000000080007ffd, 0x00000000fffffffc,
  0x0000000080007ffe, 0xfffffffffffffffd,
  0xffffffff80007fff, 0xfffffffffffffffe,
  0xffffffff80008000, 0x000000002aaaaaa7,
  0xffffffffaaab2aa9, 0x000000004cccccc9,
  0xffffffffcccd4ccb, 0x000000007fff7ffd,
  0xffffffffffffffff, 0x000000007fff7ffe,
  0x0000000000000000, 0x000000007fff7fff,
  0x0000000000000001, 0x000000007fff8000,
  0x0000000000000002, 0x000000007fffff7d,
  0x0000000000007f7f, 0x000000007fffff7e,
  0x0000000000007f80, 0x000000007fffff7f,
  0x0000000000007f81, 0x000000007fffff80,
  0x0000000000007f82, 0x000000007fffffdd,
  0x0000000000007fdf, 0x000000007ffffffa,
  0x000000007ffffffa, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x000000008000001e,
  0x000000008000001d, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x00000000b3333331,
  0x00000000b3333330, 0x00000000d5555553,
  0x00000000d5555552, 0x00000000fffffffb,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x000000002aaaaaa8,
  0x000000002aaaaaa7, 0x000000004cccccca,
  0x000000004cccccc9, 0x000000007fff7ffe,
  0x000000007fff7ffd, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fffff7e,
  0x000000007fffff7d, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffffde,
  0x000000007fffffdd, 0x000000007ffffffb,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x000000008000001f,
  0x000000008000001e, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x00000000b3333332,
  0x00000000b3333331, 0x00000000d5555554,
  0x00000000d5555553, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000000fffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x000000002aaaaaa9,
  0x000000002aaaaaa8, 0x000000004ccccccb,
  0x000000004cccccca, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffffdf,
  0x000000007fffffde, 0x000000007ffffffc,
  0x000000007ffffffc, 0x3333333333333331,
  0x000000007ffffffd, 0x3333333333333332,
  0x000000007ffffffe, 0x3333333333333333,
  0x000000007fffffff, 0x3333333333333334,
  0x0000000080000000, 0x3333333333333335,
  0x0000000080000001, 0x3333333333333353,
  0x000000008000001f, 0x33333333333333b0,
  0x000000008000007c, 0x33333333333333b1,
  0x000000008000007d, 0x33333333333333b2,
  0x000000008000007e, 0x333333333333b330,
  0x0000000080007ffc, 0x333333333333b331,
  0x0000000080007ffd, 0x333333333333b332,
  0x0000000080007ffe, 0x3333333366666666,
  0x00000000b3333332, 0x3333333388888888,
  0x00000000d5555554, 0x33333333b3333330,
  0x00000000fffffffc, 0x33333333b3333331,
  0x00000000fffffffd, 0x33333333b3333332,
  0x00000000fffffffe, 0x33333332b3333333,
  0xffffffffffffffff, 0x33333332b3333334,
  0x0000000000000000, 0x33333332dddddddd,
  0x000000002aaaaaa9, 0x33333332ffffffff,
  0x000000004ccccccb, 0x333333333332b333,
  0x000000007fff7fff, 0x333333333332b334,
  0x000000007fff8000, 0x333333333332b335,
  0x000000007fff8001, 0x333333333332b336,
  0x000000007fff8002, 0x33333333333332b3,
  0x000000007fffff7f, 0x33333333333332b4,
  0x000000007fffff80, 0x33333333333332b5,
  0x000000007fffff81, 0x33333333333332b6,
  0x000000007fffff82, 0x3333333333333313,
  0x000000007fffffdf, 0x3333333333333330,
  0x3333333333333330, 0x5555555555555553,
  0x3333333333333331, 0x5555555555555554,
  0x3333333333333332, 0x5555555555555555,
  0x3333333333333333, 0x5555555555555556,
  0x3333333333333334, 0x5555555555555557,
  0x3333333333333335, 0x5555555555555575,
  0x3333333333333353, 0x55555555555555d2,
  0x33333333333333b0, 0x55555555555555d3,
  0x33333333333333b1, 0x55555555555555d4,
  0x33333333333333b2, 0x555555555555d552,
  0x333333333333b330, 0x555555555555d553,
  0x333333333333b331, 0x555555555555d554,
  0x333333333333b332, 0x5555555588888888,
  0x3333333366666666, 0x55555555aaaaaaaa,
  0x3333333388888888, 0x55555555d5555552,
  0x33333333b3333330, 0x55555555d5555553,
  0x33333333b3333331, 0x55555555d5555554,
  0x33333333b3333332, 0x55555554d5555555,
  0x33333332b3333333, 0x55555554d5555556,
  0x33333332b3333334, 0x55555554ffffffff,
  0x33333332dddddddd, 0x5555555522222221,
  0x33333332ffffffff, 0x555555555554d555,
  0x333333333332b333, 0x555555555554d556,
  0x333333333332b334, 0x555555555554d557,
  0x333333333332b335, 0x555555555554d558,
  0x333333333332b336, 0x55555555555554d5,
  0x33333333333332b3, 0x55555555555554d6,
  0x33333333333332b4, 0x55555555555554d7,
  0x33333333333332b5, 0x55555555555554d8,
  0x33333333333332b6, 0x5555555555555535,
  0x3333333333333313, 0x5555555555555552,
  0x5555555555555552, 0x7ffffffffffffffb,
  0x5555555555555553, 0x7ffffffffffffffc,
  0x5555555555555554, 0x7ffffffffffffffd,
  0x5555555555555555, 0x7ffffffffffffffe,
  0x5555555555555556, 0x7fffffffffffffff,
  0x5555555555555557, 0x800000000000001d,
  0x5555555555555575, 0x800000000000007a,
  0x55555555555555d2, 0x800000000000007b,
  0x55555555555555d3, 0x800000000000007c,
  0x55555555555555d4, 0x8000000000007ffa,
  0x555555555555d552, 0x8000000000007ffb,
  0x555555555555d553, 0x8000000000007ffc,
  0x555555555555d554, 0x8000000033333330,
  0x5555555588888888, 0x8000000055555552,
  0x55555555aaaaaaaa, 0x800000007ffffffa,
  0x55555555d5555552, 0x800000007ffffffb,
  0x55555555d5555553, 0x800000007ffffffc,
  0x55555555d5555554, 0x7fffffff7ffffffd,
  0x55555554d5555555, 0x7fffffff7ffffffe,
  0x55555554d5555556, 0x7fffffffaaaaaaa7,
  0x55555554ffffffff, 0x7fffffffccccccc9,
  0x5555555522222221, 0x7fffffffffff7ffd,
  0x555555555554d555, 0x7fffffffffff7ffe,
  0x555555555554d556, 0x7fffffffffff7fff,
  0x555555555554d557, 0x7fffffffffff8000,
  0x555555555554d558, 0x7fffffffffffff7d,
  0x55555555555554d5, 0x7fffffffffffff7e,
  0x55555555555554d6, 0x7fffffffffffff7f,
  0x55555555555554d7, 0x7fffffffffffff80,
  0x55555555555554d8, 0x7fffffffffffffdd,
  0x5555555555555535, 0x7ffffffffffffffa,
  0x7ffffffffffffffa, 0x7ffffffffffffffc,
  0x7ffffffffffffffb, 0x7ffffffffffffffd,
  0x7ffffffffffffffc, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x8000000000000000,
  0x7fffffffffffffff, 0x800000000000001e,
  0x800000000000001d, 0x800000000000007b,
  0x800000000000007a, 0x800000000000007c,
  0x800000000000007b, 0x800000000000007d,
  0x800000000000007c, 0x8000000000007ffb,
  0x8000000000007ffa, 0x8000000000007ffc,
  0x8000000000007ffb, 0x8000000000007ffd,
  0x8000000000007ffc, 0x8000000033333331,
  0x8000000033333330, 0x8000000055555553,
  0x8000000055555552, 0x800000007ffffffb,
  0x800000007ffffffa, 0x800000007ffffffc,
  0x800000007ffffffb, 0x800000007ffffffd,
  0x800000007ffffffc, 0x7fffffff7ffffffe,
  0x7fffffff7ffffffd, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x7fffffffaaaaaaa8,
  0x7fffffffaaaaaaa7, 0x7fffffffccccccca,
  0x7fffffffccccccc9, 0x7fffffffffff7ffe,
  0x7fffffffffff7ffd, 0x7fffffffffff7fff,
  0x7fffffffffff7ffe, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffffff7e,
  0x7fffffffffffff7d, 0x7fffffffffffff7f,
  0x7fffffffffffff7e, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffffde,
  0x7fffffffffffffdd, 0x7ffffffffffffffb,
  0x7ffffffffffffffb, 0x7ffffffffffffffd,
  0x7ffffffffffffffc, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000001,
  0x8000000000000000, 0x800000000000001f,
  0x800000000000001e, 0x800000000000007c,
  0x800000000000007b, 0x800000000000007d,
  0x800000000000007c, 0x800000000000007e,
  0x800000000000007d, 0x8000000000007ffc,
  0x8000000000007ffb, 0x8000000000007ffd,
  0x8000000000007ffc, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000033333332,
  0x8000000033333331, 0x8000000055555554,
  0x8000000055555553, 0x800000007ffffffc,
  0x800000007ffffffb, 0x800000007ffffffd,
  0x800000007ffffffc, 0x800000007ffffffe,
  0x800000007ffffffd, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffffaaaaaaa9,
  0x7fffffffaaaaaaa8, 0x7fffffffcccccccb,
  0x7fffffffccccccca, 0x7fffffffffff7fff,
  0x7fffffffffff7ffe, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffffffff7f,
  0x7fffffffffffff7e, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffffffdf,
  0x7fffffffffffffde, 0x7ffffffffffffffc,
  0x7ffffffffffffffc, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000020,
  0x800000000000001f, 0x800000000000007d,
  0x800000000000007c, 0x800000000000007e,
  0x800000000000007d, 0x800000000000007f,
  0x800000000000007e, 0x8000000000007ffd,
  0x8000000000007ffc, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000033333333,
  0x8000000033333332, 0x8000000055555555,
  0x8000000055555554, 0x800000007ffffffd,
  0x800000007ffffffc, 0x800000007ffffffe,
  0x800000007ffffffd, 0x800000007fffffff,
  0x800000007ffffffe, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffffaaaaaaaa,
  0x7fffffffaaaaaaa9, 0x7fffffffcccccccc,
  0x7fffffffcccccccb, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffffffe0,
  0x7fffffffffffffdf, 0x7ffffffffffffffd,
  0x7ffffffffffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000021,
  0x8000000000000020, 0x800000000000007e,
  0x800000000000007d, 0x800000000000007f,
  0x800000000000007e, 0x8000000000000080,
  0x800000000000007f, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000008000,
  0x8000000000007fff, 0x8000000033333334,
  0x8000000033333333, 0x8000000055555556,
  0x8000000055555555, 0x800000007ffffffe,
  0x800000007ffffffd, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffffaaaaaaab,
  0x7fffffffaaaaaaaa, 0x7fffffffcccccccd,
  0x7fffffffcccccccc, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffffff8004,
  0x7fffffffffff8003, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffffff84,
  0x7fffffffffffff83, 0x7fffffffffffffe1,
  0x7fffffffffffffe0, 0x7ffffffffffffffe,
  0x7ffffffffffffffe, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000004,
  0x8000000000000003, 0x8000000000000022,
  0x8000000000000021, 0x800000000000007f,
  0x800000000000007e, 0x8000000000000080,
  0x800000000000007f, 0x8000000000000081,
  0x8000000000000080, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000008001,
  0x8000000000008000, 0x8000000033333335,
  0x8000000033333334, 0x8000000055555557,
  0x8000000055555556, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffff80000003,
  0x7fffffff80000002, 0x7fffffffaaaaaaac,
  0x7fffffffaaaaaaab, 0x7fffffffccccccce,
  0x7fffffffcccccccd, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffffff8004,
  0x7fffffffffff8003, 0x7fffffffffff8005,
  0x7fffffffffff8004, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffffff84,
  0x7fffffffffffff83, 0x7fffffffffffff85,
  0x7fffffffffffff84, 0x7fffffffffffffe2,
  0x7fffffffffffffe1, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000004,
  0x8000000000000003, 0x8000000000000005,
  0x8000000000000004, 0x8000000000000023,
  0x8000000000000022, 0x8000000000000080,
  0x800000000000007f, 0x8000000000000081,
  0x8000000000000080, 0x8000000000000082,
  0x8000000000000081, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000008001,
  0x8000000000008000, 0x8000000000008002,
  0x8000000000008001, 0x8000000033333336,
  0x8000000033333335, 0x8000000055555558,
  0x8000000055555557, 0x8000000080000000,
  0x800000007fffffff, 0x8000000080000001,
  0x8000000080000000, 0x8000000080000002,
  0x8000000080000001, 0x7fffffff80000003,
  0x7fffffff80000002, 0x7fffffff80000004,
  0x7fffffff80000003, 0x7fffffffaaaaaaad,
  0x7fffffffaaaaaaac, 0x7fffffffcccccccf,
  0x7fffffffccccccce, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffffff8004,
  0x7fffffffffff8003, 0x7fffffffffff8005,
  0x7fffffffffff8004, 0x7fffffffffff8006,
  0x7fffffffffff8005, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffffff84,
  0x7fffffffffffff83, 0x7fffffffffffff85,
  0x7fffffffffffff84, 0x7fffffffffffff86,
  0x7fffffffffffff85, 0x7fffffffffffffe3,
  0x7fffffffffffffe2, 0x8000000000000000,
  0x8000000000000000, 0xaaaaaaaaaaaaaaa8,
  0x8000000000000001, 0xaaaaaaaaaaaaaaa9,
  0x8000000000000002, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0xaaaaaaaaaaaaaaab,
  0x8000000000000004, 0xaaaaaaaaaaaaaaac,
  0x8000000000000005, 0xaaaaaaaaaaaaaaca,
  0x8000000000000023, 0xaaaaaaaaaaaaab27,
  0x8000000000000080, 0xaaaaaaaaaaaaab28,
  0x8000000000000081, 0xaaaaaaaaaaaaab29,
  0x8000000000000082, 0xaaaaaaaaaaab2aa7,
  0x8000000000008000, 0xaaaaaaaaaaab2aa8,
  0x8000000000008001, 0xaaaaaaaaaaab2aa9,
  0x8000000000008002, 0xaaaaaaaadddddddd,
  0x8000000033333336, 0xaaaaaaaaffffffff,
  0x8000000055555558, 0xaaaaaaab2aaaaaa7,
  0x8000000080000000, 0xaaaaaaab2aaaaaa8,
  0x8000000080000001, 0xaaaaaaab2aaaaaa9,
  0x8000000080000002, 0xaaaaaaaa2aaaaaaa,
  0x7fffffff80000003, 0xaaaaaaaa2aaaaaab,
  0x7fffffff80000004, 0xaaaaaaaa55555554,
  0x7fffffffaaaaaaad, 0xaaaaaaaa77777776,
  0x7fffffffcccccccf, 0xaaaaaaaaaaaa2aaa,
  0x7fffffffffff8003, 0xaaaaaaaaaaaa2aab,
  0x7fffffffffff8004, 0xaaaaaaaaaaaa2aac,
  0x7fffffffffff8005, 0xaaaaaaaaaaaa2aad,
  0x7fffffffffff8006, 0xaaaaaaaaaaaaaa2a,
  0x7fffffffffffff83, 0xaaaaaaaaaaaaaa2b,
  0x7fffffffffffff84, 0xaaaaaaaaaaaaaa2c,
  0x7fffffffffffff85, 0xaaaaaaaaaaaaaa2d,
  0x7fffffffffffff86, 0xaaaaaaaaaaaaaa8a,
  0x7fffffffffffffe3, 0xaaaaaaaaaaaaaaa7,
  0xaaaaaaaaaaaaaaa7, 0xccccccccccccccca,
  0xaaaaaaaaaaaaaaa8, 0xcccccccccccccccb,
  0xaaaaaaaaaaaaaaa9, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0xcccccccccccccccd,
  0xaaaaaaaaaaaaaaab, 0xccccccccccccccce,
  0xaaaaaaaaaaaaaaac, 0xccccccccccccccec,
  0xaaaaaaaaaaaaaaca, 0xcccccccccccccd49,
  0xaaaaaaaaaaaaab27, 0xcccccccccccccd4a,
  0xaaaaaaaaaaaaab28, 0xcccccccccccccd4b,
  0xaaaaaaaaaaaaab29, 0xcccccccccccd4cc9,
  0xaaaaaaaaaaab2aa7, 0xcccccccccccd4cca,
  0xaaaaaaaaaaab2aa8, 0xcccccccccccd4ccb,
  0xaaaaaaaaaaab2aa9, 0xccccccccffffffff,
  0xaaaaaaaadddddddd, 0xcccccccd22222221,
  0xaaaaaaaaffffffff, 0xcccccccd4cccccc9,
  0xaaaaaaab2aaaaaa7, 0xcccccccd4cccccca,
  0xaaaaaaab2aaaaaa8, 0xcccccccd4ccccccb,
  0xaaaaaaab2aaaaaa9, 0xcccccccc4ccccccc,
  0xaaaaaaaa2aaaaaaa, 0xcccccccc4ccccccd,
  0xaaaaaaaa2aaaaaab, 0xcccccccc77777776,
  0xaaaaaaaa55555554, 0xcccccccc99999998,
  0xaaaaaaaa77777776, 0xcccccccccccc4ccc,
  0xaaaaaaaaaaaa2aaa, 0xcccccccccccc4ccd,
  0xaaaaaaaaaaaa2aab, 0xcccccccccccc4cce,
  0xaaaaaaaaaaaa2aac, 0xcccccccccccc4ccf,
  0xaaaaaaaaaaaa2aad, 0xcccccccccccccc4c,
  0xaaaaaaaaaaaaaa2a, 0xcccccccccccccc4d,
  0xaaaaaaaaaaaaaa2b, 0xcccccccccccccc4e,
  0xaaaaaaaaaaaaaa2c, 0xcccccccccccccc4f,
  0xaaaaaaaaaaaaaa2d, 0xccccccccccccccac,
  0xaaaaaaaaaaaaaa8a, 0xccccccccccccccc9,
  0xccccccccccccccc9, 0xffffffff7ffffffe,
  0xccccccccccccccca, 0xffffffff7fffffff,
  0xcccccccccccccccb, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff80000001,
  0xcccccccccccccccd, 0xffffffff80000002,
  0xccccccccccccccce, 0xffffffff80000020,
  0xccccccccccccccec, 0xffffffff8000007d,
  0xcccccccccccccd49, 0xffffffff8000007e,
  0xcccccccccccccd4a, 0xffffffff8000007f,
  0xcccccccccccccd4b, 0xffffffff80007ffd,
  0xcccccccccccd4cc9, 0xffffffff80007ffe,
  0xcccccccccccd4cca, 0xffffffff80007fff,
  0xcccccccccccd4ccb, 0xffffffffb3333333,
  0xccccccccffffffff, 0xffffffffd5555555,
  0xcccccccd22222221, 0xfffffffffffffffd,
  0xcccccccd4cccccc9, 0xfffffffffffffffe,
  0xcccccccd4cccccca, 0xffffffffffffffff,
  0xcccccccd4ccccccb, 0xffffffff00000000,
  0xcccccccc4ccccccc, 0xffffffff00000001,
  0xcccccccc4ccccccd, 0xffffffff2aaaaaaa,
  0xcccccccc77777776, 0xffffffff4ccccccc,
  0xcccccccc99999998, 0xffffffff7fff8000,
  0xcccccccccccc4ccc, 0xffffffff7fff8001,
  0xcccccccccccc4ccd, 0xffffffff7fff8002,
  0xcccccccccccc4cce, 0xffffffff7fff8003,
  0xcccccccccccc4ccf, 0xffffffff7fffff80,
  0xcccccccccccccc4c, 0xffffffff7fffff81,
  0xcccccccccccccc4d, 0xffffffff7fffff82,
  0xcccccccccccccc4e, 0xffffffff7fffff83,
  0xcccccccccccccc4f, 0xffffffff7fffffe0,
  0xccccccccccccccac, 0xffffffff7ffffffd,
  0xffffffff7ffffffd, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000021,
  0xffffffff80000020, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffffb3333334,
  0xffffffffb3333333, 0xffffffffd5555556,
  0xffffffffd5555555, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff2aaaaaab,
  0xffffffff2aaaaaaa, 0xffffffff4ccccccd,
  0xffffffff4ccccccc, 0xffffffff7fff8001,
  0xffffffff7fff8000, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fffff81,
  0xffffffff7fffff80, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffffe1,
  0xffffffff7fffffe0, 0xffffffff7ffffffe,
  0xffffffff7ffffffe, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000022,
  0xffffffff80000021, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffffb3333335,
  0xffffffffb3333334, 0xffffffffd5555557,
  0xffffffffd5555556, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff2aaaaaac,
  0xffffffff2aaaaaab, 0xffffffff4cccccce,
  0xffffffff4ccccccd, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffffe2,
  0xffffffff7fffffe1, 0xffffffff7fffffff,
  0xffffffff7fffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000005,
  0xffffffff80000004, 0xffffffff80000023,
  0xffffffff80000022, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000082,
  0xffffffff80000081, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008002,
  0xffffffff80008001, 0xffffffffb3333336,
  0xffffffffb3333335, 0xffffffffd5555558,
  0xffffffffd5555557, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff2aaaaaad,
  0xffffffff2aaaaaac, 0xffffffff4ccccccf,
  0xffffffff4cccccce, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8006,
  0xffffffff7fff8005, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff86,
  0xffffffff7fffff85, 0xffffffff7fffffe3,
  0xffffffff7fffffe2, 0xffffffff80000000,
  0xffffffff80000000, 0xffffffffffff7ffe,
  0xffffffff80000001, 0xffffffffffff7fff,
  0xffffffff80000002, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff8001,
  0xffffffff80000004, 0xffffffffffff8002,
  0xffffffff80000005, 0xffffffffffff8020,
  0xffffffff80000023, 0xffffffffffff807d,
  0xffffffff80000080, 0xffffffffffff807e,
  0xffffffff80000081, 0xffffffffffff807f,
  0xffffffff80000082, 0xfffffffffffffffd,
  0xffffffff80008000, 0xfffffffffffffffe,
  0xffffffff80008001, 0xffffffffffffffff,
  0xffffffff80008002, 0x000000003332b333,
  0xffffffffb3333336, 0x000000005554d555,
  0xffffffffd5555558, 0x000000007fff7ffd,
  0x0000000000000000, 0x000000007fff7ffe,
  0x0000000000000001, 0x000000007fff7fff,
  0x0000000000000002, 0xffffffff7fff8000,
  0xffffffff00000003, 0xffffffff7fff8001,
  0xffffffff00000004, 0xffffffffaaaa2aaa,
  0xffffffff2aaaaaad, 0xffffffffcccc4ccc,
  0xffffffff4ccccccf, 0xffffffffffff0000,
  0xffffffff7fff8003, 0xffffffffffff0001,
  0xffffffff7fff8004, 0xffffffffffff0002,
  0xffffffff7fff8005, 0xffffffffffff0003,
  0xffffffff7fff8006, 0xffffffffffff7f80,
  0xffffffff7fffff83, 0xffffffffffff7f81,
  0xffffffff7fffff84, 0xffffffffffff7f82,
  0xffffffff7fffff85, 0xffffffffffff7f83,
  0xffffffff7fffff86, 0xffffffffffff7fe0,
  0xffffffff7fffffe3, 0xffffffffffff7ffd,
  0xffffffffffff7ffd, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8021,
  0xffffffffffff8020, 0xffffffffffff807e,
  0xffffffffffff807d, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x000000003332b334,
  0x000000003332b333, 0x000000005554d556,
  0x000000005554d555, 0x000000007fff7ffe,
  0x000000007fff7ffd, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0xffffffff7fff8001,
  0xffffffff7fff8000, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffffaaaa2aab,
  0xffffffffaaaa2aaa, 0xffffffffcccc4ccd,
  0xffffffffcccc4ccc, 0xffffffffffff0001,
  0xffffffffffff0000, 0xffffffffffff0002,
  0xffffffffffff0001, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff7f81,
  0xffffffffffff7f80, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7fe1,
  0xffffffffffff7fe0, 0xffffffffffff7ffe,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8022,
  0xffffffffffff8021, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000003332b335,
  0x000000003332b334, 0x000000005554d557,
  0x000000005554d556, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffffaaaa2aac,
  0xffffffffaaaa2aab, 0xffffffffcccc4cce,
  0xffffffffcccc4ccd, 0xffffffffffff0002,
  0xffffffffffff0001, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7fe2,
  0xffffffffffff7fe1, 0xffffffffffff7fff,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffff8023,
  0xffffffffffff8022, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8082,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x000000003332b336,
  0x000000003332b335, 0x000000005554d558,
  0x000000005554d557, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8002,
  0x000000007fff8001, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffffaaaa2aad,
  0xffffffffaaaa2aac, 0xffffffffcccc4ccf,
  0xffffffffcccc4cce, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff0006,
  0xffffffffffff0005, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffff7fe3,
  0xffffffffffff7fe2, 0xffffffffffff8000,
  0xffffffffffff8000, 0xffffffffffffff7e,
  0xffffffffffff8001, 0xffffffffffffff7f,
  0xffffffffffff8002, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffffffffff8004, 0xffffffffffffff82,
  0xffffffffffff8005, 0xffffffffffffffa0,
  0xffffffffffff8023, 0xfffffffffffffffd,
  0xffffffffffff8080, 0xfffffffffffffffe,
  0xffffffffffff8081, 0xffffffffffffffff,
  0xffffffffffff8082, 0x0000000000007f7d,
  0x0000000000000000, 0x0000000000007f7e,
  0x0000000000000001, 0x0000000000007f7f,
  0x0000000000000002, 0x00000000333332b3,
  0x000000003332b336, 0x00000000555554d5,
  0x000000005554d558, 0x000000007fffff7d,
  0x000000007fff8000, 0x000000007fffff7e,
  0x000000007fff8001, 0x000000007fffff7f,
  0x000000007fff8002, 0xffffffff7fffff80,
  0xffffffff7fff8003, 0xffffffff7fffff81,
  0xffffffff7fff8004, 0xffffffffaaaaaa2a,
  0xffffffffaaaa2aad, 0xffffffffcccccc4c,
  0xffffffffcccc4ccf, 0xffffffffffff7f80,
  0xffffffffffff0003, 0xffffffffffff7f81,
  0xffffffffffff0004, 0xffffffffffff7f82,
  0xffffffffffff0005, 0xffffffffffff7f83,
  0xffffffffffff0006, 0xffffffffffffff00,
  0xffffffffffff7f83, 0xffffffffffffff01,
  0xffffffffffff7f84, 0xffffffffffffff02,
  0xffffffffffff7f85, 0xffffffffffffff03,
  0xffffffffffff7f86, 0xffffffffffffff60,
  0xffffffffffff7fe3, 0xffffffffffffff7d,
  0xffffffffffffff7d, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffffa1,
  0xffffffffffffffa0, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x00000000333332b4,
  0x00000000333332b3, 0x00000000555554d6,
  0x00000000555554d5, 0x000000007fffff7e,
  0x000000007fffff7d, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0xffffffff7fffff81,
  0xffffffff7fffff80, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffffaaaaaa2b,
  0xffffffffaaaaaa2a, 0xffffffffcccccc4d,
  0xffffffffcccccc4c, 0xffffffffffff7f81,
  0xffffffffffff7f80, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffffff01,
  0xffffffffffffff00, 0xffffffffffffff02,
  0xffffffffffffff01, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff61,
  0xffffffffffffff60, 0xffffffffffffff7e,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffffa2,
  0xffffffffffffffa1, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x00000000333332b5,
  0x00000000333332b4, 0x00000000555554d7,
  0x00000000555554d6, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffffaaaaaa2c,
  0xffffffffaaaaaa2b, 0xffffffffcccccc4e,
  0xffffffffcccccc4d, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffffff02,
  0xffffffffffffff01, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff62,
  0xffffffffffffff61, 0xffffffffffffff7f,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffffa3,
  0xffffffffffffffa2, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f82,
  0x0000000000007f81, 0x00000000333332b6,
  0x00000000333332b5, 0x00000000555554d8,
  0x00000000555554d7, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff82,
  0x000000007fffff81, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffffaaaaaa2d,
  0xffffffffaaaaaa2c, 0xffffffffcccccc4f,
  0xffffffffcccccc4e, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff06,
  0xffffffffffffff05, 0xffffffffffffff63,
  0xffffffffffffff62, 0xffffffffffffff80,
  0xffffffffffffff80, 0xffffffffffffffbe,
  0xffffffffffffff81, 0xffffffffffffffbf,
  0xffffffffffffff82, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xffffffffffffffc1,
  0xffffffffffffff84, 0xffffffffffffffc2,
  0xffffffffffffff85, 0xffffffffffffffe0,
  0xffffffffffffffa3, 0x000000000000003d,
  0x0000000000000000, 0x000000000000003e,
  0x0000000000000001, 0x000000000000003f,
  0x0000000000000002, 0x0000000000007fbd,
  0x0000000000007f80, 0x0000000000007fbe,
  0x0000000000007f81, 0x0000000000007fbf,
  0x0000000000007f82, 0x00000000333332f3,
  0x00000000333332b6, 0x0000000055555515,
  0x00000000555554d8, 0x000000007fffffbd,
  0x000000007fffff80, 0x000000007fffffbe,
  0x000000007fffff81, 0x000000007fffffbf,
  0x000000007fffff82, 0xffffffff7fffffc0,
  0xffffffff7fffff83, 0xffffffff7fffffc1,
  0xffffffff7fffff84, 0xffffffffaaaaaa6a,
  0xffffffffaaaaaa2d, 0xffffffffcccccc8c,
  0xffffffffcccccc4f, 0xffffffffffff7fc0,
  0xffffffffffff7f83, 0xffffffffffff7fc1,
  0xffffffffffff7f84, 0xffffffffffff7fc2,
  0xffffffffffff7f85, 0xffffffffffff7fc3,
  0xffffffffffff7f86, 0xffffffffffffff40,
  0xffffffffffffff03, 0xffffffffffffff41,
  0xffffffffffffff04, 0xffffffffffffff42,
  0xffffffffffffff05, 0xffffffffffffff43,
  0xffffffffffffff06, 0xffffffffffffffa0,
  0xffffffffffffff63, 0xffffffffffffffbd,
  0xffffffffffffffbd, 0xfffffffffffffffb,
  0xffffffffffffffbe, 0xfffffffffffffffc,
  0xffffffffffffffbf, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffe,
  0xffffffffffffffc1, 0xffffffffffffffff,
  0xffffffffffffffc2, 0x000000000000001d,
  0xffffffffffffffe0, 0x000000000000007a,
  0x000000000000003d, 0x000000000000007b,
  0x000000000000003e, 0x000000000000007c,
  0x000000000000003f, 0x0000000000007ffa,
  0x0000000000007fbd, 0x0000000000007ffb,
  0x0000000000007fbe, 0x0000000000007ffc,
  0x0000000000007fbf, 0x0000000033333330,
  0x00000000333332f3, 0x0000000055555552,
  0x0000000055555515, 0x000000007ffffffa,
  0x000000007fffffbd, 0x000000007ffffffb,
  0x000000007fffffbe, 0x000000007ffffffc,
  0x000000007fffffbf, 0xffffffff7ffffffd,
  0xffffffff7fffffc0, 0xffffffff7ffffffe,
  0xffffffff7fffffc1, 0xffffffffaaaaaaa7,
  0xffffffffaaaaaa6a, 0xffffffffccccccc9,
  0xffffffffcccccc8c, 0xffffffffffff7ffd,
  0xffffffffffff7fc0, 0xffffffffffff7ffe,
  0xffffffffffff7fc1, 0xffffffffffff7fff,
  0xffffffffffff7fc2, 0xffffffffffff8000,
  0xffffffffffff7fc3, 0xffffffffffffff7d,
  0xffffffffffffff40, 0xffffffffffffff7e,
  0xffffffffffffff41, 0xffffffffffffff7f,
  0xffffffffffffff42, 0xffffffffffffff80,
  0xffffffffffffff43, 0xffffffffffffffdd,
  0xffffffffffffffa0, 0xfffffffffffffffa,
  0xfffffffffffffffa, 0xfffffffffffffffc,
  0xfffffffffffffffb, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x000000000000001e,
  0x000000000000001d, 0x000000000000007b,
  0x000000000000007a, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x0000000000007ffb,
  0x0000000000007ffa, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000033333331,
  0x0000000033333330, 0x0000000055555553,
  0x0000000055555552, 0x000000007ffffffb,
  0x000000007ffffffa, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0xffffffff7ffffffe,
  0xffffffff7ffffffd, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffffaaaaaaa8,
  0xffffffffaaaaaaa7, 0xffffffffccccccca,
  0xffffffffccccccc9, 0xffffffffffff7ffe,
  0xffffffffffff7ffd, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffffff7e,
  0xffffffffffffff7d, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffffde,
  0xffffffffffffffdd, 0xfffffffffffffffb,
  0xfffffffffffffffb, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0x0000000000000000, 0x000000000000001f,
  0x000000000000001e, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007e,
  0x000000000000007d, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000033333332,
  0x0000000033333331, 0x0000000055555554,
  0x0000000055555553, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffffaaaaaaa9,
  0xffffffffaaaaaaa8, 0xffffffffcccccccb,
  0xffffffffccccccca, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffffdf,
  0xffffffffffffffde, 0xfffffffffffffffc,
};
const unsigned kExpectedCount_NEON_saddw_2D = 1240;

#endif  // VIXL_SIM_SADDW_2D_TRACE_AARCH64_H_
