// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-simulator-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/disasm-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define __ masm.
#define BUF_SIZE (4096)

#ifdef VIXL_INCLUDE_SIMULATOR_AARCH32
// Run tests with the simulator.

#define SETUP() MacroAssembler masm(BUF_SIZE)

#define START() masm.GetBuffer()->Reset()

#define END() \
  __ Hlt(0);  \
  __ FinalizeCode();

// TODO: Run the tests in the simulator.
#define RUN()

#else  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32.

#define SETUP()                  \
  MacroAssembler masm(BUF_SIZE); \
  UseScratchRegisterScope harness_scratch;

#define START()                 \
  harness_scratch.Open(&masm);  \
  harness_scratch.ExcludeAll(); \
  masm.GetBuffer()->Reset();    \
  __ Push(r4);                  \
  __ Push(r5);                  \
  __ Push(r6);                  \
  __ Push(r7);                  \
  __ Push(r8);                  \
  __ Push(r9);                  \
  __ Push(r10);                 \
  __ Push(r11);                 \
  __ Push(lr);                  \
  harness_scratch.Include(ip);

#define END()                  \
  harness_scratch.Exclude(ip); \
  __ Pop(lr);                  \
  __ Pop(r11);                 \
  __ Pop(r10);                 \
  __ Pop(r9);                  \
  __ Pop(r8);                  \
  __ Pop(r7);                  \
  __ Pop(r6);                  \
  __ Pop(r5);                  \
  __ Pop(r4);                  \
  __ Bx(lr);                   \
  __ FinalizeCode();           \
  harness_scratch.Close();

#define RUN()                                                 \
  {                                                           \
    int pcs_offset = masm.IsUsingT32() ? 1 : 0;               \
    masm.GetBuffer()->SetExecutable();                        \
    ExecuteMemory(masm.GetBuffer()->GetStartAddress<byte*>(), \
                  masm.GetSizeOfCodeGenerated(),              \
                  pcs_offset);                                \
    masm.GetBuffer()->SetWritable();                          \
  }

#endif  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32

namespace vixl {
namespace aarch32 {

// List of instruction encodings:
#define FOREACH_INSTRUCTION(M) \
  M(Ldr)                       \
  M(Ldrb)                      \
  M(Ldrh)                      \
  M(Ldrsb)                     \
  M(Ldrsh)                     \
  M(Str)                       \
  M(Strb)                      \
  M(Strh)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` and
// `Inputs` have various layouts across generated tests so they absolutely
// cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Sign sign;
  Register rm;
  AddrMode addr_mode;
};

// Input data to feed to the instruction.
struct Inputs {
  uint32_t apsr;
  uint32_t rd;
  uint32_t rm;
  uint32_t memop[2];
};

// This structure contains all input data needed to test one specific encoding.
// It used to generate a loop over an instruction.
struct TestLoopData {
  // The `operands` fields represents the values to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
  // Array of values to be fed to the instruction.
  size_t input_size;
  const Inputs* inputs;
};

static const Inputs kCondition[] = {{NFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {CFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {VFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NCFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZCFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {CVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZCFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NCVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZCVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZCVFlag, 0xabababab, 0, {0, 0x77777777}}};

static const Inputs kPositiveOffset[] =
    {{NoFlag, 0xabababab, 1651, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 601, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 1934, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 3952, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 674, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3438, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3963, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 1428, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 1835, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2619, {0, 0x77777777}}};

static const Inputs kNegativeOffset[] =
    {{NoFlag, 0xabababab, 1635, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 48, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 3871, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 517, {0, 0x77777777}},
     {NoFlag, 0xabababab, 513, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 1348, {0, 0x77777777}},
     {NoFlag, 0xabababab, 3002, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 306, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 1458, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3028, {0, 0x55555555}}};

static const Inputs kPositivePostIndex[] =
    {{NoFlag, 0xabababab, 2442, {0, 0x55555555}},
     {NoFlag, 0xabababab, 1485, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 674, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 55, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2395, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 582, {0, 0x77777777}},
     {NoFlag, 0xabababab, 3572, {0, 0x77777777}},
     {NoFlag, 0xabababab, 2849, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3522, {0, 0x77777777}},
     {NoFlag, 0xabababab, 1234, {0, 0x0badbeef}}};

static const Inputs kNegativePostIndex[] =
    {{NoFlag, 0xabababab, 3413, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2442, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 3136, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2119, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 778, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 1666, {0, 0x77777777}},
     {NoFlag, 0xabababab, 3069, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 365, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 3094, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2690, {0, 0x55555555}}};

static const Inputs kPositivePreIndex[] =
    {{NoFlag, 0xabababab, 2072, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 22, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2254, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3002, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3391, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3449, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2796, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 3325, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 365, {0, 0x55555555}},
     {NoFlag, 0xabababab, 1323, {0, 0x77777777}}};

static const Inputs kNegativePreIndex[] =
    {{NoFlag, 0xabababab, 3821, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2892, {0, 0x77777777}},
     {NoFlag, 0xabababab, 3439, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3057, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2559, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3663, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 1506, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2011, {0, 0x77777777}},
     {NoFlag, 0xabababab, 3865, {0, 0x77777777}},
     {NoFlag, 0xabababab, 4058, {0, 0x55555555}}};


// A loop will be generated for each element of this array.
const TestLoopData kTests[] =
    {{{eq, r0, r1, plus, r8, Offset},
      "eq r0 r1 plus r8 Offset",
      "Condition_eq_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ne, r0, r1, plus, r8, Offset},
      "ne r0 r1 plus r8 Offset",
      "Condition_ne_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cs, r0, r1, plus, r8, Offset},
      "cs r0 r1 plus r8 Offset",
      "Condition_cs_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cc, r0, r1, plus, r8, Offset},
      "cc r0 r1 plus r8 Offset",
      "Condition_cc_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{mi, r0, r1, plus, r8, Offset},
      "mi r0 r1 plus r8 Offset",
      "Condition_mi_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{pl, r0, r1, plus, r8, Offset},
      "pl r0 r1 plus r8 Offset",
      "Condition_pl_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vs, r0, r1, plus, r8, Offset},
      "vs r0 r1 plus r8 Offset",
      "Condition_vs_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vc, r0, r1, plus, r8, Offset},
      "vc r0 r1 plus r8 Offset",
      "Condition_vc_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{hi, r0, r1, plus, r8, Offset},
      "hi r0 r1 plus r8 Offset",
      "Condition_hi_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ls, r0, r1, plus, r8, Offset},
      "ls r0 r1 plus r8 Offset",
      "Condition_ls_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ge, r0, r1, plus, r8, Offset},
      "ge r0 r1 plus r8 Offset",
      "Condition_ge_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{lt, r0, r1, plus, r8, Offset},
      "lt r0 r1 plus r8 Offset",
      "Condition_lt_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{gt, r0, r1, plus, r8, Offset},
      "gt r0 r1 plus r8 Offset",
      "Condition_gt_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{le, r0, r1, plus, r8, Offset},
      "le r0 r1 plus r8 Offset",
      "Condition_le_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r0, r1, plus, r8, Offset},
      "al r0 r1 plus r8 Offset",
      "Condition_al_r0_r1_plus_r8_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r9, r8, plus, r14, Offset},
      "al r9 r8 plus r14 Offset",
      "PositiveOffset_al_r9_r8_plus_r14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r8, plus, r9, Offset},
      "al r3 r8 plus r9 Offset",
      "PositiveOffset_al_r3_r8_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r6, plus, r9, Offset},
      "al r11 r6 plus r9 Offset",
      "PositiveOffset_al_r11_r6_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r0, plus, r12, Offset},
      "al r4 r0 plus r12 Offset",
      "PositiveOffset_al_r4_r0_plus_r12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r3, plus, r14, Offset},
      "al r8 r3 plus r14 Offset",
      "PositiveOffset_al_r8_r3_plus_r14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r9, plus, r14, Offset},
      "al r10 r9 plus r14 Offset",
      "PositiveOffset_al_r10_r9_plus_r14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r4, plus, r0, Offset},
      "al r7 r4 plus r0 Offset",
      "PositiveOffset_al_r7_r4_plus_r0_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r5, plus, r0, Offset},
      "al r4 r5 plus r0 Offset",
      "PositiveOffset_al_r4_r5_plus_r0_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r4, plus, r6, Offset},
      "al r14 r4 plus r6 Offset",
      "PositiveOffset_al_r14_r4_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r10, plus, r0, Offset},
      "al r3 r10 plus r0 Offset",
      "PositiveOffset_al_r3_r10_plus_r0_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r3, plus, r7, Offset},
      "al r8 r3 plus r7 Offset",
      "PositiveOffset_al_r8_r3_plus_r7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r10, plus, r3, Offset},
      "al r11 r10 plus r3 Offset",
      "PositiveOffset_al_r11_r10_plus_r3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r4, plus, r14, Offset},
      "al r10 r4 plus r14 Offset",
      "PositiveOffset_al_r10_r4_plus_r14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r3, plus, r9, Offset},
      "al r0 r3 plus r9 Offset",
      "PositiveOffset_al_r0_r3_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r8, plus, r3, Offset},
      "al r10 r8 plus r3 Offset",
      "PositiveOffset_al_r10_r8_plus_r3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r1, plus, r5, Offset},
      "al r3 r1 plus r5 Offset",
      "PositiveOffset_al_r3_r1_plus_r5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r14, plus, r12, Offset},
      "al r6 r14 plus r12 Offset",
      "PositiveOffset_al_r6_r14_plus_r12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r3, plus, r1, Offset},
      "al r14 r3 plus r1 Offset",
      "PositiveOffset_al_r14_r3_plus_r1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r7, plus, r4, Offset},
      "al r12 r7 plus r4 Offset",
      "PositiveOffset_al_r12_r7_plus_r4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r12, plus, r11, Offset},
      "al r0 r12 plus r11 Offset",
      "PositiveOffset_al_r0_r12_plus_r11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r10, plus, r9, Offset},
      "al r5 r10 plus r9 Offset",
      "PositiveOffset_al_r5_r10_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r9, plus, r10, Offset},
      "al r6 r9 plus r10 Offset",
      "PositiveOffset_al_r6_r9_plus_r10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r2, plus, r14, Offset},
      "al r1 r2 plus r14 Offset",
      "PositiveOffset_al_r1_r2_plus_r14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r6, plus, r10, Offset},
      "al r4 r6 plus r10 Offset",
      "PositiveOffset_al_r4_r6_plus_r10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r14, plus, r9, Offset},
      "al r1 r14 plus r9 Offset",
      "PositiveOffset_al_r1_r14_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r4, plus, r8, Offset},
      "al r14 r4 plus r8 Offset",
      "PositiveOffset_al_r14_r4_plus_r8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r11, plus, r4, Offset},
      "al r9 r11 plus r4 Offset",
      "PositiveOffset_al_r9_r11_plus_r4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r7, plus, r12, Offset},
      "al r9 r7 plus r12 Offset",
      "PositiveOffset_al_r9_r7_plus_r12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r6, plus, r11, Offset},
      "al r8 r6 plus r11 Offset",
      "PositiveOffset_al_r8_r6_plus_r11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r12, plus, r4, Offset},
      "al r1 r12 plus r4 Offset",
      "PositiveOffset_al_r1_r12_plus_r4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r7, plus, r10, Offset},
      "al r3 r7 plus r10 Offset",
      "PositiveOffset_al_r3_r7_plus_r10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r4, plus, r7, Offset},
      "al r11 r4 plus r7 Offset",
      "PositiveOffset_al_r11_r4_plus_r7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r7, plus, r0, Offset},
      "al r3 r7 plus r0 Offset",
      "PositiveOffset_al_r3_r7_plus_r0_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r0, plus, r2, Offset},
      "al r4 r0 plus r2 Offset",
      "PositiveOffset_al_r4_r0_plus_r2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r14, plus, r6, Offset},
      "al r5 r14 plus r6 Offset",
      "PositiveOffset_al_r5_r14_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r14, plus, r9, Offset},
      "al r6 r14 plus r9 Offset",
      "PositiveOffset_al_r6_r14_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r9, plus, r6, Offset},
      "al r2 r9 plus r6 Offset",
      "PositiveOffset_al_r2_r9_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r3, plus, r4, Offset},
      "al r1 r3 plus r4 Offset",
      "PositiveOffset_al_r1_r3_plus_r4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r11, plus, r8, Offset},
      "al r5 r11 plus r8 Offset",
      "PositiveOffset_al_r5_r11_plus_r8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r9, plus, r3, Offset},
      "al r11 r9 plus r3 Offset",
      "PositiveOffset_al_r11_r9_plus_r3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r12, plus, r5, Offset},
      "al r4 r12 plus r5 Offset",
      "PositiveOffset_al_r4_r12_plus_r5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r8, plus, r12, Offset},
      "al r7 r8 plus r12 Offset",
      "PositiveOffset_al_r7_r8_plus_r12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r14, plus, r6, Offset},
      "al r10 r14 plus r6 Offset",
      "PositiveOffset_al_r10_r14_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r6, plus, r10, Offset},
      "al r1 r6 plus r10 Offset",
      "PositiveOffset_al_r1_r6_plus_r10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r6, plus, r3, Offset},
      "al r2 r6 plus r3 Offset",
      "PositiveOffset_al_r2_r6_plus_r3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r10, plus, r6, Offset},
      "al r9 r10 plus r6 Offset",
      "PositiveOffset_al_r9_r10_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r3, plus, r10, Offset},
      "al r8 r3 plus r10 Offset",
      "PositiveOffset_al_r8_r3_plus_r10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r9, plus, r12, Offset},
      "al r5 r9 plus r12 Offset",
      "PositiveOffset_al_r5_r9_plus_r12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r0, plus, r12, Offset},
      "al r3 r0 plus r12 Offset",
      "PositiveOffset_al_r3_r0_plus_r12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r8, plus, r2, Offset},
      "al r3 r8 plus r2 Offset",
      "PositiveOffset_al_r3_r8_plus_r2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r5, plus, r6, Offset},
      "al r9 r5 plus r6 Offset",
      "PositiveOffset_al_r9_r5_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r0, plus, r9, Offset},
      "al r3 r0 plus r9 Offset",
      "PositiveOffset_al_r3_r0_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r12, plus, r9, Offset},
      "al r7 r12 plus r9 Offset",
      "PositiveOffset_al_r7_r12_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r3, plus, r0, Offset},
      "al r10 r3 plus r0 Offset",
      "PositiveOffset_al_r10_r3_plus_r0_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r14, plus, r11, Offset},
      "al r1 r14 plus r11 Offset",
      "PositiveOffset_al_r1_r14_plus_r11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r10, plus, r6, Offset},
      "al r11 r10 plus r6 Offset",
      "PositiveOffset_al_r11_r10_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r11, plus, r6, Offset},
      "al r9 r11 plus r6 Offset",
      "PositiveOffset_al_r9_r11_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r0, plus, r5, Offset},
      "al r4 r0 plus r5 Offset",
      "PositiveOffset_al_r4_r0_plus_r5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r14, plus, r4, Offset},
      "al r10 r14 plus r4 Offset",
      "PositiveOffset_al_r10_r14_plus_r4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r7, plus, r14, Offset},
      "al r11 r7 plus r14 Offset",
      "PositiveOffset_al_r11_r7_plus_r14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r2, plus, r9, Offset},
      "al r8 r2 plus r9 Offset",
      "PositiveOffset_al_r8_r2_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r2, plus, r11, Offset},
      "al r7 r2 plus r11 Offset",
      "PositiveOffset_al_r7_r2_plus_r11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r6, plus, r14, Offset},
      "al r12 r6 plus r14 Offset",
      "PositiveOffset_al_r12_r6_plus_r14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r2, plus, r1, Offset},
      "al r3 r2 plus r1 Offset",
      "PositiveOffset_al_r3_r2_plus_r1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r5, plus, r12, Offset},
      "al r14 r5 plus r12 Offset",
      "PositiveOffset_al_r14_r5_plus_r12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r9, plus, r2, Offset},
      "al r4 r9 plus r2 Offset",
      "PositiveOffset_al_r4_r9_plus_r2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r4, plus, r7, Offset},
      "al r5 r4 plus r7 Offset",
      "PositiveOffset_al_r5_r4_plus_r7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r2, plus, r14, Offset},
      "al r7 r2 plus r14 Offset",
      "PositiveOffset_al_r7_r2_plus_r14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r8, plus, r2, Offset},
      "al r4 r8 plus r2 Offset",
      "PositiveOffset_al_r4_r8_plus_r2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r5, plus, r6, Offset},
      "al r7 r5 plus r6 Offset",
      "PositiveOffset_al_r7_r5_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r8, plus, r6, Offset},
      "al r11 r8 plus r6 Offset",
      "PositiveOffset_al_r11_r8_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r0, plus, r1, Offset},
      "al r8 r0 plus r1 Offset",
      "PositiveOffset_al_r8_r0_plus_r1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r9, plus, r8, Offset},
      "al r4 r9 plus r8 Offset",
      "PositiveOffset_al_r4_r9_plus_r8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r1, plus, r12, Offset},
      "al r7 r1 plus r12 Offset",
      "PositiveOffset_al_r7_r1_plus_r12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r14, plus, r11, Offset},
      "al r12 r14 plus r11 Offset",
      "PositiveOffset_al_r12_r14_plus_r11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r6, plus, r5, Offset},
      "al r1 r6 plus r5 Offset",
      "PositiveOffset_al_r1_r6_plus_r5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r10, plus, r1, Offset},
      "al r9 r10 plus r1 Offset",
      "PositiveOffset_al_r9_r10_plus_r1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r14, plus, r10, Offset},
      "al r8 r14 plus r10 Offset",
      "PositiveOffset_al_r8_r14_plus_r10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r10, plus, r0, Offset},
      "al r12 r10 plus r0 Offset",
      "PositiveOffset_al_r12_r10_plus_r0_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r2, plus, r10, Offset},
      "al r6 r2 plus r10 Offset",
      "PositiveOffset_al_r6_r2_plus_r10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r1, plus, r5, Offset},
      "al r9 r1 plus r5 Offset",
      "PositiveOffset_al_r9_r1_plus_r5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r6, plus, r5, Offset},
      "al r4 r6 plus r5 Offset",
      "PositiveOffset_al_r4_r6_plus_r5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r5, plus, r11, Offset},
      "al r12 r5 plus r11 Offset",
      "PositiveOffset_al_r12_r5_plus_r11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r2, plus, r1, Offset},
      "al r0 r2 plus r1 Offset",
      "PositiveOffset_al_r0_r2_plus_r1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r1, plus, r8, Offset},
      "al r9 r1 plus r8 Offset",
      "PositiveOffset_al_r9_r1_plus_r8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r4, plus, r9, Offset},
      "al r6 r4 plus r9 Offset",
      "PositiveOffset_al_r6_r4_plus_r9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r2, plus, r7, Offset},
      "al r11 r2 plus r7 Offset",
      "PositiveOffset_al_r11_r2_plus_r7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r4, plus, r0, Offset},
      "al r11 r4 plus r0 Offset",
      "PositiveOffset_al_r11_r4_plus_r0_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r11, plus, r7, Offset},
      "al r2 r11 plus r7 Offset",
      "PositiveOffset_al_r2_r11_plus_r7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r7, plus, r5, Offset},
      "al r3 r7 plus r5 Offset",
      "PositiveOffset_al_r3_r7_plus_r5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r0, plus, r4, Offset},
      "al r1 r0 plus r4 Offset",
      "PositiveOffset_al_r1_r0_plus_r4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r12, plus, r0, Offset},
      "al r10 r12 plus r0 Offset",
      "PositiveOffset_al_r10_r12_plus_r0_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r0, plus, r11, Offset},
      "al r5 r0 plus r11 Offset",
      "PositiveOffset_al_r5_r0_plus_r11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r5, plus, r7, Offset},
      "al r3 r5 plus r7 Offset",
      "PositiveOffset_al_r3_r5_plus_r7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r14, plus, r4, Offset},
      "al r2 r14 plus r4 Offset",
      "PositiveOffset_al_r2_r14_plus_r4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r12, plus, r10, Offset},
      "al r3 r12 plus r10 Offset",
      "PositiveOffset_al_r3_r12_plus_r10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r11, plus, r1, Offset},
      "al r0 r11 plus r1 Offset",
      "PositiveOffset_al_r0_r11_plus_r1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r14, plus, r6, Offset},
      "al r2 r14 plus r6 Offset",
      "PositiveOffset_al_r2_r14_plus_r6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r10, plus, r11, Offset},
      "al r0 r10 plus r11 Offset",
      "PositiveOffset_al_r0_r10_plus_r11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r10, plus, r2, Offset},
      "al r14 r10 plus r2 Offset",
      "PositiveOffset_al_r14_r10_plus_r2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r7, minus, r8, Offset},
      "al r9 r7 minus r8 Offset",
      "NegativeOffset_al_r9_r7_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r6, minus, r2, Offset},
      "al r0 r6 minus r2 Offset",
      "NegativeOffset_al_r0_r6_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r0, minus, r7, Offset},
      "al r3 r0 minus r7 Offset",
      "NegativeOffset_al_r3_r0_minus_r7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r0, minus, r2, Offset},
      "al r3 r0 minus r2 Offset",
      "NegativeOffset_al_r3_r0_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r10, minus, r0, Offset},
      "al r7 r10 minus r0 Offset",
      "NegativeOffset_al_r7_r10_minus_r0_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r11, minus, r10, Offset},
      "al r1 r11 minus r10 Offset",
      "NegativeOffset_al_r1_r11_minus_r10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r7, minus, r3, Offset},
      "al r8 r7 minus r3 Offset",
      "NegativeOffset_al_r8_r7_minus_r3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r5, minus, r4, Offset},
      "al r6 r5 minus r4 Offset",
      "NegativeOffset_al_r6_r5_minus_r4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r10, minus, r6, Offset},
      "al r3 r10 minus r6 Offset",
      "NegativeOffset_al_r3_r10_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r14, minus, r0, Offset},
      "al r3 r14 minus r0 Offset",
      "NegativeOffset_al_r3_r14_minus_r0_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r4, minus, r5, Offset},
      "al r10 r4 minus r5 Offset",
      "NegativeOffset_al_r10_r4_minus_r5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r0, minus, r11, Offset},
      "al r10 r0 minus r11 Offset",
      "NegativeOffset_al_r10_r0_minus_r11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r0, minus, r10, Offset},
      "al r7 r0 minus r10 Offset",
      "NegativeOffset_al_r7_r0_minus_r10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r4, minus, r10, Offset},
      "al r9 r4 minus r10 Offset",
      "NegativeOffset_al_r9_r4_minus_r10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r3, minus, r10, Offset},
      "al r6 r3 minus r10 Offset",
      "NegativeOffset_al_r6_r3_minus_r10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r2, minus, r8, Offset},
      "al r14 r2 minus r8 Offset",
      "NegativeOffset_al_r14_r2_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r8, minus, r1, Offset},
      "al r14 r8 minus r1 Offset",
      "NegativeOffset_al_r14_r8_minus_r1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r6, minus, r11, Offset},
      "al r9 r6 minus r11 Offset",
      "NegativeOffset_al_r9_r6_minus_r11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r7, minus, r6, Offset},
      "al r11 r7 minus r6 Offset",
      "NegativeOffset_al_r11_r7_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r5, minus, r7, Offset},
      "al r8 r5 minus r7 Offset",
      "NegativeOffset_al_r8_r5_minus_r7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r2, minus, r10, Offset},
      "al r1 r2 minus r10 Offset",
      "NegativeOffset_al_r1_r2_minus_r10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r12, minus, r5, Offset},
      "al r0 r12 minus r5 Offset",
      "NegativeOffset_al_r0_r12_minus_r5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r8, minus, r1, Offset},
      "al r7 r8 minus r1 Offset",
      "NegativeOffset_al_r7_r8_minus_r1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r12, minus, r6, Offset},
      "al r4 r12 minus r6 Offset",
      "NegativeOffset_al_r4_r12_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r11, minus, r9, Offset},
      "al r2 r11 minus r9 Offset",
      "NegativeOffset_al_r2_r11_minus_r9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r14, minus, r11, Offset},
      "al r4 r14 minus r11 Offset",
      "NegativeOffset_al_r4_r14_minus_r11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r5, minus, r6, Offset},
      "al r8 r5 minus r6 Offset",
      "NegativeOffset_al_r8_r5_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r11, minus, r8, Offset},
      "al r10 r11 minus r8 Offset",
      "NegativeOffset_al_r10_r11_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r4, minus, r2, Offset},
      "al r14 r4 minus r2 Offset",
      "NegativeOffset_al_r14_r4_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r4, minus, r12, Offset},
      "al r2 r4 minus r12 Offset",
      "NegativeOffset_al_r2_r4_minus_r12_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r4, minus, r8, Offset},
      "al r0 r4 minus r8 Offset",
      "NegativeOffset_al_r0_r4_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r5, minus, r0, Offset},
      "al r14 r5 minus r0 Offset",
      "NegativeOffset_al_r14_r5_minus_r0_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r4, minus, r9, Offset},
      "al r8 r4 minus r9 Offset",
      "NegativeOffset_al_r8_r4_minus_r9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r11, minus, r2, Offset},
      "al r7 r11 minus r2 Offset",
      "NegativeOffset_al_r7_r11_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r5, minus, r10, Offset},
      "al r7 r5 minus r10 Offset",
      "NegativeOffset_al_r7_r5_minus_r10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r0, minus, r14, Offset},
      "al r5 r0 minus r14 Offset",
      "NegativeOffset_al_r5_r0_minus_r14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r10, minus, r12, Offset},
      "al r1 r10 minus r12 Offset",
      "NegativeOffset_al_r1_r10_minus_r12_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r14, minus, r10, Offset},
      "al r0 r14 minus r10 Offset",
      "NegativeOffset_al_r0_r14_minus_r10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r10, minus, r4, Offset},
      "al r5 r10 minus r4 Offset",
      "NegativeOffset_al_r5_r10_minus_r4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r5, minus, r4, Offset},
      "al r8 r5 minus r4 Offset",
      "NegativeOffset_al_r8_r5_minus_r4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r5, minus, r3, Offset},
      "al r9 r5 minus r3 Offset",
      "NegativeOffset_al_r9_r5_minus_r3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r3, minus, r11, Offset},
      "al r9 r3 minus r11 Offset",
      "NegativeOffset_al_r9_r3_minus_r11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r11, minus, r1, Offset},
      "al r9 r11 minus r1 Offset",
      "NegativeOffset_al_r9_r11_minus_r1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r8, minus, r1, Offset},
      "al r11 r8 minus r1 Offset",
      "NegativeOffset_al_r11_r8_minus_r1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r12, minus, r14, Offset},
      "al r5 r12 minus r14 Offset",
      "NegativeOffset_al_r5_r12_minus_r14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r0, minus, r7, Offset},
      "al r5 r0 minus r7 Offset",
      "NegativeOffset_al_r5_r0_minus_r7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r3, minus, r6, Offset},
      "al r1 r3 minus r6 Offset",
      "NegativeOffset_al_r1_r3_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r5, minus, r14, Offset},
      "al r12 r5 minus r14 Offset",
      "NegativeOffset_al_r12_r5_minus_r14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r9, minus, r6, Offset},
      "al r7 r9 minus r6 Offset",
      "NegativeOffset_al_r7_r9_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r0, minus, r2, Offset},
      "al r10 r0 minus r2 Offset",
      "NegativeOffset_al_r10_r0_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r10, minus, r6, Offset},
      "al r8 r10 minus r6 Offset",
      "NegativeOffset_al_r8_r10_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r9, minus, r2, Offset},
      "al r4 r9 minus r2 Offset",
      "NegativeOffset_al_r4_r9_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r1, minus, r14, Offset},
      "al r11 r1 minus r14 Offset",
      "NegativeOffset_al_r11_r1_minus_r14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r11, minus, r2, Offset},
      "al r10 r11 minus r2 Offset",
      "NegativeOffset_al_r10_r11_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r7, minus, r14, Offset},
      "al r5 r7 minus r14 Offset",
      "NegativeOffset_al_r5_r7_minus_r14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r14, minus, r5, Offset},
      "al r7 r14 minus r5 Offset",
      "NegativeOffset_al_r7_r14_minus_r5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r11, minus, r10, Offset},
      "al r14 r11 minus r10 Offset",
      "NegativeOffset_al_r14_r11_minus_r10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r4, minus, r12, Offset},
      "al r10 r4 minus r12 Offset",
      "NegativeOffset_al_r10_r4_minus_r12_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r12, minus, r6, Offset},
      "al r10 r12 minus r6 Offset",
      "NegativeOffset_al_r10_r12_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r11, minus, r9, Offset},
      "al r8 r11 minus r9 Offset",
      "NegativeOffset_al_r8_r11_minus_r9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r1, minus, r3, Offset},
      "al r9 r1 minus r3 Offset",
      "NegativeOffset_al_r9_r1_minus_r3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r12, minus, r14, Offset},
      "al r4 r12 minus r14 Offset",
      "NegativeOffset_al_r4_r12_minus_r14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r11, minus, r1, Offset},
      "al r8 r11 minus r1 Offset",
      "NegativeOffset_al_r8_r11_minus_r1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r2, minus, r8, Offset},
      "al r3 r2 minus r8 Offset",
      "NegativeOffset_al_r3_r2_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r3, minus, r8, Offset},
      "al r5 r3 minus r8 Offset",
      "NegativeOffset_al_r5_r3_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r7, minus, r0, Offset},
      "al r9 r7 minus r0 Offset",
      "NegativeOffset_al_r9_r7_minus_r0_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r12, minus, r8, Offset},
      "al r6 r12 minus r8 Offset",
      "NegativeOffset_al_r6_r12_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r8, minus, r9, Offset},
      "al r10 r8 minus r9 Offset",
      "NegativeOffset_al_r10_r8_minus_r9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r0, minus, r3, Offset},
      "al r11 r0 minus r3 Offset",
      "NegativeOffset_al_r11_r0_minus_r3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r0, minus, r6, Offset},
      "al r10 r0 minus r6 Offset",
      "NegativeOffset_al_r10_r0_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r10, minus, r12, Offset},
      "al r11 r10 minus r12 Offset",
      "NegativeOffset_al_r11_r10_minus_r12_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r1, minus, r2, Offset},
      "al r0 r1 minus r2 Offset",
      "NegativeOffset_al_r0_r1_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r9, minus, r2, Offset},
      "al r5 r9 minus r2 Offset",
      "NegativeOffset_al_r5_r9_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r6, minus, r5, Offset},
      "al r14 r6 minus r5 Offset",
      "NegativeOffset_al_r14_r6_minus_r5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r9, minus, r1, Offset},
      "al r6 r9 minus r1 Offset",
      "NegativeOffset_al_r6_r9_minus_r1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r2, minus, r6, Offset},
      "al r3 r2 minus r6 Offset",
      "NegativeOffset_al_r3_r2_minus_r6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r0, minus, r8, Offset},
      "al r2 r0 minus r8 Offset",
      "NegativeOffset_al_r2_r0_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r0, minus, r8, Offset},
      "al r11 r0 minus r8 Offset",
      "NegativeOffset_al_r11_r0_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r7, minus, r12, Offset},
      "al r6 r7 minus r12 Offset",
      "NegativeOffset_al_r6_r7_minus_r12_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r2, minus, r9, Offset},
      "al r0 r2 minus r9 Offset",
      "NegativeOffset_al_r0_r2_minus_r9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r10, minus, r8, Offset},
      "al r1 r10 minus r8 Offset",
      "NegativeOffset_al_r1_r10_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r3, minus, r2, Offset},
      "al r5 r3 minus r2 Offset",
      "NegativeOffset_al_r5_r3_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r11, minus, r8, Offset},
      "al r6 r11 minus r8 Offset",
      "NegativeOffset_al_r6_r11_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r11, minus, r9, Offset},
      "al r6 r11 minus r9 Offset",
      "NegativeOffset_al_r6_r11_minus_r9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r12, minus, r9, Offset},
      "al r14 r12 minus r9 Offset",
      "NegativeOffset_al_r14_r12_minus_r9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r4, minus, r2, Offset},
      "al r3 r4 minus r2 Offset",
      "NegativeOffset_al_r3_r4_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r3, minus, r8, Offset},
      "al r7 r3 minus r8 Offset",
      "NegativeOffset_al_r7_r3_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r14, minus, r8, Offset},
      "al r6 r14 minus r8 Offset",
      "NegativeOffset_al_r6_r14_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r10, minus, r14, Offset},
      "al r11 r10 minus r14 Offset",
      "NegativeOffset_al_r11_r10_minus_r14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r4, minus, r7, Offset},
      "al r3 r4 minus r7 Offset",
      "NegativeOffset_al_r3_r4_minus_r7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r6, minus, r0, Offset},
      "al r9 r6 minus r0 Offset",
      "NegativeOffset_al_r9_r6_minus_r0_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r3, minus, r2, Offset},
      "al r10 r3 minus r2 Offset",
      "NegativeOffset_al_r10_r3_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r5, minus, r1, Offset},
      "al r10 r5 minus r1 Offset",
      "NegativeOffset_al_r10_r5_minus_r1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r11, minus, r9, Offset},
      "al r10 r11 minus r9 Offset",
      "NegativeOffset_al_r10_r11_minus_r9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r1, minus, r8, Offset},
      "al r3 r1 minus r8 Offset",
      "NegativeOffset_al_r3_r1_minus_r8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r1, minus, r2, Offset},
      "al r6 r1 minus r2 Offset",
      "NegativeOffset_al_r6_r1_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r6, minus, r14, Offset},
      "al r7 r6 minus r14 Offset",
      "NegativeOffset_al_r7_r6_minus_r14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r9, minus, r5, Offset},
      "al r3 r9 minus r5 Offset",
      "NegativeOffset_al_r3_r9_minus_r5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r7, minus, r2, Offset},
      "al r10 r7 minus r2 Offset",
      "NegativeOffset_al_r10_r7_minus_r2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r9, minus, r7, Offset},
      "al r12 r9 minus r7 Offset",
      "NegativeOffset_al_r12_r9_minus_r7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r11, plus, r4, PostIndex},
      "al r8 r11 plus r4 PostIndex",
      "PositivePostIndex_al_r8_r11_plus_r4_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r1, plus, r2, PostIndex},
      "al r4 r1 plus r2 PostIndex",
      "PositivePostIndex_al_r4_r1_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r7, plus, r5, PostIndex},
      "al r0 r7 plus r5 PostIndex",
      "PositivePostIndex_al_r0_r7_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r6, plus, r10, PostIndex},
      "al r3 r6 plus r10 PostIndex",
      "PositivePostIndex_al_r3_r6_plus_r10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r3, plus, r6, PostIndex},
      "al r7 r3 plus r6 PostIndex",
      "PositivePostIndex_al_r7_r3_plus_r6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r0, plus, r3, PostIndex},
      "al r14 r0 plus r3 PostIndex",
      "PositivePostIndex_al_r14_r0_plus_r3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r0, plus, r2, PostIndex},
      "al r11 r0 plus r2 PostIndex",
      "PositivePostIndex_al_r11_r0_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r14, plus, r3, PostIndex},
      "al r11 r14 plus r3 PostIndex",
      "PositivePostIndex_al_r11_r14_plus_r3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r3, plus, r14, PostIndex},
      "al r10 r3 plus r14 PostIndex",
      "PositivePostIndex_al_r10_r3_plus_r14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r10, plus, r4, PostIndex},
      "al r3 r10 plus r4 PostIndex",
      "PositivePostIndex_al_r3_r10_plus_r4_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r0, plus, r11, PostIndex},
      "al r14 r0 plus r11 PostIndex",
      "PositivePostIndex_al_r14_r0_plus_r11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r1, plus, r14, PostIndex},
      "al r10 r1 plus r14 PostIndex",
      "PositivePostIndex_al_r10_r1_plus_r14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r2, plus, r10, PostIndex},
      "al r7 r2 plus r10 PostIndex",
      "PositivePostIndex_al_r7_r2_plus_r10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r11, plus, r9, PostIndex},
      "al r4 r11 plus r9 PostIndex",
      "PositivePostIndex_al_r4_r11_plus_r9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r7, plus, r8, PostIndex},
      "al r6 r7 plus r8 PostIndex",
      "PositivePostIndex_al_r6_r7_plus_r8_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r7, plus, r6, PostIndex},
      "al r3 r7 plus r6 PostIndex",
      "PositivePostIndex_al_r3_r7_plus_r6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r9, plus, r5, PostIndex},
      "al r1 r9 plus r5 PostIndex",
      "PositivePostIndex_al_r1_r9_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r10, plus, r2, PostIndex},
      "al r5 r10 plus r2 PostIndex",
      "PositivePostIndex_al_r5_r10_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r3, plus, r5, PostIndex},
      "al r9 r3 plus r5 PostIndex",
      "PositivePostIndex_al_r9_r3_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r11, plus, r14, PostIndex},
      "al r2 r11 plus r14 PostIndex",
      "PositivePostIndex_al_r2_r11_plus_r14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r5, plus, r3, PostIndex},
      "al r14 r5 plus r3 PostIndex",
      "PositivePostIndex_al_r14_r5_plus_r3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r1, plus, r4, PostIndex},
      "al r0 r1 plus r4 PostIndex",
      "PositivePostIndex_al_r0_r1_plus_r4_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r14, plus, r8, PostIndex},
      "al r5 r14 plus r8 PostIndex",
      "PositivePostIndex_al_r5_r14_plus_r8_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r1, plus, r9, PostIndex},
      "al r0 r1 plus r9 PostIndex",
      "PositivePostIndex_al_r0_r1_plus_r9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r12, plus, r5, PostIndex},
      "al r8 r12 plus r5 PostIndex",
      "PositivePostIndex_al_r8_r12_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r3, plus, r5, PostIndex},
      "al r6 r3 plus r5 PostIndex",
      "PositivePostIndex_al_r6_r3_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r10, plus, r8, PostIndex},
      "al r3 r10 plus r8 PostIndex",
      "PositivePostIndex_al_r3_r10_plus_r8_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r6, plus, r12, PostIndex},
      "al r9 r6 plus r12 PostIndex",
      "PositivePostIndex_al_r9_r6_plus_r12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r5, plus, r3, PostIndex},
      "al r10 r5 plus r3 PostIndex",
      "PositivePostIndex_al_r10_r5_plus_r3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r10, plus, r6, PostIndex},
      "al r3 r10 plus r6 PostIndex",
      "PositivePostIndex_al_r3_r10_plus_r6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r7, plus, r2, PostIndex},
      "al r4 r7 plus r2 PostIndex",
      "PositivePostIndex_al_r4_r7_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r12, plus, r5, PostIndex},
      "al r14 r12 plus r5 PostIndex",
      "PositivePostIndex_al_r14_r12_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r8, plus, r7, PostIndex},
      "al r1 r8 plus r7 PostIndex",
      "PositivePostIndex_al_r1_r8_plus_r7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r7, plus, r8, PostIndex},
      "al r5 r7 plus r8 PostIndex",
      "PositivePostIndex_al_r5_r7_plus_r8_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r6, plus, r11, PostIndex},
      "al r0 r6 plus r11 PostIndex",
      "PositivePostIndex_al_r0_r6_plus_r11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r6, plus, r7, PostIndex},
      "al r5 r6 plus r7 PostIndex",
      "PositivePostIndex_al_r5_r6_plus_r7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r2, plus, r6, PostIndex},
      "al r7 r2 plus r6 PostIndex",
      "PositivePostIndex_al_r7_r2_plus_r6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r8, plus, r5, PostIndex},
      "al r6 r8 plus r5 PostIndex",
      "PositivePostIndex_al_r6_r8_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r4, plus, r0, PostIndex},
      "al r7 r4 plus r0 PostIndex",
      "PositivePostIndex_al_r7_r4_plus_r0_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r8, plus, r3, PostIndex},
      "al r2 r8 plus r3 PostIndex",
      "PositivePostIndex_al_r2_r8_plus_r3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r2, plus, r6, PostIndex},
      "al r3 r2 plus r6 PostIndex",
      "PositivePostIndex_al_r3_r2_plus_r6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r6, plus, r2, PostIndex},
      "al r7 r6 plus r2 PostIndex",
      "PositivePostIndex_al_r7_r6_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r4, plus, r10, PostIndex},
      "al r0 r4 plus r10 PostIndex",
      "PositivePostIndex_al_r0_r4_plus_r10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r14, plus, r6, PostIndex},
      "al r9 r14 plus r6 PostIndex",
      "PositivePostIndex_al_r9_r14_plus_r6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r3, plus, r12, PostIndex},
      "al r0 r3 plus r12 PostIndex",
      "PositivePostIndex_al_r0_r3_plus_r12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r7, plus, r5, PostIndex},
      "al r8 r7 plus r5 PostIndex",
      "PositivePostIndex_al_r8_r7_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r14, plus, r2, PostIndex},
      "al r5 r14 plus r2 PostIndex",
      "PositivePostIndex_al_r5_r14_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r6, plus, r4, PostIndex},
      "al r7 r6 plus r4 PostIndex",
      "PositivePostIndex_al_r7_r6_plus_r4_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r14, plus, r12, PostIndex},
      "al r1 r14 plus r12 PostIndex",
      "PositivePostIndex_al_r1_r14_plus_r12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r1, plus, r0, PostIndex},
      "al r11 r1 plus r0 PostIndex",
      "PositivePostIndex_al_r11_r1_plus_r0_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r2, plus, r12, PostIndex},
      "al r4 r2 plus r12 PostIndex",
      "PositivePostIndex_al_r4_r2_plus_r12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r1, plus, r3, PostIndex},
      "al r0 r1 plus r3 PostIndex",
      "PositivePostIndex_al_r0_r1_plus_r3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r0, plus, r5, PostIndex},
      "al r4 r0 plus r5 PostIndex",
      "PositivePostIndex_al_r4_r0_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r4, plus, r0, PostIndex},
      "al r8 r4 plus r0 PostIndex",
      "PositivePostIndex_al_r8_r4_plus_r0_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r7, plus, r11, PostIndex},
      "al r1 r7 plus r11 PostIndex",
      "PositivePostIndex_al_r1_r7_plus_r11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r0, plus, r14, PostIndex},
      "al r9 r0 plus r14 PostIndex",
      "PositivePostIndex_al_r9_r0_plus_r14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r9, plus, r14, PostIndex},
      "al r8 r9 plus r14 PostIndex",
      "PositivePostIndex_al_r8_r9_plus_r14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r14, plus, r12, PostIndex},
      "al r10 r14 plus r12 PostIndex",
      "PositivePostIndex_al_r10_r14_plus_r12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r9, plus, r10, PostIndex},
      "al r8 r9 plus r10 PostIndex",
      "PositivePostIndex_al_r8_r9_plus_r10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r8, plus, r11, PostIndex},
      "al r14 r8 plus r11 PostIndex",
      "PositivePostIndex_al_r14_r8_plus_r11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r10, plus, r2, PostIndex},
      "al r4 r10 plus r2 PostIndex",
      "PositivePostIndex_al_r4_r10_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r8, plus, r10, PostIndex},
      "al r7 r8 plus r10 PostIndex",
      "PositivePostIndex_al_r7_r8_plus_r10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r4, plus, r7, PostIndex},
      "al r11 r4 plus r7 PostIndex",
      "PositivePostIndex_al_r11_r4_plus_r7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r6, plus, r1, PostIndex},
      "al r8 r6 plus r1 PostIndex",
      "PositivePostIndex_al_r8_r6_plus_r1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r5, plus, r12, PostIndex},
      "al r0 r5 plus r12 PostIndex",
      "PositivePostIndex_al_r0_r5_plus_r12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r11, plus, r5, PostIndex},
      "al r14 r11 plus r5 PostIndex",
      "PositivePostIndex_al_r14_r11_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r7, plus, r3, PostIndex},
      "al r12 r7 plus r3 PostIndex",
      "PositivePostIndex_al_r12_r7_plus_r3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r4, plus, r8, PostIndex},
      "al r6 r4 plus r8 PostIndex",
      "PositivePostIndex_al_r6_r4_plus_r8_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r3, plus, r2, PostIndex},
      "al r14 r3 plus r2 PostIndex",
      "PositivePostIndex_al_r14_r3_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r6, plus, r1, PostIndex},
      "al r7 r6 plus r1 PostIndex",
      "PositivePostIndex_al_r7_r6_plus_r1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r14, plus, r12, PostIndex},
      "al r7 r14 plus r12 PostIndex",
      "PositivePostIndex_al_r7_r14_plus_r12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r7, plus, r14, PostIndex},
      "al r8 r7 plus r14 PostIndex",
      "PositivePostIndex_al_r8_r7_plus_r14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r11, plus, r5, PostIndex},
      "al r3 r11 plus r5 PostIndex",
      "PositivePostIndex_al_r3_r11_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r2, plus, r9, PostIndex},
      "al r8 r2 plus r9 PostIndex",
      "PositivePostIndex_al_r8_r2_plus_r9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r2, plus, r0, PostIndex},
      "al r8 r2 plus r0 PostIndex",
      "PositivePostIndex_al_r8_r2_plus_r0_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r9, plus, r4, PostIndex},
      "al r10 r9 plus r4 PostIndex",
      "PositivePostIndex_al_r10_r9_plus_r4_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r5, plus, r9, PostIndex},
      "al r1 r5 plus r9 PostIndex",
      "PositivePostIndex_al_r1_r5_plus_r9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r7, plus, r2, PostIndex},
      "al r14 r7 plus r2 PostIndex",
      "PositivePostIndex_al_r14_r7_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r1, plus, r9, PostIndex},
      "al r2 r1 plus r9 PostIndex",
      "PositivePostIndex_al_r2_r1_plus_r9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r3, plus, r2, PostIndex},
      "al r9 r3 plus r2 PostIndex",
      "PositivePostIndex_al_r9_r3_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r7, plus, r0, PostIndex},
      "al r14 r7 plus r0 PostIndex",
      "PositivePostIndex_al_r14_r7_plus_r0_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r14, plus, r5, PostIndex},
      "al r0 r14 plus r5 PostIndex",
      "PositivePostIndex_al_r0_r14_plus_r5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r4, plus, r12, PostIndex},
      "al r7 r4 plus r12 PostIndex",
      "PositivePostIndex_al_r7_r4_plus_r12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r10, plus, r7, PostIndex},
      "al r4 r10 plus r7 PostIndex",
      "PositivePostIndex_al_r4_r10_plus_r7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r4, plus, r7, PostIndex},
      "al r10 r4 plus r7 PostIndex",
      "PositivePostIndex_al_r10_r4_plus_r7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r4, plus, r2, PostIndex},
      "al r8 r4 plus r2 PostIndex",
      "PositivePostIndex_al_r8_r4_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r3, plus, r6, PostIndex},
      "al r0 r3 plus r6 PostIndex",
      "PositivePostIndex_al_r0_r3_plus_r6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r8, plus, r11, PostIndex},
      "al r2 r8 plus r11 PostIndex",
      "PositivePostIndex_al_r2_r8_plus_r11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r9, plus, r7, PostIndex},
      "al r11 r9 plus r7 PostIndex",
      "PositivePostIndex_al_r11_r9_plus_r7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r2, plus, r10, PostIndex},
      "al r5 r2 plus r10 PostIndex",
      "PositivePostIndex_al_r5_r2_plus_r10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r12, plus, r7, PostIndex},
      "al r6 r12 plus r7 PostIndex",
      "PositivePostIndex_al_r6_r12_plus_r7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r11, plus, r0, PostIndex},
      "al r12 r11 plus r0 PostIndex",
      "PositivePostIndex_al_r12_r11_plus_r0_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r11, plus, r6, PostIndex},
      "al r5 r11 plus r6 PostIndex",
      "PositivePostIndex_al_r5_r11_plus_r6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r0, plus, r11, PostIndex},
      "al r1 r0 plus r11 PostIndex",
      "PositivePostIndex_al_r1_r0_plus_r11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r10, plus, r9, PostIndex},
      "al r12 r10 plus r9 PostIndex",
      "PositivePostIndex_al_r12_r10_plus_r9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r3, plus, r9, PostIndex},
      "al r2 r3 plus r9 PostIndex",
      "PositivePostIndex_al_r2_r3_plus_r9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r0, plus, r2, PostIndex},
      "al r3 r0 plus r2 PostIndex",
      "PositivePostIndex_al_r3_r0_plus_r2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r5, plus, r1, PostIndex},
      "al r2 r5 plus r1 PostIndex",
      "PositivePostIndex_al_r2_r5_plus_r1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r9, plus, r12, PostIndex},
      "al r2 r9 plus r12 PostIndex",
      "PositivePostIndex_al_r2_r9_plus_r12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r2, plus, r14, PostIndex},
      "al r4 r2 plus r14 PostIndex",
      "PositivePostIndex_al_r4_r2_plus_r14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r11, minus, r8, PostIndex},
      "al r12 r11 minus r8 PostIndex",
      "NegativePostIndex_al_r12_r11_minus_r8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r10, minus, r9, PostIndex},
      "al r4 r10 minus r9 PostIndex",
      "NegativePostIndex_al_r4_r10_minus_r9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r12, minus, r10, PostIndex},
      "al r9 r12 minus r10 PostIndex",
      "NegativePostIndex_al_r9_r12_minus_r10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r1, minus, r11, PostIndex},
      "al r2 r1 minus r11 PostIndex",
      "NegativePostIndex_al_r2_r1_minus_r11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r8, minus, r6, PostIndex},
      "al r14 r8 minus r6 PostIndex",
      "NegativePostIndex_al_r14_r8_minus_r6_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r2, minus, r8, PostIndex},
      "al r7 r2 minus r8 PostIndex",
      "NegativePostIndex_al_r7_r2_minus_r8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r1, minus, r8, PostIndex},
      "al r9 r1 minus r8 PostIndex",
      "NegativePostIndex_al_r9_r1_minus_r8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r6, minus, r5, PostIndex},
      "al r1 r6 minus r5 PostIndex",
      "NegativePostIndex_al_r1_r6_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r2, minus, r14, PostIndex},
      "al r6 r2 minus r14 PostIndex",
      "NegativePostIndex_al_r6_r2_minus_r14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r1, minus, r9, PostIndex},
      "al r11 r1 minus r9 PostIndex",
      "NegativePostIndex_al_r11_r1_minus_r9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r7, minus, r12, PostIndex},
      "al r9 r7 minus r12 PostIndex",
      "NegativePostIndex_al_r9_r7_minus_r12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r6, minus, r1, PostIndex},
      "al r10 r6 minus r1 PostIndex",
      "NegativePostIndex_al_r10_r6_minus_r1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r9, minus, r6, PostIndex},
      "al r4 r9 minus r6 PostIndex",
      "NegativePostIndex_al_r4_r9_minus_r6_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r4, minus, r9, PostIndex},
      "al r11 r4 minus r9 PostIndex",
      "NegativePostIndex_al_r11_r4_minus_r9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r12, minus, r0, PostIndex},
      "al r7 r12 minus r0 PostIndex",
      "NegativePostIndex_al_r7_r12_minus_r0_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r3, minus, r7, PostIndex},
      "al r10 r3 minus r7 PostIndex",
      "NegativePostIndex_al_r10_r3_minus_r7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r14, minus, r11, PostIndex},
      "al r7 r14 minus r11 PostIndex",
      "NegativePostIndex_al_r7_r14_minus_r11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r12, minus, r2, PostIndex},
      "al r6 r12 minus r2 PostIndex",
      "NegativePostIndex_al_r6_r12_minus_r2_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r7, minus, r1, PostIndex},
      "al r10 r7 minus r1 PostIndex",
      "NegativePostIndex_al_r10_r7_minus_r1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r11, minus, r0, PostIndex},
      "al r3 r11 minus r0 PostIndex",
      "NegativePostIndex_al_r3_r11_minus_r0_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r5, minus, r11, PostIndex},
      "al r4 r5 minus r11 PostIndex",
      "NegativePostIndex_al_r4_r5_minus_r11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r12, minus, r5, PostIndex},
      "al r6 r12 minus r5 PostIndex",
      "NegativePostIndex_al_r6_r12_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r11, minus, r12, PostIndex},
      "al r4 r11 minus r12 PostIndex",
      "NegativePostIndex_al_r4_r11_minus_r12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r5, minus, r4, PostIndex},
      "al r12 r5 minus r4 PostIndex",
      "NegativePostIndex_al_r12_r5_minus_r4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r10, minus, r9, PostIndex},
      "al r11 r10 minus r9 PostIndex",
      "NegativePostIndex_al_r11_r10_minus_r9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r11, minus, r2, PostIndex},
      "al r8 r11 minus r2 PostIndex",
      "NegativePostIndex_al_r8_r11_minus_r2_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r7, minus, r4, PostIndex},
      "al r6 r7 minus r4 PostIndex",
      "NegativePostIndex_al_r6_r7_minus_r4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r8, minus, r2, PostIndex},
      "al r14 r8 minus r2 PostIndex",
      "NegativePostIndex_al_r14_r8_minus_r2_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r10, minus, r12, PostIndex},
      "al r7 r10 minus r12 PostIndex",
      "NegativePostIndex_al_r7_r10_minus_r12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r5, minus, r7, PostIndex},
      "al r14 r5 minus r7 PostIndex",
      "NegativePostIndex_al_r14_r5_minus_r7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r8, minus, r2, PostIndex},
      "al r9 r8 minus r2 PostIndex",
      "NegativePostIndex_al_r9_r8_minus_r2_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r8, minus, r9, PostIndex},
      "al r10 r8 minus r9 PostIndex",
      "NegativePostIndex_al_r10_r8_minus_r9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r6, minus, r1, PostIndex},
      "al r11 r6 minus r1 PostIndex",
      "NegativePostIndex_al_r11_r6_minus_r1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r7, minus, r0, PostIndex},
      "al r3 r7 minus r0 PostIndex",
      "NegativePostIndex_al_r3_r7_minus_r0_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r12, minus, r5, PostIndex},
      "al r3 r12 minus r5 PostIndex",
      "NegativePostIndex_al_r3_r12_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r1, minus, r14, PostIndex},
      "al r12 r1 minus r14 PostIndex",
      "NegativePostIndex_al_r12_r1_minus_r14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r14, minus, r4, PostIndex},
      "al r11 r14 minus r4 PostIndex",
      "NegativePostIndex_al_r11_r14_minus_r4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r8, minus, r11, PostIndex},
      "al r7 r8 minus r11 PostIndex",
      "NegativePostIndex_al_r7_r8_minus_r11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r11, minus, r1, PostIndex},
      "al r3 r11 minus r1 PostIndex",
      "NegativePostIndex_al_r3_r11_minus_r1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r7, minus, r1, PostIndex},
      "al r12 r7 minus r1 PostIndex",
      "NegativePostIndex_al_r12_r7_minus_r1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r0, minus, r5, PostIndex},
      "al r3 r0 minus r5 PostIndex",
      "NegativePostIndex_al_r3_r0_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r1, minus, r12, PostIndex},
      "al r2 r1 minus r12 PostIndex",
      "NegativePostIndex_al_r2_r1_minus_r12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r11, minus, r0, PostIndex},
      "al r6 r11 minus r0 PostIndex",
      "NegativePostIndex_al_r6_r11_minus_r0_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r4, minus, r10, PostIndex},
      "al r9 r4 minus r10 PostIndex",
      "NegativePostIndex_al_r9_r4_minus_r10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r3, minus, r8, PostIndex},
      "al r1 r3 minus r8 PostIndex",
      "NegativePostIndex_al_r1_r3_minus_r8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r5, minus, r4, PostIndex},
      "al r2 r5 minus r4 PostIndex",
      "NegativePostIndex_al_r2_r5_minus_r4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r3, minus, r9, PostIndex},
      "al r12 r3 minus r9 PostIndex",
      "NegativePostIndex_al_r12_r3_minus_r9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r6, minus, r1, PostIndex},
      "al r14 r6 minus r1 PostIndex",
      "NegativePostIndex_al_r14_r6_minus_r1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r4, minus, r7, PostIndex},
      "al r8 r4 minus r7 PostIndex",
      "NegativePostIndex_al_r8_r4_minus_r7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r2, minus, r3, PostIndex},
      "al r14 r2 minus r3 PostIndex",
      "NegativePostIndex_al_r14_r2_minus_r3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r2, minus, r0, PostIndex},
      "al r11 r2 minus r0 PostIndex",
      "NegativePostIndex_al_r11_r2_minus_r0_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r14, minus, r5, PostIndex},
      "al r10 r14 minus r5 PostIndex",
      "NegativePostIndex_al_r10_r14_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r8, minus, r5, PostIndex},
      "al r3 r8 minus r5 PostIndex",
      "NegativePostIndex_al_r3_r8_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r1, minus, r5, PostIndex},
      "al r6 r1 minus r5 PostIndex",
      "NegativePostIndex_al_r6_r1_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r2, minus, r11, PostIndex},
      "al r1 r2 minus r11 PostIndex",
      "NegativePostIndex_al_r1_r2_minus_r11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r9, minus, r4, PostIndex},
      "al r12 r9 minus r4 PostIndex",
      "NegativePostIndex_al_r12_r9_minus_r4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r12, minus, r7, PostIndex},
      "al r14 r12 minus r7 PostIndex",
      "NegativePostIndex_al_r14_r12_minus_r7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r2, minus, r4, PostIndex},
      "al r5 r2 minus r4 PostIndex",
      "NegativePostIndex_al_r5_r2_minus_r4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r6, minus, r8, PostIndex},
      "al r2 r6 minus r8 PostIndex",
      "NegativePostIndex_al_r2_r6_minus_r8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r3, minus, r8, PostIndex},
      "al r5 r3 minus r8 PostIndex",
      "NegativePostIndex_al_r5_r3_minus_r8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r11, minus, r3, PostIndex},
      "al r6 r11 minus r3 PostIndex",
      "NegativePostIndex_al_r6_r11_minus_r3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r6, minus, r11, PostIndex},
      "al r12 r6 minus r11 PostIndex",
      "NegativePostIndex_al_r12_r6_minus_r11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r14, minus, r7, PostIndex},
      "al r8 r14 minus r7 PostIndex",
      "NegativePostIndex_al_r8_r14_minus_r7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r6, minus, r5, PostIndex},
      "al r2 r6 minus r5 PostIndex",
      "NegativePostIndex_al_r2_r6_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r5, minus, r1, PostIndex},
      "al r12 r5 minus r1 PostIndex",
      "NegativePostIndex_al_r12_r5_minus_r1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r2, minus, r9, PostIndex},
      "al r11 r2 minus r9 PostIndex",
      "NegativePostIndex_al_r11_r2_minus_r9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r4, minus, r0, PostIndex},
      "al r12 r4 minus r0 PostIndex",
      "NegativePostIndex_al_r12_r4_minus_r0_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r3, minus, r12, PostIndex},
      "al r4 r3 minus r12 PostIndex",
      "NegativePostIndex_al_r4_r3_minus_r12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r1, minus, r6, PostIndex},
      "al r14 r1 minus r6 PostIndex",
      "NegativePostIndex_al_r14_r1_minus_r6_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r4, minus, r7, PostIndex},
      "al r12 r4 minus r7 PostIndex",
      "NegativePostIndex_al_r12_r4_minus_r7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r7, minus, r3, PostIndex},
      "al r12 r7 minus r3 PostIndex",
      "NegativePostIndex_al_r12_r7_minus_r3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r0, minus, r4, PostIndex},
      "al r8 r0 minus r4 PostIndex",
      "NegativePostIndex_al_r8_r0_minus_r4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r0, minus, r5, PostIndex},
      "al r10 r0 minus r5 PostIndex",
      "NegativePostIndex_al_r10_r0_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r2, minus, r8, PostIndex},
      "al r4 r2 minus r8 PostIndex",
      "NegativePostIndex_al_r4_r2_minus_r8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r8, minus, r1, PostIndex},
      "al r7 r8 minus r1 PostIndex",
      "NegativePostIndex_al_r7_r8_minus_r1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r2, minus, r10, PostIndex},
      "al r8 r2 minus r10 PostIndex",
      "NegativePostIndex_al_r8_r2_minus_r10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r2, minus, r5, PostIndex},
      "al r11 r2 minus r5 PostIndex",
      "NegativePostIndex_al_r11_r2_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r12, minus, r14, PostIndex},
      "al r5 r12 minus r14 PostIndex",
      "NegativePostIndex_al_r5_r12_minus_r14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r1, minus, r14, PostIndex},
      "al r8 r1 minus r14 PostIndex",
      "NegativePostIndex_al_r8_r1_minus_r14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r6, minus, r8, PostIndex},
      "al r10 r6 minus r8 PostIndex",
      "NegativePostIndex_al_r10_r6_minus_r8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r4, minus, r12, PostIndex},
      "al r0 r4 minus r12 PostIndex",
      "NegativePostIndex_al_r0_r4_minus_r12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r0, minus, r11, PostIndex},
      "al r6 r0 minus r11 PostIndex",
      "NegativePostIndex_al_r6_r0_minus_r11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r7, minus, r11, PostIndex},
      "al r10 r7 minus r11 PostIndex",
      "NegativePostIndex_al_r10_r7_minus_r11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r10, minus, r5, PostIndex},
      "al r0 r10 minus r5 PostIndex",
      "NegativePostIndex_al_r0_r10_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r7, minus, r12, PostIndex},
      "al r4 r7 minus r12 PostIndex",
      "NegativePostIndex_al_r4_r7_minus_r12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r2, minus, r0, PostIndex},
      "al r8 r2 minus r0 PostIndex",
      "NegativePostIndex_al_r8_r2_minus_r0_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r11, minus, r10, PostIndex},
      "al r2 r11 minus r10 PostIndex",
      "NegativePostIndex_al_r2_r11_minus_r10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r10, minus, r5, PostIndex},
      "al r8 r10 minus r5 PostIndex",
      "NegativePostIndex_al_r8_r10_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r5, minus, r10, PostIndex},
      "al r11 r5 minus r10 PostIndex",
      "NegativePostIndex_al_r11_r5_minus_r10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r14, minus, r2, PostIndex},
      "al r9 r14 minus r2 PostIndex",
      "NegativePostIndex_al_r9_r14_minus_r2_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r12, minus, r3, PostIndex},
      "al r7 r12 minus r3 PostIndex",
      "NegativePostIndex_al_r7_r12_minus_r3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r8, minus, r6, PostIndex},
      "al r12 r8 minus r6 PostIndex",
      "NegativePostIndex_al_r12_r8_minus_r6_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r12, minus, r5, PostIndex},
      "al r9 r12 minus r5 PostIndex",
      "NegativePostIndex_al_r9_r12_minus_r5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r8, minus, r10, PostIndex},
      "al r4 r8 minus r10 PostIndex",
      "NegativePostIndex_al_r4_r8_minus_r10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r12, minus, r1, PostIndex},
      "al r10 r12 minus r1 PostIndex",
      "NegativePostIndex_al_r10_r12_minus_r1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r7, minus, r8, PostIndex},
      "al r12 r7 minus r8 PostIndex",
      "NegativePostIndex_al_r12_r7_minus_r8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r6, minus, r0, PostIndex},
      "al r8 r6 minus r0 PostIndex",
      "NegativePostIndex_al_r8_r6_minus_r0_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r3, minus, r14, PostIndex},
      "al r8 r3 minus r14 PostIndex",
      "NegativePostIndex_al_r8_r3_minus_r14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r14, minus, r3, PostIndex},
      "al r12 r14 minus r3 PostIndex",
      "NegativePostIndex_al_r12_r14_minus_r3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r2, minus, r7, PostIndex},
      "al r10 r2 minus r7 PostIndex",
      "NegativePostIndex_al_r10_r2_minus_r7_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r9, plus, r0, PreIndex},
      "al r12 r9 plus r0 PreIndex",
      "PositivePreIndex_al_r12_r9_plus_r0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r4, plus, r11, PreIndex},
      "al r0 r4 plus r11 PreIndex",
      "PositivePreIndex_al_r0_r4_plus_r11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r8, plus, r7, PreIndex},
      "al r14 r8 plus r7 PreIndex",
      "PositivePreIndex_al_r14_r8_plus_r7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r1, plus, r8, PreIndex},
      "al r2 r1 plus r8 PreIndex",
      "PositivePreIndex_al_r2_r1_plus_r8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r9, plus, r5, PreIndex},
      "al r7 r9 plus r5 PreIndex",
      "PositivePreIndex_al_r7_r9_plus_r5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r12, plus, r3, PreIndex},
      "al r11 r12 plus r3 PreIndex",
      "PositivePreIndex_al_r11_r12_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r1, plus, r6, PreIndex},
      "al r8 r1 plus r6 PreIndex",
      "PositivePreIndex_al_r8_r1_plus_r6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r10, plus, r8, PreIndex},
      "al r9 r10 plus r8 PreIndex",
      "PositivePreIndex_al_r9_r10_plus_r8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r1, plus, r0, PreIndex},
      "al r12 r1 plus r0 PreIndex",
      "PositivePreIndex_al_r12_r1_plus_r0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r7, plus, r3, PreIndex},
      "al r10 r7 plus r3 PreIndex",
      "PositivePreIndex_al_r10_r7_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r0, plus, r2, PreIndex},
      "al r9 r0 plus r2 PreIndex",
      "PositivePreIndex_al_r9_r0_plus_r2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r5, plus, r3, PreIndex},
      "al r9 r5 plus r3 PreIndex",
      "PositivePreIndex_al_r9_r5_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r0, plus, r8, PreIndex},
      "al r6 r0 plus r8 PreIndex",
      "PositivePreIndex_al_r6_r0_plus_r8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r4, plus, r8, PreIndex},
      "al r3 r4 plus r8 PreIndex",
      "PositivePreIndex_al_r3_r4_plus_r8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r7, plus, r6, PreIndex},
      "al r1 r7 plus r6 PreIndex",
      "PositivePreIndex_al_r1_r7_plus_r6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r8, plus, r7, PreIndex},
      "al r2 r8 plus r7 PreIndex",
      "PositivePreIndex_al_r2_r8_plus_r7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r11, plus, r0, PreIndex},
      "al r10 r11 plus r0 PreIndex",
      "PositivePreIndex_al_r10_r11_plus_r0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r9, plus, r11, PreIndex},
      "al r10 r9 plus r11 PreIndex",
      "PositivePreIndex_al_r10_r9_plus_r11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r7, plus, r11, PreIndex},
      "al r9 r7 plus r11 PreIndex",
      "PositivePreIndex_al_r9_r7_plus_r11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r0, plus, r7, PreIndex},
      "al r11 r0 plus r7 PreIndex",
      "PositivePreIndex_al_r11_r0_plus_r7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r0, plus, r4, PreIndex},
      "al r9 r0 plus r4 PreIndex",
      "PositivePreIndex_al_r9_r0_plus_r4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r1, plus, r3, PreIndex},
      "al r6 r1 plus r3 PreIndex",
      "PositivePreIndex_al_r6_r1_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r11, plus, r1, PreIndex},
      "al r0 r11 plus r1 PreIndex",
      "PositivePreIndex_al_r0_r11_plus_r1_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r10, plus, r7, PreIndex},
      "al r5 r10 plus r7 PreIndex",
      "PositivePreIndex_al_r5_r10_plus_r7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r2, plus, r10, PreIndex},
      "al r3 r2 plus r10 PreIndex",
      "PositivePreIndex_al_r3_r2_plus_r10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r2, plus, r0, PreIndex},
      "al r8 r2 plus r0 PreIndex",
      "PositivePreIndex_al_r8_r2_plus_r0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r0, plus, r9, PreIndex},
      "al r3 r0 plus r9 PreIndex",
      "PositivePreIndex_al_r3_r0_plus_r9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r4, plus, r7, PreIndex},
      "al r2 r4 plus r7 PreIndex",
      "PositivePreIndex_al_r2_r4_plus_r7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r1, plus, r6, PreIndex},
      "al r14 r1 plus r6 PreIndex",
      "PositivePreIndex_al_r14_r1_plus_r6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r8, plus, r14, PreIndex},
      "al r9 r8 plus r14 PreIndex",
      "PositivePreIndex_al_r9_r8_plus_r14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r5, plus, r1, PreIndex},
      "al r14 r5 plus r1 PreIndex",
      "PositivePreIndex_al_r14_r5_plus_r1_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r14, plus, r12, PreIndex},
      "al r5 r14 plus r12 PreIndex",
      "PositivePreIndex_al_r5_r14_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r8, plus, r14, PreIndex},
      "al r0 r8 plus r14 PreIndex",
      "PositivePreIndex_al_r0_r8_plus_r14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r3, plus, r10, PreIndex},
      "al r2 r3 plus r10 PreIndex",
      "PositivePreIndex_al_r2_r3_plus_r10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r10, plus, r11, PreIndex},
      "al r2 r10 plus r11 PreIndex",
      "PositivePreIndex_al_r2_r10_plus_r11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r9, plus, r14, PreIndex},
      "al r7 r9 plus r14 PreIndex",
      "PositivePreIndex_al_r7_r9_plus_r14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r10, plus, r12, PreIndex},
      "al r1 r10 plus r12 PreIndex",
      "PositivePreIndex_al_r1_r10_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r10, plus, r0, PreIndex},
      "al r1 r10 plus r0 PreIndex",
      "PositivePreIndex_al_r1_r10_plus_r0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r11, plus, r9, PreIndex},
      "al r12 r11 plus r9 PreIndex",
      "PositivePreIndex_al_r12_r11_plus_r9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r5, plus, r8, PreIndex},
      "al r0 r5 plus r8 PreIndex",
      "PositivePreIndex_al_r0_r5_plus_r8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r4, plus, r8, PreIndex},
      "al r2 r4 plus r8 PreIndex",
      "PositivePreIndex_al_r2_r4_plus_r8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r11, plus, r12, PreIndex},
      "al r14 r11 plus r12 PreIndex",
      "PositivePreIndex_al_r14_r11_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r5, plus, r3, PreIndex},
      "al r4 r5 plus r3 PreIndex",
      "PositivePreIndex_al_r4_r5_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r6, plus, r12, PreIndex},
      "al r1 r6 plus r12 PreIndex",
      "PositivePreIndex_al_r1_r6_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r8, plus, r3, PreIndex},
      "al r4 r8 plus r3 PreIndex",
      "PositivePreIndex_al_r4_r8_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r14, plus, r12, PreIndex},
      "al r0 r14 plus r12 PreIndex",
      "PositivePreIndex_al_r0_r14_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r11, plus, r9, PreIndex},
      "al r0 r11 plus r9 PreIndex",
      "PositivePreIndex_al_r0_r11_plus_r9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r10, plus, r2, PreIndex},
      "al r11 r10 plus r2 PreIndex",
      "PositivePreIndex_al_r11_r10_plus_r2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r0, plus, r12, PreIndex},
      "al r8 r0 plus r12 PreIndex",
      "PositivePreIndex_al_r8_r0_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r10, plus, r7, PreIndex},
      "al r0 r10 plus r7 PreIndex",
      "PositivePreIndex_al_r0_r10_plus_r7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r6, plus, r9, PreIndex},
      "al r2 r6 plus r9 PreIndex",
      "PositivePreIndex_al_r2_r6_plus_r9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r9, plus, r0, PreIndex},
      "al r7 r9 plus r0 PreIndex",
      "PositivePreIndex_al_r7_r9_plus_r0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r2, plus, r4, PreIndex},
      "al r11 r2 plus r4 PreIndex",
      "PositivePreIndex_al_r11_r2_plus_r4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r3, plus, r4, PreIndex},
      "al r2 r3 plus r4 PreIndex",
      "PositivePreIndex_al_r2_r3_plus_r4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r14, plus, r11, PreIndex},
      "al r0 r14 plus r11 PreIndex",
      "PositivePreIndex_al_r0_r14_plus_r11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r5, plus, r0, PreIndex},
      "al r7 r5 plus r0 PreIndex",
      "PositivePreIndex_al_r7_r5_plus_r0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r12, plus, r9, PreIndex},
      "al r6 r12 plus r9 PreIndex",
      "PositivePreIndex_al_r6_r12_plus_r9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r11, plus, r10, PreIndex},
      "al r8 r11 plus r10 PreIndex",
      "PositivePreIndex_al_r8_r11_plus_r10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r14, plus, r2, PreIndex},
      "al r5 r14 plus r2 PreIndex",
      "PositivePreIndex_al_r5_r14_plus_r2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r7, plus, r5, PreIndex},
      "al r4 r7 plus r5 PreIndex",
      "PositivePreIndex_al_r4_r7_plus_r5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r8, plus, r10, PreIndex},
      "al r14 r8 plus r10 PreIndex",
      "PositivePreIndex_al_r14_r8_plus_r10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r1, plus, r9, PreIndex},
      "al r8 r1 plus r9 PreIndex",
      "PositivePreIndex_al_r8_r1_plus_r9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r9, plus, r1, PreIndex},
      "al r4 r9 plus r1 PreIndex",
      "PositivePreIndex_al_r4_r9_plus_r1_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r5, plus, r11, PreIndex},
      "al r8 r5 plus r11 PreIndex",
      "PositivePreIndex_al_r8_r5_plus_r11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r7, plus, r5, PreIndex},
      "al r0 r7 plus r5 PreIndex",
      "PositivePreIndex_al_r0_r7_plus_r5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r3, plus, r11, PreIndex},
      "al r8 r3 plus r11 PreIndex",
      "PositivePreIndex_al_r8_r3_plus_r11_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r8, plus, r6, PreIndex},
      "al r12 r8 plus r6 PreIndex",
      "PositivePreIndex_al_r12_r8_plus_r6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r0, plus, r12, PreIndex},
      "al r5 r0 plus r12 PreIndex",
      "PositivePreIndex_al_r5_r0_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r2, plus, r8, PreIndex},
      "al r12 r2 plus r8 PreIndex",
      "PositivePreIndex_al_r12_r2_plus_r8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r4, plus, r5, PreIndex},
      "al r7 r4 plus r5 PreIndex",
      "PositivePreIndex_al_r7_r4_plus_r5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r12, plus, r3, PreIndex},
      "al r4 r12 plus r3 PreIndex",
      "PositivePreIndex_al_r4_r12_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r11, plus, r1, PreIndex},
      "al r7 r11 plus r1 PreIndex",
      "PositivePreIndex_al_r7_r11_plus_r1_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r14, plus, r3, PreIndex},
      "al r6 r14 plus r3 PreIndex",
      "PositivePreIndex_al_r6_r14_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r9, plus, r10, PreIndex},
      "al r5 r9 plus r10 PreIndex",
      "PositivePreIndex_al_r5_r9_plus_r10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r11, plus, r12, PreIndex},
      "al r6 r11 plus r12 PreIndex",
      "PositivePreIndex_al_r6_r11_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r7, plus, r4, PreIndex},
      "al r12 r7 plus r4 PreIndex",
      "PositivePreIndex_al_r12_r7_plus_r4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r10, plus, r0, PreIndex},
      "al r9 r10 plus r0 PreIndex",
      "PositivePreIndex_al_r9_r10_plus_r0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r11, plus, r10, PreIndex},
      "al r12 r11 plus r10 PreIndex",
      "PositivePreIndex_al_r12_r11_plus_r10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r11, plus, r3, PreIndex},
      "al r6 r11 plus r3 PreIndex",
      "PositivePreIndex_al_r6_r11_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r8, plus, r6, PreIndex},
      "al r9 r8 plus r6 PreIndex",
      "PositivePreIndex_al_r9_r8_plus_r6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r7, plus, r8, PreIndex},
      "al r11 r7 plus r8 PreIndex",
      "PositivePreIndex_al_r11_r7_plus_r8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r11, plus, r7, PreIndex},
      "al r2 r11 plus r7 PreIndex",
      "PositivePreIndex_al_r2_r11_plus_r7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r7, plus, r2, PreIndex},
      "al r6 r7 plus r2 PreIndex",
      "PositivePreIndex_al_r6_r7_plus_r2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r5, plus, r4, PreIndex},
      "al r8 r5 plus r4 PreIndex",
      "PositivePreIndex_al_r8_r5_plus_r4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r4, plus, r6, PreIndex},
      "al r0 r4 plus r6 PreIndex",
      "PositivePreIndex_al_r0_r4_plus_r6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r14, plus, r1, PreIndex},
      "al r11 r14 plus r1 PreIndex",
      "PositivePreIndex_al_r11_r14_plus_r1_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r3, plus, r12, PreIndex},
      "al r7 r3 plus r12 PreIndex",
      "PositivePreIndex_al_r7_r3_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r7, plus, r12, PreIndex},
      "al r4 r7 plus r12 PreIndex",
      "PositivePreIndex_al_r4_r7_plus_r12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r14, plus, r0, PreIndex},
      "al r6 r14 plus r0 PreIndex",
      "PositivePreIndex_al_r6_r14_plus_r0_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r5, plus, r7, PreIndex},
      "al r11 r5 plus r7 PreIndex",
      "PositivePreIndex_al_r11_r5_plus_r7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r14, plus, r2, PreIndex},
      "al r12 r14 plus r2 PreIndex",
      "PositivePreIndex_al_r12_r14_plus_r2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r14, plus, r2, PreIndex},
      "al r10 r14 plus r2 PreIndex",
      "PositivePreIndex_al_r10_r14_plus_r2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r2, plus, r3, PreIndex},
      "al r5 r2 plus r3 PreIndex",
      "PositivePreIndex_al_r5_r2_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r6, plus, r7, PreIndex},
      "al r8 r6 plus r7 PreIndex",
      "PositivePreIndex_al_r8_r6_plus_r7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r2, plus, r4, PreIndex},
      "al r1 r2 plus r4 PreIndex",
      "PositivePreIndex_al_r1_r2_plus_r4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r6, plus, r5, PreIndex},
      "al r2 r6 plus r5 PreIndex",
      "PositivePreIndex_al_r2_r6_plus_r5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r7, plus, r2, PreIndex},
      "al r11 r7 plus r2 PreIndex",
      "PositivePreIndex_al_r11_r7_plus_r2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r10, plus, r3, PreIndex},
      "al r4 r10 plus r3 PreIndex",
      "PositivePreIndex_al_r4_r10_plus_r3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r8, plus, r4, PreIndex},
      "al r1 r8 plus r4 PreIndex",
      "PositivePreIndex_al_r1_r8_plus_r4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r2, plus, r6, PreIndex},
      "al r14 r2 plus r6 PreIndex",
      "PositivePreIndex_al_r14_r2_plus_r6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r14, minus, r4, PreIndex},
      "al r8 r14 minus r4 PreIndex",
      "NegativePreIndex_al_r8_r14_minus_r4_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r12, minus, r8, PreIndex},
      "al r11 r12 minus r8 PreIndex",
      "NegativePreIndex_al_r11_r12_minus_r8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r3, minus, r6, PreIndex},
      "al r14 r3 minus r6 PreIndex",
      "NegativePreIndex_al_r14_r3_minus_r6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r14, minus, r12, PreIndex},
      "al r9 r14 minus r12 PreIndex",
      "NegativePreIndex_al_r9_r14_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r10, minus, r9, PreIndex},
      "al r12 r10 minus r9 PreIndex",
      "NegativePreIndex_al_r12_r10_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r3, minus, r8, PreIndex},
      "al r11 r3 minus r8 PreIndex",
      "NegativePreIndex_al_r11_r3_minus_r8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r7, minus, r2, PreIndex},
      "al r4 r7 minus r2 PreIndex",
      "NegativePreIndex_al_r4_r7_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r5, minus, r1, PreIndex},
      "al r0 r5 minus r1 PreIndex",
      "NegativePreIndex_al_r0_r5_minus_r1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r14, minus, r9, PreIndex},
      "al r8 r14 minus r9 PreIndex",
      "NegativePreIndex_al_r8_r14_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r5, minus, r6, PreIndex},
      "al r4 r5 minus r6 PreIndex",
      "NegativePreIndex_al_r4_r5_minus_r6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r5, minus, r12, PreIndex},
      "al r8 r5 minus r12 PreIndex",
      "NegativePreIndex_al_r8_r5_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r5, minus, r12, PreIndex},
      "al r1 r5 minus r12 PreIndex",
      "NegativePreIndex_al_r1_r5_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r0, minus, r10, PreIndex},
      "al r6 r0 minus r10 PreIndex",
      "NegativePreIndex_al_r6_r0_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r2, minus, r10, PreIndex},
      "al r12 r2 minus r10 PreIndex",
      "NegativePreIndex_al_r12_r2_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r8, minus, r2, PreIndex},
      "al r6 r8 minus r2 PreIndex",
      "NegativePreIndex_al_r6_r8_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r3, minus, r9, PreIndex},
      "al r7 r3 minus r9 PreIndex",
      "NegativePreIndex_al_r7_r3_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r9, minus, r10, PreIndex},
      "al r11 r9 minus r10 PreIndex",
      "NegativePreIndex_al_r11_r9_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r9, minus, r2, PreIndex},
      "al r10 r9 minus r2 PreIndex",
      "NegativePreIndex_al_r10_r9_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r1, minus, r3, PreIndex},
      "al r10 r1 minus r3 PreIndex",
      "NegativePreIndex_al_r10_r1_minus_r3_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r1, minus, r7, PreIndex},
      "al r3 r1 minus r7 PreIndex",
      "NegativePreIndex_al_r3_r1_minus_r7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r14, minus, r9, PreIndex},
      "al r11 r14 minus r9 PreIndex",
      "NegativePreIndex_al_r11_r14_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r0, minus, r6, PreIndex},
      "al r14 r0 minus r6 PreIndex",
      "NegativePreIndex_al_r14_r0_minus_r6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r3, minus, r2, PreIndex},
      "al r6 r3 minus r2 PreIndex",
      "NegativePreIndex_al_r6_r3_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r11, minus, r5, PreIndex},
      "al r9 r11 minus r5 PreIndex",
      "NegativePreIndex_al_r9_r11_minus_r5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r2, minus, r8, PreIndex},
      "al r11 r2 minus r8 PreIndex",
      "NegativePreIndex_al_r11_r2_minus_r8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r1, minus, r6, PreIndex},
      "al r8 r1 minus r6 PreIndex",
      "NegativePreIndex_al_r8_r1_minus_r6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r11, minus, r5, PreIndex},
      "al r10 r11 minus r5 PreIndex",
      "NegativePreIndex_al_r10_r11_minus_r5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r4, minus, r7, PreIndex},
      "al r12 r4 minus r7 PreIndex",
      "NegativePreIndex_al_r12_r4_minus_r7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r4, minus, r8, PreIndex},
      "al r14 r4 minus r8 PreIndex",
      "NegativePreIndex_al_r14_r4_minus_r8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r6, minus, r9, PreIndex},
      "al r3 r6 minus r9 PreIndex",
      "NegativePreIndex_al_r3_r6_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r1, minus, r0, PreIndex},
      "al r2 r1 minus r0 PreIndex",
      "NegativePreIndex_al_r2_r1_minus_r0_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r12, minus, r9, PreIndex},
      "al r3 r12 minus r9 PreIndex",
      "NegativePreIndex_al_r3_r12_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r5, minus, r6, PreIndex},
      "al r10 r5 minus r6 PreIndex",
      "NegativePreIndex_al_r10_r5_minus_r6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r2, minus, r6, PreIndex},
      "al r11 r2 minus r6 PreIndex",
      "NegativePreIndex_al_r11_r2_minus_r6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r4, minus, r10, PreIndex},
      "al r1 r4 minus r10 PreIndex",
      "NegativePreIndex_al_r1_r4_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r2, minus, r10, PreIndex},
      "al r11 r2 minus r10 PreIndex",
      "NegativePreIndex_al_r11_r2_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r12, minus, r5, PreIndex},
      "al r14 r12 minus r5 PreIndex",
      "NegativePreIndex_al_r14_r12_minus_r5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r12, minus, r5, PreIndex},
      "al r2 r12 minus r5 PreIndex",
      "NegativePreIndex_al_r2_r12_minus_r5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r3, minus, r0, PreIndex},
      "al r7 r3 minus r0 PreIndex",
      "NegativePreIndex_al_r7_r3_minus_r0_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r9, minus, r11, PreIndex},
      "al r0 r9 minus r11 PreIndex",
      "NegativePreIndex_al_r0_r9_minus_r11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r6, minus, r9, PreIndex},
      "al r0 r6 minus r9 PreIndex",
      "NegativePreIndex_al_r0_r6_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r6, minus, r0, PreIndex},
      "al r4 r6 minus r0 PreIndex",
      "NegativePreIndex_al_r4_r6_minus_r0_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r11, minus, r14, PreIndex},
      "al r12 r11 minus r14 PreIndex",
      "NegativePreIndex_al_r12_r11_minus_r14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r2, minus, r10, PreIndex},
      "al r6 r2 minus r10 PreIndex",
      "NegativePreIndex_al_r6_r2_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r4, minus, r10, PreIndex},
      "al r11 r4 minus r10 PreIndex",
      "NegativePreIndex_al_r11_r4_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r3, minus, r12, PreIndex},
      "al r5 r3 minus r12 PreIndex",
      "NegativePreIndex_al_r5_r3_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r9, minus, r3, PreIndex},
      "al r0 r9 minus r3 PreIndex",
      "NegativePreIndex_al_r0_r9_minus_r3_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r7, minus, r12, PreIndex},
      "al r4 r7 minus r12 PreIndex",
      "NegativePreIndex_al_r4_r7_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r3, minus, r14, PreIndex},
      "al r8 r3 minus r14 PreIndex",
      "NegativePreIndex_al_r8_r3_minus_r14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r12, minus, r10, PreIndex},
      "al r8 r12 minus r10 PreIndex",
      "NegativePreIndex_al_r8_r12_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r5, minus, r9, PreIndex},
      "al r6 r5 minus r9 PreIndex",
      "NegativePreIndex_al_r6_r5_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r6, minus, r14, PreIndex},
      "al r3 r6 minus r14 PreIndex",
      "NegativePreIndex_al_r3_r6_minus_r14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r8, minus, r4, PreIndex},
      "al r0 r8 minus r4 PreIndex",
      "NegativePreIndex_al_r0_r8_minus_r4_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r6, minus, r12, PreIndex},
      "al r2 r6 minus r12 PreIndex",
      "NegativePreIndex_al_r2_r6_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r12, minus, r11, PreIndex},
      "al r8 r12 minus r11 PreIndex",
      "NegativePreIndex_al_r8_r12_minus_r11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r10, minus, r11, PreIndex},
      "al r5 r10 minus r11 PreIndex",
      "NegativePreIndex_al_r5_r10_minus_r11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r5, minus, r10, PreIndex},
      "al r12 r5 minus r10 PreIndex",
      "NegativePreIndex_al_r12_r5_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r2, minus, r1, PreIndex},
      "al r10 r2 minus r1 PreIndex",
      "NegativePreIndex_al_r10_r2_minus_r1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r6, minus, r7, PreIndex},
      "al r10 r6 minus r7 PreIndex",
      "NegativePreIndex_al_r10_r6_minus_r7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r10, minus, r11, PreIndex},
      "al r14 r10 minus r11 PreIndex",
      "NegativePreIndex_al_r14_r10_minus_r11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r14, minus, r10, PreIndex},
      "al r11 r14 minus r10 PreIndex",
      "NegativePreIndex_al_r11_r14_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r7, minus, r11, PreIndex},
      "al r9 r7 minus r11 PreIndex",
      "NegativePreIndex_al_r9_r7_minus_r11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r10, minus, r6, PreIndex},
      "al r2 r10 minus r6 PreIndex",
      "NegativePreIndex_al_r2_r10_minus_r6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r5, minus, r0, PreIndex},
      "al r6 r5 minus r0 PreIndex",
      "NegativePreIndex_al_r6_r5_minus_r0_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r6, minus, r2, PreIndex},
      "al r0 r6 minus r2 PreIndex",
      "NegativePreIndex_al_r0_r6_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r6, minus, r8, PreIndex},
      "al r14 r6 minus r8 PreIndex",
      "NegativePreIndex_al_r14_r6_minus_r8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r9, minus, r2, PreIndex},
      "al r14 r9 minus r2 PreIndex",
      "NegativePreIndex_al_r14_r9_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r5, minus, r3, PreIndex},
      "al r6 r5 minus r3 PreIndex",
      "NegativePreIndex_al_r6_r5_minus_r3_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r12, minus, r7, PreIndex},
      "al r0 r12 minus r7 PreIndex",
      "NegativePreIndex_al_r0_r12_minus_r7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r3, minus, r4, PreIndex},
      "al r11 r3 minus r4 PreIndex",
      "NegativePreIndex_al_r11_r3_minus_r4_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r4, minus, r5, PreIndex},
      "al r10 r4 minus r5 PreIndex",
      "NegativePreIndex_al_r10_r4_minus_r5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r8, minus, r0, PreIndex},
      "al r1 r8 minus r0 PreIndex",
      "NegativePreIndex_al_r1_r8_minus_r0_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r14, minus, r9, PreIndex},
      "al r10 r14 minus r9 PreIndex",
      "NegativePreIndex_al_r10_r14_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r3, minus, r9, PreIndex},
      "al r12 r3 minus r9 PreIndex",
      "NegativePreIndex_al_r12_r3_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r9, minus, r10, PreIndex},
      "al r7 r9 minus r10 PreIndex",
      "NegativePreIndex_al_r7_r9_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r6, minus, r1, PreIndex},
      "al r8 r6 minus r1 PreIndex",
      "NegativePreIndex_al_r8_r6_minus_r1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r10, minus, r8, PreIndex},
      "al r12 r10 minus r8 PreIndex",
      "NegativePreIndex_al_r12_r10_minus_r8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r4, minus, r12, PreIndex},
      "al r0 r4 minus r12 PreIndex",
      "NegativePreIndex_al_r0_r4_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r10, minus, r3, PreIndex},
      "al r2 r10 minus r3 PreIndex",
      "NegativePreIndex_al_r2_r10_minus_r3_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r11, minus, r14, PreIndex},
      "al r5 r11 minus r14 PreIndex",
      "NegativePreIndex_al_r5_r11_minus_r14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r5, minus, r11, PreIndex},
      "al r7 r5 minus r11 PreIndex",
      "NegativePreIndex_al_r7_r5_minus_r11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r3, minus, r5, PreIndex},
      "al r1 r3 minus r5 PreIndex",
      "NegativePreIndex_al_r1_r3_minus_r5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r11, minus, r1, PreIndex},
      "al r6 r11 minus r1 PreIndex",
      "NegativePreIndex_al_r6_r11_minus_r1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r10, minus, r9, PreIndex},
      "al r5 r10 minus r9 PreIndex",
      "NegativePreIndex_al_r5_r10_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r12, minus, r2, PreIndex},
      "al r5 r12 minus r2 PreIndex",
      "NegativePreIndex_al_r5_r12_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r2, minus, r12, PreIndex},
      "al r4 r2 minus r12 PreIndex",
      "NegativePreIndex_al_r4_r2_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r2, minus, r12, PreIndex},
      "al r11 r2 minus r12 PreIndex",
      "NegativePreIndex_al_r11_r2_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r11, minus, r5, PreIndex},
      "al r14 r11 minus r5 PreIndex",
      "NegativePreIndex_al_r14_r11_minus_r5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r14, minus, r3, PreIndex},
      "al r11 r14 minus r3 PreIndex",
      "NegativePreIndex_al_r11_r14_minus_r3_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r5, minus, r9, PreIndex},
      "al r11 r5 minus r9 PreIndex",
      "NegativePreIndex_al_r11_r5_minus_r9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r1, minus, r14, PreIndex},
      "al r2 r1 minus r14 PreIndex",
      "NegativePreIndex_al_r2_r1_minus_r14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r7, minus, r12, PreIndex},
      "al r8 r7 minus r12 PreIndex",
      "NegativePreIndex_al_r8_r7_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r1, minus, r10, PreIndex},
      "al r5 r1 minus r10 PreIndex",
      "NegativePreIndex_al_r5_r1_minus_r10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r10, minus, r2, PreIndex},
      "al r1 r10 minus r2 PreIndex",
      "NegativePreIndex_al_r1_r10_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r3, minus, r2, PreIndex},
      "al r7 r3 minus r2 PreIndex",
      "NegativePreIndex_al_r7_r3_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r4, minus, r12, PreIndex},
      "al r9 r4 minus r12 PreIndex",
      "NegativePreIndex_al_r9_r4_minus_r12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r10, minus, r1, PreIndex},
      "al r8 r10 minus r1 PreIndex",
      "NegativePreIndex_al_r8_r10_minus_r1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r0, minus, r4, PreIndex},
      "al r5 r0 minus r4 PreIndex",
      "NegativePreIndex_al_r5_r0_minus_r4_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r2, minus, r11, PreIndex},
      "al r3 r2 minus r11 PreIndex",
      "NegativePreIndex_al_r3_r2_minus_r11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r14, minus, r2, PreIndex},
      "al r6 r14 minus r2 PreIndex",
      "NegativePreIndex_al_r6_r14_minus_r2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex}};

// We record all inputs to the instructions as outputs. This way, we also check
// that what shouldn't change didn't change.
struct TestResult {
  size_t output_size;
  const Inputs* outputs;
};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/simulator-cond-rd-memop-rs-ldr-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-ldrb-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-ldrh-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-ldrsb-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-ldrsh-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-str-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-strb-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-strh-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const MemOperand& memop);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  SETUP();
  masm.UseA32();
  START();

  // Data to compare to `reference`.
  TestResult* results[ARRAY_SIZE(kTests)];

  // Test cases for memory bound instructions may allocate a buffer and save its
  // address in this array.
  byte* scratch_memory_buffers[ARRAY_SIZE(kTests)];

  // Generate a loop for each element in `kTests`. Each loop tests one specific
  // instruction.
  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Allocate results on the heap for this test.
    results[i] = new TestResult;
    results[i]->outputs = new Inputs[kTests[i].input_size];
    results[i]->output_size = kTests[i].input_size;

    size_t input_stride = sizeof(kTests[i].inputs[0]) * kTests[i].input_size;
    VIXL_ASSERT(IsUint32(input_stride));

    scratch_memory_buffers[i] = NULL;

    Label loop;
    UseScratchRegisterScope scratch_registers(&masm);
    // Include all registers from r0 ro r12.
    scratch_registers.Include(RegisterList(0x1fff));

    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Sign sign = kTests[i].operands.sign;
    Register rm = kTests[i].operands.rm;
    AddrMode addr_mode = kTests[i].operands.addr_mode;
    MemOperand memop(rn, sign, rm, addr_mode);
    scratch_registers.Exclude(rd);
    scratch_registers.Exclude(rn);
    scratch_registers.Exclude(rm);

    // Allocate reserved registers for our own use.
    Register input_ptr = scratch_registers.Acquire();
    Register input_end = scratch_registers.Acquire();
    Register result_ptr = scratch_registers.Acquire();

    // Initialize `input_ptr` to the first element and `input_end` the address
    // after the array.
    __ Mov(input_ptr, Operand::From(kTests[i].inputs));
    __ Add(input_end, input_ptr, static_cast<uint32_t>(input_stride));
    __ Mov(result_ptr, Operand::From(results[i]->outputs));
    __ Bind(&loop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      Register saved_q_bit = temp_registers.Acquire();
      // Save the `Q` bit flag.
      __ Mrs(saved_q_bit, APSR);
      __ And(saved_q_bit, saved_q_bit, QFlag);
      // Set the `NZCV` and `Q` flags together.
      __ Ldr(nzcv_bits, MemOperand(input_ptr, offsetof(Inputs, apsr)));
      __ Orr(nzcv_bits, nzcv_bits, saved_q_bit);
      __ Msr(APSR_nzcvq, nzcv_bits);
    }
    __ Ldr(rd, MemOperand(input_ptr, offsetof(Inputs, rd)));
    __ Ldr(rm, MemOperand(input_ptr, offsetof(Inputs, rm)));
    // Allocate 4 bytes for the instruction to work with.
    scratch_memory_buffers[i] = new byte[4];
    {
      UseScratchRegisterScope temp_registers(&masm);

      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Write the expected data into the scratch buffer.
      __ Mov(base_register, Operand::From(scratch_memory_buffers[i]));
      __ Ldr(memop_tmp, MemOperand(input_ptr, offsetof(Inputs, memop) + 4));
      __ Str(memop_tmp, MemOperand(base_register));

      // Compute the address to put into the base register so that the
      // `MemOperand` points to the right location.
      // TODO: Support more kinds of `MemOperand`.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Add(base_register, base_register, memop_tmp);
          }
        }
      }
    }


    (masm.*instruction)(cond, rd, memop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      __ Mrs(nzcv_bits, APSR);
      // Only record the NZCV bits.
      __ And(nzcv_bits, nzcv_bits, NZCVFlag);
      __ Str(nzcv_bits, MemOperand(result_ptr, offsetof(Inputs, apsr)));
    }
    __ Str(rd, MemOperand(result_ptr, offsetof(Inputs, rd)));
    __ Str(rm, MemOperand(result_ptr, offsetof(Inputs, rm)));
    {
      UseScratchRegisterScope temp_registers(&masm);
      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Compute the address of the scratch buffer by from the base register. If
      // the instruction has updated the base register, we will be able to
      // record it.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Sub(base_register, base_register, memop_tmp);
          }
        }
      }

      // Record the value of the base register, as an offset from the scratch
      // buffer's address.
      __ Mov(memop_tmp, Operand::From(scratch_memory_buffers[i]));
      __ Sub(base_register, base_register, memop_tmp);
      __ Str(base_register, MemOperand(result_ptr, offsetof(Inputs, memop)));

      // Record the 32 bit word from memory.
      __ Ldr(memop_tmp, MemOperand(memop_tmp));
      __ Str(memop_tmp, MemOperand(result_ptr, offsetof(Inputs, memop) + 4));
    }


    // Advance the result pointer.
    __ Add(result_ptr, result_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    // Loop back until `input_ptr` is lower than `input_base`.
    __ Add(input_ptr, input_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    __ Cmp(input_ptr, input_end);
    __ B(ne, &loop);
  }

  END();

  RUN();

  if (Test::generate_test_trace()) {
    // Print the results.
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("const Inputs kOutputs_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (size_t j = 0; j < results[i]->output_size; j++) {
        printf("  { ");
        printf("0x%08" PRIx32, results[i]->outputs[j].apsr);
        printf(", ");
        printf("0x%08" PRIx32, results[i]->outputs[j].rd);
        printf(", ");
        printf("0x%08" PRIx32, results[i]->outputs[j].rm);
        printf(", ");
        printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
               results[i]->outputs[j].memop[0],
               results[i]->outputs[j].memop[1]);
        printf(" },\n");
      }
      printf("};\n");
    }
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kOutputs_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kOutputs_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else if (kCheckSimulatorTestResults) {
    // Check the results.
    unsigned total_error_count = 0;
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      bool instruction_has_errors = false;
      for (size_t j = 0; j < kTests[i].input_size; j++) {
        uint32_t apsr = results[i]->outputs[j].apsr;
        uint32_t rd = results[i]->outputs[j].rd;
        uint32_t rm = results[i]->outputs[j].rm;
        uint32_t memop[2] = {results[i]->outputs[j].memop[0],
                             results[i]->outputs[j].memop[1]};

        uint32_t apsr_input = kTests[i].inputs[j].apsr;
        uint32_t rd_input = kTests[i].inputs[j].rd;
        uint32_t rm_input = kTests[i].inputs[j].rm;
        uint32_t memop_input[2] = {kTests[i].inputs[j].memop[0],
                                   kTests[i].inputs[j].memop[1]};

        uint32_t apsr_ref = reference[i].outputs[j].apsr;
        uint32_t rd_ref = reference[i].outputs[j].rd;
        uint32_t rm_ref = reference[i].outputs[j].rm;
        uint32_t memop_ref[2] = {results[i]->outputs[j].memop[0],
                                 results[i]->outputs[j].memop[1]};


        if (((apsr != apsr_ref) || (rd != rd_ref) || (rm != rm_ref) ||
             ((memop[0] != memop_ref[0]) && (memop[1] != memop_ref[1]))) &&
            (++total_error_count <= kErrorReportLimit)) {
          // Print the instruction once even if it triggered multiple failures.
          if (!instruction_has_errors) {
            printf("Error(s) when testing \"%s %s\":\n",
                   mnemonic,
                   kTests[i].operands_description);
            instruction_has_errors = true;
          }
          // Print subsequent errors.
          printf("  Input:    ");
          printf("0x%08" PRIx32, apsr_input);
          printf(", ");
          printf("0x%08" PRIx32, rd_input);
          printf(", ");
          printf("0x%08" PRIx32, rm_input);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_input[0],
                 memop_input[1]);
          printf("\n");
          printf("  Expected: ");
          printf("0x%08" PRIx32, apsr_ref);
          printf(", ");
          printf("0x%08" PRIx32, rd_ref);
          printf(", ");
          printf("0x%08" PRIx32, rm_ref);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_ref[0],
                 memop_ref[1]);
          printf("\n");
          printf("  Found:    ");
          printf("0x%08" PRIx32, apsr);
          printf(", ");
          printf("0x%08" PRIx32, rd);
          printf(", ");
          printf("0x%08" PRIx32, rm);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}", memop[0], memop[1]);
          printf("\n\n");
        }
      }
    }

    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    VIXL_CHECK(total_error_count == 0);
  } else {
    VIXL_WARNING("Assembled the code, but did not run anything.\n");
  }

  for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
    delete[] results[i]->outputs;
    delete results[i];
    delete[] scratch_memory_buffers[i];
  }
}

// Instantiate tests for each instruction in the list.
// TODO: Remove this limitation by having a sandboxing mechanism.
#if defined(VIXL_HOST_POINTER_32)
#define TEST(mnemonic)                                                         \
  void Test_##mnemonic() {                                                     \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic);    \
  }                                                                            \
  Test test_##mnemonic("AARCH32_SIMULATOR_COND_RD_MEMOP_RS_" #mnemonic "_A32", \
                       &Test_##mnemonic);
#else
#define TEST(mnemonic)                                                         \
  void Test_##mnemonic() {                                                     \
    VIXL_WARNING("This test can only run on a 32-bit host.\n");                \
    USE(TestHelper);                                                           \
  }                                                                            \
  Test test_##mnemonic("AARCH32_SIMULATOR_COND_RD_MEMOP_RS_" #mnemonic "_A32", \
                       &Test_##mnemonic);
#endif

FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
