// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SABDL_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SABDL_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sabdl_4S[] = {
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x000032b4, 0x00002222, 0x00002aa8,
  0x000032b5, 0x000054d6, 0x00004cca, 0x00002aa9,
  0x000054d7, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x00005555,
  0x00007f80, 0x00007f80, 0x00003333, 0x00005554,
  0x00007f81, 0x0000007f, 0x00003332, 0x00005553,
  0x0000007e, 0x0000007e, 0x00003331, 0x00005545,
  0x0000007d, 0x0000007d, 0x00003323, 0x000054d8,
  0x0000007c, 0x0000006f, 0x000032b6, 0x000054d7,
  0x0000006e, 0x00000002, 0x000032b5, 0x000054d6,
  0x00000001, 0x00000001, 0x000032b4, 0x00002222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x000032b4, 0x00002222, 0x00002aa8,
  0x000032b5, 0x000054d6, 0x00004cca, 0x00002aa9,
  0x000054d7, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x0000d555,
  0x00007f80, 0x00007f80, 0x0000b333, 0x0000d554,
  0x00007f81, 0x0000807f, 0x0000b332, 0x0000aaab,
  0x0000807e, 0x0000807e, 0x00008889, 0x00008889,
  0x0000807d, 0x000055d5, 0x00006667, 0x000055d5,
  0x000055d4, 0x000033b3, 0x000033b3, 0x000055d4,
  0x000033b2, 0x000000ff, 0x000033b2, 0x000055d3,
  0x000000fe, 0x000000fe, 0x000033b1, 0x000055d2,
  0x000000fe, 0x000033b1, 0x000055d2, 0x0000800d,
  0x000000fd, 0x000033b0, 0x00005565, 0x00008000,
  0x000000fc, 0x00003343, 0x00005558, 0x00007fff,
  0x0000008f, 0x00003336, 0x00005557, 0x00007ffe,
  0x00000082, 0x00003335, 0x00005556, 0x00007ffd,
  0x00000081, 0x00003334, 0x00005555, 0x00007ffc,
  0x00000080, 0x00003333, 0x00005554, 0x00007ffb,
  0x0000007f, 0x00003332, 0x00005553, 0x00007fed,
  0x0000007e, 0x00003331, 0x00005545, 0x00007f80,
  0x0000007d, 0x00003323, 0x000054d8, 0x00007f7f,
  0x0000006f, 0x000032b6, 0x000054d7, 0x00007f7e,
  0x00000002, 0x000032b5, 0x000054d6, 0x00004cca,
  0x00000001, 0x000032b4, 0x00002222, 0x00002aa8,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000032b4, 0x00002222, 0x00002aa8, 0x00000001,
  0x000054d6, 0x00004cca, 0x00002aa9, 0x00000002,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0x0000fffd,
  0x00007f7f, 0x00004ccc, 0x0000d555, 0x0000fffc,
  0x00007f80, 0x0000b333, 0x0000d554, 0x0000d553,
  0x0000807f, 0x0000b332, 0x0000aaab, 0x0000b331,
  0x0000807e, 0x00008889, 0x00008889, 0x0000807d,
  0x000055d5, 0x00006667, 0x000055d5, 0x0000807c,
  0x000033b3, 0x000033b3, 0x000055d4, 0x0000807b,
  0x000000ff, 0x000033b2, 0x000055d3, 0x0000807a,
  0x000033b2, 0x000055d3, 0x0000807a, 0x0000800e,
  0x000033b1, 0x000055d2, 0x0000800d, 0x00008001,
  0x000033b0, 0x00005565, 0x00008000, 0x00008000,
  0x00003343, 0x00005558, 0x00007fff, 0x00007fff,
  0x00003336, 0x00005557, 0x00007ffe, 0x00007ffe,
  0x00003335, 0x00005556, 0x00007ffd, 0x00007ffd,
  0x00003334, 0x00005555, 0x00007ffc, 0x00007ffc,
  0x00003333, 0x00005554, 0x00007ffb, 0x00007fee,
  0x00003332, 0x00005553, 0x00007fed, 0x00007f81,
  0x00003331, 0x00005545, 0x00007f80, 0x00007f80,
  0x00003323, 0x000054d8, 0x00007f7f, 0x00007f7f,
  0x000032b6, 0x000054d7, 0x00007f7e, 0x00004ccb,
  0x000032b5, 0x000054d6, 0x00004cca, 0x00002aa9,
  0x000032b4, 0x00002222, 0x00002aa8, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002222, 0x00002aa8, 0x00000001, 0x00000001,
  0x00004cca, 0x00002aa9, 0x00000002, 0x0000fffe,
  0x00004ccb, 0x00002aaa, 0x0000fffd, 0x0000fffd,
  0x00004ccc, 0x0000d555, 0x0000fffc, 0x0000d554,
  0x0000b333, 0x0000d554, 0x0000d553, 0x0000b332,
  0x0000b332, 0x0000aaab, 0x0000b331, 0x0000807e,
  0x00008889, 0x00008889, 0x0000807d, 0x0000807d,
  0x00006667, 0x000055d5, 0x0000807c, 0x0000807c,
  0x000033b3, 0x000055d4, 0x0000807b, 0x0000807b,
  0x000055d4, 0x0000807b, 0x0000807b, 0x0000800f,
  0x000055d3, 0x0000807a, 0x0000800e, 0x00008002,
  0x000055d2, 0x0000800d, 0x00008001, 0x00008001,
  0x00005565, 0x00008000, 0x00008000, 0x00008000,
  0x00005558, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00005557, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00005556, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x00005555, 0x00007ffc, 0x00007ffc, 0x00007fef,
  0x00005554, 0x00007ffb, 0x00007fee, 0x00007f82,
  0x00005553, 0x00007fed, 0x00007f81, 0x00007f81,
  0x00005545, 0x00007f80, 0x00007f80, 0x00007f80,
  0x000054d8, 0x00007f7f, 0x00007f7f, 0x00004ccc,
  0x000054d7, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x000054d6, 0x00004cca, 0x00002aa9, 0x00000002,
  0x00002222, 0x00002aa8, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002aa8, 0x00000001, 0x00000001, 0x0000ffff,
  0x00002aa9, 0x00000002, 0x0000fffe, 0x0000fffe,
  0x00002aaa, 0x0000fffd, 0x0000fffd, 0x0000d555,
  0x0000d555, 0x0000fffc, 0x0000d554, 0x0000b333,
  0x0000d554, 0x0000d553, 0x0000b332, 0x0000807f,
  0x0000aaab, 0x0000b331, 0x0000807e, 0x0000807e,
  0x00008889, 0x0000807d, 0x0000807d, 0x0000807d,
  0x000055d5, 0x0000807c, 0x0000807c, 0x0000807c,
  0x0000807c, 0x0000807c, 0x0000807c, 0x00000010,
  0x0000807b, 0x0000807b, 0x0000800f, 0x00000003,
  0x0000807a, 0x0000800e, 0x00008002, 0x00000002,
  0x0000800d, 0x00008001, 0x00008001, 0x00000001,
  0x00008000, 0x00008000, 0x00008000, 0x00000000,
  0x00007fff, 0x00007fff, 0x00007fff, 0x00000001,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0x00000002,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0x00000010,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0x0000007d,
  0x00007ffb, 0x00007fee, 0x00007f82, 0x0000007e,
  0x00007fed, 0x00007f81, 0x00007f81, 0x0000007f,
  0x00007f80, 0x00007f80, 0x00007f80, 0x00003333,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x00005555,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0x00007ffd,
  0x00004cca, 0x00002aa9, 0x00000002, 0x00007ffe,
  0x00002aa8, 0x00000001, 0x00000001, 0x00007fff,
  0x00000000, 0x00000000, 0x00000000, 0x00008000,
  0x00000001, 0x00000001, 0x0000ffff, 0x00007fff,
  0x00000002, 0x0000fffe, 0x0000fffe, 0x00005556,
  0x0000fffd, 0x0000fffd, 0x0000d555, 0x00003334,
  0x0000fffc, 0x0000d554, 0x0000b333, 0x00000080,
  0x0000d553, 0x0000b332, 0x0000807f, 0x0000007f,
  0x0000b331, 0x0000807e, 0x0000807e, 0x0000007e,
  0x0000807d, 0x0000807d, 0x0000807d, 0x0000007d,
  0x0000807d, 0x0000807d, 0x0000007d, 0x00000011,
  0x0000807c, 0x0000807c, 0x00000010, 0x00000004,
  0x0000807b, 0x0000800f, 0x00000003, 0x00000003,
  0x0000800e, 0x00008002, 0x00000002, 0x00000002,
  0x00008001, 0x00008001, 0x00000001, 0x00000001,
  0x00008000, 0x00008000, 0x00000000, 0x00000000,
  0x00007fff, 0x00007fff, 0x00000001, 0x00000001,
  0x00007ffe, 0x00007ffe, 0x00000002, 0x0000000f,
  0x00007ffd, 0x00007ffd, 0x00000010, 0x0000007c,
  0x00007ffc, 0x00007fef, 0x0000007d, 0x0000007d,
  0x00007fee, 0x00007f82, 0x0000007e, 0x0000007e,
  0x00007f81, 0x00007f81, 0x0000007f, 0x00003332,
  0x00007f80, 0x00007f80, 0x00003333, 0x00005554,
  0x00007f7f, 0x00004ccc, 0x00005555, 0x00007ffc,
  0x00004ccb, 0x00002aaa, 0x00007ffd, 0x00007ffd,
  0x00002aa9, 0x00000002, 0x00007ffe, 0x00007ffe,
  0x00000001, 0x00000001, 0x00007fff, 0x00008001,
  0x00000000, 0x00000000, 0x00008000, 0x00008000,
  0x00000001, 0x0000ffff, 0x00007fff, 0x00005557,
  0x0000fffe, 0x0000fffe, 0x00005556, 0x00003335,
  0x0000fffd, 0x0000d555, 0x00003334, 0x00000081,
  0x0000d554, 0x0000b333, 0x00000080, 0x00000080,
  0x0000b332, 0x0000807f, 0x0000007f, 0x0000007f,
  0x0000807e, 0x0000807e, 0x0000007e, 0x0000007e,
  0x0000807e, 0x0000007e, 0x0000007e, 0x00000012,
  0x0000807d, 0x0000007d, 0x00000011, 0x00000005,
  0x0000807c, 0x00000010, 0x00000004, 0x00000004,
  0x0000800f, 0x00000003, 0x00000003, 0x00000003,
  0x00008002, 0x00000002, 0x00000002, 0x00000002,
  0x00008001, 0x00000001, 0x00000001, 0x00000001,
  0x00008000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0x00000001, 0x00000001, 0x0000000e,
  0x00007ffe, 0x00000002, 0x0000000f, 0x0000007b,
  0x00007ffd, 0x00000010, 0x0000007c, 0x0000007c,
  0x00007fef, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00007f82, 0x0000007e, 0x0000007e, 0x00003331,
  0x00007f81, 0x0000007f, 0x00003332, 0x00005553,
  0x00007f80, 0x00003333, 0x00005554, 0x00007ffb,
  0x00004ccc, 0x00005555, 0x00007ffc, 0x00007ffc,
  0x00002aaa, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x00000002, 0x00007ffe, 0x00007ffe, 0x00008002,
  0x00000001, 0x00007fff, 0x00008001, 0x00008001,
  0x00000000, 0x00008000, 0x00008000, 0x00005558,
  0x0000ffff, 0x00007fff, 0x00005557, 0x00003336,
  0x0000fffe, 0x00005556, 0x00003335, 0x00000082,
  0x0000d555, 0x00003334, 0x00000081, 0x00000081,
  0x0000b333, 0x00000080, 0x00000080, 0x00000080,
  0x0000807f, 0x0000007f, 0x0000007f, 0x0000007f,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000020,
  0x0000007e, 0x0000007e, 0x00000012, 0x00000013,
  0x0000007d, 0x00000011, 0x00000005, 0x00000012,
  0x00000010, 0x00000004, 0x00000004, 0x00000011,
  0x00000003, 0x00000003, 0x00000003, 0x00000010,
  0x00000002, 0x00000002, 0x00000002, 0x0000000f,
  0x00000001, 0x00000001, 0x00000001, 0x0000000e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x0000000e, 0x0000006d,
  0x00000002, 0x0000000f, 0x0000007b, 0x0000006e,
  0x00000010, 0x0000007c, 0x0000007c, 0x0000006f,
  0x0000007d, 0x0000007d, 0x0000007d, 0x00003323,
  0x0000007e, 0x0000007e, 0x00003331, 0x00005545,
  0x0000007f, 0x00003332, 0x00005553, 0x00007fed,
  0x00003333, 0x00005554, 0x00007ffb, 0x00007fee,
  0x00005555, 0x00007ffc, 0x00007ffc, 0x00007fef,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0x00008010,
  0x00007ffe, 0x00007ffe, 0x00008002, 0x0000800f,
  0x00007fff, 0x00008001, 0x00008001, 0x00005566,
  0x00008000, 0x00008000, 0x00005558, 0x00003344,
  0x00007fff, 0x00005557, 0x00003336, 0x00000090,
  0x00005556, 0x00003335, 0x00000082, 0x0000008f,
  0x00003334, 0x00000081, 0x00000081, 0x0000008e,
  0x00000080, 0x00000080, 0x00000080, 0x0000008d,
  0x00000080, 0x00000080, 0x0000008d, 0x0000008d,
  0x0000007f, 0x0000007f, 0x00000020, 0x00000080,
  0x0000007e, 0x00000012, 0x00000013, 0x0000007f,
  0x00000011, 0x00000005, 0x00000012, 0x0000007e,
  0x00000004, 0x00000004, 0x00000011, 0x0000007d,
  0x00000003, 0x00000003, 0x00000010, 0x0000007c,
  0x00000002, 0x00000002, 0x0000000f, 0x0000007b,
  0x00000001, 0x00000001, 0x0000000e, 0x0000006d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x0000000e, 0x0000006d, 0x00000001,
  0x0000000f, 0x0000007b, 0x0000006e, 0x00000002,
  0x0000007c, 0x0000007c, 0x0000006f, 0x000032b6,
  0x0000007d, 0x0000007d, 0x00003323, 0x000054d8,
  0x0000007e, 0x00003331, 0x00005545, 0x00007f80,
  0x00003332, 0x00005553, 0x00007fed, 0x00007f81,
  0x00005554, 0x00007ffb, 0x00007fee, 0x00007f82,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0x0000807d,
  0x00007ffd, 0x00007ffd, 0x00008010, 0x0000807c,
  0x00007ffe, 0x00008002, 0x0000800f, 0x000055d3,
  0x00008001, 0x00008001, 0x00005566, 0x000033b1,
  0x00008000, 0x00005558, 0x00003344, 0x000000fd,
  0x00005557, 0x00003336, 0x00000090, 0x000000fc,
  0x00003335, 0x00000082, 0x0000008f, 0x000000fb,
  0x00000081, 0x00000081, 0x0000008e, 0x000000fa,
  0x00000081, 0x0000008e, 0x000000fa, 0x0000008e,
  0x00000080, 0x0000008d, 0x0000008d, 0x00000081,
  0x0000007f, 0x00000020, 0x00000080, 0x00000080,
  0x00000012, 0x00000013, 0x0000007f, 0x0000007f,
  0x00000005, 0x00000012, 0x0000007e, 0x0000007e,
  0x00000004, 0x00000011, 0x0000007d, 0x0000007d,
  0x00000003, 0x00000010, 0x0000007c, 0x0000007c,
  0x00000002, 0x0000000f, 0x0000007b, 0x0000006e,
  0x00000001, 0x0000000e, 0x0000006d, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000000e, 0x0000006d, 0x00000001, 0x00000001,
  0x0000007b, 0x0000006e, 0x00000002, 0x000032b5,
  0x0000007c, 0x0000006f, 0x000032b6, 0x000054d7,
  0x0000007d, 0x00003323, 0x000054d8, 0x00007f7f,
  0x00003331, 0x00005545, 0x00007f80, 0x00007f80,
  0x00005553, 0x00007fed, 0x00007f81, 0x00007f81,
  0x00007ffb, 0x00007fee, 0x00007f82, 0x0000807e,
  0x00007ffc, 0x00007fef, 0x0000807d, 0x0000807d,
  0x00007ffd, 0x00008010, 0x0000807c, 0x000055d4,
  0x00008002, 0x0000800f, 0x000055d3, 0x000033b2,
  0x00008001, 0x00005566, 0x000033b1, 0x000000fe,
  0x00005558, 0x00003344, 0x000000fd, 0x000000fd,
  0x00003336, 0x00000090, 0x000000fc, 0x000000fc,
  0x00000082, 0x0000008f, 0x000000fb, 0x000000fb,
  0x0000008f, 0x000000fb, 0x000000fb, 0x0000008f,
  0x0000008e, 0x000000fa, 0x0000008e, 0x00000082,
  0x0000008d, 0x0000008d, 0x00000081, 0x00000081,
  0x00000020, 0x00000080, 0x00000080, 0x00000080,
  0x00000013, 0x0000007f, 0x0000007f, 0x0000007f,
  0x00000012, 0x0000007e, 0x0000007e, 0x0000007e,
  0x00000011, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00000010, 0x0000007c, 0x0000007c, 0x0000006f,
  0x0000000f, 0x0000007b, 0x0000006e, 0x00000002,
  0x0000000e, 0x0000006d, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000006d, 0x00000001, 0x00000001, 0x000032b4,
  0x0000006e, 0x00000002, 0x000032b5, 0x000054d6,
  0x0000006f, 0x000032b6, 0x000054d7, 0x00007f7e,
  0x00003323, 0x000054d8, 0x00007f7f, 0x00007f7f,
  0x00005545, 0x00007f80, 0x00007f80, 0x00007f80,
  0x00007fed, 0x00007f81, 0x00007f81, 0x0000807f,
  0x00007fee, 0x00007f82, 0x0000807e, 0x0000807e,
  0x00007fef, 0x0000807d, 0x0000807d, 0x000055d5,
  0x00008010, 0x0000807c, 0x000055d4, 0x000033b3,
  0x0000800f, 0x000055d3, 0x000033b2, 0x000000ff,
  0x00005566, 0x000033b1, 0x000000fe, 0x000000fe,
  0x00003344, 0x000000fd, 0x000000fd, 0x000000fd,
  0x00000090, 0x000000fc, 0x000000fc, 0x000000fc,
  0x000000fc, 0x000000fc, 0x000000fc, 0x00003343,
  0x000000fb, 0x000000fb, 0x0000008f, 0x00003336,
  0x000000fa, 0x0000008e, 0x00000082, 0x00003335,
  0x0000008d, 0x00000081, 0x00000081, 0x00003334,
  0x00000080, 0x00000080, 0x00000080, 0x00003333,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00003332,
  0x0000007e, 0x0000007e, 0x0000007e, 0x00003331,
  0x0000007d, 0x0000007d, 0x0000007d, 0x00003323,
  0x0000007c, 0x0000007c, 0x0000006f, 0x000032b6,
  0x0000007b, 0x0000006e, 0x00000002, 0x000032b5,
  0x0000006d, 0x00000001, 0x00000001, 0x000032b4,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x000032b4, 0x00002222,
  0x00000002, 0x000032b5, 0x000054d6, 0x00004cca,
  0x000032b6, 0x000054d7, 0x00007f7e, 0x00004ccb,
  0x000054d8, 0x00007f7f, 0x00007f7f, 0x00004ccc,
  0x00007f80, 0x00007f80, 0x00007f80, 0x0000b333,
  0x00007f81, 0x00007f81, 0x0000807f, 0x0000b332,
  0x00007f82, 0x0000807e, 0x0000807e, 0x00008889,
  0x0000807d, 0x0000807d, 0x000055d5, 0x00006667,
  0x0000807c, 0x000055d4, 0x000033b3, 0x000033b3,
  0x000055d3, 0x000033b2, 0x000000ff, 0x000033b2,
  0x000033b1, 0x000000fe, 0x000000fe, 0x000033b1,
  0x000000fd, 0x000000fd, 0x000000fd, 0x000033b0,
  0x000000fd, 0x000000fd, 0x000033b0, 0x00005565,
  0x000000fc, 0x000000fc, 0x00003343, 0x00005558,
  0x000000fb, 0x0000008f, 0x00003336, 0x00005557,
  0x0000008e, 0x00000082, 0x00003335, 0x00005556,
  0x00000081, 0x00000081, 0x00003334, 0x00005555,
  0x00000080, 0x00000080, 0x00003333, 0x00005554,
  0x0000007f, 0x0000007f, 0x00003332, 0x00005553,
  0x0000007e, 0x0000007e, 0x00003331, 0x00005545,
  0x0000007d, 0x0000007d, 0x00003323, 0x000054d8,
  0x0000007c, 0x0000006f, 0x000032b6, 0x000054d7,
  0x0000006e, 0x00000002, 0x000032b5, 0x000054d6,
  0x00000001, 0x00000001, 0x000032b4, 0x00002222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x000032b4, 0x00002222, 0x00002aa8,
  0x000032b5, 0x000054d6, 0x00004cca, 0x00002aa9,
  0x000054d7, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x0000d555,
  0x00007f80, 0x00007f80, 0x0000b333, 0x0000d554,
  0x00007f81, 0x0000807f, 0x0000b332, 0x0000aaab,
  0x0000807e, 0x0000807e, 0x00008889, 0x00008889,
  0x0000807d, 0x000055d5, 0x00006667, 0x000055d5,
  0x000055d4, 0x000033b3, 0x000033b3, 0x000055d4,
  0x000033b2, 0x000000ff, 0x000033b2, 0x000055d3,
  0x000000fe, 0x000000fe, 0x000033b1, 0x000055d2,
  0x000000fe, 0x000033b1, 0x000055d2, 0x0000800d,
  0x000000fd, 0x000033b0, 0x00005565, 0x00008000,
  0x000000fc, 0x00003343, 0x00005558, 0x00007fff,
  0x0000008f, 0x00003336, 0x00005557, 0x00007ffe,
  0x00000082, 0x00003335, 0x00005556, 0x00007ffd,
  0x00000081, 0x00003334, 0x00005555, 0x00007ffc,
  0x00000080, 0x00003333, 0x00005554, 0x00007ffb,
  0x0000007f, 0x00003332, 0x00005553, 0x00007fed,
  0x0000007e, 0x00003331, 0x00005545, 0x00007f80,
  0x0000007d, 0x00003323, 0x000054d8, 0x00007f7f,
  0x0000006f, 0x000032b6, 0x000054d7, 0x00007f7e,
  0x00000002, 0x000032b5, 0x000054d6, 0x00004cca,
  0x00000001, 0x000032b4, 0x00002222, 0x00002aa8,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000032b4, 0x00002222, 0x00002aa8, 0x00000001,
  0x000054d6, 0x00004cca, 0x00002aa9, 0x00000002,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0x0000fffd,
  0x00007f7f, 0x00004ccc, 0x0000d555, 0x0000fffc,
  0x00007f80, 0x0000b333, 0x0000d554, 0x0000d553,
  0x0000807f, 0x0000b332, 0x0000aaab, 0x0000b331,
  0x0000807e, 0x00008889, 0x00008889, 0x0000807d,
  0x000055d5, 0x00006667, 0x000055d5, 0x0000807c,
  0x000033b3, 0x000033b3, 0x000055d4, 0x0000807b,
  0x000000ff, 0x000033b2, 0x000055d3, 0x0000807a,
  0x000033b2, 0x000055d3, 0x0000807a, 0x0000800e,
  0x000033b1, 0x000055d2, 0x0000800d, 0x00008001,
  0x000033b0, 0x00005565, 0x00008000, 0x00008000,
  0x00003343, 0x00005558, 0x00007fff, 0x00007fff,
  0x00003336, 0x00005557, 0x00007ffe, 0x00007ffe,
  0x00003335, 0x00005556, 0x00007ffd, 0x00007ffd,
  0x00003334, 0x00005555, 0x00007ffc, 0x00007ffc,
  0x00003333, 0x00005554, 0x00007ffb, 0x00007fee,
  0x00003332, 0x00005553, 0x00007fed, 0x00007f81,
  0x00003331, 0x00005545, 0x00007f80, 0x00007f80,
  0x00003323, 0x000054d8, 0x00007f7f, 0x00007f7f,
  0x000032b6, 0x000054d7, 0x00007f7e, 0x00004ccb,
  0x000032b5, 0x000054d6, 0x00004cca, 0x00002aa9,
  0x000032b4, 0x00002222, 0x00002aa8, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002222, 0x00002aa8, 0x00000001, 0x00000001,
  0x00004cca, 0x00002aa9, 0x00000002, 0x0000fffe,
  0x00004ccb, 0x00002aaa, 0x0000fffd, 0x0000fffd,
  0x00004ccc, 0x0000d555, 0x0000fffc, 0x0000d554,
  0x0000b333, 0x0000d554, 0x0000d553, 0x0000b332,
  0x0000b332, 0x0000aaab, 0x0000b331, 0x0000807e,
  0x00008889, 0x00008889, 0x0000807d, 0x0000807d,
  0x00006667, 0x000055d5, 0x0000807c, 0x0000807c,
  0x000033b3, 0x000055d4, 0x0000807b, 0x0000807b,
  0x000055d4, 0x0000807b, 0x0000807b, 0x0000800f,
  0x000055d3, 0x0000807a, 0x0000800e, 0x00008002,
  0x000055d2, 0x0000800d, 0x00008001, 0x00008001,
  0x00005565, 0x00008000, 0x00008000, 0x00008000,
  0x00005558, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00005557, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00005556, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x00005555, 0x00007ffc, 0x00007ffc, 0x00007fef,
  0x00005554, 0x00007ffb, 0x00007fee, 0x00007f82,
  0x00005553, 0x00007fed, 0x00007f81, 0x00007f81,
  0x00005545, 0x00007f80, 0x00007f80, 0x00007f80,
  0x000054d8, 0x00007f7f, 0x00007f7f, 0x00004ccc,
  0x000054d7, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x000054d6, 0x00004cca, 0x00002aa9, 0x00000002,
  0x00002222, 0x00002aa8, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002aa8, 0x00000001, 0x00000001, 0x0000ffff,
  0x00002aa9, 0x00000002, 0x0000fffe, 0x0000fffe,
  0x00002aaa, 0x0000fffd, 0x0000fffd, 0x0000d555,
  0x0000d555, 0x0000fffc, 0x0000d554, 0x0000b333,
  0x0000d554, 0x0000d553, 0x0000b332, 0x0000807f,
  0x0000aaab, 0x0000b331, 0x0000807e, 0x0000807e,
  0x00008889, 0x0000807d, 0x0000807d, 0x0000807d,
  0x000055d5, 0x0000807c, 0x0000807c, 0x0000807c,
  0x0000807c, 0x0000807c, 0x0000807c, 0x00007ff0,
  0x0000807b, 0x0000807b, 0x0000800f, 0x00007ffd,
  0x0000807a, 0x0000800e, 0x00008002, 0x00007ffe,
  0x0000800d, 0x00008001, 0x00008001, 0x00007fff,
  0x00008000, 0x00008000, 0x00008000, 0x00008000,
  0x00007fff, 0x00007fff, 0x00007fff, 0x00008001,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0x00008002,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0x00008010,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0x0000807d,
  0x00007ffb, 0x00007fee, 0x00007f82, 0x0000807e,
  0x00007fed, 0x00007f81, 0x00007f81, 0x0000807f,
  0x00007f80, 0x00007f80, 0x00007f80, 0x0000b333,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x0000d555,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0x0000fffd,
  0x00004cca, 0x00002aa9, 0x00000002, 0x0000fffe,
  0x00002aa8, 0x00000001, 0x00000001, 0x0000ffff,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x0000ffff, 0x00000001,
  0x00000002, 0x0000fffe, 0x0000fffe, 0x00002aaa,
  0x0000fffd, 0x0000fffd, 0x0000d555, 0x00004ccc,
  0x0000fffc, 0x0000d554, 0x0000b333, 0x00007f80,
  0x0000d553, 0x0000b332, 0x0000807f, 0x00007f81,
  0x0000b331, 0x0000807e, 0x0000807e, 0x00007f82,
  0x0000807d, 0x0000807d, 0x0000807d, 0x00007f83,
  0x0000807d, 0x0000807d, 0x00007f83, 0x00007fef,
  0x0000807c, 0x0000807c, 0x00007ff0, 0x00007ffc,
  0x0000807b, 0x0000800f, 0x00007ffd, 0x00007ffd,
  0x0000800e, 0x00008002, 0x00007ffe, 0x00007ffe,
  0x00008001, 0x00008001, 0x00007fff, 0x00007fff,
  0x00008000, 0x00008000, 0x00008000, 0x00008000,
  0x00007fff, 0x00007fff, 0x00008001, 0x00008001,
  0x00007ffe, 0x00007ffe, 0x00008002, 0x0000800f,
  0x00007ffd, 0x00007ffd, 0x00008010, 0x0000807c,
  0x00007ffc, 0x00007fef, 0x0000807d, 0x0000807d,
  0x00007fee, 0x00007f82, 0x0000807e, 0x0000807e,
  0x00007f81, 0x00007f81, 0x0000807f, 0x0000b332,
  0x00007f80, 0x00007f80, 0x0000b333, 0x0000d554,
  0x00007f7f, 0x00004ccc, 0x0000d555, 0x0000fffc,
  0x00004ccb, 0x00002aaa, 0x0000fffd, 0x0000fffd,
  0x00002aa9, 0x00000002, 0x0000fffe, 0x0000fffe,
  0x00000001, 0x00000001, 0x0000ffff, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x0000ffff, 0x00000001, 0x00002aa9,
  0x0000fffe, 0x0000fffe, 0x00002aaa, 0x00004ccb,
  0x0000fffd, 0x0000d555, 0x00004ccc, 0x00007f7f,
  0x0000d554, 0x0000b333, 0x00007f80, 0x00007f80,
  0x0000b332, 0x0000807f, 0x00007f81, 0x00007f81,
  0x0000807e, 0x0000807e, 0x00007f82, 0x00007f82,
  0x0000807e, 0x00007f82, 0x00007f82, 0x00005546,
  0x0000807d, 0x00007f83, 0x00007fef, 0x00005553,
  0x0000807c, 0x00007ff0, 0x00007ffc, 0x00005554,
  0x0000800f, 0x00007ffd, 0x00007ffd, 0x00005555,
  0x00008002, 0x00007ffe, 0x00007ffe, 0x00005556,
  0x00008001, 0x00007fff, 0x00007fff, 0x00005557,
  0x00008000, 0x00008000, 0x00008000, 0x00005558,
  0x00007fff, 0x00008001, 0x00008001, 0x00005566,
  0x00007ffe, 0x00008002, 0x0000800f, 0x000055d3,
  0x00007ffd, 0x00008010, 0x0000807c, 0x000055d4,
  0x00007fef, 0x0000807d, 0x0000807d, 0x000055d5,
  0x00007f82, 0x0000807e, 0x0000807e, 0x00008889,
  0x00007f81, 0x0000807f, 0x0000b332, 0x0000aaab,
  0x00007f80, 0x0000b333, 0x0000d554, 0x0000d553,
  0x00004ccc, 0x0000d555, 0x0000fffc, 0x0000d554,
  0x00002aaa, 0x0000fffd, 0x0000fffd, 0x0000d555,
  0x00000002, 0x0000fffe, 0x0000fffe, 0x00002aaa,
  0x00000001, 0x0000ffff, 0x00000001, 0x00002aa9,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000ffff, 0x00000001, 0x00002aa9, 0x00002222,
  0x0000fffe, 0x00002aaa, 0x00004ccb, 0x000054d6,
  0x0000d555, 0x00004ccc, 0x00007f7f, 0x000054d7,
  0x0000b333, 0x00007f80, 0x00007f80, 0x000054d8,
  0x0000807f, 0x00007f81, 0x00007f81, 0x000054d9,
  0x00007f81, 0x00007f81, 0x000054d9, 0x00003324,
  0x00007f82, 0x00007f82, 0x00005546, 0x00003331,
  0x00007f83, 0x00007fef, 0x00005553, 0x00003332,
  0x00007ff0, 0x00007ffc, 0x00005554, 0x00003333,
  0x00007ffd, 0x00007ffd, 0x00005555, 0x00003334,
  0x00007ffe, 0x00007ffe, 0x00005556, 0x00003335,
  0x00007fff, 0x00007fff, 0x00005557, 0x00003336,
  0x00008000, 0x00008000, 0x00005558, 0x00003344,
  0x00008001, 0x00008001, 0x00005566, 0x000033b1,
  0x00008002, 0x0000800f, 0x000055d3, 0x000033b2,
  0x00008010, 0x0000807c, 0x000055d4, 0x000033b3,
  0x0000807d, 0x0000807d, 0x000055d5, 0x00006667,
  0x0000807e, 0x0000807e, 0x00008889, 0x00008889,
  0x0000807f, 0x0000b332, 0x0000aaab, 0x0000b331,
  0x0000b333, 0x0000d554, 0x0000d553, 0x0000b332,
  0x0000d555, 0x0000fffc, 0x0000d554, 0x0000b333,
  0x0000fffd, 0x0000fffd, 0x0000d555, 0x00004ccc,
  0x0000fffe, 0x0000fffe, 0x00002aaa, 0x00004ccb,
  0x0000ffff, 0x00000001, 0x00002aa9, 0x00002222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00002aa9, 0x00002222, 0x000032b4,
  0x00002aaa, 0x00004ccb, 0x000054d6, 0x000032b5,
  0x00004ccc, 0x00007f7f, 0x000054d7, 0x000032b6,
  0x00007f80, 0x00007f80, 0x000054d8, 0x000032b7,
  0x00007f80, 0x000054d8, 0x000032b7, 0x00000070,
  0x00007f81, 0x000054d9, 0x00003324, 0x0000007d,
  0x00007f82, 0x00005546, 0x00003331, 0x0000007e,
  0x00007fef, 0x00005553, 0x00003332, 0x0000007f,
  0x00007ffc, 0x00005554, 0x00003333, 0x00000080,
  0x00007ffd, 0x00005555, 0x00003334, 0x00000081,
  0x00007ffe, 0x00005556, 0x00003335, 0x00000082,
  0x00007fff, 0x00005557, 0x00003336, 0x00000090,
  0x00008000, 0x00005558, 0x00003344, 0x000000fd,
  0x00008001, 0x00005566, 0x000033b1, 0x000000fe,
  0x0000800f, 0x000055d3, 0x000033b2, 0x000000ff,
  0x0000807c, 0x000055d4, 0x000033b3, 0x000033b3,
  0x0000807d, 0x000055d5, 0x00006667, 0x000055d5,
  0x0000807e, 0x00008889, 0x00008889, 0x0000807d,
  0x0000b332, 0x0000aaab, 0x0000b331, 0x0000807e,
  0x0000d554, 0x0000d553, 0x0000b332, 0x0000807f,
  0x0000fffc, 0x0000d554, 0x0000b333, 0x00007f80,
  0x0000fffd, 0x0000d555, 0x00004ccc, 0x00007f7f,
  0x0000fffe, 0x00002aaa, 0x00004ccb, 0x000054d6,
  0x00000001, 0x00002aa9, 0x00002222, 0x000032b4,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002aa9, 0x00002222, 0x000032b4, 0x00000001,
  0x00004ccb, 0x000054d6, 0x000032b5, 0x00000002,
  0x00007f7f, 0x000054d7, 0x000032b6, 0x00000003,
  0x000054d7, 0x000032b6, 0x00000003, 0x0000006f,
  0x000054d8, 0x000032b7, 0x00000070, 0x0000007c,
  0x000054d9, 0x00003324, 0x0000007d, 0x0000007d,
  0x00005546, 0x00003331, 0x0000007e, 0x0000007e,
  0x00005553, 0x00003332, 0x0000007f, 0x0000007f,
  0x00005554, 0x00003333, 0x00000080, 0x00000080,
  0x00005555, 0x00003334, 0x00000081, 0x00000081,
  0x00005556, 0x00003335, 0x00000082, 0x0000008f,
  0x00005557, 0x00003336, 0x00000090, 0x000000fc,
  0x00005558, 0x00003344, 0x000000fd, 0x000000fd,
  0x00005566, 0x000033b1, 0x000000fe, 0x000000fe,
  0x000055d3, 0x000033b2, 0x000000ff, 0x000033b2,
  0x000055d4, 0x000033b3, 0x000033b3, 0x000055d4,
  0x000055d5, 0x00006667, 0x000055d5, 0x0000807c,
  0x00008889, 0x00008889, 0x0000807d, 0x0000807d,
  0x0000aaab, 0x0000b331, 0x0000807e, 0x0000807e,
  0x0000d553, 0x0000b332, 0x0000807f, 0x00007f81,
  0x0000d554, 0x0000b333, 0x00007f80, 0x00007f80,
  0x0000d555, 0x00004ccc, 0x00007f7f, 0x000054d7,
  0x00002aaa, 0x00004ccb, 0x000054d6, 0x000032b5,
  0x00002aa9, 0x00002222, 0x000032b4, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002222, 0x000032b4, 0x00000001, 0x00000001,
  0x000054d6, 0x000032b5, 0x00000002, 0x00000002,
  0x000032b5, 0x00000002, 0x00000002, 0x0000006e,
  0x000032b6, 0x00000003, 0x0000006f, 0x0000007b,
  0x000032b7, 0x00000070, 0x0000007c, 0x0000007c,
  0x00003324, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00003331, 0x0000007e, 0x0000007e, 0x0000007e,
  0x00003332, 0x0000007f, 0x0000007f, 0x0000007f,
  0x00003333, 0x00000080, 0x00000080, 0x00000080,
  0x00003334, 0x00000081, 0x00000081, 0x0000008e,
  0x00003335, 0x00000082, 0x0000008f, 0x000000fb,
  0x00003336, 0x00000090, 0x000000fc, 0x000000fc,
  0x00003344, 0x000000fd, 0x000000fd, 0x000000fd,
  0x000033b1, 0x000000fe, 0x000000fe, 0x000033b1,
  0x000033b2, 0x000000ff, 0x000033b2, 0x000055d3,
  0x000033b3, 0x000033b3, 0x000055d4, 0x0000807b,
  0x00006667, 0x000055d5, 0x0000807c, 0x0000807c,
  0x00008889, 0x0000807d, 0x0000807d, 0x0000807d,
  0x0000b331, 0x0000807e, 0x0000807e, 0x00007f82,
  0x0000b332, 0x0000807f, 0x00007f81, 0x00007f81,
  0x0000b333, 0x00007f80, 0x00007f80, 0x000054d8,
  0x00004ccc, 0x00007f7f, 0x000054d7, 0x000032b6,
  0x00004ccb, 0x000054d6, 0x000032b5, 0x00000002,
  0x00002222, 0x000032b4, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000032b4, 0x00000001, 0x00000001, 0x00000001,
  0x00000001, 0x00000001, 0x00000001, 0x0000006d,
  0x00000002, 0x00000002, 0x0000006e, 0x0000007a,
  0x00000003, 0x0000006f, 0x0000007b, 0x0000007b,
  0x00000070, 0x0000007c, 0x0000007c, 0x0000007c,
  0x0000007d, 0x0000007d, 0x0000007d, 0x0000007d,
  0x0000007e, 0x0000007e, 0x0000007e, 0x0000007e,
  0x0000007f, 0x0000007f, 0x0000007f, 0x0000007f,
  0x00000080, 0x00000080, 0x00000080, 0x0000008d,
  0x00000081, 0x00000081, 0x0000008e, 0x000000fa,
  0x00000082, 0x0000008f, 0x000000fb, 0x000000fb,
  0x00000090, 0x000000fc, 0x000000fc, 0x000000fc,
  0x000000fd, 0x000000fd, 0x000000fd, 0x000033b0,
  0x000000fe, 0x000000fe, 0x000033b1, 0x000055d2,
  0x000000ff, 0x000033b2, 0x000055d3, 0x0000807a,
  0x000033b3, 0x000055d4, 0x0000807b, 0x0000807b,
  0x000055d5, 0x0000807c, 0x0000807c, 0x0000807c,
  0x0000807d, 0x0000807d, 0x0000807d, 0x00007f83,
  0x0000807e, 0x0000807e, 0x00007f82, 0x00007f82,
  0x0000807f, 0x00007f81, 0x00007f81, 0x000054d9,
  0x00007f80, 0x00007f80, 0x000054d8, 0x000032b7,
  0x00007f7f, 0x000054d7, 0x000032b6, 0x00000003,
  0x000054d6, 0x000032b5, 0x00000002, 0x00000002,
  0x000032b4, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
};
const unsigned kExpectedCount_NEON_sabdl_4S = 576;

#endif  // VIXL_SIM_SABDL_4S_TRACE_AARCH64_H_
