// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SABDL2_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SABDL2_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sabdl2_2D[] = {
  0x0000000000000000, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000001,
  0x00000000007ffcff, 0x0000000000000002,
  0x00000000007ffcfe, 0x0000000000000020,
  0x00000000007ffce0, 0x000000000000007d,
  0x00000000007ffc83, 0x000000000000007e,
  0x00000000007ffc82, 0x000000000000007f,
  0x00000000007ffc81, 0x0000000000007ffd,
  0x00000000007f7d03, 0x0000000000007ffe,
  0x00000000007f7d02, 0x0000000000007fff,
  0x00000000007f7d01, 0x0000000033333333,
  0x0000000032b33633, 0x0000000055555555,
  0x0000000054d55855, 0x000000007ffffffd,
  0x000000007f8002fd, 0x000000007ffffffe,
  0x000000007f8002fe, 0x000000007fffffff,
  0x000000007f8002ff, 0x0000000080000000,
  0x00000000807ffd00, 0x000000007fffffff,
  0x00000000807ffcff, 0x0000000055555556,
  0x0000000055d55256, 0x0000000033333334,
  0x0000000033b33034, 0x0000000000008000,
  0x0000000000807d00, 0x0000000000007fff,
  0x0000000000807cff, 0x0000000000007ffe,
  0x0000000000807cfe, 0x0000000000007ffd,
  0x0000000000807cfd, 0x0000000000000080,
  0x00000000007ffd80, 0x000000000000007f,
  0x00000000007ffd7f, 0x000000000000007e,
  0x00000000007ffd7e, 0x000000000000007d,
  0x00000000007ffd7d, 0x0000000000000020,
  0x00000000007ffd20, 0x0000000000000003,
  0x00000000007ffd03, 0x0000000000000002,
  0x00000000007ffd02, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x000000000000001f,
  0x0000000000000020, 0x000000000000007c,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007f, 0x0000000000007ffc,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007fff, 0x0000000033333332,
  0x0000000033333333, 0x0000000055555554,
  0x0000000055555555, 0x000000007ffffffc,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000000,
  0x000000007fffffff, 0x0000000055555557,
  0x0000000055555556, 0x0000000033333335,
  0x0000000033333334, 0x0000000000008001,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000000081,
  0x0000000000000080, 0x0000000000000080,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x0000000000000021,
  0x0000000000000020, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x000000000000001e,
  0x000000000000001f, 0x000000000000007b,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007e, 0x0000000000007ffb,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffe, 0x0000000033333331,
  0x0000000033333332, 0x0000000055555553,
  0x0000000055555554, 0x000000007ffffffb,
  0x000000007ffffffc, 0x000000007ffffffc,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffe, 0x0000000080000002,
  0x0000000080000001, 0x0000000080000001,
  0x0000000080000000, 0x0000000055555558,
  0x0000000055555557, 0x0000000033333336,
  0x0000000033333335, 0x0000000000008002,
  0x0000000000008001, 0x0000000000008001,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000000082,
  0x0000000000000081, 0x0000000000000081,
  0x0000000000000080, 0x0000000000000080,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000022,
  0x0000000000000021, 0x0000000000000005,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000003, 0x0000000000000020,
  0x0000000000000002, 0x000000000000001f,
  0x0000000000000001, 0x000000000000001e,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000001e, 0x000000000000005d,
  0x000000000000007b, 0x000000000000005e,
  0x000000000000007c, 0x000000000000005f,
  0x000000000000007d, 0x0000000000007fdd,
  0x0000000000007ffb, 0x0000000000007fde,
  0x0000000000007ffc, 0x0000000000007fdf,
  0x0000000000007ffd, 0x0000000033333313,
  0x0000000033333331, 0x0000000055555535,
  0x0000000055555553, 0x000000007fffffdd,
  0x000000007ffffffb, 0x000000007fffffde,
  0x000000007ffffffc, 0x000000007fffffdf,
  0x000000007ffffffd, 0x0000000080000020,
  0x0000000080000002, 0x000000008000001f,
  0x0000000080000001, 0x0000000055555576,
  0x0000000055555558, 0x0000000033333354,
  0x0000000033333336, 0x0000000000008020,
  0x0000000000008002, 0x000000000000801f,
  0x0000000000008001, 0x000000000000801e,
  0x0000000000008000, 0x000000000000801d,
  0x0000000000007fff, 0x00000000000000a0,
  0x0000000000000082, 0x000000000000009f,
  0x0000000000000081, 0x000000000000009e,
  0x0000000000000080, 0x000000000000009d,
  0x000000000000007f, 0x0000000000000040,
  0x0000000000000022, 0x0000000000000023,
  0x0000000000000005, 0x0000000000000022,
  0x0000000000000004, 0x0000000000000021,
  0x0000000000000021, 0x000000000000007d,
  0x0000000000000020, 0x000000000000007c,
  0x000000000000001f, 0x000000000000007b,
  0x000000000000001e, 0x000000000000005d,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000005d, 0x0000000000000001,
  0x000000000000005e, 0x0000000000000002,
  0x000000000000005f, 0x0000000000007f80,
  0x0000000000007fdd, 0x0000000000007f81,
  0x0000000000007fde, 0x0000000000007f82,
  0x0000000000007fdf, 0x00000000333332b6,
  0x0000000033333313, 0x00000000555554d8,
  0x0000000055555535, 0x000000007fffff80,
  0x000000007fffffdd, 0x000000007fffff81,
  0x000000007fffffde, 0x000000007fffff82,
  0x000000007fffffdf, 0x000000008000007d,
  0x0000000080000020, 0x000000008000007c,
  0x000000008000001f, 0x00000000555555d3,
  0x0000000055555576, 0x00000000333333b1,
  0x0000000033333354, 0x000000000000807d,
  0x0000000000008020, 0x000000000000807c,
  0x000000000000801f, 0x000000000000807b,
  0x000000000000801e, 0x000000000000807a,
  0x000000000000801d, 0x00000000000000fd,
  0x00000000000000a0, 0x00000000000000fc,
  0x000000000000009f, 0x00000000000000fb,
  0x000000000000009e, 0x00000000000000fa,
  0x000000000000009d, 0x000000000000009d,
  0x0000000000000040, 0x0000000000000080,
  0x0000000000000023, 0x000000000000007f,
  0x0000000000000022, 0x000000000000007e,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000005e,
  0x000000000000005d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f82, 0x00000000333332b5,
  0x00000000333332b6, 0x00000000555554d7,
  0x00000000555554d8, 0x000000007fffff7f,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff82, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007d,
  0x000000008000007c, 0x00000000555555d4,
  0x00000000555555d3, 0x00000000333333b2,
  0x00000000333333b1, 0x000000000000807e,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807b,
  0x000000000000807a, 0x00000000000000fe,
  0x00000000000000fd, 0x00000000000000fd,
  0x00000000000000fc, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fb,
  0x00000000000000fa, 0x000000000000009e,
  0x000000000000009d, 0x0000000000000081,
  0x0000000000000080, 0x0000000000000080,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000005f,
  0x000000000000005e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000007f7e,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x00000000333332b4,
  0x00000000333332b5, 0x00000000555554d6,
  0x00000000555554d7, 0x000000007fffff7e,
  0x000000007fffff7f, 0x000000007fffff7f,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff81, 0x000000008000007f,
  0x000000008000007e, 0x000000008000007e,
  0x000000008000007d, 0x00000000555555d5,
  0x00000000555555d4, 0x00000000333333b3,
  0x00000000333333b2, 0x000000000000807f,
  0x000000000000807e, 0x000000000000807e,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807b, 0x00000000000000ff,
  0x00000000000000fe, 0x00000000000000fe,
  0x00000000000000fd, 0x00000000000000fd,
  0x00000000000000fc, 0x00000000000000fc,
  0x00000000000000fb, 0x000000000000009f,
  0x000000000000009e, 0x0000000000000082,
  0x0000000000000081, 0x0000000000000081,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000080, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffc,
  0x000000000000007e, 0x0000000000007ffb,
  0x000000000000007d, 0x0000000000007fdd,
  0x000000000000005f, 0x0000000000007f80,
  0x0000000000000002, 0x0000000000007f7f,
  0x0000000000000001, 0x0000000000007f7e,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007f7e, 0x0000000000000001,
  0x0000000000007f7f, 0x0000000000000002,
  0x0000000000007f80, 0x000000003332b336,
  0x00000000333332b4, 0x000000005554d558,
  0x00000000555554d6, 0x000000007fff8000,
  0x000000007fffff7e, 0x000000007fff8001,
  0x000000007fffff7f, 0x000000007fff8002,
  0x000000007fffff80, 0x0000000080007ffd,
  0x000000008000007f, 0x0000000080007ffc,
  0x000000008000007e, 0x000000005555d553,
  0x00000000555555d5, 0x000000003333b331,
  0x00000000333333b3, 0x000000000000fffd,
  0x000000000000807f, 0x000000000000fffc,
  0x000000000000807e, 0x000000000000fffb,
  0x000000000000807d, 0x000000000000fffa,
  0x000000000000807c, 0x000000000000807d,
  0x00000000000000ff, 0x000000000000807c,
  0x00000000000000fe, 0x000000000000807b,
  0x00000000000000fd, 0x000000000000807a,
  0x00000000000000fc, 0x000000000000801d,
  0x000000000000009f, 0x0000000000008000,
  0x0000000000000082, 0x0000000000007fff,
  0x0000000000000081, 0x0000000000007ffe,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007fde,
  0x0000000000007fdd, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x000000003332b335,
  0x000000003332b336, 0x000000005554d557,
  0x000000005554d558, 0x000000007fff7fff,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8002, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007ffd,
  0x0000000080007ffc, 0x000000005555d554,
  0x000000005555d553, 0x000000003333b332,
  0x000000003333b331, 0x000000000000fffe,
  0x000000000000fffd, 0x000000000000fffd,
  0x000000000000fffc, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffb,
  0x000000000000fffa, 0x000000000000807e,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807b,
  0x000000000000807a, 0x000000000000801e,
  0x000000000000801d, 0x0000000000008001,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007fdf,
  0x0000000000007fde, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x000000003332b334,
  0x000000003332b335, 0x000000005554d556,
  0x000000005554d557, 0x000000007fff7ffe,
  0x000000007fff7fff, 0x000000007fff7fff,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff8001, 0x0000000080007fff,
  0x0000000080007ffe, 0x0000000080007ffe,
  0x0000000080007ffd, 0x000000005555d555,
  0x000000005555d554, 0x000000003333b333,
  0x000000003333b332, 0x000000000000ffff,
  0x000000000000fffe, 0x000000000000fffe,
  0x000000000000fffd, 0x000000000000fffd,
  0x000000000000fffc, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000807f,
  0x000000000000807e, 0x000000000000807e,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807b, 0x000000000000801f,
  0x000000000000801e, 0x0000000000008002,
  0x0000000000008001, 0x0000000000008001,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000008000, 0x0000000033333333,
  0x0000000000007fff, 0x0000000033333332,
  0x0000000000007ffe, 0x0000000033333331,
  0x0000000000007ffd, 0x0000000033333313,
  0x0000000000007fdf, 0x00000000333332b6,
  0x0000000000007f82, 0x00000000333332b5,
  0x0000000000007f81, 0x00000000333332b4,
  0x0000000000007f80, 0x000000003332b336,
  0x0000000000000002, 0x000000003332b335,
  0x0000000000000001, 0x000000003332b334,
  0x0000000000000000, 0x0000000000000000,
  0x000000003332b334, 0x0000000022222222,
  0x000000005554d556, 0x000000004cccccca,
  0x000000007fff7ffe, 0x000000004ccccccb,
  0x000000007fff7fff, 0x000000004ccccccc,
  0x000000007fff8000, 0x00000000b3333333,
  0x0000000080007fff, 0x00000000b3333332,
  0x0000000080007ffe, 0x0000000088888889,
  0x000000005555d555, 0x0000000066666667,
  0x000000003333b333, 0x000000003333b333,
  0x000000000000ffff, 0x000000003333b332,
  0x000000000000fffe, 0x000000003333b331,
  0x000000000000fffd, 0x000000003333b330,
  0x000000000000fffc, 0x00000000333333b3,
  0x000000000000807f, 0x00000000333333b2,
  0x000000000000807e, 0x00000000333333b1,
  0x000000000000807d, 0x00000000333333b0,
  0x000000000000807c, 0x0000000033333353,
  0x000000000000801f, 0x0000000033333336,
  0x0000000000008002, 0x0000000033333335,
  0x0000000000008001, 0x0000000033333334,
  0x0000000033333334, 0x0000000055555555,
  0x0000000033333333, 0x0000000055555554,
  0x0000000033333332, 0x0000000055555553,
  0x0000000033333331, 0x0000000055555535,
  0x0000000033333313, 0x00000000555554d8,
  0x00000000333332b6, 0x00000000555554d7,
  0x00000000333332b5, 0x00000000555554d6,
  0x00000000333332b4, 0x000000005554d558,
  0x000000003332b336, 0x000000005554d557,
  0x000000003332b335, 0x000000005554d556,
  0x000000003332b334, 0x0000000022222222,
  0x0000000000000000, 0x0000000000000000,
  0x0000000022222222, 0x000000002aaaaaa8,
  0x000000004cccccca, 0x000000002aaaaaa9,
  0x000000004ccccccb, 0x000000002aaaaaaa,
  0x000000004ccccccc, 0x00000000d5555555,
  0x00000000b3333333, 0x00000000d5555554,
  0x00000000b3333332, 0x00000000aaaaaaab,
  0x0000000088888889, 0x0000000088888889,
  0x0000000066666667, 0x000000005555d555,
  0x000000003333b333, 0x000000005555d554,
  0x000000003333b332, 0x000000005555d553,
  0x000000003333b331, 0x000000005555d552,
  0x000000003333b330, 0x00000000555555d5,
  0x00000000333333b3, 0x00000000555555d4,
  0x00000000333333b2, 0x00000000555555d3,
  0x00000000333333b1, 0x00000000555555d2,
  0x00000000333333b0, 0x0000000055555575,
  0x0000000033333353, 0x0000000055555558,
  0x0000000033333336, 0x0000000055555557,
  0x0000000033333335, 0x0000000055555556,
  0x0000000055555556, 0x000000007ffffffd,
  0x0000000055555555, 0x000000007ffffffc,
  0x0000000055555554, 0x000000007ffffffb,
  0x0000000055555553, 0x000000007fffffdd,
  0x0000000055555535, 0x000000007fffff80,
  0x00000000555554d8, 0x000000007fffff7f,
  0x00000000555554d7, 0x000000007fffff7e,
  0x00000000555554d6, 0x000000007fff8000,
  0x000000005554d558, 0x000000007fff7fff,
  0x000000005554d557, 0x000000007fff7ffe,
  0x000000005554d556, 0x000000004cccccca,
  0x0000000022222222, 0x000000002aaaaaa8,
  0x0000000000000000, 0x0000000000000000,
  0x000000002aaaaaa8, 0x0000000000000001,
  0x000000002aaaaaa9, 0x0000000000000002,
  0x000000002aaaaaaa, 0x00000000fffffffd,
  0x00000000d5555555, 0x00000000fffffffc,
  0x00000000d5555554, 0x00000000d5555553,
  0x00000000aaaaaaab, 0x00000000b3333331,
  0x0000000088888889, 0x0000000080007ffd,
  0x000000005555d555, 0x0000000080007ffc,
  0x000000005555d554, 0x0000000080007ffb,
  0x000000005555d553, 0x0000000080007ffa,
  0x000000005555d552, 0x000000008000007d,
  0x00000000555555d5, 0x000000008000007c,
  0x00000000555555d4, 0x000000008000007b,
  0x00000000555555d3, 0x000000008000007a,
  0x00000000555555d2, 0x000000008000001d,
  0x0000000055555575, 0x0000000080000000,
  0x0000000055555558, 0x000000007fffffff,
  0x0000000055555557, 0x000000007ffffffe,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007fffffde,
  0x000000007fffffdd, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000004ccccccb,
  0x000000004cccccca, 0x000000002aaaaaa9,
  0x000000002aaaaaa8, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000d5555554,
  0x00000000d5555553, 0x00000000b3333332,
  0x00000000b3333331, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffb,
  0x0000000080007ffa, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007b,
  0x000000008000007a, 0x000000008000001e,
  0x000000008000001d, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000000,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007fffffdf,
  0x000000007fffffde, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000004ccccccc,
  0x000000004ccccccb, 0x000000002aaaaaaa,
  0x000000002aaaaaa9, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x00000000ffffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000d5555555,
  0x00000000d5555554, 0x00000000b3333333,
  0x00000000b3333332, 0x0000000080007fff,
  0x0000000080007ffe, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffc,
  0x0000000080007ffb, 0x000000008000007f,
  0x000000008000007e, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007c,
  0x000000008000007b, 0x000000008000001f,
  0x000000008000001e, 0x0000000080000002,
  0x0000000080000001, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000000,
  0x0000000080000000, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x000000007ffffffe, 0x0000000080000002,
  0x000000007ffffffd, 0x0000000080000020,
  0x000000007fffffdf, 0x000000008000007d,
  0x000000007fffff82, 0x000000008000007e,
  0x000000007fffff81, 0x000000008000007f,
  0x000000007fffff80, 0x0000000080007ffd,
  0x000000007fff8002, 0x0000000080007ffe,
  0x000000007fff8001, 0x0000000080007fff,
  0x000000007fff8000, 0x00000000b3333333,
  0x000000004ccccccc, 0x00000000d5555555,
  0x000000002aaaaaaa, 0x00000000fffffffd,
  0x0000000000000002, 0x00000000fffffffe,
  0x0000000000000001, 0x00000000ffffffff,
  0x0000000000000000, 0x0000000000000000,
  0x00000000ffffffff, 0x0000000000000001,
  0x00000000fffffffe, 0x000000002aaaaaaa,
  0x00000000d5555555, 0x000000004ccccccc,
  0x00000000b3333333, 0x000000007fff8000,
  0x0000000080007fff, 0x000000007fff8001,
  0x0000000080007ffe, 0x000000007fff8002,
  0x0000000080007ffd, 0x000000007fff8003,
  0x0000000080007ffc, 0x000000007fffff80,
  0x000000008000007f, 0x000000007fffff81,
  0x000000008000007e, 0x000000007fffff82,
  0x000000008000007d, 0x000000007fffff83,
  0x000000008000007c, 0x000000007fffffe0,
  0x000000008000001f, 0x000000007ffffffd,
  0x0000000080000002, 0x000000007ffffffe,
  0x0000000080000001, 0x000000007fffffff,
  0x000000007fffffff, 0x000000007fffffff,
  0x0000000080000000, 0x0000000080000000,
  0x0000000080000001, 0x0000000080000001,
  0x0000000080000002, 0x000000008000001f,
  0x0000000080000020, 0x000000008000007c,
  0x000000008000007d, 0x000000008000007d,
  0x000000008000007e, 0x000000008000007e,
  0x000000008000007f, 0x0000000080007ffc,
  0x0000000080007ffd, 0x0000000080007ffd,
  0x0000000080007ffe, 0x0000000080007ffe,
  0x0000000080007fff, 0x00000000b3333332,
  0x00000000b3333333, 0x00000000d5555554,
  0x00000000d5555555, 0x00000000fffffffc,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000000ffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x000000002aaaaaa9,
  0x000000002aaaaaaa, 0x000000004ccccccb,
  0x000000004ccccccc, 0x000000007fff7fff,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8003, 0x000000007fffff7f,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff83, 0x000000007fffffdf,
  0x000000007fffffe0, 0x000000007ffffffc,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffe, 0x0000000055555556,
  0x000000007fffffff, 0x0000000055555557,
  0x0000000080000000, 0x0000000055555558,
  0x0000000080000001, 0x0000000055555576,
  0x000000008000001f, 0x00000000555555d3,
  0x000000008000007c, 0x00000000555555d4,
  0x000000008000007d, 0x00000000555555d5,
  0x000000008000007e, 0x000000005555d553,
  0x0000000080007ffc, 0x000000005555d554,
  0x0000000080007ffd, 0x000000005555d555,
  0x0000000080007ffe, 0x0000000088888889,
  0x00000000b3333332, 0x00000000aaaaaaab,
  0x00000000d5555554, 0x00000000d5555553,
  0x00000000fffffffc, 0x00000000d5555554,
  0x00000000fffffffd, 0x00000000d5555555,
  0x00000000fffffffe, 0x000000002aaaaaaa,
  0x0000000000000001, 0x000000002aaaaaa9,
  0x0000000000000000, 0x0000000000000000,
  0x000000002aaaaaa9, 0x0000000022222222,
  0x000000004ccccccb, 0x000000005554d556,
  0x000000007fff7fff, 0x000000005554d557,
  0x000000007fff8000, 0x000000005554d558,
  0x000000007fff8001, 0x000000005554d559,
  0x000000007fff8002, 0x00000000555554d6,
  0x000000007fffff7f, 0x00000000555554d7,
  0x000000007fffff80, 0x00000000555554d8,
  0x000000007fffff81, 0x00000000555554d9,
  0x000000007fffff82, 0x0000000055555536,
  0x000000007fffffdf, 0x0000000055555553,
  0x000000007ffffffc, 0x0000000055555554,
  0x000000007ffffffd, 0x0000000055555555,
  0x0000000055555555, 0x0000000033333334,
  0x0000000055555556, 0x0000000033333335,
  0x0000000055555557, 0x0000000033333336,
  0x0000000055555558, 0x0000000033333354,
  0x0000000055555576, 0x00000000333333b1,
  0x00000000555555d3, 0x00000000333333b2,
  0x00000000555555d4, 0x00000000333333b3,
  0x00000000555555d5, 0x000000003333b331,
  0x000000005555d553, 0x000000003333b332,
  0x000000005555d554, 0x000000003333b333,
  0x000000005555d555, 0x0000000066666667,
  0x0000000088888889, 0x0000000088888889,
  0x00000000aaaaaaab, 0x00000000b3333331,
  0x00000000d5555553, 0x00000000b3333332,
  0x00000000d5555554, 0x00000000b3333333,
  0x00000000d5555555, 0x000000004ccccccc,
  0x000000002aaaaaaa, 0x000000004ccccccb,
  0x000000002aaaaaa9, 0x0000000022222222,
  0x0000000000000000, 0x0000000000000000,
  0x0000000022222222, 0x000000003332b334,
  0x000000005554d556, 0x000000003332b335,
  0x000000005554d557, 0x000000003332b336,
  0x000000005554d558, 0x000000003332b337,
  0x000000005554d559, 0x00000000333332b4,
  0x00000000555554d6, 0x00000000333332b5,
  0x00000000555554d7, 0x00000000333332b6,
  0x00000000555554d8, 0x00000000333332b7,
  0x00000000555554d9, 0x0000000033333314,
  0x0000000055555536, 0x0000000033333331,
  0x0000000055555553, 0x0000000033333332,
  0x0000000055555554, 0x0000000033333333,
  0x0000000033333333, 0x0000000000008000,
  0x0000000033333334, 0x0000000000008001,
  0x0000000033333335, 0x0000000000008002,
  0x0000000033333336, 0x0000000000008020,
  0x0000000033333354, 0x000000000000807d,
  0x00000000333333b1, 0x000000000000807e,
  0x00000000333333b2, 0x000000000000807f,
  0x00000000333333b3, 0x000000000000fffd,
  0x000000003333b331, 0x000000000000fffe,
  0x000000003333b332, 0x000000000000ffff,
  0x000000003333b333, 0x000000003333b333,
  0x0000000066666667, 0x000000005555d555,
  0x0000000088888889, 0x0000000080007ffd,
  0x00000000b3333331, 0x0000000080007ffe,
  0x00000000b3333332, 0x0000000080007fff,
  0x00000000b3333333, 0x000000007fff8000,
  0x000000004ccccccc, 0x000000007fff7fff,
  0x000000004ccccccb, 0x000000005554d556,
  0x0000000022222222, 0x000000003332b334,
  0x0000000000000000, 0x0000000000000000,
  0x000000003332b334, 0x0000000000000001,
  0x000000003332b335, 0x0000000000000002,
  0x000000003332b336, 0x0000000000000003,
  0x000000003332b337, 0x0000000000007f80,
  0x00000000333332b4, 0x0000000000007f81,
  0x00000000333332b5, 0x0000000000007f82,
  0x00000000333332b6, 0x0000000000007f83,
  0x00000000333332b7, 0x0000000000007fe0,
  0x0000000033333314, 0x0000000000007ffd,
  0x0000000033333331, 0x0000000000007ffe,
  0x0000000033333332, 0x0000000000007fff,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000008001, 0x0000000000008001,
  0x0000000000008002, 0x000000000000801f,
  0x0000000000008020, 0x000000000000807c,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807e, 0x000000000000807e,
  0x000000000000807f, 0x000000000000fffc,
  0x000000000000fffd, 0x000000000000fffd,
  0x000000000000fffe, 0x000000000000fffe,
  0x000000000000ffff, 0x000000003333b332,
  0x000000003333b333, 0x000000005555d554,
  0x000000005555d555, 0x0000000080007ffc,
  0x0000000080007ffd, 0x0000000080007ffd,
  0x0000000080007ffe, 0x0000000080007ffe,
  0x0000000080007fff, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000005554d557,
  0x000000005554d556, 0x000000003332b335,
  0x000000003332b334, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000003, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f82, 0x0000000000007f82,
  0x0000000000007f83, 0x0000000000007fdf,
  0x0000000000007fe0, 0x0000000000007ffc,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000008001, 0x000000000000801e,
  0x000000000000801f, 0x000000000000807b,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807e, 0x000000000000fffb,
  0x000000000000fffc, 0x000000000000fffc,
  0x000000000000fffd, 0x000000000000fffd,
  0x000000000000fffe, 0x000000003333b331,
  0x000000003333b332, 0x000000005555d553,
  0x000000005555d554, 0x0000000080007ffb,
  0x0000000080007ffc, 0x0000000080007ffc,
  0x0000000080007ffd, 0x0000000080007ffd,
  0x0000000080007ffe, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000005554d558,
  0x000000005554d557, 0x000000003332b336,
  0x000000003332b335, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000007f7e,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f82, 0x0000000000007fde,
  0x0000000000007fdf, 0x0000000000007ffb,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000008000, 0x000000000000801d,
  0x000000000000801e, 0x000000000000807a,
  0x000000000000807b, 0x000000000000807b,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807d, 0x000000000000fffa,
  0x000000000000fffb, 0x000000000000fffb,
  0x000000000000fffc, 0x000000000000fffc,
  0x000000000000fffd, 0x000000003333b330,
  0x000000003333b331, 0x000000005555d552,
  0x000000005555d553, 0x0000000080007ffa,
  0x0000000080007ffb, 0x0000000080007ffb,
  0x0000000080007ffc, 0x0000000080007ffc,
  0x0000000080007ffd, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8001, 0x000000005554d559,
  0x000000005554d558, 0x000000003332b337,
  0x000000003332b336, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000007f7d,
  0x0000000000007f7e, 0x0000000000007f7e,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x0000000000007fdd,
  0x0000000000007fde, 0x0000000000007ffa,
  0x0000000000007ffb, 0x0000000000007ffb,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffc, 0x0000000000000080,
  0x0000000000007ffd, 0x0000000000000081,
  0x0000000000007ffe, 0x0000000000000082,
  0x0000000000007fff, 0x00000000000000a0,
  0x000000000000801d, 0x00000000000000fd,
  0x000000000000807a, 0x00000000000000fe,
  0x000000000000807b, 0x00000000000000ff,
  0x000000000000807c, 0x000000000000807d,
  0x000000000000fffa, 0x000000000000807e,
  0x000000000000fffb, 0x000000000000807f,
  0x000000000000fffc, 0x00000000333333b3,
  0x000000003333b330, 0x00000000555555d5,
  0x000000005555d552, 0x000000008000007d,
  0x0000000080007ffa, 0x000000008000007e,
  0x0000000080007ffb, 0x000000008000007f,
  0x0000000080007ffc, 0x000000007fffff80,
  0x000000007fff8003, 0x000000007fffff7f,
  0x000000007fff8002, 0x00000000555554d6,
  0x000000005554d559, 0x00000000333332b4,
  0x000000003332b337, 0x0000000000007f80,
  0x0000000000000003, 0x0000000000007f7f,
  0x0000000000000002, 0x0000000000007f7e,
  0x0000000000000001, 0x0000000000007f7d,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007f7d, 0x0000000000000001,
  0x0000000000007f7e, 0x0000000000000002,
  0x0000000000007f7f, 0x0000000000000003,
  0x0000000000007f80, 0x0000000000000060,
  0x0000000000007fdd, 0x000000000000007d,
  0x0000000000007ffa, 0x000000000000007e,
  0x0000000000007ffb, 0x000000000000007f,
  0x000000000000007f, 0x000000000000007f,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000081, 0x0000000000000081,
  0x0000000000000082, 0x000000000000009f,
  0x00000000000000a0, 0x00000000000000fc,
  0x00000000000000fd, 0x00000000000000fd,
  0x00000000000000fe, 0x00000000000000fe,
  0x00000000000000ff, 0x000000000000807c,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807e, 0x000000000000807e,
  0x000000000000807f, 0x00000000333333b2,
  0x00000000333333b3, 0x00000000555555d4,
  0x00000000555555d5, 0x000000008000007c,
  0x000000008000007d, 0x000000008000007d,
  0x000000008000007e, 0x000000008000007e,
  0x000000008000007f, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x00000000555554d7,
  0x00000000555554d6, 0x00000000333332b5,
  0x00000000333332b4, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000003, 0x000000000000005f,
  0x0000000000000060, 0x000000000000007c,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007f, 0x000000000000007f,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000081, 0x000000000000009e,
  0x000000000000009f, 0x00000000000000fb,
  0x00000000000000fc, 0x00000000000000fc,
  0x00000000000000fd, 0x00000000000000fd,
  0x00000000000000fe, 0x000000000000807b,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807e, 0x00000000333333b1,
  0x00000000333333b2, 0x00000000555555d3,
  0x00000000555555d4, 0x000000008000007b,
  0x000000008000007c, 0x000000008000007c,
  0x000000008000007d, 0x000000008000007d,
  0x000000008000007e, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x00000000555554d8,
  0x00000000555554d7, 0x00000000333332b6,
  0x00000000333332b5, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x000000000000005e,
  0x000000000000005f, 0x000000000000007b,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007f, 0x000000000000007f,
  0x0000000000000080, 0x000000000000009d,
  0x000000000000009e, 0x00000000000000fa,
  0x00000000000000fb, 0x00000000000000fb,
  0x00000000000000fc, 0x00000000000000fc,
  0x00000000000000fd, 0x000000000000807a,
  0x000000000000807b, 0x000000000000807b,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807d, 0x00000000333333b0,
  0x00000000333333b1, 0x00000000555555d2,
  0x00000000555555d3, 0x000000008000007a,
  0x000000008000007b, 0x000000008000007b,
  0x000000008000007c, 0x000000008000007c,
  0x000000008000007d, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff81, 0x00000000555554d9,
  0x00000000555554d8, 0x00000000333332b7,
  0x00000000333332b6, 0x0000000000007f83,
  0x0000000000007f82, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x000000000000005d,
  0x000000000000005e, 0x000000000000007a,
  0x000000000000007b, 0x000000000000007b,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007c, 0x0000000000000020,
  0x000000000000007d, 0x0000000000000021,
  0x000000000000007e, 0x0000000000000022,
  0x000000000000007f, 0x0000000000000040,
  0x000000000000009d, 0x000000000000009d,
  0x00000000000000fa, 0x000000000000009e,
  0x00000000000000fb, 0x000000000000009f,
  0x00000000000000fc, 0x000000000000801d,
  0x000000000000807a, 0x000000000000801e,
  0x000000000000807b, 0x000000000000801f,
  0x000000000000807c, 0x0000000033333353,
  0x00000000333333b0, 0x0000000055555575,
  0x00000000555555d2, 0x000000008000001d,
  0x000000008000007a, 0x000000008000001e,
  0x000000008000007b, 0x000000008000001f,
  0x000000008000007c, 0x000000007fffffe0,
  0x000000007fffff83, 0x000000007fffffdf,
  0x000000007fffff82, 0x0000000055555536,
  0x00000000555554d9, 0x0000000033333314,
  0x00000000333332b7, 0x0000000000007fe0,
  0x0000000000007f83, 0x0000000000007fdf,
  0x0000000000007f82, 0x0000000000007fde,
  0x0000000000007f81, 0x0000000000007fdd,
  0x0000000000007f80, 0x0000000000000060,
  0x0000000000000003, 0x000000000000005f,
  0x0000000000000002, 0x000000000000005e,
  0x0000000000000001, 0x000000000000005d,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000005d, 0x000000000000001d,
  0x000000000000007a, 0x000000000000001e,
  0x000000000000007b, 0x000000000000001f,
  0x000000000000001f, 0x0000000000000003,
  0x0000000000000020, 0x0000000000000004,
  0x0000000000000021, 0x0000000000000005,
  0x0000000000000022, 0x0000000000000023,
  0x0000000000000040, 0x0000000000000080,
  0x000000000000009d, 0x0000000000000081,
  0x000000000000009e, 0x0000000000000082,
  0x000000000000009f, 0x0000000000008000,
  0x000000000000801d, 0x0000000000008001,
  0x000000000000801e, 0x0000000000008002,
  0x000000000000801f, 0x0000000033333336,
  0x0000000033333353, 0x0000000055555558,
  0x0000000055555575, 0x0000000080000000,
  0x000000008000001d, 0x0000000080000001,
  0x000000008000001e, 0x0000000080000002,
  0x000000008000001f, 0x000000007ffffffd,
  0x000000007fffffe0, 0x000000007ffffffc,
  0x000000007fffffdf, 0x0000000055555553,
  0x0000000055555536, 0x0000000033333331,
  0x0000000033333314, 0x0000000000007ffd,
  0x0000000000007fe0, 0x0000000000007ffc,
  0x0000000000007fdf, 0x0000000000007ffb,
  0x0000000000007fde, 0x0000000000007ffa,
  0x0000000000007fdd, 0x000000000000007d,
  0x0000000000000060, 0x000000000000007c,
  0x000000000000005f, 0x000000000000007b,
  0x000000000000005e, 0x000000000000007a,
  0x000000000000005d, 0x000000000000001d,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000001d, 0x0000000000000001,
  0x000000000000001e, 0x0000000000000002,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000005, 0x0000000000000022,
  0x0000000000000023, 0x000000000000007f,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000081, 0x0000000000000081,
  0x0000000000000082, 0x0000000000007fff,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000008001, 0x0000000000008001,
  0x0000000000008002, 0x0000000033333335,
  0x0000000033333336, 0x0000000055555557,
  0x0000000055555558, 0x000000007fffffff,
  0x0000000080000000, 0x0000000080000000,
  0x0000000080000001, 0x0000000080000001,
  0x0000000080000002, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x0000000055555554,
  0x0000000055555553, 0x0000000033333332,
  0x0000000033333331, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffb,
  0x0000000000007ffa, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007b,
  0x000000000000007a, 0x000000000000001e,
  0x000000000000001d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000004, 0x0000000000000021,
  0x0000000000000022, 0x000000000000007e,
  0x000000000000007f, 0x000000000000007f,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000081, 0x0000000000007ffe,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000008001, 0x0000000033333334,
  0x0000000033333335, 0x0000000055555556,
  0x0000000055555557, 0x000000007ffffffe,
  0x000000007fffffff, 0x000000007fffffff,
  0x0000000080000000, 0x0000000080000000,
  0x0000000080000001, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x0000000055555555,
  0x0000000055555554, 0x0000000033333333,
  0x0000000033333332, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x000000000000007f,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000001f,
  0x000000000000001e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
};
const unsigned kExpectedCount_NEON_sabdl2_2D = 961;

#endif  // VIXL_SIM_SABDL2_2D_TRACE_AARCH64_H_
