/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.core.loading;

import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xj3d.core.loading.LoadDetails;
import org.xj3d.core.loading.LoadPriorityComparator;
import org.xj3d.core.loading.LoadRequest;
import org.xj3d.core.loading.LoadRequestHandler;

public class ContentLoadQueue {
    private static final String NULL_URL_MSG = "The URL provided to the content load queue did not contain anything.";
    private static final String NULL_TYPE_MSG = "The node type constant was null. A valid type is needed.";
    private boolean purging = false;
    private int numberOfWaitingThreads = 0;
    private TreeSet loadQueue;
    private LoadPriorityComparator sorter = new LoadPriorityComparator();
    private HashMap detailsToRequestMap;

    ContentLoadQueue() {
        this.loadQueue = new TreeSet(this.sorter);
        this.detailsToRequestMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(String string, String[] stringArray, LoadRequestHandler loadRequestHandler, LoadDetails loadDetails) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException(NULL_URL_MSG);
        }
        LoadRequest loadRequest = new LoadRequest();
        loadRequest.url = stringArray;
        loadRequest.handler = loadRequestHandler;
        loadRequest.type = string;
        TreeSet treeSet = this.loadQueue;
        synchronized (treeSet) {
            if (this.loadQueue.contains(loadRequest)) {
                SortedSet<LoadRequest> sortedSet = this.loadQueue.tailSet(loadRequest);
                loadRequest = sortedSet.first();
                loadRequest.loadList.add(loadDetails);
            } else {
                loadRequest.loadList.add(loadDetails);
                this.loadQueue.add(loadRequest);
            }
            this.detailsToRequestMap.put(loadDetails, loadRequest);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LoadRequest getNext() {
        LoadRequest loadRequest = null;
        while (!this.purging && loadRequest == null) {
            Object object;
            while (!this.purging && this.loadQueue.isEmpty()) {
                ++this.numberOfWaitingThreads;
                try {
                    object = this;
                    synchronized (object) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.numberOfWaitingThreads;
            }
            object = this.loadQueue;
            synchronized (object) {
                if (!this.loadQueue.isEmpty()) {
                    loadRequest = (LoadRequest)this.loadQueue.first();
                    this.loadQueue.remove(loadRequest);
                }
            }
        }
        if (this.purging && this.numberOfWaitingThreads == 0) {
            this.purging = false;
        }
        return loadRequest;
    }

    public synchronized int size() {
        return this.loadQueue.size();
    }

    public synchronized void purge() {
        this.loadQueue.clear();
        this.detailsToRequestMap.clear();
        this.purging = true;
        this.notifyAll();
    }

    public synchronized void clear() {
        this.loadQueue.clear();
        this.detailsToRequestMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String[] stringArray, LoadDetails loadDetails) {
        TreeSet treeSet = this.loadQueue;
        synchronized (treeSet) {
            LoadRequest loadRequest = (LoadRequest)this.detailsToRequestMap.get(loadDetails);
            if (loadRequest == null || !loadRequest.loadList.contains(loadDetails)) {
                return;
            }
            if (loadRequest.loadList.size() == 1) {
                this.loadQueue.remove(loadRequest);
            } else {
                loadRequest.loadList.remove(loadDetails);
            }
            this.detailsToRequestMap.remove(loadDetails);
        }
    }

    public void requestResort() {
        this.sorter.updatePriorities();
        TreeSet treeSet = new TreeSet(this.sorter);
        treeSet.addAll(this.loadQueue);
        this.loadQueue = treeSet;
    }
}

