/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Eigen;

public class Quadric {
    public static void getAxesForEllipsoid(double[] dArray, Vector3f[] vector3fArray, float[] fArray) {
        int n;
        double[][] dArray2 = new double[3][3];
        dArray2[0][0] = dArray[0];
        dArray2[1][1] = dArray[1];
        dArray2[2][2] = dArray[2];
        double d = dArray[3] / 2.0;
        dArray2[1][0] = d;
        dArray2[0][1] = d;
        double d2 = dArray[4] / 2.0;
        dArray2[2][0] = d2;
        dArray2[0][2] = d2;
        double d3 = dArray[5] / 2.0;
        dArray2[2][1] = d3;
        dArray2[1][2] = d3;
        Eigen eigen = new Eigen(dArray2);
        float[][] fArray2 = eigen.getEigenvectorsFloatTransposed();
        double[] dArray3 = eigen.getEigenvalues();
        for (n = 0; n < 3; ++n) {
            fArray[n] = (float)(1.0 / Math.sqrt(dArray3[n]));
        }
        for (n = 0; n < 3; ++n) {
            vector3fArray[n].set(fArray2[n]);
        }
    }

    public static Matrix3f setEllipsoidMatrix(Vector3f[] vector3fArray, float[] fArray, Vector3f vector3f, Matrix3f matrix3f) {
        for (int i = 0; i < 3; ++i) {
            vector3f.set(vector3fArray[i]);
            vector3f.scale(fArray[i]);
            matrix3f.setColumn(i, vector3f);
        }
        matrix3f.invert(matrix3f);
        return matrix3f;
    }

    public static void getEquationForQuadricWithCenter(float f, float f2, float f3, Matrix3f matrix3f, Vector3f vector3f, Matrix3f matrix3f2, double[] dArray, Matrix4f matrix4f) {
        vector3f.set(f, f2, f3);
        matrix3f.transform(vector3f);
        double d = 1.0f - vector3f.dot(vector3f);
        matrix3f2.transpose(matrix3f);
        matrix3f2.transform(vector3f);
        matrix3f2.mul(matrix3f);
        dArray[0] = (double)matrix3f2.m00 / d;
        dArray[1] = (double)matrix3f2.m11 / d;
        dArray[2] = (double)matrix3f2.m22 / d;
        dArray[3] = (double)(matrix3f2.m01 * 2.0f) / d;
        dArray[4] = (double)(matrix3f2.m02 * 2.0f) / d;
        dArray[5] = (double)(matrix3f2.m12 * 2.0f) / d;
        dArray[6] = (double)(-2.0f * vector3f.x) / d;
        dArray[7] = (double)(-2.0f * vector3f.y) / d;
        dArray[8] = (double)(-2.0f * vector3f.z) / d;
        dArray[9] = -1.0;
        if (matrix4f == null) {
            return;
        }
        matrix4f.setIdentity();
        matrix4f.m00 = (float)(2.0 * dArray[0]);
        matrix4f.m11 = (float)(2.0 * dArray[1]);
        matrix4f.m22 = (float)(2.0 * dArray[2]);
        matrix4f.m01 = matrix4f.m10 = (float)dArray[3];
        matrix4f.m02 = matrix4f.m20 = (float)dArray[4];
        matrix4f.m12 = matrix4f.m21 = (float)dArray[5];
        matrix4f.m03 = (float)dArray[6];
        matrix4f.m13 = (float)dArray[7];
        matrix4f.m23 = (float)dArray[8];
    }

    public static boolean getQuardricZ(double d, double d2, double[] dArray, double[] dArray2) {
        double d3 = (dArray[4] * d + dArray[5] * d2 + dArray[8]) / dArray[2] / 2.0;
        double d4 = (dArray[0] * d * d + dArray[1] * d2 * d2 + dArray[3] * d * d2 + dArray[6] * d + dArray[7] * d2 - 1.0) / dArray[2];
        double d5 = d3 * d3 - d4;
        if (d5 < 0.0) {
            return false;
        }
        d5 = Math.sqrt(d5);
        dArray2[0] = -d3 - d5;
        dArray2[1] = -d3 + d5;
        return true;
    }

    public static int getOctant(Point3f point3f) {
        int n = 0;
        if (point3f.x < 0.0f) {
            ++n;
        }
        if (point3f.y < 0.0f) {
            n += 2;
        }
        if (point3f.z < 0.0f) {
            n += 4;
        }
        return n;
    }
}

