/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.GenericFilterBean;

public class DelegatingFilterProxy
extends GenericFilterBean {
    private String contextAttribute;
    private WebApplicationContext webApplicationContext;
    private String targetBeanName;
    private boolean targetFilterLifecycle = false;
    private Filter delegate;
    private final Object delegateMonitor = new Object();

    public DelegatingFilterProxy() {
    }

    public DelegatingFilterProxy(Filter delegate) {
        Assert.notNull((Object)delegate, (String)"delegate Filter object must not be null");
        this.delegate = delegate;
    }

    public DelegatingFilterProxy(String targetBeanName) {
        this(targetBeanName, null);
    }

    public DelegatingFilterProxy(String targetBeanName, WebApplicationContext wac) {
        Assert.hasText((String)targetBeanName, (String)"target Filter bean name must not be null or empty");
        this.setTargetBeanName(targetBeanName);
        this.webApplicationContext = wac;
        if (wac != null) {
            this.setEnvironment(wac.getEnvironment());
        }
    }

    public void setContextAttribute(String contextAttribute) {
        this.contextAttribute = contextAttribute;
    }

    public String getContextAttribute() {
        return this.contextAttribute;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    protected String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetFilterLifecycle(boolean targetFilterLifecycle) {
        this.targetFilterLifecycle = targetFilterLifecycle;
    }

    protected boolean isTargetFilterLifecycle() {
        return this.targetFilterLifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFilterBean() throws ServletException {
        Object object = this.delegateMonitor;
        synchronized (object) {
            if (this.delegate == null) {
                WebApplicationContext wac;
                if (this.targetBeanName == null) {
                    this.targetBeanName = this.getFilterName();
                }
                if ((wac = this.findWebApplicationContext()) != null) {
                    this.delegate = this.initDelegate(wac);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Filter delegateToUse = null;
        Object object = this.delegateMonitor;
        synchronized (object) {
            if (this.delegate == null) {
                WebApplicationContext wac = this.findWebApplicationContext();
                if (wac == null) {
                    throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
                }
                this.delegate = this.initDelegate(wac);
            }
            delegateToUse = this.delegate;
        }
        this.invokeDelegate(delegateToUse, request, response, filterChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Filter delegateToUse = null;
        Object object = this.delegateMonitor;
        synchronized (object) {
            delegateToUse = this.delegate;
        }
        if (delegateToUse != null) {
            this.destroyDelegate(delegateToUse);
        }
    }

    protected WebApplicationContext findWebApplicationContext() {
        if (this.webApplicationContext != null) {
            if (this.webApplicationContext instanceof ConfigurableApplicationContext && !((ConfigurableApplicationContext)this.webApplicationContext).isActive()) {
                ((ConfigurableApplicationContext)this.webApplicationContext).refresh();
            }
            return this.webApplicationContext;
        }
        String attrName = this.getContextAttribute();
        if (attrName != null) {
            return WebApplicationContextUtils.getWebApplicationContext(this.getServletContext(), attrName);
        }
        return WebApplicationContextUtils.getWebApplicationContext(this.getServletContext());
    }

    protected Filter initDelegate(WebApplicationContext wac) throws ServletException {
        Filter delegate = (Filter)wac.getBean(this.getTargetBeanName(), Filter.class);
        if (this.isTargetFilterLifecycle()) {
            delegate.init(this.getFilterConfig());
        }
        return delegate;
    }

    protected void invokeDelegate(Filter delegate, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        delegate.doFilter(request, response, filterChain);
    }

    protected void destroyDelegate(Filter delegate) {
        if (this.isTargetFilterLifecycle()) {
            delegate.destroy();
        }
    }
}

