/*
 * This file was generated by LibCSS gen_parser 
 * 
 * Generated from:
 *
 * align_content:CSS_PROP_ALIGN_CONTENT IDENT:( INHERIT: STRETCH:0,ALIGN_CONTENT_STRETCH FLEX_START:0,ALIGN_CONTENT_FLEX_START FLEX_END:0,ALIGN_CONTENT_FLEX_END CENTER:0,ALIGN_CONTENT_CENTER SPACE_BETWEEN:0,ALIGN_CONTENT_SPACE_BETWEEN SPACE_AROUND:0,ALIGN_CONTENT_SPACE_AROUND SPACE_EVENLY:0,ALIGN_CONTENT_SPACE_EVENLY IDENT:)
 * 
 * Licensed under the MIT License,
 *		  http://www.opensource.org/licenses/mit-license.php
 * Copyright 2010 The NetSurf Browser Project.
 */

#include <assert.h>
#include <string.h>

#include "bytecode/bytecode.h"
#include "bytecode/opcodes.h"
#include "parse/properties/properties.h"
#include "parse/properties/utils.h"

/**
 * Parse align_content
 *
 * \param c	  Parsing context
 * \param vector  Vector of tokens to process
 * \param ctx	  Pointer to vector iteration context
 * \param result  resulting style
 * \return CSS_OK on success,
 *	   CSS_NOMEM on memory exhaustion,
 *	   CSS_INVALID if the input is not valid
 *
 * Post condition: \a *ctx is updated with the next token to process
 *		   If the input is invalid, then \a *ctx remains unchanged.
 */
css_error css__parse_align_content(css_language *c,
		const parserutils_vector *vector, int *ctx,
		css_style *result)
{
	int orig_ctx = *ctx;
	css_error error;
	const css_token *token;
	bool match;

	token = parserutils_vector_iterate(vector, ctx);
	if ((token == NULL) || ((token->type != CSS_TOKEN_IDENT))) {
		*ctx = orig_ctx;
		return CSS_INVALID;
	}

	if ((lwc_string_caseless_isequal(token->idata, c->strings[INHERIT], &match) == lwc_error_ok && match)) {
			error = css_stylesheet_style_inherit(result, CSS_PROP_ALIGN_CONTENT);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[STRETCH], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_ALIGN_CONTENT, 0,ALIGN_CONTENT_STRETCH);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[FLEX_START], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_ALIGN_CONTENT, 0,ALIGN_CONTENT_FLEX_START);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[FLEX_END], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_ALIGN_CONTENT, 0,ALIGN_CONTENT_FLEX_END);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[CENTER], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_ALIGN_CONTENT, 0,ALIGN_CONTENT_CENTER);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[SPACE_BETWEEN], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_ALIGN_CONTENT, 0,ALIGN_CONTENT_SPACE_BETWEEN);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[SPACE_AROUND], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_ALIGN_CONTENT, 0,ALIGN_CONTENT_SPACE_AROUND);
	} else if ((lwc_string_caseless_isequal(token->idata, c->strings[SPACE_EVENLY], &match) == lwc_error_ok && match)) {
			error = css__stylesheet_style_appendOPV(result, CSS_PROP_ALIGN_CONTENT, 0,ALIGN_CONTENT_SPACE_EVENLY);
	} else {
		error = CSS_INVALID;
	}

	if (error != CSS_OK)
		*ctx = orig_ctx;
	
	return error;
}

