/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.util;

public class LastNValues {
    private double[] lastN;
    private int seen;
    private double sumOfLastN;
    private double sumOfSquaresOfLastN;

    public LastNValues(int n) {
        this.lastN = new double[n];
    }

    public void add(double newVal) {
        double oldVal = this.replace(this.seen++ % this.lastN.length, newVal);
        this.sumOfLastN += newVal - oldVal;
        this.sumOfSquaresOfLastN += LastNValues.squared(newVal) - LastNValues.squared(oldVal);
    }

    private double replace(int i, double d) {
        double tmp = this.lastN[i];
        this.lastN[i] = d;
        return tmp;
    }

    public boolean isFull() {
        return this.seen >= this.lastN.length;
    }

    public double mean() {
        return this.sumOfLastN / (double)this.size();
    }

    public double variance() {
        return this.sumOfSquaresOfLastN / (double)this.size() - LastNValues.squared(this.mean());
    }

    public double stddev() {
        return Math.sqrt(this.variance());
    }

    public double normalizedStddev() {
        return this.stddev() / this.mean();
    }

    private int size() {
        return Math.min(this.lastN.length, this.seen);
    }

    private static double squared(double d) {
        return d * d;
    }
}

