/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DragTracker;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;

public class DefaultDragTracker
extends AbstractTool
implements DragTracker {
    protected Figure anchorFigure;
    protected Rectangle2D.Double dragRect;
    protected Point2D.Double previousOrigin;
    protected Point2D.Double anchorOrigin;
    protected Point2D.Double previousPoint;
    protected Point2D.Double anchorPoint;
    private boolean isDragging;

    public DefaultDragTracker(Figure figure) {
        this.anchorFigure = figure;
    }

    public DefaultDragTracker() {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateCursor(this.editor.findView((Container)mouseEvent.getSource()), mouseEvent.getPoint());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        DrawingView drawingView = this.getView();
        if (mouseEvent.isShiftDown()) {
            drawingView.setHandleDetailLevel(0);
            drawingView.toggleSelection(this.anchorFigure);
            if (!drawingView.isFigureSelected(this.anchorFigure)) {
                this.anchorFigure = null;
            }
        } else if (!drawingView.isFigureSelected(this.anchorFigure)) {
            drawingView.setHandleDetailLevel(0);
            drawingView.clearSelection();
            drawingView.addToSelection(this.anchorFigure);
        }
        if (!drawingView.getSelectedFigures().isEmpty()) {
            this.dragRect = null;
            for (Figure figure : drawingView.getSelectedFigures()) {
                if (this.dragRect == null) {
                    this.dragRect = figure.getBounds();
                    continue;
                }
                this.dragRect.add(figure.getBounds());
            }
            this.anchorPoint = this.previousPoint = drawingView.viewToDrawing(this.anchor);
            this.anchorOrigin = this.previousOrigin = new Point2D.Double(this.dragRect.x, this.dragRect.y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        DrawingView drawingView = this.getView();
        if (!drawingView.getSelectedFigures().isEmpty()) {
            if (!this.isDragging) {
                this.isDragging = true;
                this.updateCursor(this.editor.findView((Container)mouseEvent.getSource()), new Point(mouseEvent.getX(), mouseEvent.getY()));
            }
            Point2D.Double double_ = drawingView.viewToDrawing(new Point(mouseEvent.getX(), mouseEvent.getY()));
            this.dragRect.x += double_.x - this.previousPoint.x;
            this.dragRect.y += double_.y - this.previousPoint.y;
            Rectangle2D.Double double_2 = (Rectangle2D.Double)this.dragRect.clone();
            if (drawingView.getConstrainer() != null) {
                drawingView.getConstrainer().constrainRectangle(double_2);
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(double_2.x - this.previousOrigin.x, double_2.y - this.previousOrigin.y);
            Constrainer constrainer = drawingView.getConstrainer();
            for (Figure figure : drawingView.getSelectedFigures()) {
                figure.willChange();
                figure.transform(affineTransform);
                figure.changed();
            }
            this.previousPoint = double_;
            this.previousOrigin = new Point2D.Double(double_2.x, double_2.y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        DrawingView drawingView = this.getView();
        if (!drawingView.getSelectedFigures().isEmpty()) {
            boolean bl;
            this.isDragging = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.updateCursor(this.editor.findView((Container)mouseEvent.getSource()), new Point(n, n2));
            Point2D.Double double_ = drawingView.viewToDrawing(new Point(n, n2));
            LinkedList<Figure> linkedList = new LinkedList<Figure>(drawingView.getSelectedFigures());
            Figure figure = this.getDrawing().findFigureExcept(double_, linkedList);
            if (figure != null && (bl = figure.handleDrop(double_, linkedList, drawingView))) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(this.anchorOrigin.x - this.previousOrigin.x, this.anchorOrigin.y - this.previousOrigin.y);
                Constrainer constrainer = drawingView.getConstrainer();
                for (Figure figure2 : linkedList) {
                    figure2.willChange();
                    figure2.transform(affineTransform);
                    figure2.changed();
                }
                this.fireToolDone();
                return;
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(-this.anchorOrigin.x + this.previousOrigin.x, -this.anchorOrigin.y + this.previousOrigin.y);
            if (!affineTransform.isIdentity()) {
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(linkedList, affineTransform));
            }
        }
        this.fireToolDone();
    }

    @Override
    public void setDraggedFigure(Figure figure) {
        this.anchorFigure = figure;
    }
}

