/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class ApplyAttributesAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
    private Set<AttributeKey> excludedAttributes = new HashSet<AttributeKey>(Arrays.asList(AttributeKeys.TRANSFORM, AttributeKeys.TEXT));

    public ApplyAttributesAction(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.labels.configureAction(this, "edit.applyAttributes");
        this.setEnabled(true);
    }

    public void setExcludedAttributes(Set<AttributeKey> set) {
        this.excludedAttributes = set;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.applyAttributes();
    }

    public void applyAttributes() {
        DrawingEditor drawingEditor = this.getEditor();
        CompositeEdit compositeEdit = new CompositeEdit(this.labels.getString("edit.applyAttrbutes.text"));
        DrawingView drawingView = this.getView();
        drawingView.getDrawing().fireUndoableEditHappened(compositeEdit);
        for (Figure figure : drawingView.getSelectedFigures()) {
            figure.willChange();
            for (Map.Entry<AttributeKey, Object> entry : drawingEditor.getDefaultAttributes().entrySet()) {
                if (this.excludedAttributes.contains(entry.getKey())) continue;
                figure.set(entry.getKey(), entry.getValue());
            }
            figure.changed();
        }
        drawingView.getDrawing().fireUndoableEditHappened(compositeEdit);
    }

    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

