/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef yf_LAYOUT_HPP_INCLUDED
#define yf_LAYOUT_HPP_INCLUDED

#include <QString>

const size_t keyboardRowCount = 4;
class Layout
{
 public:
	void read(const QString& path);
	bool containsKey(QChar key) const;
	int charsInRow(size_t row) const;
	QChar getSmallChar(size_t row, int index) const;
	QChar getBigChar(size_t row, int index) const;
	bool isAdmissibleFortune(const QString& text) const;
	QString getLayoutFortuneParam() const;
	QChar getRandomChar() const;

 private:
	QString smallLetters[keyboardRowCount];
	QString bigLetters[keyboardRowCount];
	QString lastPath;
	QString layoutFortuneParam;
};

#endif

