/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;

public class DSIPool {
    protected Hashtable mPool = new Hashtable();
    protected Logger mLogger = LoggerUtils.getLogger(this);
    protected Reclaimer mReclaimThread = new Reclaimer(90000L);
    static DSIPool mInstance = null;

    protected DSIPool() {
        this.mReclaimThread.start();
        CMCSProperties.getCMCSProperties();
        Vector ports = CMCSProperties.getPropertyAsVector("selfsignedcerts");
        if (ports != null && ports.size() > 0) {
            for (int idx = 0; idx < ports.size(); ++idx) {
                Protocol p = new Protocol("https", new EasySSLProtocolSocketFactory(), Integer.parseInt((String)ports.get(idx)));
                Protocol.registerProtocol("https", p);
            }
        }
    }

    public static DSIPool getDSIPool() {
        if (mInstance == null) {
            mInstance = new DSIPool();
        }
        return mInstance;
    }

    public synchronized void destroy() {
        this.mReclaimThread.interrupt();
        Enumeration keys = this.mPool.keys();
        while (keys.hasMoreElements()) {
            Vector v = (Vector)this.mPool.get(keys.nextElement());
            for (int idx = v.size() - 1; idx >= 0; --idx) {
                ((DSI)v.get(idx)).close();
            }
        }
        this.mPool.clear();
    }

    public synchronized void reclaim(String user) {
        Enumeration keys = this.mPool.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.endsWith(user)) {
                Vector v = (Vector)this.mPool.get(key);
                for (int idx = v.size() - 1; idx >= 0; --idx) {
                    ((DSI)v.get(idx)).close();
                }
            }
            this.mPool.remove(key);
        }
    }

    public synchronized DSI getConnection(String url, String user, String auth) {
        DSI ret = null;
        String hashKey = this.createHashKey(url, user);
        Vector dsis = (Vector)this.mPool.get(hashKey);
        if (dsis != null && dsis.size() > 0) {
            ret = (DSI)dsis.remove(dsis.size() - 1);
            ret.setURL(url);
            this.mLogger.info("Returning POOLED connection." + hashKey);
        } else {
            ret = new DSI(url, user, auth);
            this.mLogger.info("Returning NEW connection." + hashKey);
        }
        return ret;
    }

    public synchronized DSI getConnection(String url) {
        DSI ret = null;
        String hashKey = this.createHashKey(url, "");
        Vector dsis = (Vector)this.mPool.get(hashKey);
        if (dsis != null && dsis.size() > 0) {
            ret = (DSI)dsis.remove(dsis.size() - 1);
            ret.setURL(url);
            this.mLogger.info("Returning POOLED connection." + ret);
        } else {
            ret = new DSI(url);
            this.mLogger.info("Returning NEW connection." + ret);
        }
        return ret;
    }

    public synchronized void release(DSI dsi) {
        String user;
        String url = dsi.getURL();
        String hashKey = this.createHashKey(url, user = dsi.getUser());
        Vector<DSI> dsis = (Vector<DSI>)this.mPool.get(hashKey);
        if (dsis == null) {
            dsis = new Vector<DSI>();
            this.mPool.put(hashKey, dsis);
        }
        this.mLogger.info("Releasing connection." + dsi);
        dsis.add(dsi);
    }

    protected synchronized String createHashKey(String urlstr, String user) {
        String key = "";
        try {
            URL url = new URL(urlstr);
            key = url.getHost();
            String protocol = url.getProtocol();
            int port = url.getPort();
            if (!(port == -1 || port == 80 && protocol.equals("http") || port == 8443 && protocol.equals("https"))) {
                key = key + port;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        key = key + user;
        return key;
    }

    private class Reclaimer
    extends Thread {
        protected long mReclaimIntervalTime = 90000L;

        public Reclaimer() {
        }

        public Reclaimer(long interval) {
            this.mReclaimIntervalTime = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    this.join(this.mReclaimIntervalTime);
                }
                catch (InterruptedException ex) {
                    break;
                }
                int cnt = 0;
                Hashtable hashtable = DSIPool.this.mPool;
                synchronized (hashtable) {
                    Enumeration keys = DSIPool.this.mPool.keys();
                    while (keys.hasMoreElements()) {
                        Vector v = (Vector)DSIPool.this.mPool.get(keys.nextElement());
                        cnt += v.size();
                    }
                }
                DSIPool.this.mLogger.info("Number of connections in pool: " + cnt);
            }
        }
    }
}

