/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.upload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;

public class FileHandler {
    public static String PARAMETER_NAME_FILENAME = "_fileuploader_filename";
    public static String PARAMETER_NAME_FILESIZE = "_fileuploader_filesize";
    public static String PARAMETER_NAME_FILENAME_SAVED = "_fileuploader_filename_saved";
    public static String PARAMETER_NAME_ENCODING = "_fileuploader_encoding";
    public static String PARAMETER_NAME_CONTENT_TYPE = "_fileuploader_content-type";
    private static final byte[] CRLF2 = new byte[]{13, 10, 13, 10};
    private static int readbuffersize = 4096;
    private static int writebuffersize = 4096;
    private byte[] readbuffer = new byte[readbuffersize];
    private int storebuffersize;
    private byte[] storebuffer = null;
    private byte[] writebuffer = new byte[writebuffersize];
    private long maxdata = 0L;
    private int boundarysize;
    private byte[] boundary = null;
    private String fieldname;
    private String filename;
    private String contenttype;
    private HttpServletRequest req;
    private HttpServletResponse res;
    private ParameterParser pp;
    private String root;

    public static boolean isSimpleForm(HttpServletRequest req) {
        String header = req.getHeader("Content-Type");
        return header == null || header.indexOf("multipart/form-data") < 0;
    }

    /*
     * WARNING - void declaration
     */
    private void copyStream(InputStream ins, OutputStream outs) throws IOException {
        int bufread;
        BufferedInputStream bis = new BufferedInputStream(ins, writebuffersize);
        BufferedOutputStream bos = new BufferedOutputStream(outs, writebuffersize);
        while ((bufread = bis.read(this.writebuffer)) != -1) {
            void var5_5;
            bos.write(this.writebuffer, 0, (int)var5_5);
        }
        bos.flush();
        bos.close();
        bis.close();
    }

    public void writeFileToResponse(String savedname, String filename, String contenttype) throws Exception {
        String fullPath = this.root + "/" + savedname;
        File f = new File(fullPath);
        try {
            Class[] sig = new Class[]{Integer.TYPE};
            Object[] param = new Object[]{new Integer(writebuffersize)};
            Method method = this.res.getClass().getDeclaredMethod("setBufferSize", sig);
            method.invoke((Object)this.res, param);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.res.setContentLength((int)f.length());
        this.res.setContentType(contenttype);
        this.res.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        this.res.setDateHeader("Date", new Date().getTime());
        this.res.setDateHeader("Expires", new Date().getTime());
        this.res.setIntHeader("Age", 0);
        this.res.setIntHeader("Retry-After", 60);
        this.res.setHeader("Pragma", "no-cache");
        this.res.setHeader("Connection", "Keep-Alive");
        this.copyStream(new FileInputStream(fullPath), (OutputStream)this.res.getOutputStream());
    }

    private String getRandomName() {
        String name = null;
        String fullpath = null;
        File f = null;
        do {
            name = "upload" + System.currentTimeMillis() + "_";
        } while ((f = new File(fullpath = this.root + "/" + name)).exists());
        return name;
    }

    private String getShortName(String fullname) {
        int pos;
        int n;
        int lastbackslash;
        int lastslash = fullname.lastIndexOf("/");
        if (lastslash == (lastbackslash = fullname.lastIndexOf("\\"))) {
            n = -1;
        } else if (lastslash > lastbackslash) {
            n = lastslash + 1;
        } else {
            pos = lastbackslash + 1;
        }
        return fullname.substring(pos);
    }

    private int findByte(byte b, int pos) {
        if (pos < 0) {
            pos = 0;
        } else if (pos >= this.storebuffersize) {
            return -1;
        }
        int i = pos;
        while (i < this.storebuffersize) {
            if (this.storebuffer[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int findSubArray(byte[] subarray, int pos) {
        int sublen = subarray.length;
        int sp = 0;
        int maxpos = this.storebuffersize - sublen;
        int first = pos;
        while (sp != sublen && first <= maxpos) {
            if ((first = this.findByte(subarray[0], first)) < 0 || first > maxpos) {
                return -1;
            }
            sp = 1;
            while (sp < sublen) {
                if (this.storebuffer[first + sp] != subarray[sp]) {
                    sp = sublen;
                }
                ++sp;
            }
            ++first;
        }
        if (sublen == 0) {
            return 0;
        }
        if (sp == sublen) {
            return first - 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private void readToStoreBuffer(InputStream instream) throws IOException {
        int bufread;
        int pos = 0;
        BufferedInputStream bis = new BufferedInputStream(instream, readbuffersize);
        while ((bufread = bis.read(this.readbuffer)) != -1 && (this.maxdata >= (long)pos || this.maxdata == 0L)) {
            void var2_4;
            System.arraycopy(this.readbuffer, 0, this.storebuffer, pos, (int)var2_4);
            pos += var2_4;
        }
        bis.close();
    }

    private void getHeaderInfo(int start, int end) {
        String temp = new String(this.storebuffer, start, end - start + 1);
        this.contenttype = null;
        this.filename = null;
        int conttypestart = temp.indexOf("Content-Type: ");
        if (conttypestart >= 0) {
            int conttypeend = temp.length() - 1;
            this.contenttype = temp.substring(conttypestart += 14, conttypeend);
        }
        int namestart = temp.indexOf("; name=\"") + 8;
        int nameend = temp.indexOf("\"", namestart);
        this.fieldname = temp.substring(namestart, nameend);
        int filenamestart = temp.indexOf("; filename=\"", nameend + 1);
        if (filenamestart >= 0) {
            int filenameend = temp.indexOf("\"", filenamestart += 12);
            this.filename = temp.substring(filenamestart, filenameend);
        }
    }

    private String getChunkAsText(int start, int end) {
        String text = new String(this.storebuffer, start, end - start + 1);
        return text;
    }

    private void storeChunk(int start, int end, OutputStream outstream) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(outstream, readbuffersize);
        bos.write(this.storebuffer, start, end - start + 1);
        bos.flush();
        bos.close();
    }

    /*
     * WARNING - void declaration
     */
    private void writeChunks() throws IOException {
        void var1_5;
        int c = 0;
        String savename = null;
        String param = null;
        int b = this.findSubArray(this.boundary, 0);
        do {
            int a;
            if ((a = this.findSubArray(CRLF2, b + this.boundarysize)) < 0) continue;
            b = this.findSubArray(this.boundary, a + 4);
            if (b >= 0) {
                // empty if block
            }
            this.getHeaderInfo(c, a);
            c = b;
            if (this.filename == null || this.filename.length() == 0) {
                param = this.getChunkAsText(a + 4, b - 5);
                Log.info("FileUploader: received field: " + this.fieldname + "=" + param);
                this.pp.add(this.fieldname, param);
                continue;
            }
            String shortname = this.getShortName(this.filename);
            savename = this.getRandomName() + shortname + ".dat";
            String fullPath = this.root + "/" + savename;
            Log.info("FileUploader: received file: field=" + this.fieldname + ", fullpath=" + this.filename + ", filename=" + shortname + ", saved to file: " + fullPath);
            this.storeChunk(a + 4, b - 5, new FileOutputStream(fullPath));
            File f = new File(fullPath);
            this.pp.add(PARAMETER_NAME_FILESIZE, f.length());
            this.pp.add(PARAMETER_NAME_FILENAME, shortname);
            this.pp.add(PARAMETER_NAME_FILENAME_SAVED, savename);
            this.pp.add(PARAMETER_NAME_CONTENT_TYPE, this.contenttype);
        } while (var1_5 >= 0 && b >= 0);
    }

    public void saveStream() throws ServletException, IOException {
        this.readToStoreBuffer((InputStream)this.req.getInputStream());
        this.writeChunks();
    }

    public void setFileRepository(String root) {
        this.root = root;
    }

    public String getFileRepository() {
        return this.root;
    }

    public void setMaxSize(long size) {
        this.maxdata = size;
    }

    public boolean deleteFile(String filename) {
        File f = new File(this.root + "/" + filename);
        return f.delete();
    }

    public FileHandler(HttpServletRequest req, HttpServletResponse res, ParameterParser pp) {
        this.req = req;
        this.res = res;
        this.pp = pp;
        this.root = "c:";
        String conttype = req.getHeader("Content-Type");
        if (conttype != null) {
            this.boundary = conttype.substring(conttype.indexOf("boundary") + 9).getBytes();
            this.boundarysize = this.boundary.length;
            this.storebuffersize = Integer.parseInt(req.getHeader("Content-Length"));
            this.storebuffer = new byte[this.storebuffersize];
        }
    }

    public FileHandler(HttpServletRequest req, HttpServletResponse res, ParameterParser pp, String root) {
        this(req, res, pp);
        this.setFileRepository(root);
    }

    public FileHandler(HttpServletRequest req, ParameterParser pp, String root) {
        this(req, null, pp);
        this.setFileRepository(root);
    }

    public FileHandler(RunData data, String root) {
        this(data.getRequest(), data.getResponse(), data.getParameters(), root);
    }

    public FileHandler(RunData data) {
        this(data.getRequest(), data.getResponse(), data.getParameters());
    }
}

