# -*- coding: utf-8 -*-
#
# SasView documentation build configuration file, created by
# sphinx-quickstart on Wed Aug 28 14:59:44 2013.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.
from __future__ import print_function

import sys, os, collections

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
from distutils.util import get_platform
platform = '.%s-%s'%(get_platform(),sys.version[:3])
build_lib = os.path.abspath('../../../build/lib'+platform)
sys.path.insert(0, build_lib)
sys.path.insert(0, os.path.abspath('_extensions')) # for sphinx extensions
print("-- path --")
print("\n".join(sys.path))

#need to import src.sas.sasview init to access version number and dates
#use abspath as above to locate then import
sasview_path = os.path.abspath('../../../src/sas')
sys.path.append(sasview_path)
import sas.sasview

# -- General configuration -----------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = ['sphinx.ext.autodoc',
              'sphinx.ext.todo',
              'sphinx.ext.coverage',
              'sphinx.ext.mathjax',
              #'mathjax',  # replacement mathjax that allows a list of paths
              'dollarmath',
              'sphinx.ext.viewcode']

mathjax_path = (
    'https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.1/MathJax.js?'
    'config=TeX-MML-AM_CHTML')

# For katex uncomment the following
"""
#STATIC_PATH = '../../_static/'
STATIC_PATH = ''
mathjax_path = [
    STATIC_PATH + 'katex/katex.min.js',
    STATIC_PATH + 'katex/contrib/auto-render.min.js',
    STATIC_PATH + 'rendermath.js'
]
mathjax_css = STATIC_PATH + 'katex/katex.min.css'
"""


# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
copyright_date = sas.sasview.__release_date__
project = u'SasView'
copyright = u'%s, The SasView Project' % copyright_date

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = ".".join(sas.sasview.__version__.split(".", 2)[0:2]) 
# The full version, including ax/bx tags Note strict version is enforced.
release = sas.sasview.__version__

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
#
# PGP 2014/04/03: We have some code which doesn't get carried over to
# the build directory.  Exclude the appropriate *.rst files here so
# that we don't get various "ImportError: No module named ___" when
# running Sphinx.
exclude_patterns = ["*sas.sasgui.perspectives.simulation.rst",
                    "*sas.sascalc.pr.c_extensions.rst",
                    "*sas.sascalc.realspace.rst",
                    "*sas.sascalc.simulation.rst",
                    "*sas.sasview.setup_exe.rst",
                    "*sas.sasview.setup_mac.rst",
                    "*sas.sasgui.guiframe.custom_pstats.rst", # pstats not in standard library on Ubuntu out of the box
                    ]

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
#keep_warnings = False


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'default'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
#html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
#html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_domain_indices = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
#html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = 'SasViewdoc'

# Turn off permalinks, which are a nice feature for the docs when viewed in a
# browser, but which look weird (and cannot be "right-click->copy url") in
# the SasView help.
html_add_permalinks = ""


# -- Options for LaTeX output --------------------------------------------------

# TODO: seems like angstroms is defined twice.
LATEX_PREAMBLE=r"""
\usepackage[utf8]{inputenc}      % Allow unicode symbols in text
\newcommand{\lt}{<}              % HTML needs \lt rather than <
\newcommand{\gt}{>}              % HTML needs \gt rather than >
\renewcommand{\AA}{\text{\r{A}}} % Allow \AA in math mode
\DeclareUnicodeCharacter {212B} {\AA}                  % Angstrom
\DeclareUnicodeCharacter {00B7} {\ensuremath{\cdot}}   % cdot
\DeclareUnicodeCharacter {00B0} {\ensuremath{^\circ}}  % degrees
"""
latex_elements = {
# The paper size ('letterpaper' or 'a4paper').
'papersize': 'a4paper',

# The font size ('10pt', '11pt' or '12pt').
#'pointsize': '10pt',

# Additional stuff for the LaTeX preamble.
'preamble': LATEX_PREAMBLE

}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
  ('index', 'SasView.tex', u'SasView Documentation',
   u'The SasView Project', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# If true, show page references after internal links.
#latex_show_pagerefs = False

# If true, show URL addresses after external links.
#latex_show_urls = False

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_domain_indices = True


# -- Options for manual page output --------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ('index', 'sasview', u'SasView Documentation',
     [u'The SasView Project'], 1)
]

# If true, show URL addresses after external links.
#man_show_urls = False


# -- Options for Texinfo output ------------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
  ('index', 'SasView', u'SasView Documentation',
   u'The SasView Project', 'SasView', 'One line description of project.',
   'Miscellaneous'),
]

# Documents to append as an appendix to all manuals.
#texinfo_appendices = []

# If false, no module index is generated.
#texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
#texinfo_show_urls = 'footnote'

# If true, do not generate a @detailmenu in the "Top" node's menu.
#texinfo_no_detailmenu = False

if os.path.exists('rst_prolog'):
    with open('rst_prolog') as fid:
        rst_prolog = fid.read()

numfig = True
