/*
 * Implement 'ampgr cancel' functionality
 */
#include "basil_alps.h"

int main(int argc, char **argv)
{
	if (geteuid())
		errx(1, "this program can only be run by root");

	if (argc == 1)
		errx(1, "need one or more ALPS reservation IDs");

	while (--argc) {
		int res_id = atoi(*++argv);

		if (res_id <= 0) {
			warnx("invalid ALPS reservation ID '%s'", *argv);
		} else {
			int rc = basil_safe_release(res_id, NULL);

			if (rc < 0)
				warnx("could not release reservation #%d: %s",
				      res_id, basil_strerror(rc));
		}
	}
	return EXIT_SUCCESS;
}
