7.1 演奏中のシンセ制御

# 演奏中のシンセ制御

これまでは、新しいサウンドとエフェクトを引き起こす方法について触れてきたただけ見てきましたが、Sonic Piは、演奏中の音を操り、処理する機能を備えています。シンセ扱うためには、変数を用います。

```
s = play 60, release: 5
```

これはローカル変数`s`が音符60の演奏を処理することを表しています。
このローカル変数は、例えば別の関数といった他の機能からアクセスすることはできません。
一度`s`を用意すれば`control`関数を介して制御することができます。

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

演奏している間に、1つのシンセのみを呼び出し、3回ピッチを変更します。ここで注目すべき点は、4つの異なるシンセを呼び出していないということです。

標準的なオプション（関数）は`control`へ渡すことができます。そして`amp:`, `cutoff:`あるいは`pan:`のようなオプションを制御することができます。

## 制御不可能なオプション

一度シンセが開始されると、一部のオプションは制御することができなくなります。ADSRエンベロープ·パラメータがこれに該当します。そのオプションが制御可能かは、ヘルプシステムのドキュメントを参照してください。ドキュメントに「設定を変更することは出来ません」というコメントがある場合、シンセが開始した後にオプションを制御することはできません。
