5.6 Zmienne

# Zmienne

Przydatną rzeczą, którą możesz robić w swoim kodzie jest tworzenie 
nazw dla różnych rzeczy. Sonic Pi sprawia, że jest to bardzo łatwe, 
wpisujesz nazwę, której chciałbyś użyć, znak równości (`=`), następnie 
rzecz, którą chcialbyś zapamiętać: 

```
sample_name = :loop_amen
```

W powyższym kawałku kodu 'zapisaliśmy' wartość symbolu `:loop_amen` 
w zmiennej `sample_name`. Od teraz możemy używać nazwy `sample_name` 
wszędzie, gdzie do tej pory użylibyśmy sampla `:loop_amen`. Na przykład: 

```
sample_name = :loop_amen
sample sample_name
```

Są trzy podstawowe powody na korzystanie ze zmiennych w Sonic Pi: 
komunikowanie znaczenia, zarządzanie powtórzeniami oraz przechwytywanie 
wyników różnych rzeczy.

## Komunikowanie Znaczenia

Kiedy piszesz kod łatwo jest myśleć, że jedyne co robisz to mówisz 
komputerowi jak ma wykonać jakieś rzeczy - tak długo jak komputer rozumie 
co do niego mówisz to jest w porządku. Jednakże, ważne jest aby pamiętać 
że nie tylko komputer czyta kod. Inni ludzie również mogą chcieć przeczytać 
go i spróbować zrozumieć co się w nim dzieje. Ponadto, bardzo prawdopodobne, 
że Ty również będziesz czytał swój własny kod w przyszłości i próbował 
zrozumieć o co w nim chodzi. Chociaż w tej chwili jego znaczenie może być 
dla Ciebie oczywiste - może nie być takie oczywiste dla innych lub nawet 
dla Ciebie samego w przyszłości!

Jedną z metod, która pomoże innym zrozumieć co twój kod robi jest pisanie 
komentarzy (co widzieliśmy już we wcześniejszej sekcji tego samouczka). 
Inną jest używanie takich nazw dla zmiennych, które coś znaczą. 
Spójrz na poniższy kod: 

```
sleep 1.7533
```

Dlaczego używa on liczby `1.7533`? Skąd wzięła się ta liczba? Co ona 
oznacza? A teraz, spójrz na poniższy kod:

```
loop_amen_duration = 1.7533
sleep loop_amen_duration
```

Teraz, zrozumienie tego co oznacza liczba `1.7533` jest znacznie prostsze: 
oznacza ona dłuość trwania sampla `:loop_amen`! Oczywiście, możesz zapytać, 
dlaczego po prostu nie napisaliśmy: 

```
sleep sample_duration(:loop_amen)
```

Co, jak najbardziej, jest bardzo fajnym sposobem zakomunikowania intencji 
zawartych w kodzie.

## Zarządzanie Powtórzeniami

Często widzisz dużo powtórzeń w twoim kodzie i kiedy chcesz coś zmienić, 
musisz zmienić to w wielu miejscach. Spójrz na poniższy kawałek kodu:

```
sample :loop_amen
sleep sample_duration(:loop_amen)
sample :loop_amen, rate: 0.5
sleep sample_duration(:loop_amen, rate: 0.5)
sample :loop_amen
sleep sample_duration(:loop_amen)
```

Robiliśmy tutaj sporo rzeczy z samplem `:loop_amen`! Co jeśli 
chcielibyśmy usłyszeć, jak ten kawałek kodu brzmi z innym samplem, 
na przykład `:loop_garzul`? Musielibyśmy wtedy znaleźć i zamienić 
wszystkie wystąpienia sampla `:loop_amen` na `:loop_garzul`. To może 
być całkiem w porządku jeśli masz dużo czasu - ale co jeśli właśnie 
występujesz na scenie? Czasami nie masz tego luksusu, że masz czasu 
tyle ile chcesz - zwłaszcza gdy chcesz utrzymać ludzi na parkiecie. 

A co jeśli powyższy kawałek kodu przepiszemy na coś takiego: 

```
sample_name = :loop_amen
sample sample_name
sleep sample_duration(sample_name)
sample sample_name, rate: 0.5
sleep sample_duration(sample_name, rate: 0.5)
sample sample_name
sleep sample_duration(sample_name)
```

Teraz, ten kod robi dokładnie to samo co wcześniejszy (spróbuj). Oprócz 
tego daje na możliwość zmiany tylko jednej linijki z obecnej 
`sample_name = :loop_amen` na `sample_name = :loop_garzul` aby 
jednocześnie zmienić brzmienie w wielu miejscach dzięki magii zmiennych.

## Przechwytywanie Wyników

I na koniec, dobrą powodem do używania zmiennych jest przechwytywanie 
wyniku wykonania różnych rzeczy. Na przykład, możesz chcieć robić różne 
rzeczy z długością trwania sampla: 

```
sd = sample_duration(:loop_amen)
```

Możemy teraz używać zmiennej `sd` wszędzie gdzie potrzebujemy użyć 
długości trwania sampla `:loop_amen`.

Możliwe, że nawet bardziej ważne jest to, że zmienne pozwalają nam 
na przechwycenie i zapisanie wyniku uruchomienia polecenia `play` 
lub `sample`: 

```
s = play 50, release: 8
```

Teraz złapaliśmy i zapamiętaliśmy `s` jako zmienną, co pozwala nam 
na kontrolę syntezatora w trakcie jego działania:

```
s = play 50, release: 8
sleep 2
control s, note: 62
```

Przyjrzymy się bardziej kontrolowaniu syntezatorów w kolejnej sekcji. 
