#include "loginwindow.h"

#include <QProcess>
#include <QCoreApplication>

LoginWindow::LoginWindow(QWidget *parent)
    : DDialog(parent)
    , m_usernameEdit(new DPasswordEdit)
    , m_passwordEdit(new DPasswordEdit)
{
    setTitle(tr("UOS Login"));

    setIcon(QIcon::fromTheme("uos"));

    m_usernameEdit->setEchoMode(QLineEdit::EchoMode::Normal);
    m_usernameEdit->setEchoButtonIsVisible(false);

    m_usernameEdit->lineEdit()->setPlaceholderText(tr("Input Username"));
    m_passwordEdit->lineEdit()->setPlaceholderText(tr("Input Password"));

    m_usernameEdit->lineEdit()->setFocus();

    addSpacing(10);
    addContent(m_usernameEdit);
    addSpacing(10);
    addContent(m_passwordEdit);

    addSpacing(20);

    addButton(tr("Login"));

    setContentsMargins(20, 0, 20, 10);

    connect(this, &DDialog::buttonClicked, this, &LoginWindow::onClicked);
    connect(this, &DDialog::buttonClicked, this, &LoginWindow::setOnButtonClickedClose);
}

LoginWindow::~LoginWindow()
{

}

void LoginWindow::onClicked()
{
    if (m_usernameEdit->text().isEmpty()) {
        m_usernameEdit->showAlertMessage(tr("Username Error"));
        return;
    }

    if (m_passwordEdit->text().isEmpty()) {
        m_passwordEdit->showAlertMessage(tr("Password Error"));
        return;
    }

    auto ret =QProcess::execute("pkexec", {"/usr/bin/uos-apt-login",
                                   "l",
                                   "--username", m_usernameEdit->text(),
                                   "--password", m_passwordEdit->text()});

    if (0 <= ret && ret < 3) {
        switch (ret) {
        case 0:
            m_passwordEdit->showAlertMessage(tr("Account login successful"));
            QTimer::singleShot(1000,[=](){
            qApp->quit();
            });
            break;
        case 1:
            m_passwordEdit->showAlertMessage(tr("Wrong username or password"));
            break;
        case 2:
            m_passwordEdit->showAlertMessage(tr("Network error"));
            break;
        case 3:
            m_passwordEdit->showAlertMessage(tr("Sistem error"));
            break;
        default:
            break;
        }
        return;
    }
    else {
        qApp->quit();
    }
}
