/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DTK_WMJACK_WAYLAND_CLIENT_H
#define DTK_WMJACK_WAYLAND_CLIENT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>

typedef struct Dtk_Window_State
{
    int32_t pid;
    int32_t windowId;
    char resourceName[256];
    struct Geometry
    {
        int32_t x;
        int32_t y;
        int32_t width;
        int32_t height;
    } geometry;
    bool isMinimized;
    bool isFullScreen;
    bool isActive;
    int32_t splitable;
    char uuid[256];
} WindowState;

#ifdef __cplusplus
}
#endif

#endif
