#ifndef _UOS_RECOVERY_BTRFS_SYSTEM_H_
#define _UOS_RECOVERY_BTRFS_SYSTEM_H_
#include "SystemRecovery.h"

class BtrfsSystem : public SystemRecovery
{
    Q_OBJECT
public:
    // 分区方式是否支持btrfs快照
    bool supported(FSTabInfoList &fsTabInfoList) override;
    // 获取备份默认存放路径
    QString getDefaultBackupDeviceUUID(const QString &rootPath) override;
    // 备份系统
    ErrorCode systemBackup(const SystemBackupRequest &request) override;
    // 还原系统
    ErrorCode systemRestore(const SystemRestoreRequest &request) override;
    // 制作uimg
    ErrorCode createUImg(const QString &backupDir) override;

    BackupInfoList listSystemBackup(QStringList &destUUIDs) override;

    ErrorCode removeSystemBackup(const RemoveUserDataBackupRequest &request) override;
    ErrorCode checkFullSystemBackupSpace(SystemBackupRequest &request) override;
    ErrorCode checkIncSystemBackupSpace(const SystemBackupRequest &request) override;
};

#endif
