#pragma once
#include "utils/global.h"
#include <QString>
#include <QSharedPointer>
#include <QObject>

class DimFileRecovery : public QObject
{
    Q_OBJECT

public:
    explicit DimFileRecovery();
    ~DimFileRecovery() override;

    virtual bool dimFileTrans(const QString &dimFilePath, const QString &imgFilePath) = 0;
    virtual bool clearDimFileRestoreCfg(const QString &imgFilePath) = 0;
    virtual bool hasInitBackDimFile() = 0;
    virtual ErrorCode checkDimFileSpace(const QString &dimFilesPath) = 0;

Q_SIGNALS:
    void progressChanged(const QString &progress);
    void error(const QString &errMsg);
    void success(const QString &msg);
    void spaceCheckFinished(const QString &space);
};

typedef QSharedPointer<DimFileRecovery> DimFileRecoveryPtr;
