//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/9/23.
//

#ifndef UOS_RECOVERY_IMMUTABLE_SYSTEM_H
#define UOS_RECOVERY_IMMUTABLE_SYSTEM_H
#include "SystemRecovery.h"

class ImmutableTask;
class CheckTask;

struct SnapshotItem {
    QString id;
    QString name;
    QString time;
    QString desc;
};
typedef QList<SnapshotItem> SnapshotItemList;

class ImmutableSystem : public SystemRecovery
{
    Q_OBJECT
public:
    ImmutableSystem();
    ~ImmutableSystem();

    // 分区方式是否支持ImmutableSystem
    bool supported(FSTabInfoList &fsTabInfoList) override;
    // 获取备份默认存放路径
    QString getDefaultBackupDeviceUUID(const QString &rootPath) override;
    // 备份系统
    ErrorCode systemBackup(const SystemBackupRequest &request) override;
    // 还原系统
    ErrorCode systemRestore(const SystemRestoreRequest &request) override;
    // 制作uimg
    ErrorCode createUImg(const QString &backupDir) override;

    BackupInfoList listSystemBackup(QStringList &destUUIDs) override;

    ErrorCode removeSystemBackup(const RemoveUserDataBackupRequest &request) override;

    ErrorCode checkFullSystemBackupSpace(SystemBackupRequest &request) override;
    ErrorCode checkIncSystemBackupSpace(const SystemBackupRequest &request) override;
    virtual bool isRunning() override;
    void setFstabInfoList(const FSTabInfoList &fsTabInfoList);
    bool getSnapshotByID(const QString &id, SnapshotItem &item);

private:
    int m_osMajorVer = -1;
    int m_osMinorVer = -1;
    FSTabInfoList m_fsTabInfoList;
    ImmutableTask *m_pImmutableTask = nullptr;
    CheckTask *m_checkTask = nullptr;
};

#endif //UOS_RECOVERY_IMMUTABLE_SYSTEM_H
