# D.3 How does wealth influence the mass media?

In a word, massively. This, in turn, influences the way people see the world
and, as a result, the media is a key means by which the general population
come to accept, and support, _"the arrangements of the social, economic, and
political order."_ The media, in other words _"are vigilant guardians
protecting privilege from the threat of public understanding and
participation."_ This process ensures that state violence is not necessary to
maintain the system as _"more subtle means are required: the manufacture of
consent, [and] deceiving the masses with 'necessary illusions."_ [Noam
Chomsky, **Necessary Illusions** , pp. 13-4 and p. 19] The media, in other
words, are a key means of ensuring that the dominant ideas within society are
those of the dominant class.

Noam Chomsky has helped develop a detailed and sophisticated analyse of how
the wealthy and powerful use the media to propagandise in their own interests
behind a mask of objective news reporting. Along with Edward Herman, he has
developed the _**"Propaganda Model"**_ of the media works. Herman and Chomsky
expound this analysis in their book **Manufacturing Consent: The Political
Economy of the Mass Media** , whose main theses we will summarise in this
section (unless otherwise indicated all quotes are from this work). We do not
suggest that we can present anything other than a summary here and, as such,
we urge readers to consult **Manufacturing Consent** itself for a full
description and extensive supporting evidence. We would also recommend
Chomsky's **Necessary Illusions** for a further discussion of this model of
the media.

Chomsky and Herman's "propaganda model" of the media postulates a set of five
_"filters"_ that act to screen the news and other material disseminated by the
media. These _"filters"_ result in a media that reflects elite viewpoints and
interests and mobilises _"support for the special interests that dominate the
state and private activity."_ [ **Manufacturing Consent** , p. xi] These
_"filters"_ are: (1) the size, concentrated ownership, owner wealth, and
profit orientation of the dominant mass-media firms; (2) advertising as the
primary income source of the mass media; (3) the reliance of the media on
information provided by government, business, and "experts" funded and
approved by these primary sources and agents of power; (4) _"flak"_ (negative
responses to a media report) as a means of disciplining the media; and (5)
_"anticommunism"_ as a national religion and control mechanism. It is these
filters which ensure that genuine objectivity is usually lacking in the media
(needless to say, some media, such as Fox news and the right-wing newspapers
like the UK's Sun, Telegraph and Daily Mail, do not even try to present an
objective perspective).

_"The raw material of news must pass through successive filters leaving only
the cleansed residue fit to print,"_ Chomsky and Herman maintain. The filters
_"fix the premises of discourse and interpretation, and the definition of what
is newsworthy in the first place, and they explain the basis and operations of
what amount to propaganda campaigns."_ [p. 2] We will briefly consider the
nature of these five filters below before refuting two common objections to
the model. As with Chomsky and Herman, examples are mostly from the US media.
For more extensive analysis, we would recommend two organisations which study
and critique the performance of the media from a perspective informed by the
"propaganda model." These are the American **Fairness & Accuracy In
Reporting** (FAIR) and the UK based **MediaLens** (neither, it should be
pointed out, are anarchist organisations).

Before discussing the "propaganda model", we will present a few examples by
FAIR to show how the media reflects the interests of the ruling class. War
usually provides the most obvious evidence for the biases in the media. For
example, Steve Rendall and Tara Broughel analysed the US news media during the
first stage of the 2003 invasion of Iraq and found that official voices
dominated it _"while opponents of the war have been notably
underrepresented,"_ Nearly two-thirds of all sources were pro-war, rising to
71% of US guests. Anti-war voices were a mere 10% of all sources, but just 6%
of non-Iraqi sources and 3% of US sources. _"Thus viewers were more than six
times as likely to see a pro-war source as one who was anti-war; with U.S.
guests alone, the ratio increases to 25 to 1."_ Unsurprisingly, official
voices, _"including current and former government employees, whether civilian
or military, dominated network newscasts"_ (63% of overall sources). Some
analysts did criticise certain aspects of the military planning, but such
_"the rare criticisms were clearly motivated by a desire to see U.S. military
efforts succeed."_ While dissent was quite visible in America, _"the networks
largely ignored anti-war opinion."_ FAIR found that just 3% of US sources
represented or expressed opposition to the war in spite of the fact more than
one in four Americans opposed it. In summary, _"none of the networks offered
anything resembling proportionate coverage of anti-war voices"_. [
_"Amplifying Officials, Squelching Dissent"_ , **Extra!** May/June 2003]

This perspective is common during war time, with the media's rule of thumb
being, essentially, that to support the war is to be objective, while to be
anti-war is to carry a bias. The media repeats the sanitised language of the
state, relying on official sources to inform the public. Truth-seeking
independence was far from the media agenda and so they made it easier for
governments to do what they always do, that is lie. Rather than challenge the
agenda of the state, the media simply foisted them onto the general
population. Genuine criticism only starts to appear when the costs of a
conflict become so high that elements of the ruling class start to question
tactics and strategy. Until that happens, any criticism is minor (and within a
generally pro-war perspective) and the media acts essentially as the fourth
branch of the government rather than a Fourth Estate. The Iraq war, it should
be noted, was an excellent example of this process at work. Initially, the
media simply amplified elite needs, uncritically reporting the Bush
Administration's pathetic "evidence" of Iraqi WMD (which quickly became
exposed as the nonsense it was). Only when the war became too much of a burden
did critical views start being heard and then only in a context of being
supportive of the goals of the operation.

This analysis applies as much to domestic issues. For example, Janine Jackson
reported how most of the media fell in step with the Bush Administration's
attempts in 2006 to trumpet a "booming" U.S. economy in the face of public
disbelief. As she notes, there were _"obvious reasons [for] the majority of
Americans dissent . . . Most American households are not, in fact, seeing
their economic fortunes improve. GDP is up, but virtually all the growth has
gone into corporate profits and the incomes of the highest economic brackets.
Wages and incomes for average workers, adjusted for inflation, are down in
recent years; the median income for non-elderly households is down 4.8 percent
since 2000 . . .The poverty rate is rising, as is the number of people in
debt."_ Yet _"rather than confront these realities, and explore the
implications of the White House's efforts to deny them, most mainstream media
instead assisted the Bush team's PR by themselves feigning confusion over the
gap between the official view and the public mood."_ They did so by presenting
_"the majority of Americans' understanding of their own economic situation . .
. as somehow disconnected from reality, ascribed to 'pessimism,' ignorance or
irrationality . . . But why these ordinary workers, representing the majority
of households, should not be considered the arbiters of whether or not 'the
economy' is good is never explained."_ Barring a few exceptions, the media did
not _"reflect the concerns of average salaried workers at least as much as
those of the investor class."_ Needless to say, which capitalist economists
were allowed space to discuss their ideas, progressive economists did not. [
_"Good News! The Rich Get Richer: Lack of applause for falling wages is media
mystery,"_ **Extra!** , March/April 2006] Given the nature and role of the
media, this reporting comes as no surprise.

We stress again, before continuing, that this is a **summary** of Herman's and
Chomsky's thesis and we cannot hope to present the wealth of evidence and
argument available in either **Manufacturing Consent** or **Necessary
Illusions**. We recommend either of these books for more information on and
evidence to support the "propaganda model" of the media. Unless otherwise
indicated, all quotes in this section of the FAQ are from Herman and Chomsky's
**Manufacturing Consent**.

## D.3.1 How does the structure of the media affect its content?

Even a century ago, the number of media with any substantial outreach was
limited by the large size of the necessary investment, and this limitation has
become increasingly effective over time. As in any well developed market, this
means that there are very effective **natural** barriers to entry into the
media industry. Due to this process of concentration, the ownership of the
major media has become increasingly concentrated in fewer and fewer hands. As
Ben Bagdikian's stresses in his 1987 book **Media Monopoly** , the 29 largest
media systems account for over half of the output of all newspapers, and most
of the sales and audiences in magazines, broadcasting, books, and movies. The
_"top tier"_ of these -- somewhere between 10 and 24 systems -- along with the
government and wire services, _"defines the news agenda and supplies much of
the national and international news to the lower tiers of the media, and thus
for the general public."_ [p. 5] Since then, media concentration has
increased, both nationally and on a global level. Bagdikian's 2004 book, **The
New Media Monopoly** , showed that since 1983 the number of corporations
controlling most newspapers, magazines, book publishers, movie studios, and
electronic media have shrunk from 50 to five global-dimension firms, operating
with many of the characteristics of a cartel -- Time-Warner, Disney, News
Corporation, Viacom and Germany-based Bertelsmann.

These _"top-tier companies are large, profit-seeking corporations, owned and
controlled by very wealthy people . . . Many of these companies are fully
integrated into the financial market"_ which means that _"the pressures of
stockholders, directors and bankers to focus on the bottom line are
powerful."_ [p. 5] These pressures have intensified in recent years as media
stocks have become market favourites and as deregulation has increased
profitability and so the threat of take-overs. These ensure that these
_"control groups obviously have a special take on the status quo by virtue of
their wealth and their strategic position in one of the great institutions of
society. And they exercise the power of this strategic position, if only by
establishing the general aims of the company and choosing its top
management."_ [p. 8]

The media giants have also diversified into other fields. For example GE, and
Westinghouse, both owners of major television networks, are huge, diversified
multinational companies heavily involved in the controversial areas of weapons
production and nuclear power. GE and Westinghouse depend on the government to
subsidise their nuclear power and military research and development, and to
create a favourable climate for their overseas sales and investments. Similar
dependence on the government affect other media.

Because they are large corporations with international investment interests,
the major media tend to have a right-wing political bias. In addition, members
of the business class own most of the mass media, the bulk of which depends
for their existence on advertising revenue (which in turn comes from private
business). Business also provides a substantial share of "experts" for news
programmes and generates massive "flak." Claims that the media are "left-
leaning" are sheer disinformation manufactured by the "flak" organisations
described below (in [section D.3.4](secD3.md#secd34)). Thus Herman and
Chomsky:

> _"the dominant media forms are quite large businesses; they are controlled
> by very wealthy people or by managers who are subject to sharp constraints
> by owners and other market-profit-oriented forces; and they are closely
> interlocked, and have important common interests, with other major
> corporations, banks, and government. This is the first powerful filter that
> effects news choices."_ [p. 14]

Needless to say, reporters and editors will be selected based upon how well
their work reflects the interests and needs of their employers. Thus a radical
reporter and a more mainstream one both of the same skills and abilities would
have very different careers within the industry. Unless the radical reporter
toned down their copy, they are unlikely to see it printed unedited or
unchanged. Thus the structure within the media firm will tend to penalise
radical viewpoints, encouraging an acceptance of the status quo in order to
further a career. This selection process ensures that owners do not need to
order editors or reporters what to do -- to be successful they will have to
internalise the values of their employers.

## D.3.2 What is the effect of advertising on the mass media?

The main business of the media is to sell audiences to advertisers.
Advertisers thus acquire a kind of de facto licensing authority, since without
their support the media would cease to be economically viable. And it is
**affluent** audiences that get advertisers interested. As Chomsky and Herman
put it, the _"idea that the drive for large audiences makes the mass media
'democratic' thus suffers from the initial weakness that its political
analogue is a voting system weighted by income!"_ [p.16]

As regards TV, in addition to _"discrimination against unfriendly media
institutions, advertisers also choose selectively among programs on the basis
of their own principles. With rare exceptions these are culturally and
politically conservative. Large corporate advertisers on television will
rarely sponsor programs that engage in serious criticisms of corporate
activities."_ Accordingly, large corporate advertisers almost never sponsor
programs that contain serious criticisms of corporate activities, such as
negative ecological impacts, the workings of the military-industrial complex,
or corporate support of and benefits from Third World dictatorships. This
means that TV companies _"learn over time that such programs will not sell and
would have to be carried at a financial sacrifice, and that, in addition, they
may offend powerful advertisers."_ More generally, advertisers will want _"to
avoid programs with serious complexities and disturbing controversies that
interfere with the 'buying mood.'"_ [p. 17]

Political discrimination is therefore structured into advertising allocations
by wealthy companies with an emphasis on people with money to buy. In
addition, _"many companies will always refuse to do business with ideological
enemies and those whom they perceive as damaging their interests."_ Thus overt
discrimination adds to the force of the _"voting system weighted by income."_
This has had the effect of placing working class and radical papers at a
serious disadvantage. Without access to advertising revenue, even the most
popular paper will fold or price itself out of the market. Chomsky and Herman
cite the British pro-labour and pro-union **Daily Herald** as an example of
this process. At its peak, the **Daily Herald** had almost double the
readership of **The Times** , the **Financial Times** and **The Guardian**
combined, yet even with 8.1% of the national circulation it got 3.5% of net
advertising revenue and so could not survive on the "free market." As Herman
and Chomsky note, a _"mass movement without any major media support, and
subject to a great deal of active press hostility, suffers a serious
disability, and struggles against grave odds."_ With the folding of the
**Daily Herald** , the labour movement lost its voice in the mainstream media.
[pp. 17-8 and pp. 15-16]

Thus advertising is an effective filter for news choice (and, indeed, survival
in the market).

## D.3.3 Why do the media rely on government and business "experts" for
information?

As Herman and Chomsky stress, basic economics explains why the mass media
_"are drawn into a symbiotic relationship with powerful sources of
information"_ as well as _"reciprocity of interest."_ The media need _"a
steady, reliable flow of raw material of news. They have daily news demands
and imperative news schedules that they must meet."_ They cannot afford to
have reporters and cameras at all locations and so economics _"dictates that
they concentrate their resources where significant news often occurs."_ [p.
18] This means that bottom-line considerations dictate that the media
concentrate their resources where news, rumours and leaks are plentiful, and
where regular press conferences are held. The White House, Pentagon, and the
State Department, in Washington, D.C., are centres of such activity on a
national scale, while city hall and police departments are their local
equivalents. In addition, trade groups, businesses and corporations also
provide regular stories that are deemed as newsworthy and from credible
sources.

In other words, government and corporate sources have the great merit of being
recognisable and credible by their status and prestige; moreover, they have
the most money available to produce a flow of news that the media can use. For
example, the Pentagon has a public-information service employing many
thousands of people, spending hundreds of millions of dollars every year, and
far outspending not only the public-information resources of any dissenting
individual or group but the **aggregate** of such groups. Only the corporate
sector has the resources to produce public information and propaganda on the
scale of the Pentagon and other government bodies. The Chamber of Commerce, a
business collective, had a 1983 budget for research, communications, and
political activities of $65 million. Besides the US Chamber of Commerce, there
are thousands of state and local chambers of commerce and trade associations
also engaged in public relations and lobbying activities. As we noted in
[section D.2](secD2.md), the corporate funding of PR is massive. Thus
_"business corporations and trade groups are also regular purveyors of stories
deemed newsworthy. These bureaucracies turn out a large volume of material
that meets the demands of news organisations for reliable, scheduled flows."_
[p. 19]

To maintain their pre-eminent position as sources, government and business-
news agencies expend much effort to make things easy for news organisations.
They provide the media organisations with facilities in which to gather, give
journalists advance copies of speeches and upcoming reports; schedule press
conferences at hours convenient for those needing to meet news deadlines;
write press releases in language that can be used with little editing; and
carefully organise press conferences and photo-opportunity sessions. This
means that, in effect, _"the large bureaucracies of the powerful **subsidise**
the mass media, and gain special access by their contribution to reducing the
media's costs of acquiring the raw materials of, and producing, news."_ [p.
22]

This economic dependency also allows corporations and the state to influence
the media. The most obvious way is by using their _"personal relationships,
threats, and rewards to further influence and coerce the media. The media may
feel obligated to carry extremely dubious stories and mute criticism in order
not to offend sources and disturb a close relationship. It is very difficult
to call authorities on whom one depends for daily news liars, even if they
tell whoppers."_ Critical sources may be avoided not only due to the higher
costs in finding them and establishing their credibility, but because the
established _"primary sources may be offended and may even threaten the media
with using them."_ [p. 22] As well as refusing to co-operate on shows or
reports which include critics, corporations and governments may threaten the
media with loss of access if they ask too many critical questions or delve
into inappropriate areas.

In addition, _"more important, powerful sources regularly take advantage of
media routines and dependency to 'manage' the media, to manipulate them into
following a special agenda and framework . . . Part of this management process
consists of inundating the media with stories, which serve sometimes to foist
a particular line and frame on the media . . . and at other times to chase
unwanted stories off the front page or out of the media altogether."_ [p. 23]

The dominance of official sources would, of course, be weakened by the
existence of highly respectable unofficial sources that gave dissident views
with great authority. To alleviate this problem, the power elite uses the
strategy of _"co-opting the experts"_ \-- that is, putting them on the payroll
as consultants, funding their research, and organising think tanks that will
hire them directly and help disseminate the messages deemed essential to elite
interests. "Experts" on TV panel discussions and news programs are often drawn
from such organisations, whose funding comes primarily from the corporate
sector and wealthy families -- a fact that is, of course, never mentioned on
the programs where they appear. This allows business, for example, to sell its
interests as objective and academic while, in fact, they provide a thin veneer
to mask partisan work which draws the proper conclusions desired by their pay
masters.

This process of creating a mass of experts readily available to the media
_"has been carried out on a deliberate and a massive scale."_ These ensure
that _"the corporate viewpoint"_ is effectively spread as the experts work is
_"funded and their outputs . . . disseminated to the media by a sophisticated
propaganda effort. The corporate funding and clear ideological purpose in the
overall effort had no discernible effect on the credibility of the
intellectuals so mobilised; on the contrary, the funding and pushing of their
ideas catapulted them into the press."_ [p. 23 and p. 24]

## D.3.4 How is "flak" used as a means of disciplining the media?

_"Flak"_ is a term used by Herman and Chomsky to refer _"to negative responses
to a media statement or program."_ Such responses may be expressed as phone
calls, letters, telegrams, e-mail messages, petitions, lawsuits, speeches,
bills before Congress, or _"other modes of complaint, threat, or punishment."_
Flak may be generated centrally, by organisations, or it may come from the
independent actions of individuals (sometimes encouraged to act by media hacks
such as right-wing talk show hosts or newspapers). _"If flak is produced on a
large-scale, or by individuals or groups with substantial resources, it can be
both uncomfortable and costly to the media."_ [p. 26]

This is for many reasons. Positions need to be defended within and outwith an
organisation, sometimes in front of legislatures and (perhaps) in the courts.
Advertisers are very concerned to avoid offending constituencies who might
produce flak, and their demands for inoffensive programming exerts pressure on
the media to avoid certain kinds of facts, positions, or programs that are
likely to call forth flak. This can have a strong deterrence factor, with
media organisations avoiding certain subjects and sources simply to avoid
having to deal with the inevitable flak they will receive from the usual
sources. The ability to produce flak _"is related to power,"_ as it is
expensive to generate on scale which is actually effective. [p. 26]
Unsurprisingly, this means that the most effective flak comes from business
and government who have the funds to produce it on a large scale.

The government itself is _"a major producer of flak, regularly assailing,
threatening, and 'correcting' the media, trying to contain any deviations from
the established line in foreign or domestic policy."_ However, the right-wing
plays a major role in deliberately creating flak. For example, during the
1970s and 1980s, the corporate community sponsored the creation of such
institutions as the American Legal Foundation, the Capital Legal Foundation,
the Media Institute, the Center for Media and Public Affairs, and Accuracy in
Media (AIM), which may be regarded as organisations designed for the specific
purpose of producing flak. Freedom House is an older US organisation which had
a broader design but whose flak-producing activities became a model for the
more recent organisations. The Media Institute, for instance, was set up in
1972 and is funded by wealthy corporate patrons, sponsoring media monitoring
projects, conferences, and studies of the media. The main focus of its studies
and conferences has been the alleged failure of the media to portray business
accurately and to give adequate weight to the business point of view, but it
also sponsors works which "expose" alleged left-wing bias in the mass media.
[p. 28 and pp. 27-8]

And, it should be noted, while the flak machines _"steadily attack the media,
the media treats them well. They receive respectful attention, and their
propagandistic role and links to a large corporate program are rarely
mentioned or analysed."_ [p. 28] Indeed, such attacks _"are often not
unwelcome, first because response is simple or superfluous; and second,
because debate over this issue helps entrench the belief that the media are .
. . independent and objective, with high standards of professional integrity
and openness to all reasonable views"_ which is _"quite acceptable to
established power and privilege -- even to the media elites themselves, who
are not averse to the charge that they may have gone to far in pursuing their
cantankerous and obstreperous ways in defiance of orthodoxy and power."_
Ultimately, such flak _"can only be understood as a demand that the media
should not even reflect the range of debate over tactical questions among the
dominant elites, but should serve only those segments that happen to manage
the state at a particular moment, and should do so with proper enthusiasm and
optimism about the causes -- noble by definition -- in which state power is
engaged."_ [Chomsky, **Necessary Illusions** , p. 13 and p. 11]

## D.3.5 Why is "anticommunism" used as control mechanism?

The final filter which Herman and Chomsky discuss is the ideology of
anticommunism. "Communism" is of course regarded as the ultimate evil by the
corporate rich, since the ideas of collective ownership of productive assets
_"threatens the very root of their class position and superior status."_ As
the concept is _"fuzzy,"_ it can be widely applied and _"can be used against
anybody advocating policies that threaten property interests."_ [p. 29] Hence
the attacks on third-world nationalists as "socialists" and the steady
expansion of "communism" to apply to any form of socialism, social democracy,
reformism, trade unionism or even "liberalism" (i.e. any movement which aims
to give workers more bargaining power or allow ordinary citizens more voice in
public policy decisions).

Hence the ideology of anticommunism has been very useful, because it can be
used to discredit anybody advocating policies regarded as harmful to corporate
interests. It also helps to divide the Left and labour movements, justifies
support for pro-US fascist regimes abroad as "lesser evils" than communism,
and discourages liberals from opposing such regimes for fear of being branded
as heretics from the national religion. This process has been aided immensely
by the obvious fact that the "communist" regimes (i.e. Stalinist
dictatorships) have been so terrible.

Since the collapse of the USSR and related states in 1989, the utility of
anticommunism has lost some of its power. Of course, there are still a few
official communist enemy states, like North Korea, Cuba, and China, but these
are not quite the threat the USSR was. North Korea and Cuba are too
impoverished to threaten the world's only super-power (that so many Americans
think that Cuba was ever a threat says a lot about the power of propaganda).
China is problematic, as Western corporations now have access to, and can
exploit, its resources, markets and cheap labour. As such, criticism of China
will be mooted, unless it starts to hinder US corporations or become too much
of an economic rival.

So we can still expect, to some degree, abuses or human rights violations in
these countries are systematically played up by the media while similar abuses
in client states are downplayed or ignored. Chomsky and Herman refer to the
victims of abuses in enemy states as **worthy victims,** while victims who
suffer at the hands of US clients or friends are **unworthy victims.** Stories
about worthy victims are often made the subject of sustained propaganda
campaigns, to score political points against enemies. For example:

> _"If the government of corporate community and the media feel that a story
> is useful as well as dramatic, they focus on it intensively and use it to
> enlighten the public. This was true, for example, of the shooting down by
> the Soviets of the Korean airliner KAL 007 in early September 1983, which
> permitted an extended campaign of denigration of an official enemy and
> greatly advanced Reagan administration arms plans."  
>  _
>
> _"In sharp contrast, the shooting down by Israel of a Libyan civilian
> airliner in February 1973 led to no outcry in the West, no denunciations for
> 'cold-blooded murder,' and no boycott. This difference in treatment was
> explained by the **New York Times** precisely on the grounds of utility: 'No
> useful purpose is served by an acrimonious debate over the assignment of
> blame for the downing of a Libyan airliner in the Sinai peninsula last
> week.' There **was** a very 'useful purpose' served by focusing on the
> Soviet act, and a massive propaganda campaign ensued."_ [p. 32]

As noted, since the end of the Cold War, anti-communism has not been used as
extensively as it once was to mobilise support for elite crusades. Other
enemies have to be found and so the "Drug War" or "anti-terrorism" now often
provide the public with "official enemies" to hate and fear. Thus the Drug War
was the excuse for the Bush administration's invasion of Panama, and "fighting
narco-terrorists" has more recently been the official reason for shipping
military hardware and surveillance equipment to Mexico (where it's actually
being used against the Zapatista rebels in Chiapas, whose uprising is
threatening to destabilise the country and endanger US investments). After
9/11, terrorism became the key means of forcing support for policies. The
mantra _"you are either with us or with the terrorists"_ was used to bolster
support and reduce criticism for both imperial adventures as well as a whole
range of regressive domestic policies.

Whether any of these new enemies will prove to be as useful as anticommunism
remains to be seen. It is likely, particularly given how "communism" has
become so vague as to include liberal and social democratic ideas, that it
will remain the bogey man of choice -- particularly as many within the
population both at home and abroad continue to support left-wing ideas and
organisations. Given the track record of neo-liberalism across the globe,
being able to tar its opponents as "communists" will remain a useful tool.

## D.3.6 Isn't the "propaganda model" a conspiracy theory?

No, far from it. Chomsky and Herman explicitly address this charge in
**Manufacturing Consent** and explain why it is a false one:

> _"Institutional critiques such as we present in this book are commonly
> dismissed by establishment commentators as 'conspiracy theories,' but this
> is merely an evasion. We do not use any kind of 'conspiracy' hypothesis to
> explain mass-media performance. In fact, our treatment is much closer to a
> 'free market' analysis, with the results largely an outcome of the workings
> of market forces."_ [p. xii]

They go on to suggest what some of these "market forces" are. One of the most
important is the weeding-out process that determines who gets the journalistic
jobs in the major media: _"Most biased choices in the media arise from the
preselection of right-thinking people, internalised preconceptions, and the
adaptation of personnel to the constraints of ownership, organisation, market,
and political power."_ This is the key, as the model _"helps us to understand
how media personnel adapt, and are adapted, to systemic demands. Given the
imperatives of corporate organisation and the workings of the various filters,
conformity to the needs and interests of privileged sectors is essential to
success."_ This means that those who do not display the requisite values and
perspectives will be regarded as irresponsible and/or ideological and,
consequently, will not succeed (barring a few exceptions). In other words,
those who _"adapt, perhaps quite honestly, will then be able to assert,
accurately, that they perceive no pressures to conform. The media are indeed
free . . . for those who have internalised the required values and
perspectives."_ [p. xii and p. 304]

In other words, important media employees learn to internalise the values of
their bosses: _"Censorship is largely self-censorship, by reporters and
commentators who adjust to the realities of source and media organisational
requirements, and by people at higher levels within media organisations who
are chosen to implement, and have usually internalised, the constraints
imposed by proprietary and other market and governmental centres of power."_
But, it may be asked, isn't it still a conspiracy theory to suggest that media
leaders all have similar values? Not at all. Such leaders _"do similar things
because they see the world through the same lenses, are subject to similar
constraints and incentives, and thus feature stories or maintain silence
together in tacit collective action and leader-follower behaviour."_ [p. xii]

The fact that media leaders share the same fundamental values does not mean,
however, that the media are a solid monolith on all issues. The powerful often
disagree on the tactics needed _"to attain generally shared aims, [and this
gets] reflected in media debate. But views that challenge fundamental premises
or suggest that the observed modes of exercise of state power are based on
systemic factors will be excluded from the mass media even when elite
controversy over tactics rages fiercely."_ [p. xii] This means that viewpoints
which question the legitimacy of elite aims or suggest that state power is
being exercised in elite interests rather than the "national" interest will be
excluded from the mass media. As such, we would expect the media to encourage
debate within accepted bounds simply because the ruling class is not
monolithic and while they agree on keeping the system going, they disagree on
the best way to do so.

Therefore the "propaganda model" has as little in common with a "conspiracy
theory" as saying that the management of General Motors acts to maintain and
increase its profits. As Chomsky notes, _"[t]o confront power is costly and
difficult; high standards of evidence and argument are imposed, and critical
analysis is naturally not welcomed by those who are in a position to react
vigorously and to determine the array of rewards and punishments. Conformity
to a 'patriotic agenda,' in contrast, imposes no such costs."_ This means that
_"conformity is the easy way, and the path to privilege and prestige . . . It
is a natural expectation, on uncontroversial assumptions, that the major media
and other ideological institutions will generally reflect the perspectives and
interests of established power."_ [ **Necessary Illusions** , pp. 8-9 and p.
10]

## D.3.7 Isn't the model contradicted by the media reporting government and
business failures?

As noted above, the claim that the media are "adversarial" or (more
implausibly) that they have a "left-wing bias" is due to right-wing PR
organisations. This means that some "inconvenient facts" are occasionally
allowed to pass through the filters in order to give the **appearance** of
"objectivity" -- precisely so the media can deny charges of engaging in
propaganda. As Chomsky and Herman put it: _"the 'naturalness' of these
processes, with inconvenient facts allowed sparingly and within the proper
framework of assumptions, and fundamental dissent virtually excluded from the
mass media (but permitted in a marginalised press), makes for a propaganda
system that is far more credible and effective in putting over a patriotic
agenda than one with official censorship."_ [p. xiv]

To support their case against the "adversarial" nature of the media, Herman
and Chomsky look into the claims of such right-wing media PR machines as
Freedom House. However, it is soon discovered that _"the very examples offered
in praise of the media for their independence, or criticism of their excessive
zeal, illustrate exactly the opposite."_ Such flak, while being worthless as
serious analysis, does help to reinforce the myth of an "adversarial media"
and so is taken seriously by the media. By saying that both right and left
attack them, the media presents themselves as neutral, balanced and objective
-- a position which is valid only if both criticisms are valid and of equal
worth. This is not the case, as Herman and Chomsky prove, both in terms of
evidence and underlying aims and principles. Ultimately, the attacks by the
right on the media are based on the concern _"to protect state authority from
an intrusive public"_ and so _"condemn the media for lack of sufficient
enthusiasm in supporting official crusades."_ In other words, that the
_"existing level of subordination to state authority is often deemed
unsatisfactory."_ [p. xiv and p. 301] The right-wing notion that the media are
"liberal" or "left-wing" says far more about the authoritarian vision and aims
of the right than the reality of the media.

Therefore the "adversarial" nature of the media is a myth, but this is not to
imply that the media does not present critical analysis. Herman and Chomsky in
fact argue that the _"mass media are not a solid monolith on all issues."_ and
do not deny that it does present facts (which they do sometimes themselves
cite). This _"affords the opportunity for a classic **non sequitur** , in
which the citations of facts from the mainstream press by a critic of the
press is offered as a triumphant 'proof' that the criticism is self-refuting,
and that media coverage of disputed issues is indeed adequate."_ But, as they
argue, _"[t]hat the media provide some facts about an issue . . . proves
absolutely nothing about the adequacy or accuracy of that coverage. The mass
media do, in fact, literally suppress a great deal . . . But even more
important in this context is the question given to a fact - its placement,
tone, and repetitions, the framework within which it is presented, and the
related facts that accompany it and give it meaning (or provide understanding)
. . . there is no merit to the pretence that because certain facts may be
found by a diligent and sceptical researcher, the absence of radical bias and
de facto suppression is thereby demonstrated."_ [p. xii and pp xiv-xv]

As they stress, the media in a democratic system is different from one in a
dictatorship and so they _"do not function in the manner of the propaganda
system of a totalitarian state. Rather, they permit -- indeed, encourage --
spirited debate, criticism, and dissent, as long as these remain faithfully
within the system of presuppositions and principles that constitute an elite
consensus, a system so powerful as to be internalised largely without
awareness."_ Within this context, _"facts that tend to undermine the
government line, if they are properly understood, can be found."_ Indeed, it
is _"possible that the volume of inconvenient facts can expand, as it did
during the Vietnam War, in response to the growth of a critical constituency
(which included elite elements from 1968). Even in this exceptional case,
however, it was very rare for news and commentary to find their way into the
mass media if they failed to conform to the framework of established dogma
(postulating benevolent U.S aims, the United States responding to aggression
and terror, etc.)"_ While during the war and after, _"apologists for state
policy commonly pointed to the inconvenient facts, the periodic 'pessimism' of
media pundits, and the debates over tactics as showing that the media were
'adversarial' and even 'lost' the war,"_ in fact these _"allegations are
ludicrous."_ [p. 302 and p. xiv] A similar process, it should be noted,
occurred during the invasion and occupation of Iraq.

To summarise, as Chomsky notes _"what is essential is the power to set the
agenda."_ This means that debate _"cannot be stilled, and indeed, in a
properly functioning system of propaganda, it should not be, because it has a
system-reinforcing character if constrained within proper bounds. What is
essential is to set the bounds firmly. Controversy may rage as long as it
adheres to the presuppositions that define the consensus of elites, and it
should furthermore be encourages within these bounds, this helping to
establish these doctrines as the very condition of thinkable thought while
reinforcing the belief that freedom reigns."_ [ **Necessary Illusions** , p.
48]

[‹ D.2 What influence does wealth have over politics?](secD2.md "Go to
previous page") [up](secDcon.md "Go to parent page") [D.4 What is the
relationship between capitalism and the ecological crisis? ›](secD4.md "Go
to next page")

