// -*- c++ -*-
// Generated by gmmproc 2.45.3 -- DO NOT MODIFY!
#ifndef _GTKMM_SCROLLEDWINDOW_H
#define _GTKMM_SCROLLEDWINDOW_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: scrolledwindow.hg,v 1.7 2006/08/17 18:03:34 murrayc Exp $ */

/* scrolledwindow.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkScrolledWindow GtkScrolledWindow;
typedef struct _GtkScrolledWindowClass GtkScrolledWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ScrolledWindow_Class; } // namespace Gtk
namespace Gtk
{

class Adjustment;
class HScrollbar;
class VScrollbar;

/** Adds scrollbars to its child widget.
 *
 * This container accepts a single child widget. It adds scrollbars to the child widget and optionally draws a beveled frame around the child widget.
 * The scrolled window can work in two ways:
 * 1) Some widgets have native scrolling support; these widgets handle certain Gtk::Adjustment signals. Widgets with native scroll support include Gtk::TreeView, Gtk::TextView, and Gtk::Layout.
 * 2) For widgets that lack native scrolling support, such as Gtk::Table, Gtk::Box, and so on, the widget will be placed inside a Gtk::Viewport.
 *
 * The position of the scrollbars is controlled by the scroll adjustments. See Gtk::Adjustment for the fields in an adjustment - for Gtk::Scrollbar, used by Gtk::ScrolledWindow,
 * the "value" field represents the position of the scrollbar, which must be between the "lower" field and "upper - page_size."
 * The "page_size" field represents the size of the visible scrollable area.
 * The "step_increment" and "page_increment" fields are used when the user asks to step down (using the small stepper arrows) or page down (using for example the PageDown key).
 *
 * If a Gtk::ScrolledWindow doesn't behave quite as you would like, or doesn't have exactly the right layout, it's very possible to set up your own scrolling with Gtk::Scrollbar and, for example, a Gtk::Table.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class ScrolledWindow : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ScrolledWindow CppObjectType;
  typedef ScrolledWindow_Class CppClassType;
  typedef GtkScrolledWindow BaseObjectType;
  typedef GtkScrolledWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ScrolledWindow();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ScrolledWindow_Class;
  static CppClassType scrolledwindow_class_;

  // noncopyable
  ScrolledWindow(const ScrolledWindow&);
  ScrolledWindow& operator=(const ScrolledWindow&);

protected:
  explicit ScrolledWindow(const Glib::ConstructParams& construct_params);
  explicit ScrolledWindow(GtkScrolledWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkScrolledWindow*       gobj()       { return reinterpret_cast<GtkScrolledWindow*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkScrolledWindow* gobj() const { return reinterpret_cast<GtkScrolledWindow*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:


public:
  ScrolledWindow();
    explicit ScrolledWindow(Adjustment& hadjustment, Adjustment& vadjustment);


  /** Sets the Gtk::Adjustment for the horizontal scrollbar.
   * 
   * @param hadjustment Horizontal scroll adjustment.
   */
  void set_hadjustment(Gtk::Adjustment* hadjustment =  0);
  
  /** Sets the Gtk::Adjustment for the vertical scrollbar.
   * 
   * @param vadjustment Vertical scroll adjustment.
   */
  void set_vadjustment(Gtk::Adjustment* vadjustment =  0);
  
  /** Sets the Gtk::Adjustment for the horizontal scrollbar.
   * 
   * @param hadjustment Horizontal scroll adjustment.
   */
  void set_hadjustment(Gtk::Adjustment& hadjustment);
  
  /** Sets the Gtk::Adjustment for the vertical scrollbar.
   * 
   * @param vadjustment Vertical scroll adjustment.
   */
  void set_vadjustment(Gtk::Adjustment& vadjustment);

  
  /** Returns the horizontal scrollbar's adjustment, used to connect the
   * horizontal scrollbar to the child widget's horizontal scroll
   * functionality.
   * 
   * @return The horizontal Gtk::Adjustment.
   */
  Gtk::Adjustment* get_hadjustment();
  
  /** Returns the horizontal scrollbar's adjustment, used to connect the
   * horizontal scrollbar to the child widget's horizontal scroll
   * functionality.
   * 
   * @return The horizontal Gtk::Adjustment.
   */
  const Gtk::Adjustment* get_hadjustment() const;
  
  /** Returns the vertical scrollbar's adjustment, used to connect the
   * vertical scrollbar to the child widget's vertical scroll functionality.
   * 
   * @return The vertical Gtk::Adjustment.
   */
  Gtk::Adjustment* get_vadjustment();
  
  /** Returns the vertical scrollbar's adjustment, used to connect the
   * vertical scrollbar to the child widget's vertical scroll functionality.
   * 
   * @return The vertical Gtk::Adjustment.
   */
  const Gtk::Adjustment* get_vadjustment() const;

  
  /** Sets the scrollbar policy for the horizontal and vertical scrollbars.
   * 
   * The policy determines when the scrollbar should appear; it is a value
   * from the Gtk::PolicyType enumeration. If Gtk::POLICY_ALWAYS, the
   * scrollbar is always present; if Gtk::POLICY_NEVER, the scrollbar is
   * never present; if Gtk::POLICY_AUTOMATIC, the scrollbar is present only
   * if needed (that is, if the slider part of the bar would be smaller
   * than the trough - the display is larger than the page size).
   * 
   * @param hscrollbar_policy Policy for horizontal bar.
   * @param vscrollbar_policy Policy for vertical bar.
   */
  void set_policy(PolicyType hscrollbar_policy, PolicyType vscrollbar_policy);
  
  /** Retrieves the current policy values for the horizontal and vertical
   * scrollbars. See set_policy().
   * 
   * @param hscrollbar_policy Location to store the policy for the horizontal 
   * scrollbar, or <tt>0</tt>.
   * @param vscrollbar_policy Location to store the policy for the vertical
   * scrollbar, or <tt>0</tt>.
   */
  void get_policy(PolicyType& hscrollbar_policy, PolicyType& vscrollbar_policy) const;

  
  /** Sets the placement of the contents with respect to the scrollbars
   * for the scrolled window.
   * 
   * The default is Gtk::CORNER_TOP_LEFT, meaning the child is
   * in the top left, with the scrollbars underneath and to the right.
   * Other values in Gtk::CornerType are Gtk::CORNER_TOP_RIGHT,
   * Gtk::CORNER_BOTTOM_LEFT, and Gtk::CORNER_BOTTOM_RIGHT.
   * 
   * See also get_placement() and
   * unset_placement().
   * 
   * @param window_placement Position of the child window.
   */
  void set_placement(CornerType window_placement);
  
  /** Unsets the placement of the contents with respect to the scrollbars
   * for the scrolled window. If no window placement is set for a scrolled
   * window, it obeys the "gtk-scrolled-window-placement" XSETTING.
   * 
   * See also set_placement() and
   * get_placement().
   */
  void unset_placement();
  
  /** Gets the placement of the contents with respect to the scrollbars
   * for the scrolled window. See set_placement().
   * 
   * @return The current placement value.
   * 
   * See also set_placement() and
   * unset_placement().
   */
  CornerType get_placement() const;

  
  /** Changes the type of shadow drawn around the contents of
   *  @a scrolled_window.
   * 
   * @param type Kind of shadow to draw around scrolled window contents.
   */
  void set_shadow_type(ShadowType type);
  
  /** Gets the shadow type of the scrolled window. See 
   * set_shadow_type().
   * 
   * @return The current shadow type.
   */
  ShadowType get_shadow_type() const;

  ///Puts the child inside a Gtk::Viewport if it doesn't have native scrolling capability.
  virtual void add(Gtk::Widget& widget);
  

  /** Returns the vertical scrollbar of @a scrolled_window.
   * 
   * @return The vertical scrollbar of the scrolled window,
   * or <tt>0</tt> if it does not have one.
   */
  VScrollbar* get_vscrollbar();
  
  /** Returns the vertical scrollbar of @a scrolled_window.
   * 
   * @return The vertical scrollbar of the scrolled window,
   * or <tt>0</tt> if it does not have one.
   */
  const VScrollbar* get_vscrollbar() const;

  
  /** Returns the horizontal scrollbar of @a scrolled_window.
   * 
   * @return The horizontal scrollbar of the scrolled window,
   * or <tt>0</tt> if it does not have one.
   */
  HScrollbar* get_hscrollbar();
  
  /** Returns the horizontal scrollbar of @a scrolled_window.
   * 
   * @return The horizontal scrollbar of the scrolled window,
   * or <tt>0</tt> if it does not have one.
   */
  const HScrollbar* get_hscrollbar() const;

#ifndef GTKMM_DISABLE_DEPRECATED

  /** @deprecated You should not need to call this method.
   */
   bool get_vscrollbar_visible() const;
 
  /** @deprecated You should not need to call this method.
   */
   bool get_hscrollbar_visible() const;
 #endif // GTKMM_DISABLE_DEPRECATED


  //Keybinding signals:
  
  
  /** The GtkAdjustment for the horizontal position.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gtk::Adjustment* > property_hadjustment() ;

/** The GtkAdjustment for the horizontal position.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::Adjustment* > property_hadjustment() const;

  /** The GtkAdjustment for the vertical position.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gtk::Adjustment* > property_vadjustment() ;

/** The GtkAdjustment for the vertical position.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::Adjustment* > property_vadjustment() const;

  /** When the horizontal scrollbar is displayed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PolicyType > property_hscrollbar_policy() ;

/** When the horizontal scrollbar is displayed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PolicyType > property_hscrollbar_policy() const;

  /** When the vertical scrollbar is displayed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PolicyType > property_vscrollbar_policy() ;

/** When the vertical scrollbar is displayed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PolicyType > property_vscrollbar_policy() const;

  /** Where the contents are located with respect to the scrollbars. This property only takes effect if 'window-placement-set' is TRUE.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< CornerType > property_window_placement() ;

/** Where the contents are located with respect to the scrollbars. This property only takes effect if 'window-placement-set' is TRUE.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< CornerType > property_window_placement() const;

  /** Whether 'window-placement' should be used to determine the location of the contents with respect to the scrollbars.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_window_placement_set() ;

/** Whether 'window-placement' should be used to determine the location of the contents with respect to the scrollbars.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_window_placement_set() const;

  /** Style of bevel around the contents.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ShadowType > property_shadow_type() ;

/** Style of bevel around the contents.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ShadowType > property_shadow_type() const;


};

} /* namespace Gtk */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ScrolledWindow
   */
  Gtk::ScrolledWindow* wrap(GtkScrolledWindow* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_SCROLLEDWINDOW_H */

