/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;

public class ColorFormat {
    private ChannelOrder channelOrder;
    private int[] channelBits;

    public ColorFormat(ChannelOrder channelOrder, int ... channelBits) {
        if (channelOrder == null) {
            throw new IllegalArgumentException("Invalid channel order");
        }
        if (channelBits.length != channelOrder.name().length()) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        this.channelOrder = channelOrder;
        this.channelBits = channelBits;
    }

    public ColorFormat(String format) {
        String cos = format.replaceAll("[^A-Za-z]", "").toUpperCase();
        this.channelOrder = ChannelOrder.valueOf(cos);
        if (this.channelOrder == null) {
            throw new IllegalArgumentException("Invalid channel order");
        }
        this.channelBits = new int[this.channelOrder.name().length()];
        String[] cbs = format.replaceAll("[^0-9]", " ").trim().split("\\s+");
        if (cbs.length == 1 && cbs[0].length() == 0) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        if (cbs.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        int i = 0;
        while (i < cbs.length) {
            this.channelBits[i] = Integer.parseInt(cbs[i]);
            ++i;
        }
    }

    public ColorFormat(int width, String format) {
        String cos = format.replaceAll("[^A-Za-z]", "").toUpperCase();
        this.channelOrder = ChannelOrder.valueOf(cos);
        if (this.channelOrder == null) {
            throw new IllegalArgumentException("Invalid channel order");
        }
        this.channelBits = new int[this.channelOrder.name().length()];
        String[] cbs = format.replaceAll("[^0-9]", " ").trim().split("\\s+");
        if (cbs.length == 1 && cbs[0].length() == 0) {
            cbs = new String[]{};
        }
        if (cbs.length > this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        int i = 0;
        while (i < cbs.length) {
            this.channelBits[i] = Integer.parseInt(cbs[i]);
            width -= this.channelBits[i];
            ++i;
        }
        if (cbs.length < this.channelBits.length) {
            int ncr = this.channelBits.length - cbs.length;
            int npc = width / ncr;
            int i2 = cbs.length;
            while (i2 < this.channelBits.length) {
                this.channelBits[i2] = npc;
                width -= npc;
                ++i2;
            }
            if (width > 0) {
                int o = cos.indexOf(71);
                if (o >= 0) {
                    int n = o;
                    this.channelBits[n] = this.channelBits[n] + width;
                } else {
                    o = cos.indexOf(72);
                    if (o >= 0) {
                        int n = o;
                        this.channelBits[n] = this.channelBits[n] + width;
                    } else {
                        o = cos.indexOf(75);
                        if (o >= 0) {
                            int n = o;
                            this.channelBits[n] = this.channelBits[n] + width;
                        } else {
                            o = cos.indexOf(89);
                            if (o >= 0) {
                                int n = o;
                                this.channelBits[n] = this.channelBits[n] + width;
                            } else {
                                int n = this.channelBits.length / 2;
                                this.channelBits[n] = this.channelBits[n] + width;
                            }
                        }
                    }
                }
            }
        }
    }

    public ChannelOrder channelOrder() {
        return this.channelOrder;
    }

    public int channelCount() {
        return this.channelBits.length;
    }

    public int channelWidth(int ch) {
        return this.channelBits[ch];
    }

    public boolean equals(Object o) {
        if (o instanceof ColorFormat) {
            ColorFormat other = (ColorFormat)o;
            if (this.channelOrder != other.channelOrder) {
                return false;
            }
            if (this.channelBits.length != other.channelBits.length) {
                return false;
            }
            int i = 0;
            while (i < this.channelBits.length) {
                if (this.channelBits[i] != other.channelBits[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.channelOrder.hashCode() ^ Arrays.hashCode(this.channelBits);
    }

    public String toString() {
        String cos = this.channelOrder.name().toLowerCase();
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.channelBits.length) {
            s.append(cos.charAt(i));
            s.append(this.channelBits[i]);
            ++i;
        }
        return s.toString();
    }

    public float[] toFloatArray(Number[] values) {
        if (values.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        float[] r = new float[values.length];
        int i = 0;
        while (i < values.length) {
            r[i] = values[i].floatValue() / BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).floatValue();
            ++i;
        }
        return r;
    }

    public float[] toFloatArray(long[] values) {
        if (values.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        float[] r = new float[values.length];
        int i = 0;
        while (i < values.length) {
            r[i] = (float)values[i] / BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).floatValue();
            ++i;
        }
        return r;
    }

    public float[] toFloatArray(int[] values) {
        if (values.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        float[] r = new float[values.length];
        int i = 0;
        while (i < values.length) {
            r[i] = (float)values[i] / BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).floatValue();
            ++i;
        }
        return r;
    }

    public BigInteger[] toBigIntArray(float[] values) {
        if (values.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        MathContext mc = MathContext.DECIMAL128;
        BigInteger[] r = new BigInteger[values.length];
        int i = 0;
        while (i < values.length) {
            BigInteger m = BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE);
            r[i] = BigDecimal.valueOf(values[i]).multiply(new BigDecimal(m, mc), mc).toBigInteger();
            ++i;
        }
        return r;
    }

    public long[] toLongArray(float[] values) {
        if (values.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        long[] r = new long[values.length];
        int i = 0;
        while (i < values.length) {
            r[i] = (long)((double)values[i] * BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).doubleValue());
            ++i;
        }
        return r;
    }

    public int[] toIntArray(float[] values) {
        if (values.length != this.channelBits.length) {
            throw new IllegalArgumentException("Number of channels do not match");
        }
        int[] r = new int[values.length];
        int i = 0;
        while (i < values.length) {
            r[i] = (int)((double)values[i] * BigInteger.ONE.shiftLeft(this.channelBits[i]).subtract(BigInteger.ONE).doubleValue());
            ++i;
        }
        return r;
    }

    public float[] toRGBAFloatArray(float[] values) {
        String cos = this.channelOrder.name().toUpperCase();
        switch (this.channelOrder) {
            case ARGB: 
            case ARBG: 
            case AGRB: 
            case AGBR: 
            case ABRG: 
            case ABGR: 
            case RAGB: 
            case RABG: 
            case RGAB: 
            case RGBA: 
            case RBAG: 
            case RBGA: 
            case GARB: 
            case GABR: 
            case GRAB: 
            case GRBA: 
            case GBAR: 
            case GBRA: 
            case BARG: 
            case BAGR: 
            case BRAG: 
            case BRGA: 
            case BGAR: 
            case BGRA: {
                return new float[]{values[cos.indexOf(82)], values[cos.indexOf(71)], values[cos.indexOf(66)], values[cos.indexOf(65)]};
            }
            case RGB: 
            case RBG: 
            case GRB: 
            case GBR: 
            case BRG: 
            case BGR: {
                return new float[]{values[cos.indexOf(82)], values[cos.indexOf(71)], values[cos.indexOf(66)], 1.0f};
            }
            case AY: 
            case YA: {
                return new float[]{values[cos.indexOf(89)], values[cos.indexOf(89)], values[cos.indexOf(89)], values[cos.indexOf(65)]};
            }
            case Y: {
                return new float[]{values[cos.indexOf(89)], values[cos.indexOf(89)], values[cos.indexOf(89)], 1.0f};
            }
            case A: {
                return new float[]{0.0f, 0.0f, 0.0f, values[cos.indexOf(65)]};
            }
            case AHSV: 
            case AHVS: 
            case ASHV: 
            case ASVH: 
            case AVHS: 
            case AVSH: 
            case HASV: 
            case HAVS: 
            case HSAV: 
            case HSVA: 
            case HVAS: 
            case HVSA: 
            case SAHV: 
            case SAVH: 
            case SHAV: 
            case SHVA: 
            case SVAH: 
            case SVHA: 
            case VAHS: 
            case VASH: 
            case VHAS: 
            case VHSA: 
            case VSAH: 
            case VSHA: {
                int rgb1 = Color.HSBtoRGB(values[cos.indexOf(72)], values[cos.indexOf(83)], values[cos.indexOf(86)]);
                return new float[]{(float)(rgb1 >> 16 & 0xFF) / 255.0f, (float)(rgb1 >> 8 & 0xFF) / 255.0f, (float)(rgb1 & 0xFF) / 255.0f, values[cos.indexOf(65)]};
            }
            case HSV: 
            case HVS: 
            case SHV: 
            case SVH: 
            case VHS: 
            case VSH: {
                int rgb2 = Color.HSBtoRGB(values[cos.indexOf(72)], values[cos.indexOf(83)], values[cos.indexOf(86)]);
                return new float[]{(float)(rgb2 >> 16 & 0xFF) / 255.0f, (float)(rgb2 >> 8 & 0xFF) / 255.0f, (float)(rgb2 & 0xFF) / 255.0f, 1.0f};
            }
            case AHSL: 
            case AHLS: 
            case ASHL: 
            case ASLH: 
            case ALHS: 
            case ALSH: 
            case HASL: 
            case HALS: 
            case HSAL: 
            case HSLA: 
            case HLAS: 
            case HLSA: 
            case SAHL: 
            case SALH: 
            case SHAL: 
            case SHLA: 
            case SLAH: 
            case SLHA: 
            case LAHS: 
            case LASH: 
            case LHAS: 
            case LHSA: 
            case LSAH: 
            case LSHA: {
                float hh1 = values[cos.indexOf(72)];
                float ss1 = values[cos.indexOf(83)];
                float ll1 = values[cos.indexOf(76)];
                float h1 = hh1;
                float v1 = (ll1 + (ss1 *= ll1 <= 1.0f ? ll1 : 2.0f - (ll1 *= 2.0f))) / 2.0f;
                float s1 = ll1 + ss1 == 0.0f ? 0.0f : 2.0f * ss1 / (ll1 + ss1);
                int rgb3 = Color.HSBtoRGB(h1, s1, v1);
                return new float[]{(float)(rgb3 >> 16 & 0xFF) / 255.0f, (float)(rgb3 >> 8 & 0xFF) / 255.0f, (float)(rgb3 & 0xFF) / 255.0f, values[cos.indexOf(65)]};
            }
            case HSL: 
            case HLS: 
            case SHL: 
            case SLH: 
            case LHS: 
            case LSH: {
                float hh2 = values[cos.indexOf(72)];
                float ss2 = values[cos.indexOf(83)];
                float ll2 = values[cos.indexOf(76)];
                float h2 = hh2;
                float v2 = (ll2 + (ss2 *= ll2 <= 1.0f ? ll2 : 2.0f - (ll2 *= 2.0f))) / 2.0f;
                float s2 = ll2 + ss2 == 0.0f ? 0.0f : 2.0f * ss2 / (ll2 + ss2);
                int rgb4 = Color.HSBtoRGB(h2, s2, v2);
                return new float[]{(float)(rgb4 >> 16 & 0xFF) / 255.0f, (float)(rgb4 >> 8 & 0xFF) / 255.0f, (float)(rgb4 & 0xFF) / 255.0f, 1.0f};
            }
            case CMYK: 
            case CMKY: 
            case CYMK: 
            case CYKM: 
            case CKMY: 
            case CKYM: 
            case MCYK: 
            case MCKY: 
            case MYCK: 
            case MYKC: 
            case MKCY: 
            case MKYC: 
            case YCMK: 
            case YCKM: 
            case YMCK: 
            case YMKC: 
            case YKCM: 
            case YKMC: 
            case KCMY: 
            case KCYM: 
            case KMCY: 
            case KMYC: 
            case KYCM: 
            case KYMC: {
                float k1 = values[cos.indexOf(75)];
                float c1 = k1 + values[cos.indexOf(67)] * (1.0f - k1);
                float m1 = k1 + values[cos.indexOf(77)] * (1.0f - k1);
                float y1 = k1 + values[cos.indexOf(89)] * (1.0f - k1);
                return new float[]{1.0f - c1, 1.0f - m1, 1.0f - y1, 1.0f};
            }
            case CMY: 
            case CYM: 
            case MCY: 
            case MYC: 
            case YCM: 
            case YMC: {
                return new float[]{1.0f - values[cos.indexOf(67)], 1.0f - values[cos.indexOf(77)], 1.0f - values[cos.indexOf(89)], 1.0f};
            }
            case YIQ: 
            case YQI: 
            case IYQ: 
            case IQY: 
            case QYI: 
            case QIY: {
                double[] rgb5 = ColorFormat.YIQtoRGB(values[cos.indexOf(89)], values[cos.indexOf(73)], values[cos.indexOf(81)]);
                return new float[]{(float)rgb5[0], (float)rgb5[1], (float)rgb5[2], 1.0f};
            }
            case YUV: 
            case YVU: 
            case UYV: 
            case UVY: 
            case VYU: 
            case VUY: {
                double[] rgb6 = ColorFormat.YUVtoRGB(values[cos.indexOf(89)], values[cos.indexOf(85)], values[cos.indexOf(86)]);
                return new float[]{(float)rgb6[0], (float)rgb6[1], (float)rgb6[2], 1.0f};
            }
            case XYZ: 
            case XZY: 
            case YXZ: 
            case YZX: 
            case ZXY: 
            case ZYX: {
                double[] rgb8 = ColorFormat.XYZtosRGB(values[cos.indexOf(88)], values[cos.indexOf(89)], values[cos.indexOf(90)]);
                return new float[]{(float)rgb8[0], (float)rgb8[1], (float)rgb8[2], 1.0f};
            }
        }
        throw new IllegalArgumentException("Invalid channel order");
    }

    public float[] fromRGBAFloatArray(float[] rgb) {
        String cos = this.channelOrder.name().toUpperCase();
        switch (this.channelOrder) {
            case ARGB: 
            case ARBG: 
            case AGRB: 
            case AGBR: 
            case ABRG: 
            case ABGR: 
            case RAGB: 
            case RABG: 
            case RGAB: 
            case RGBA: 
            case RBAG: 
            case RBGA: 
            case GARB: 
            case GABR: 
            case GRAB: 
            case GRBA: 
            case GBAR: 
            case GBRA: 
            case BARG: 
            case BAGR: 
            case BRAG: 
            case BRGA: 
            case BGAR: 
            case BGRA: {
                float[] values = new float[4];
                values[cos.indexOf((int)82)] = rgb[0];
                values[cos.indexOf((int)71)] = rgb[1];
                values[cos.indexOf((int)66)] = rgb[2];
                values[cos.indexOf((int)65)] = rgb[3];
                return values;
            }
            case RGB: 
            case RBG: 
            case GRB: 
            case GBR: 
            case BRG: 
            case BGR: {
                float[] values = new float[3];
                values[cos.indexOf((int)82)] = rgb[0];
                values[cos.indexOf((int)71)] = rgb[1];
                values[cos.indexOf((int)66)] = rgb[2];
                return values;
            }
            case AY: 
            case YA: {
                float[] values = new float[2];
                values[cos.indexOf((int)89)] = 0.3f * rgb[0] + 0.59f * rgb[1] + 0.11f * rgb[2];
                values[cos.indexOf((int)65)] = rgb[3];
                return values;
            }
            case Y: {
                float[] values = new float[1];
                values[cos.indexOf((int)89)] = 0.3f * rgb[0] + 0.59f * rgb[1] + 0.11f * rgb[2];
                return values;
            }
            case A: {
                float[] values = new float[1];
                values[cos.indexOf((int)65)] = rgb[3];
                return values;
            }
            case AHSV: 
            case AHVS: 
            case ASHV: 
            case ASVH: 
            case AVHS: 
            case AVSH: 
            case HASV: 
            case HAVS: 
            case HSAV: 
            case HSVA: 
            case HVAS: 
            case HVSA: 
            case SAHV: 
            case SAVH: 
            case SHAV: 
            case SHVA: 
            case SVAH: 
            case SVHA: 
            case VAHS: 
            case VASH: 
            case VHAS: 
            case VHSA: 
            case VSAH: 
            case VSHA: {
                float[] values = new float[4];
                float[] hsv1 = Color.RGBtoHSB((int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f), null);
                values[cos.indexOf((int)72)] = hsv1[0];
                values[cos.indexOf((int)83)] = hsv1[1];
                values[cos.indexOf((int)86)] = hsv1[2];
                values[cos.indexOf((int)65)] = rgb[3];
                return values;
            }
            case HSV: 
            case HVS: 
            case SHV: 
            case SVH: 
            case VHS: 
            case VSH: {
                float[] values = new float[3];
                float[] hsv2 = Color.RGBtoHSB((int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f), null);
                values[cos.indexOf((int)72)] = hsv2[0];
                values[cos.indexOf((int)83)] = hsv2[1];
                values[cos.indexOf((int)86)] = hsv2[2];
                return values;
            }
            case AHSL: 
            case AHLS: 
            case ASHL: 
            case ASLH: 
            case ALHS: 
            case ALSH: 
            case HASL: 
            case HALS: 
            case HSAL: 
            case HSLA: 
            case HLAS: 
            case HLSA: 
            case SAHL: 
            case SALH: 
            case SHAL: 
            case SHLA: 
            case SLAH: 
            case SLHA: 
            case LAHS: 
            case LASH: 
            case LHAS: 
            case LHSA: 
            case LSAH: 
            case LSHA: {
                float[] values = new float[4];
                float[] hsv3 = Color.RGBtoHSB((int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f), null);
                float hh1 = hsv3[0];
                float ll1 = (2.0f - hsv3[1]) * hsv3[2];
                float ss1 = hsv3[1] * hsv3[2];
                if (ll1 != 0.0f) {
                    ss1 /= ll1 <= 1.0f ? ll1 : 2.0f - ll1;
                }
                values[cos.indexOf((int)72)] = hh1;
                values[cos.indexOf((int)83)] = ss1;
                values[cos.indexOf((int)76)] = ll1 /= 2.0f;
                values[cos.indexOf((int)65)] = rgb[3];
                return values;
            }
            case HSL: 
            case HLS: 
            case SHL: 
            case SLH: 
            case LHS: 
            case LSH: {
                float[] values = new float[3];
                float[] hsv4 = Color.RGBtoHSB((int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f), null);
                float hh2 = hsv4[0];
                float ll2 = (2.0f - hsv4[1]) * hsv4[2];
                float ss2 = hsv4[1] * hsv4[2];
                if (ll2 != 0.0f) {
                    ss2 /= ll2 <= 1.0f ? ll2 : 2.0f - ll2;
                }
                values[cos.indexOf((int)72)] = hh2;
                values[cos.indexOf((int)83)] = ss2;
                values[cos.indexOf((int)76)] = ll2 /= 2.0f;
                return values;
            }
            case CMYK: 
            case CMKY: 
            case CYMK: 
            case CYKM: 
            case CKMY: 
            case CKYM: 
            case MCYK: 
            case MCKY: 
            case MYCK: 
            case MYKC: 
            case MKCY: 
            case MKYC: 
            case YCMK: 
            case YCKM: 
            case YMCK: 
            case YMKC: 
            case YKCM: 
            case YKMC: 
            case KCMY: 
            case KCYM: 
            case KMCY: 
            case KMYC: 
            case KYCM: 
            case KYMC: {
                float[] values = new float[4];
                float c1 = 1.0f - rgb[0];
                float m1 = 1.0f - rgb[1];
                float y1 = 1.0f - rgb[2];
                float k1 = Math.min(c1, Math.min(m1, y1));
                values[cos.indexOf((int)67)] = 1.0f - k1 == 0.0f ? 0.0f : (c1 - k1) / (1.0f - k1);
                values[cos.indexOf((int)77)] = 1.0f - k1 == 0.0f ? 0.0f : (m1 - k1) / (1.0f - k1);
                values[cos.indexOf((int)89)] = 1.0f - k1 == 0.0f ? 0.0f : (y1 - k1) / (1.0f - k1);
                values[cos.indexOf((int)75)] = k1;
                return values;
            }
            case CMY: 
            case CYM: 
            case MCY: 
            case MYC: 
            case YCM: 
            case YMC: {
                float[] values = new float[3];
                values[cos.indexOf((int)67)] = 1.0f - rgb[0];
                values[cos.indexOf((int)77)] = 1.0f - rgb[1];
                values[cos.indexOf((int)89)] = 1.0f - rgb[2];
                return values;
            }
            case YIQ: 
            case YQI: 
            case IYQ: 
            case IQY: 
            case QYI: 
            case QIY: {
                float[] values = new float[3];
                double[] yiq = ColorFormat.RGBtoYIQ(rgb[0], rgb[1], rgb[2]);
                values[cos.indexOf((int)89)] = (float)yiq[0];
                values[cos.indexOf((int)73)] = (float)yiq[1];
                values[cos.indexOf((int)81)] = (float)yiq[2];
                return values;
            }
            case YUV: 
            case YVU: 
            case UYV: 
            case UVY: 
            case VYU: 
            case VUY: {
                float[] values = new float[3];
                double[] yuv = ColorFormat.RGBtoYUV(rgb[0], rgb[1], rgb[2]);
                values[cos.indexOf((int)89)] = (float)yuv[0];
                values[cos.indexOf((int)85)] = (float)yuv[1];
                values[cos.indexOf((int)86)] = (float)yuv[2];
                return values;
            }
            case XYZ: 
            case XZY: 
            case YXZ: 
            case YZX: 
            case ZXY: 
            case ZYX: {
                float[] values = new float[3];
                double[] xyz = ColorFormat.sRGBtoXYZ(rgb[0], rgb[1], rgb[2]);
                values[cos.indexOf((int)88)] = (float)xyz[0];
                values[cos.indexOf((int)89)] = (float)xyz[1];
                values[cos.indexOf((int)90)] = (float)xyz[2];
                return values;
            }
        }
        throw new IllegalArgumentException("Invalid channel order");
    }

    private static final double[] RGBtoYIQ(double r, double g, double b) {
        double y = 0.3 * r + 0.59 * g + 0.11 * b;
        double i = 0.599 * r - 0.2773 * g - 0.3217 * b;
        double q = 0.213 * r - 0.5251 * g + 0.3121 * b;
        return new double[]{y, i, q};
    }

    private static final double[] YIQtoRGB(double y, double i, double q) {
        double r = y + 0.9469 * i + 0.6236 * q;
        double g = y - 0.2748 * i - 0.6357 * q;
        double b = y - 1.1086 * i + 1.709 * q;
        return new double[]{r, g, b};
    }

    private static final double[] RGBtoYUV(double r, double g, double b) {
        double y = 0.299 * r + 0.587 * g + 0.114 * b;
        double u = -0.14713 * r - 0.28886 * g + 0.436 * b;
        double v = 0.615 * r - 0.51499 * g - 0.10001 * b;
        return new double[]{y, u, v};
    }

    private static final double[] YUVtoRGB(double y, double u, double v) {
        double r = y + 1.13983 * v;
        double g = y - 0.39465 * u - 0.5806 * v;
        double b = y + 2.03211 * u;
        return new double[]{r, g, b};
    }

    private static final double[] XYZtosRGB(double x, double y, double z) {
        double rl = 3.241 * x - 1.5374 * y - 0.4986 * z;
        double gl = -0.9692 * x + 1.876 * y + 0.0416 * z;
        double bl = 0.0556 * x - 0.204 * y + 1.057 * z;
        double r = rl <= 0.0031308 ? 12.92 * rl : 1.055 * Math.pow(rl, 0.4166666666666667) - 0.055;
        double g = gl <= 0.0031308 ? 12.92 * gl : 1.055 * Math.pow(gl, 0.4166666666666667) - 0.055;
        double b = bl <= 0.0031308 ? 12.92 * bl : 1.055 * Math.pow(bl, 0.4166666666666667) - 0.055;
        return new double[]{r, g, b};
    }

    private static final double[] sRGBtoXYZ(double r, double g, double b) {
        double rl = r <= 0.04045 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        double gl = g <= 0.04045 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
        double bl = b <= 0.04045 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);
        double x = 0.4124 * rl + 0.3576 * gl + 0.1805 * bl;
        double y = 0.2126 * rl + 0.7152 * gl + 0.0722 * bl;
        double z = 0.0193 * rl + 0.1192 * gl + 0.9505 * bl;
        return new double[]{x, y, z};
    }

    public static enum ChannelOrder {
        ARGB,
        ARBG,
        AGRB,
        AGBR,
        ABRG,
        ABGR,
        RAGB,
        RABG,
        RGAB,
        RGBA,
        RBAG,
        RBGA,
        GARB,
        GABR,
        GRAB,
        GRBA,
        GBAR,
        GBRA,
        BARG,
        BAGR,
        BRAG,
        BRGA,
        BGAR,
        BGRA,
        RGB,
        RBG,
        GRB,
        GBR,
        BRG,
        BGR,
        AY,
        YA,
        Y,
        A,
        AHSV,
        AHVS,
        ASHV,
        ASVH,
        AVHS,
        AVSH,
        HASV,
        HAVS,
        HSAV,
        HSVA,
        HVAS,
        HVSA,
        SAHV,
        SAVH,
        SHAV,
        SHVA,
        SVAH,
        SVHA,
        VAHS,
        VASH,
        VHAS,
        VHSA,
        VSAH,
        VSHA,
        HSV,
        HVS,
        SHV,
        SVH,
        VHS,
        VSH,
        AHSL,
        AHLS,
        ASHL,
        ASLH,
        ALHS,
        ALSH,
        HASL,
        HALS,
        HSAL,
        HSLA,
        HLAS,
        HLSA,
        SAHL,
        SALH,
        SHAL,
        SHLA,
        SLAH,
        SLHA,
        LAHS,
        LASH,
        LHAS,
        LHSA,
        LSAH,
        LSHA,
        HSL,
        HLS,
        SHL,
        SLH,
        LHS,
        LSH,
        CMYK,
        CMKY,
        CYMK,
        CYKM,
        CKMY,
        CKYM,
        MCYK,
        MCKY,
        MYCK,
        MYKC,
        MKCY,
        MKYC,
        YCMK,
        YCKM,
        YMCK,
        YMKC,
        YKCM,
        YKMC,
        KCMY,
        KCYM,
        KMCY,
        KMYC,
        KYCM,
        KYMC,
        CMY,
        CYM,
        MCY,
        MYC,
        YCM,
        YMC,
        YIQ,
        YQI,
        IYQ,
        IQY,
        QYI,
        QIY,
        YUV,
        YVU,
        UYV,
        UVY,
        VYU,
        VUY,
        XYZ,
        XZY,
        YXZ,
        YZX,
        ZXY,
        ZYX;

    }
}

