SET(SOPLEX_ROOT_DIR "" CACHE PATH "SoPlex root directory")

FIND_PATH(SOPLEX_INCLUDE_DIR
  soplex.h
  HINTS ${SOPLEX_ROOT_DIR}/src
)
FIND_LIBRARY(SOPLEX_LIBRARY
  soplex
  HINTS ${SOPLEX_ROOT_DIR}/lib
)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(SOPLEX DEFAULT_MSG SOPLEX_LIBRARY SOPLEX_INCLUDE_DIR)

IF(SOPLEX_FOUND)
  SET(SOPLEX_INCLUDE_DIRS ${SOPLEX_INCLUDE_DIR})
  SET(SOPLEX_LIBRARIES ${SOPLEX_LIBRARY})
  IF(CMAKE_SYSTEM_NAME STREQUAL "Linux")
    SET(SOPLEX_LIBRARIES "${SOPLEX_LIBRARIES};z")
  ENDIF(CMAKE_SYSTEM_NAME STREQUAL "Linux")
ENDIF(SOPLEX_FOUND)

MARK_AS_ADVANCED(SOPLEX_LIBRARY SOPLEX_INCLUDE_DIR)
