# SPDX-FileCopyrightText: 2023 Blender Authors
#
# SPDX-License-Identifier: GPL-2.0-or-later

# these must be all lower case for comparisons

dict_custom = {
    # Added to newer versions of the dictionary,
    # we can remove these when the updated word-lists have been applied to `aspell-en`.
    "accessor",
    "accessors",
    "completer",
    "completers",
    "enqueue",
    "enqueued",
    "enqueues",
    "intrinsics",
    "iterable",
    "parallelization",
    "parallelized",
    "pipelining",
    "polygonization",
    "prepend",
    "prepends",
    "rasterize",
    "reachability",
    "runtime",
    "runtimes",
    "serializable",
    "unary",
    "variadic",

    # Correct spelling, update the dictionary, here:
    # https://github.com/en-wl/wordlist
    "accessor",
    "accumulatively",
    "additively",
    "adjoint",
    "adjugate",
    "affectable",
    "alignable",
    "branchless",
    "allocatable",
    "allocator",
    "allocators",
    "anisotropic",
    "anisotropy",
    "asymptote",
    "atomicity",
    "attachmentless",
    "attenuations",
    "backends",
    "backlit",
    "backpropagated",
    "backpropagation",
    "bindless",
    "bitwise",
    "blocky",
    "boolean",
    "borderless",
    "breaked",
    "browsable",
    "callables",
    "canonicalization",
    "canonicalize",
    "canonicalized",
    "canonicalizing",
    "catadioptric",
    "checksums",
    "chrominance",
    "clearcoat",
    "codecs",
    "collapser",
    "collinear",
    "comparator",
    "comparators",
    "compilable",
    "confusticate",
    "confusticated",
    "constructability",
    "constructible",
    "convolved",
    "coplanarity",
    "copyable",
    "correctors",
    "counterforce",
    "criterium",
    "crosshair",
    "crosstalk",
    "cumulate",
    "cumulated",
    "customizable",
    "deallocate",
    "deallocated",
    "deallocating",
    "deallocation",
    "decompressor",
    "decorrelated",
    "decrement",
    "decrementing",
    "deduplicate",
    "deduplicated",
    "deduplicates",
    "deduplicating",
    "deduplication",
    "defocus",
    "defocusing",
    "defragment",
    "defragmented",
    "defragmenting",
    "degeneracies",
    "deinitialize",
    "deinitializes",
    "deletable",
    "deleter",
    "demangle",
    "demangled",
    "denoised",
    "denoiser",
    "denoising",
    "denormal",
    "denormalized",
    "denormals",
    "dereference",
    "dereferenced",
    "dereferences",
    "dereferencing",
    "derivates",
    "desaturate",
    "designator",
    "despeckle",
    "despeckled",
    "destructor",
    "destructors",
    "dialogs",
    "digitizers",
    "dihedral",
    "dimensionality",
    "directionality",
    "disambiguated",
    "disambiguates",
    "discoverability",
    "discretization",
    "discretized",
    "discretizes",
    "distributable",
    "downcasting",
    "downsample",
    "downsampled",
    "downsampler",
    "downsamples",
    "downsampling",
    "draggable",
    "drawable",
    "durations",
    "eachother",
    "editability",
    "effector",
    "effectors",
    "elementwise",
    "embedder",
    "enablement",
    "enqueueing",
    "equiangular",
    "evolute",
    "extrema",
    "fallbacks",
    "finalizer",
    "flippable",
    "flushable",
    "formatter",
    "formatters",
    "foveation",
    "generatrix",
    "glitchy",
    "haptics",
    "headerless",
    "highlightable",
    "homogenous",
    "ideographic",
    "illuminant",
    "imbricated",
    "impactful",
    "incrementation",
    "indexable",
    "inferencing",
    "initializations",
    "initializer",
    "initializers",
    "inlining",
    "instancer",
    "instancers",
    "instantiable",
    "instantiation",
    "instantiations",
    "interdependencies",
    "interferences",
    "interocular",
    "interpolator",
    "invariance",
    "invariant",
    "invariants",
    "invisibilities",
    "invocated",
    "irradiance",
    "iteratively",
    "jitteriness",
    "keyable",
    "keyless",
    "linearize",
    "linearized",
    "linearizes",
    "linearizing",
    "linkable",
    "lockless",
    "looper",
    "loopers",
    "losslessly",
    "luminances",
    "mappable",
    "memoryless",
    "merchantability",
    "mergeable",
    "minimalistic",
    "misconfiguration",
    "misconfigured",
    "modally",
    "modifiability",
    "monoscopy",
    "monospaced",
    "mutators",
    "natively",
    "nullable",
    "occludee",
    "occluder",
    "occluders",
    "octant",
    "octants",
    "optionals",
    "orthogonalize",
    "orthogonally",
    "orthonormalize",
    "orthonormalized",
    "overridable",
    "oversample",
    "oversampled",
    "oversampler",
    "oversamples",
    "oversampling",
    "paddings",
    "paintable",
    "pannable",
    "parallelepiped",
    "parallelize",
    "parallelizing",
    "parameterization",
    "parameterless",
    "parametrization",
    "parentless",
    "passepartout",
    "passthrough",
    "performant",
    "piecewise",
    "pixelate",
    "pixelated",
    "pixelation",
    "pixelisation",
    "planarity",
    "planarize",
    "polygonizer",
    "polytope",
    "postfix",
    "postfixes",
    "postprocess",
    "postprocessed",
    "pre-filtered",
    "pre-multiplied",
    "precalculate",
    "precisions",
    "precomputations",
    "precompute",
    "precomputed",
    "precomputing",
    "prefetch",
    "prefetched",
    "prefetching",
    "prefilter",
    "prefiltered",
    "prefiltering",
    "preloading",
    "premutliplied",
    "preorder",
    "prepend",
    "prepending",
    "preprocess",
    "preprocessing",
    "preprocessor",
    "preprocessors",
    "preventively",
    "probabilistically",
    "procedurally",
    "profiler",
    "programmatically",
    "projective",
    "purgeability",
    "quadratically",
    "queryable",
    "rasterizer",
    "rasterizes",
    "rasterizing",
    "reallocations",
    "realtime",
    "rebalancing",
    "rebase",
    "recomputation",
    "reconnection",
    "recurse",
    "recursed",
    "recurses",
    "recursing",
    "recursivity",
    "redefinitions",
    "redisplay",
    "redistributions",
    "registerable",
    "reimplement",
    "reimplemented",
    "reimplementing",
    "remappable",
    "remapper",
    "remappings",
    "remesher",
    "renderer",
    "renderable",
    "renderers",
    "renormalize",
    "renormalized",
    "reparameterization",
    "reparametrization",
    "representable",
    "reprojected",
    "reprojecting",
    "reprojection",
    "reprojections",
    "reprojects",
    "repurpose",
    "rescale",
    "rescaled",
    "respecialized",
    "restorable",
    "resynced",
    "resyncing",
    "retarget",
    "retiming",
    "reupload",
    "reusability",
    "rotationally",
    "sanitization",
    "saveable",
    "schemas",
    "scrollable",
    "selectability",
    "serializers",
    "shadowless",
    "sharpnesses",
    "sidedness",
    "simplices",
    "situationally",
    "skeletally",
    "skinnable",
    "skippable",
    "sortable",
    "stationarity",
    "stepsize",
    "stepwise",
    "stitchable",
    "subclass",
    "subclasses",
    "subclassing",
    "subdirectories",
    "subdirectory",
    "submenu",
    "submenus",
    "suboptimally",
    "subprocess",
    "subprocesses",
    "subrange",
    "subtractive",
    "subtype",
    "subtypes",
    "supersample",
    "supersampled",
    "supersampler",
    "supersamples",
    "supersampling",
    "superset",
    "symmetrizable",
    "symmetrize",
    "symmetrized",
    "targetless",
    "tedrahedral",
    "teleporting",
    "templating",
    "tertiarily",
    "testability",
    "thumbstick",
    "tokenize",
    "tokenizing",
    "toolchain",
    "trackpad",
    "transcode",
    "transmissive",
    "triaging",
    "triangulations",
    "triangulator",
    "trilinear",
    "tunable",
    "uber",
    "unadjusted",
    "unalignable",
    "unallocated",
    "unanimated",
    "unapplied",
    "unapply",
    "unassign",
    "unassigning",
    "unassigns",
    "unassociated",
    "unbake",
    "unbuffered",
    "uncached",
    "uncategorized",
    "unclaim",
    "unclamped",
    "unclipped",
    "uncollapsed",
    "uncomment",
    "uncommented",
    "uncompacted",
    "uncomputed",
    "unconfigured",
    "unconvert",
    "uncorrupted",
    "undefine",
    "undefined",
    "undeform",
    "undeformed",
    "undersample",
    "undersampled",
    "undersamples",
    "undersampling",
    "undisplaced",
    "undistorted",
    "undistorting",
    "unduplicated",
    "uneditable",
    "unflagged",
    "unflip",
    "unfoldable",
    "unformatted",
    "unfreed",
    "ungrabbed",
    "ungrabbing",
    "ungroup",
    "ungrouped",
    "ungrouping",
    "ungrown",
    "unhandled",
    "unhidden",
    "unhide",
    "unintuitive",
    "unkeyed",
    "unkeyframed",
    "unlink",
    "unlinkable",
    "unlinked",
    "unlinking",
    "unlinks",
    "unmap",
    "unmapped",
    "unmark",
    "unmask",
    "unmatching",
    "unmaximized",
    "unmeasurable",
    "unminimize",
    "unmodulated",
    "unmute",
    "unnormalize",
    "unnormalized",
    "unoccluded",
    "unoptimized",
    "unparameterized",
    "unparsed",
    "unpause",
    "unpaused",
    "unphysical",
    "unpoison",
    "unproject",
    "unquantifiable",
    "unreferenced",
    "unregister",
    "unregistering",
    "unregisters",
    "unreproducible",
    "unscaled",
    "unselect",
    "unselected",
    "unsetting",
    "unshadowed",
    "unshared",
    "unsharp",
    "unspecialized",
    "unsqueezed",
    "unstretch",
    "unsubdivided",
    "unsubdividing",
    "unsubdivisions",
    "unsynchronized",
    "untag",
    "untagging",
    "unterminated",
    "untracked",
    "untransformed",
    "untrusted",
    "untyped",
    "unusably",
    "unvisited",
    "unwritable",
    "upsample",
    "upsampled",
    "upsampler",
    "upsamples",
    "upsampling",
    "userless",
    "vectorial",
    "vectorization",
    "vectorize",
    "vectorized",
    "versionable",
    "videogrammetry",
    "viewports",
    "virtualized",
    "visibilities",
    "volumetrics",
    "vortices",
    "voxelize",
    "workspaces",
    "writeable",
    "zoomable",

    # C/C++/Python types (we could quote every instance but it's impractical).
    "enum",
    "enums",
    "int",
    "ints",
    "nullptr",  # C++ NULL-pointer.
    "str",
    "tuple",
    "tuples",

    # python functions
    "func",
    "repr",

    # Accepted concatenations.
    "addon",
    "addons",
    "autocomplete",
    "bitmask",
    "codegen",
    "colospace",
    "datablock",
    "datablocks",
    "keyframe",
    "keyframing",
    "lookup",
    "lookups",
    "multithreaded",
    "multithreading",
    "namespace",
    "namespaces",
    "reparent",
    "tooltip",
    "unparent",

    # Accepted abbreviations.
    # `"dir",`  # direction/directory? Too ambiguous, don't use this.
    "anim",  # animation.
    "attr",
    "attrs",
    "config",  # configuration.
    "coord",
    "coords",
    "ctrl",  # control (modifier key).
    "ie",
    "init",
    "iter",  # iteration.
    "multi",
    "numpad",  # numeric-pad.
    "numpads",  # numeric-pads.
    "ortho",
    "recalc",
    "resync",
    "struct",
    "structs",
    "subdir",

    # General computer terms.
    "app",
    "ascii",
    "autocomplete",
    "autorepeat",
    "bilinear",
    "blit",
    "blitting",
    "boids",
    "booleans",
    "backface",
    "codepage",
    "contructor",
    "decimator",
    "decref",
    "decrefed",
    "decrefing",
    "diff",
    "diffs",
    "endian",
    "endianness",
    "env",
    "euler",
    "eulers",
    "foo",
    "hashable",
    "http",
    "incref",
    "increfed",
    "increfing",
    "intellisense",
    "jitter",
    "jittered",
    "jittering",
    "keymap",
    "lerp",
    "metadata",
    "mutex",
    "opengl",
    "quantized",
    "searchable",
    "segfault",
    "stdin",
    "stdout",
    "sudo",
    "threadsafe",
    "touchpad",
    "touchpads",
    "trackpad",
    "trackpads",
    "trilinear",
    "unicode",
    "usr",
    "vert",
    "verts",
    "voxel",
    "voxels",
    "wiki",

    # specific computer terms/brands
    "ack",
    "amiga",
    "cmake",
    "ffmpeg",
    "freebsd",
    "linux",
    "manpage",
    "mozilla",
    "nvidia",
    "openexr",
    "posix",
    "qtcreator",
    "unix",
    "valgrind",
    "wayland",
    "xinerama",

    # general computer graphics terms
    "atomics",
    "barycentric",
    "bezier",
    "bicubic",
    "bitangent",
    "centroid",
    "colinear",
    "compositing",
    "coplanar",
    "crypto",
    "deinterlace",
    "emissive",
    "fresnel",
    "gaussian",
    "grayscale",
    "kerning",
    "lacunarity",
    "lossless",
    "lossy",
    "luma",
    "macronormal",
    "macronormals",
    "mesonormal",
    "mesonormals",
    "microfacet",
    "microfacets",
    "micronormal",
    "micronormals",
    "mipmap",
    "mipmapped",
    "mipmapping",
    "mipmaps",
    "musgrave",
    "n-gon",
    "n-gons",
    "normals",
    "nurbs",
    "octree",
    "quaternion",
    "quaternions",
    "radiosity",
    "reflectance",
    "shader",
    "shaders",
    "specular",

    # Mathematical terms.
    "eigenvalue",
    "eigenvalues",

    # Blender specific terms.
    "animsys",
    "animviz",
    "bmain",
    "bmesh",
    "bpy",
    "depsgraph",
    "doctree",
    "editmode",
    "eekadoodle",
    "fcurve",
    "look-dev",
    "mathutils",
    "obdata",
    "userpref",
    "userprefs",

    # Should have apostrophe but ignore for now unless we want to get really picky!
    "indices",
    "vertices",
}

# incorrect spelling but ignore anyway
dict_ignore = {
    "a-z",
    "animatable",
    "arg",
    "args",
    "bool",
    "constness",
    "dirpath",
    "dupli",
    "eg",
    "filename",
    "filenames",
    "filepath",
    "filepaths",
    "hardcoded",
    "id-block",
    "inlined",
    "loc",
    "namespace",
    "node-trees",
    "ok",
    "ok-ish",
    "param",
    "polyline",
    "polylines",
    "premultiplied",
    "premultiply",
    "pylint",
    "quad",
    "readonly",
    "submodule",
    "submodules",
    "tooltips",
    "tri",
    "ui",
    "unfuzzy",
    "utils",
    "uv",
    "vec",
    "wireframe",
    "x-axis",
    "y-axis",
    "z-axis",

    # acronyms
    "api",
    "cpu",
    "gl",
    "gpl",
    "gpu",
    "gzip",
    "hg",
    "ik",
    "lhs",
    "nan",
    "nla",
    "ppc",
    "rgb",
    "rhs",
    "rna",
    "smpte",
    "svn",
    "utf",

    # extensions
    "py",
    "rst",
    "xml",
    "xpm",

    # tags
    "fixme",
    "todo",

    # sphinx/rst
    "rtype",

    # slang
    "automagically",
    "hacky",
    "hrmf",

    # names
    "campbell",
    "jahka",
    "mikkelsen",
    "morten",

    # Company names.
    "Logitech",
    "Wacom",

    # Project Names.
    "Wayland",

    # clang-tidy (for convenience).
    "bugprone-suspicious-enum-usage",
    "bugprone-use-after-move",
}

# Allow: `un-word`, `re-word` ... etc, in this case only check `word`.
dict_ignore_hyphenated_prefix = {
    "de",
    "mis",
    "non",
    "post",
    "pre",
    "re",
    "un",
}

dict_ignore_hyphenated_suffix = {
    "ify",
    "ish",
    "ness",
}

files_ignore = {
    "tools/utils_doc/rna_manual_reference_updater.py",  # Contains language ID references.

    # Maintained by 3rd parties.
    "source/blender/blenlib/intern/fnmatch.c",
    "source/blender/draw/intern/shaders/common_fxaa_lib.glsl",
    "source/blender/gpu/shaders/common/gpu_shader_smaa_lib.glsl",
}

directories_ignore = {
    "scripts/addons",
    "scripts/addons_core",
}
