#ifndef PROGRAMMER_H
#define PROGRAMMER_H

#include <string>
#include <vector>


class ProgrammerPrivate;
class Part;

namespace avrdude {
    class Update;
}


struct ProgrammerInfo {
    std::string name;
    std::string desc;
    std::string cfgname;
    int cfglineno;
};


class Programmer {
    public:
        Programmer();
        virtual ~Programmer();
        static std::vector<ProgrammerInfo> getAvailableProgrammers();
        static Programmer * locateProgrammer(const std::string & name);

        void initpgm();
        void setup();

        bool open(const std::string & port);
#if (LIBAVRDUDE_VER >= 70)
        void enable(Part & part);
#else
        void enable();
#endif
        void powerdown();
        void disable();
        void rdy_led(bool on);
        void close();
        void setBaudrate(unsigned int baudrate);

        void initialize(Part & part);

        void avr_chip_erase(Part & part);
        bool do_update_op(Part & part, avrdude::Update & op, bool nowrite, bool verify);
        std::string read_signature(Part & part);


    protected:
    private:
        ProgrammerPrivate * priv;
};

#endif // PROGRAMMER_H
