/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.stubs;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/multiFileHighlighting")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class MultiFileHighlightingTestGenerated extends AbstractMultiFileHighlightingTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInMultiFileHighlighting() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/multiFileHighlighting"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, false);
    }

    @TestMetadata("annotatedParameter.kt")
    public void testAnnotatedParameter() throws Exception {
        runTest("idea/testData/multiFileHighlighting/annotatedParameter.kt");
    }

    @TestMetadata("copyResolveBeforeParams.kt")
    public void testCopyResolveBeforeParams() throws Exception {
        runTest("idea/testData/multiFileHighlighting/copyResolveBeforeParams.kt");
    }

    @TestMetadata("delegatesReference.kt")
    public void testDelegatesReference() throws Exception {
        runTest("idea/testData/multiFileHighlighting/delegatesReference.kt");
    }

    @TestMetadata("enumReference.kt")
    public void testEnumReference() throws Exception {
        runTest("idea/testData/multiFileHighlighting/enumReference.kt");
    }

    @TestMetadata("missingDependencyClass.kt")
    public void testMissingDependencyClass() throws Exception {
        runTest("idea/testData/multiFileHighlighting/missingDependencyClass.kt");
    }

    @TestMetadata("referencesFunWithUnspecifiedType.kt")
    public void testReferencesFunWithUnspecifiedType() throws Exception {
        runTest("idea/testData/multiFileHighlighting/referencesFunWithUnspecifiedType.kt");
    }

    @TestMetadata("topLevelMembersReference.kt")
    public void testTopLevelMembersReference() throws Exception {
        runTest("idea/testData/multiFileHighlighting/topLevelMembersReference.kt");
    }
}
