# -*-ruby-*-
#
# Copyright (c) 2004-2005 SASADA Koichi <ko1 at atdot.net>
#
# This program is free software with ABSOLUTELY NO WARRANTY.
# You can re-distribute and/or modify this program under
# the same terms of the Ruby's license.
#
#
# $Id$
#

=begin

== Abstract

An example using DRb. You can access to nadoka via DRb protocol.
See sample drbcl.rb


== Configuration

BotConfig = [
{
  :name => :DRbot,
  :port => 12345,
  :host => '',
}
]


=end


require 'drb/drb'
require 'observer'

class DRbot < Nadoka::NDK_Bot
  class Dispatcher
    include Observable

    def initialize bot
      @bot = bot
    end
    
    def send_to_client prefix, command, args
      changed
      notify_observers(prefix, command, args)
    end

    def recv_from_client *args
      @bot.kick_from_client args
    end

    def notify_observers(*arg)
      if defined? @observer_state and @observer_state
        if defined? @observer_peers
          @observer_peers.dup.each{|e|
            begin
              e.update(*arg)
            rescue Exception
              @observer_peers.delete e
            end
          }
        end
        @observer_state = false
      end
    end
    
  end
  
  def bot_initialize
    @port = @bot_config.fetch(:port, 12346)
    @host = @bot_config.fetch(:host, '')
    @invoker   = Dispatcher.new(self)
    @uri       = "druby://#{@host}:#{@port}"
    @drbserver = DRb.start_service(@uri, @invoker)
  end
  
  def bot_destruct
    @drbserver.stop_service
  end
  
  def on_every_message prefix, command, *args
    @invoker.send_to_client prefix, command, args
  end

  def recv_from_client *args
    
  end
  
end

